/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.events.block;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.DurationTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.FurnaceStartSmeltEvent;

public class FurnaceStartsSmeltingScriptEvent
extends BukkitScriptEvent
implements Listener {
    public ItemTag item;
    public LocationTag location;
    public FurnaceStartSmeltEvent event;

    public FurnaceStartsSmeltingScriptEvent() {
        this.registerCouldMatcher("furnace starts smelting <item>");
        this.registerDetermination(null, DurationTag.class, (evt, context, time) -> evt.event.setTotalCookTime(time.getTicksAsInt()));
    }

    @Override
    public boolean matches(ScriptEvent.ScriptPath path) {
        if (!this.runInCheck(path, this.location)) {
            return false;
        }
        if (!path.tryArgObject(3, this.item)) {
            return false;
        }
        return super.matches(path);
    }

    @Override
    public ObjectTag getContext(String name) {
        return switch (name) {
            case "location" -> this.location;
            case "item" -> this.item;
            case "recipe_id" -> new ElementTag(this.event.getRecipe().getKey().toString(), true);
            case "total_cook_time" -> new DurationTag((long)this.event.getTotalCookTime());
            default -> super.getContext(name);
        };
    }

    @EventHandler
    public void onFurnaceStartsSmelting(FurnaceStartSmeltEvent event) {
        this.location = new LocationTag(event.getBlock().getLocation());
        this.item = new ItemTag(event.getSource());
        this.event = event;
        this.fire((Event)event);
    }
}

