/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.paper.datacomponents;

import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.objects.properties.item.ItemComponentsPatch;
import com.denizenscript.denizen.objects.properties.item.ItemProperty;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.MapTag;
import com.denizenscript.denizencore.objects.properties.PropertyParser;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import io.papermc.paper.datacomponent.DataComponentType;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.bukkit.Registry;
import org.bukkit.inventory.ItemStack;

public abstract class DataComponentAdapter<D extends ObjectTag, C extends DataComponentType> {
    public static final Map<String, DataComponentType> COMPONENTS_BY_PROPERTY = new HashMap<String, DataComponentType>();
    public static final String[] EMPTY_STRING_ARRAY = new String[0];
    public final C componentType;
    public final Class<D> denizenType;
    public final String name;

    public static DataComponentType getComponentType(String name) {
        String nameLower = CoreUtilities.toLowerCase(name);
        DataComponentType componentType = (DataComponentType)Registry.DATA_COMPONENT_TYPE.get(Utilities.parseNamespacedKey(nameLower));
        if (componentType == null) {
            componentType = COMPONENTS_BY_PROPERTY.get(nameLower);
        }
        return componentType;
    }

    public static void register(DataComponentAdapter<?, ?> adapter) {
        Property.currentlyRegisteringComponentAdapter = adapter;
        PropertyParser.registerPropertyGetter(item -> {
            Property property;
            if (!item.getItemStack().isEmpty()) {
                DataComponentAdapter dataComponentAdapter = adapter;
                Objects.requireNonNull(dataComponentAdapter);
                property = dataComponentAdapter.new Property((ItemTag)item);
            } else {
                property = null;
            }
            return property;
        }, ItemTag.class, EMPTY_STRING_ARRAY, EMPTY_STRING_ARRAY, Property.class);
        Property.currentlyRegisteringComponentAdapter = null;
        String componentName = adapter.componentType.key().asMinimalString();
        ItemComponentsPatch.registerHandledComponent(componentName);
        if (!adapter.name.equals(componentName)) {
            COMPONENTS_BY_PROPERTY.put(adapter.name, (DataComponentType)adapter.componentType);
        }
    }

    public DataComponentAdapter(C componentType, Class<D> denizenType, String name) {
        this.componentType = componentType;
        this.denizenType = denizenType;
        this.name = name;
    }

    public abstract D getValue(ItemStack var1);

    public abstract void setValue(ItemStack var1, D var2, Mechanism var3);

    public boolean isDefaultValue(D value) {
        return false;
    }

    static {
        ItemTag.tagProcessor.registerTag(ElementTag.class, ElementTag.class, "is_overridden", (attribute, object, param) -> {
            DataComponentType componentType = DataComponentAdapter.getComponentType(param.asString());
            if (componentType == null) {
                attribute.echoError("Invalid type specified, must be a valid item component type or property name.");
                return null;
            }
            return new ElementTag(object.getItemStack().isDataOverridden(componentType));
        }, new String[0]);
    }

    public class Property
    extends ItemProperty<D> {
        private static DataComponentAdapter<?, ?> currentlyRegisteringComponentAdapter;

        public Property(ItemTag item) {
            this.object = item;
        }

        @Override
        public D getPropertyValue() {
            return DataComponentAdapter.this.getValue(this.getItemStack());
        }

        @Override
        public D getPropertyValueNoDefault() {
            if (!this.getItemStack().isDataOverridden(DataComponentAdapter.this.componentType)) {
                return null;
            }
            return super.getPropertyValueNoDefault();
        }

        @Override
        public boolean isDefaultValue(D value) {
            return DataComponentAdapter.this.isDefaultValue(value);
        }

        @Override
        public void setPropertyValue(D value, Mechanism mechanism) {
            if (value == null) {
                this.getItemStack().resetData(DataComponentAdapter.this.componentType);
                return;
            }
            DataComponentAdapter.this.setValue(this.getItemStack(), value, mechanism);
        }

        @Override
        public String getPropertyId() {
            return DataComponentAdapter.this.name;
        }

        public static void register() {
            Property.autoRegisterNullable(Property.currentlyRegisteringComponentAdapter.name, Property.class, Property.currentlyRegisteringComponentAdapter.denizenType, false, new String[0]);
        }
    }

    public static abstract class Valued<D extends ObjectTag, P>
    extends DataComponentAdapter<D, DataComponentType.Valued<P>> {
        public static <T, D extends ObjectTag> void setIfValid(Consumer<T> setter, MapTag data, String key, Class<D> objectType, Predicate<D> checker, Function<D, T> converter, String type, Mechanism mechanism) {
            T converted;
            D value = data.getObjectAs(key, objectType, mechanism.context);
            if (value == null) {
                return;
            }
            if (checker != null && !checker.test(value) || (converted = converter.apply(value)) == null) {
                mechanism.echoError("Invalid '" + key + "' specified: must be a " + type + ".");
                return;
            }
            setter.accept(converted);
        }

        public Valued(Class<D> denizenType, DataComponentType.Valued<P> componentType, String name) {
            super(componentType, denizenType, name);
        }

        public abstract D toDenizen(P var1);

        public abstract P fromDenizen(D var1, Mechanism var2);

        @Override
        public D getValue(ItemStack item) {
            Object data = item.getData((DataComponentType.Valued)this.componentType);
            return data != null ? (D)this.toDenizen(data) : null;
        }

        @Override
        public void setValue(ItemStack item, D value, Mechanism mechanism) {
            P converted = this.fromDenizen(value, mechanism);
            if (converted != null) {
                item.setData((DataComponentType.Valued)this.componentType, converted);
            }
        }
    }

    public static abstract class NonValued
    extends DataComponentAdapter<ElementTag, DataComponentType.NonValued> {
        public NonValued(DataComponentType.NonValued componentType, String name) {
            super(componentType, ElementTag.class, name);
        }

        @Override
        public ElementTag getValue(ItemStack item) {
            return new ElementTag(item.hasData(this.componentType));
        }

        @Override
        public void setValue(ItemStack item, ElementTag value, Mechanism mechanism) {
            if (!mechanism.requireBoolean()) {
                return;
            }
            if (value.asBoolean()) {
                item.setData((DataComponentType.NonValued)this.componentType);
            } else {
                item.unsetData(this.componentType);
            }
        }

        @Override
        public boolean isDefaultValue(ElementTag value) {
            return !value.asBoolean();
        }
    }
}

