/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.paper.datacomponents;

import com.denizenscript.denizen.paper.datacomponents.DataComponentAdapter;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.MapTag;
import io.papermc.paper.datacomponent.DataComponentTypes;
import io.papermc.paper.datacomponent.item.FoodProperties;

public class FoodAdapter
extends DataComponentAdapter.Valued<MapTag, FoodProperties> {
    public FoodAdapter() {
        super(MapTag.class, DataComponentTypes.FOOD, "food");
    }

    @Override
    public MapTag toDenizen(FoodProperties value) {
        MapTag foodData = new MapTag();
        foodData.putObject("nutrition", (ObjectTag)new ElementTag(value.nutrition()));
        foodData.putObject("saturation", (ObjectTag)new ElementTag(value.saturation()));
        foodData.putObject("can_always_eat", (ObjectTag)new ElementTag(value.canAlwaysEat()));
        return foodData;
    }

    @Override
    public FoodProperties fromDenizen(MapTag value, Mechanism mechanism) {
        FoodProperties.Builder builder = FoodProperties.food();
        FoodAdapter.setIfValid(arg_0 -> ((FoodProperties.Builder)builder).nutrition(arg_0), value, "nutrition", ElementTag.class, ElementTag::isInt, ElementTag::asInt, "number", mechanism);
        FoodAdapter.setIfValid(arg_0 -> ((FoodProperties.Builder)builder).saturation(arg_0), value, "saturation", ElementTag.class, ElementTag::isFloat, ElementTag::asFloat, "decimal number", mechanism);
        FoodAdapter.setIfValid(arg_0 -> ((FoodProperties.Builder)builder).canAlwaysEat(arg_0), value, "can_always_eat", ElementTag.class, ElementTag::isBoolean, ElementTag::asBoolean, "boolean", mechanism);
        return (FoodProperties)builder.build();
    }
}

