/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.commands.entity;

import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizen.utilities.command.TabCompleteHelper;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsRuntimeException;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.scripts.commands.generator.ArgDefaultNull;
import com.denizenscript.denizencore.scripts.commands.generator.ArgDefaultText;
import com.denizenscript.denizencore.scripts.commands.generator.ArgLinear;
import com.denizenscript.denizencore.scripts.commands.generator.ArgName;
import com.denizenscript.denizencore.scripts.commands.generator.ArgPrefixed;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;
import java.util.List;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.player.PlayerTeleportEvent;

public class SpawnCommand
extends AbstractCommand {
    public SpawnCommand() {
        this.setName("spawn");
        this.setSyntax("spawn [<entity>|...] (<location>) (target:<entity>) (persistent) (reason:<reason>)");
        this.setRequiredArguments(1, 5);
        this.isProcedural = false;
        this.autoCompile();
    }

    @Override
    public void addCustomTabCompletions(AbstractCommand.TabCompletionsBuilder tab) {
        TabCompleteHelper.tabCompleteEntityTypes(tab);
        tab.addWithPrefix("reason", (Enum<?>[])CreatureSpawnEvent.SpawnReason.values());
    }

    public static void autoExecute(ScriptEntry scriptEntry, @ArgLinear @ArgName(value="entities") ObjectTag entityListInput, @ArgDefaultNull @ArgLinear @ArgName(value="location") ObjectTag locationInput, @ArgDefaultNull @ArgPrefixed @ArgName(value="target") EntityTag target, @ArgDefaultNull @ArgPrefixed @ArgName(value="spread") ElementTag spread, @ArgName(value="persistent") boolean persistent, @ArgDefaultText(value="custom") @ArgPrefixed @ArgName(value="reason") CreatureSpawnEvent.SpawnReason reason) {
        LocationTag location;
        if (locationInput != null && entityListInput.shouldBeType(LocationTag.class)) {
            ObjectTag swap = locationInput;
            locationInput = entityListInput;
            entityListInput = swap;
        }
        LocationTag locationTag = location = locationInput == null ? Utilities.entryDefaultLocation(scriptEntry, false) : locationInput.asType(LocationTag.class, scriptEntry.context);
        if (location == null) {
            throw new InvalidArgumentsRuntimeException("Must specify a location!");
        }
        EntityTag.allowDespawnedNpcs = true;
        List<EntityTag> entities = entityListInput.asType(ListTag.class, scriptEntry.context).filter(EntityTag.class, scriptEntry.context);
        EntityTag.allowDespawnedNpcs = false;
        ListTag entityList = new ListTag();
        for (EntityTag entity : entities) {
            LocationTag loc = location.clone();
            if (spread != null) {
                loc.add(CoreUtilities.getRandom().nextInt(spread.asInt() * 2) - spread.asInt(), 0.0, CoreUtilities.getRandom().nextInt(spread.asInt() * 2) - spread.asInt());
            }
            entity = entity.duplicate();
            entity.spawnAt(loc, PlayerTeleportEvent.TeleportCause.PLUGIN, reason);
            entityList.addObject(entity);
            if (!entity.isSpawned()) {
                Debug.echoDebug((Debuggable)scriptEntry, "Failed to spawn " + String.valueOf(entity) + " (blocked by other plugin, script, or gamerule?).");
                continue;
            }
            if (persistent && entity.isLivingEntity()) {
                entity.getLivingEntity().setRemoveWhenFarAway(false);
            }
            if (target == null) continue;
            entity.target(target.getLivingEntity());
        }
        scriptEntry.saveObject("spawned_entities", entityList);
        if (entities.size() != 0) {
            scriptEntry.saveObject("spawned_entity", entityList.getObject(0));
        }
    }
}

