/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.denizen.scripts.commands.world;

import com.denizenscript.denizen.nms.NMSHandler;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.properties.bukkit.BukkitColorExtensions;
import com.denizenscript.denizen.utilities.Conversion;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.core.ColorTag;
import com.denizenscript.denizencore.objects.core.DurationTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;
import java.util.Collections;
import java.util.List;
import org.bukkit.Color;
import org.bukkit.FireworkEffect;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Firework;
import org.bukkit.inventory.meta.FireworkMeta;

public class FireworkCommand
extends AbstractCommand {
    public FireworkCommand() {
        this.setName("firework");
        this.setSyntax("firework (<location>) (power:<#>) (<type>/random) (primary:<color>|...) (fade:<color>|...) (flicker) (trail) (life:<duration>)");
        this.setRequiredArguments(0, 8);
        this.isProcedural = false;
        this.setPrefixesHandled("life", "power", "primary", "fade");
        this.setBooleansHandled("flicker", "trail");
    }

    @Override
    public void addCustomTabCompletions(AbstractCommand.TabCompletionsBuilder tab) {
        tab.addNotesOfType(LocationTag.class);
    }

    @Override
    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (Argument arg : scriptEntry) {
            if (!scriptEntry.hasObject("location") && arg.matchesArgumentType(LocationTag.class)) {
                scriptEntry.addObject("location", arg.asType(LocationTag.class));
                continue;
            }
            if (!scriptEntry.hasObject("type") && arg.matches("random")) {
                scriptEntry.addObject("type", new ElementTag((Enum<?>)FireworkEffect.Type.values()[CoreUtilities.getRandom().nextInt(FireworkEffect.Type.values().length)]));
                continue;
            }
            if (!scriptEntry.hasObject("type") && arg.matchesEnum(FireworkEffect.Type.class)) {
                scriptEntry.addObject("type", arg.asElement());
                continue;
            }
            arg.reportUnhandled();
        }
        scriptEntry.defaultObject("location", Utilities.entryDefaultLocation(scriptEntry, false));
        if (!scriptEntry.hasObject("location")) {
            throw new InvalidArgumentsException("Missing location!");
        }
        scriptEntry.defaultObject("type", new ElementTag("ball"));
    }

    @Override
    public void execute(ScriptEntry scriptEntry) {
        LocationTag location = (LocationTag)scriptEntry.getObject("location");
        ElementTag type = scriptEntry.getElement("type");
        List<ColorTag> primary = scriptEntry.argForPrefixList("primary", ColorTag.class, true);
        if (primary == null) {
            primary = Collections.singletonList(BukkitColorExtensions.fromColor(Color.YELLOW));
        }
        List<ColorTag> fade = scriptEntry.argForPrefixList("fade", ColorTag.class, true);
        boolean flicker = scriptEntry.argAsBoolean("flicker");
        boolean trail = scriptEntry.argAsBoolean("trail");
        ElementTag power = scriptEntry.argForPrefixAsElement("power", "1");
        DurationTag life = scriptEntry.argForPrefix("life", DurationTag.class, true);
        if (scriptEntry.dbCallShouldDebug()) {
            Debug.report((Debuggable)scriptEntry, this.getName(), location, type, power, life, FireworkCommand.db("flicker", flicker), FireworkCommand.db("trail", trail), FireworkCommand.db("primary colors", primary), FireworkCommand.db("fade colors", fade));
        }
        Firework firework = (Firework)location.getWorld().spawn((Location)location, Firework.class);
        FireworkMeta fireworkMeta = firework.getFireworkMeta();
        fireworkMeta.setPower(power.asInt());
        FireworkEffect.Builder fireworkBuilder = FireworkEffect.builder();
        fireworkBuilder.with(FireworkEffect.Type.valueOf((String)type.asString().toUpperCase()));
        fireworkBuilder.withColor(Conversion.convertColors(primary));
        if (fade != null) {
            fireworkBuilder.withFade(Conversion.convertColors(fade));
        }
        if (flicker) {
            fireworkBuilder.withFlicker();
        }
        if (trail) {
            fireworkBuilder.withTrail();
        }
        fireworkMeta.addEffects(new FireworkEffect[]{fireworkBuilder.build()});
        firework.setFireworkMeta(fireworkMeta);
        if (life != null) {
            NMSHandler.entityHelper.setFireworkLifetime(firework, life.getTicksAsInt());
        }
        scriptEntry.saveObject("launched_firework", new EntityTag((Entity)firework));
    }
}

