/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.depenizen.bukkit.events.jobs;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import com.denizenscript.depenizen.bukkit.objects.jobs.JobsJobTag;
import com.gamingmesh.jobs.Jobs;
import com.gamingmesh.jobs.api.JobsPrePaymentEvent;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;

public class JobsJobsPaymentScriptEvent
extends BukkitScriptEvent
implements Listener {
    public JobsPrePaymentEvent event;
    public JobsJobTag job;

    public JobsJobsPaymentScriptEvent() {
        this.registerCouldMatcher("jobs player earns money for <'job'>");
        this.registerSwitches(new String[]{"action"});
        this.registerOptionalDetermination("money", ElementTag.class, (evt, context, input) -> {
            if (input.isDouble()) {
                evt.event.setAmount(input.asDouble());
                return true;
            }
            return false;
        });
        this.registerOptionalDetermination("points", ElementTag.class, (evt, context, input) -> {
            if (input.isDouble()) {
                evt.event.setPoints(input.asDouble());
                return true;
            }
            return false;
        });
    }

    public boolean matches(ScriptEvent.ScriptPath path) {
        if (!path.tryArgObject(5, (ObjectTag)this.job)) {
            return false;
        }
        if (!JobsJobsPaymentScriptEvent.runGenericSwitchCheck((ScriptEvent.ScriptPath)path, (String)"action", (String)this.event.getActionInfo().getType().getName())) {
            return false;
        }
        return super.matches(path);
    }

    public ObjectTag getContext(String name) {
        return switch (name) {
            case "job" -> this.job;
            case "money" -> new ElementTag(this.event.getAmount());
            case "points" -> new ElementTag(this.event.getPoints());
            case "action" -> new ElementTag(this.event.getActionInfo().getType().getName(), true);
            case "entity" -> {
                if (this.event.getLivingEntity() == null) {
                    yield null;
                }
                yield new EntityTag((Entity)this.event.getLivingEntity()).getDenizenObject();
            }
            case "block" -> {
                if (this.event.getBlock() == null) {
                    yield null;
                }
                yield new LocationTag(this.event.getBlock().getLocation());
            }
            default -> super.getContext(name);
        };
    }

    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(new PlayerTag(this.event.getPlayer()), null);
    }

    @EventHandler
    public void onJobsJobsPrepayment(JobsPrePaymentEvent event) {
        this.job = new JobsJobTag(event.getJob(), Jobs.getPlayerManager().getJobsPlayer(event.getPlayer().getUniqueId()));
        this.event = event;
        this.fire((Event)event);
    }
}

