/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.depenizen.bukkit.bridges;

import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.objects.NPCTag;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ScriptTag;
import com.denizenscript.denizencore.objects.properties.PropertyParser;
import com.denizenscript.denizencore.scripts.containers.ScriptContainer;
import com.denizenscript.denizencore.scripts.containers.core.ProcedureScriptContainer;
import com.denizenscript.denizencore.scripts.queues.ScriptQueue;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.ScriptUtilities;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.depenizen.bukkit.Bridge;
import com.denizenscript.depenizen.bukkit.events.sentinel.SentinelAttackScriptEvent;
import com.denizenscript.depenizen.bukkit.events.sentinel.SentinelNoMoreTargetsScriptEvent;
import com.denizenscript.depenizen.bukkit.properties.sentinel.SentinelNPCProperties;
import java.util.function.Consumer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.mcmonkey.sentinel.SentinelIntegration;
import org.mcmonkey.sentinel.SentinelPlugin;
import org.mcmonkey.sentinel.SentinelUtilities;

public class SentinelBridge
extends Bridge {
    @Override
    public void init() {
        ScriptEvent.registerScriptEvent(SentinelAttackScriptEvent.class);
        ScriptEvent.registerScriptEvent(SentinelNoMoreTargetsScriptEvent.class);
        SentinelPlugin.instance.registerIntegration((SentinelIntegration)new DenizenSentinelTargets());
        PropertyParser.registerProperty(SentinelNPCProperties.class, NPCTag.class);
    }

    public static class DenizenSentinelTargets
    extends SentinelIntegration {
        public String getTargetHelp() {
            return "denizen_proc:PROCEDURE_SCRIPT_NAME, held_denizen_item:DENIZEN_ITEM_NAME";
        }

        public String[] getTargetPrefixes() {
            return new String[]{"denizen_proc", "held_denizen_item"};
        }

        public boolean isTarget(LivingEntity ent, String prefix, String value) {
            try {
                if (prefix.equals("held_denizen_item") && ent.getEquipment() != null && SentinelUtilities.regexFor((String)value).matcher(new ItemTag(SentinelUtilities.getHeldItem((LivingEntity)ent)).identifySimple().replace("i@", "")).matches()) {
                    return true;
                }
                if (prefix.equals("denizen_proc")) {
                    ScriptTag script;
                    String context = null;
                    int colon = value.indexOf(58);
                    if (colon > 0) {
                        context = value.substring(colon + 1);
                        value = value.substring(0, colon);
                    }
                    if ((script = ScriptTag.valueOf((String)value, (TagContext)CoreUtilities.basicContext)) == null) {
                        Debug.echoError((String)("Invalid procedure script name '" + value + "' (non-existent) in a Sentinel NPC target."));
                        return false;
                    }
                    if (!(script.getContainer() instanceof ProcedureScriptContainer)) {
                        Debug.echoError((String)("Invalid procedure script name '" + value + "' (not a procedure) in a Sentinel NPC target."));
                        return false;
                    }
                    String contextFinal = context;
                    Consumer<ScriptQueue> configure = queue -> {
                        queue.addDefinition("entity", (ObjectTag)new EntityTag((Entity)ent).getDenizenObject());
                        if (contextFinal != null) {
                            queue.addDefinition("context", (ObjectTag)new ElementTag(contextFinal));
                        }
                    };
                    ScriptQueue queue2 = ScriptUtilities.createAndStartQueue((ScriptContainer)script.getContainer(), null, null, null, configure, null, null, null, null);
                    if (queue2.determinations != null && queue2.determinations.size() > 0) {
                        return CoreUtilities.equalsIgnoreCase((String)queue2.determinations.get(0), (String)"true");
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            return false;
        }
    }
}

