/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.depenizen.bukkit.properties.worldguard;

import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.MapTag;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.debugging.SlowWarning;
import com.denizenscript.denizencore.utilities.debugging.Warning;
import com.denizenscript.depenizen.bukkit.bridges.WorldGuardBridge;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldguard.WorldGuard;
import com.sk89q.worldguard.bukkit.WorldGuardPlugin;
import com.sk89q.worldguard.protection.flags.Flag;
import com.sk89q.worldguard.protection.flags.Flags;
import com.sk89q.worldguard.protection.flags.StateFlag;
import com.sk89q.worldguard.protection.flags.registry.FlagRegistry;
import com.sk89q.worldguard.protection.regions.RegionQuery;
import org.bukkit.Location;

public class WorldGuardPlayerExtensions {
    public static Warning worldguardCanBuild = new SlowWarning("worldguardCanBuild", "Most pointless sub-tags are deprecated in favor of explicit unique tags. The tag 'PlayerTag.worldguard.can_build[...]' from Depenizen/Worldguard is deprecated: use 'PlayerTag.worldguard_can_build[...]'");
    public static Warning worldguardTestFlag = new SlowWarning("worldguardTestFlag", "Most pointless sub-tags are deprecated in favor of explicit unique tags. The tag 'PlayerTag.worldguard.test_flag[...]' from Depenizen/Worldguard is deprecated: use 'PlayerTag.worldguard_flag[...]'");

    public static void register() {
        PlayerTag.tagProcessor.registerTag(ObjectTag.class, "worldguard", (attribute, player) -> {
            if (attribute.startsWith("can_build", 2) && attribute.hasContext(2)) {
                worldguardCanBuild.warn(attribute.context);
                LocationTag loc = (LocationTag)attribute.contextAsType(2, LocationTag.class);
                attribute.fulfill(1);
                if (loc == null) {
                    return null;
                }
                WorldGuardPlugin worldGuard = (WorldGuardPlugin)WorldGuardBridge.instance.plugin;
                return new ElementTag(WorldGuard.getInstance().getPlatform().getRegionContainer().createQuery().testBuild(BukkitAdapter.adapt((Location)loc), worldGuard.wrapPlayer(player.getPlayerEntity()), new StateFlag[0]));
            }
            if (attribute.startsWith("test_flag", 2) && attribute.hasContext(2)) {
                worldguardTestFlag.warn(attribute.context);
                ElementTag name = (ElementTag)attribute.contextAsType(2, ElementTag.class);
                attribute.fulfill(1);
                Flag flag = Flags.fuzzyMatchFlag((FlagRegistry)WorldGuard.getInstance().getFlagRegistry(), (String)name.asString());
                if (flag == null) {
                    Debug.echoError((String)("The tag PlayerTag.worldguard.test_flag[...] has an invalid value: " + name.asString()));
                    return null;
                }
                LocationTag loc = player.getLocation();
                if (attribute.startsWith("at", 2) && attribute.hasContext(2)) {
                    loc = (LocationTag)attribute.contextAsType(2, LocationTag.class);
                    attribute.fulfill(1);
                    if (loc == null) {
                        return null;
                    }
                }
                WorldGuardPlugin worldGuard = (WorldGuardPlugin)WorldGuardBridge.instance.plugin;
                RegionQuery query = WorldGuard.getInstance().getPlatform().getRegionContainer().createQuery();
                if (flag instanceof StateFlag) {
                    StateFlag stateFlag = (StateFlag)flag;
                    return new ElementTag(query.testState(BukkitAdapter.adapt((Location)loc), worldGuard.wrapPlayer(player.getPlayerEntity()), new StateFlag[]{stateFlag}));
                }
                return CoreUtilities.objectToTagForm((Object)query.queryValue(BukkitAdapter.adapt((Location)loc), worldGuard.wrapPlayer(player.getPlayerEntity()), flag), (TagContext)attribute.context).asElement();
            }
            return null;
        }, new String[0]);
        PlayerTag.tagProcessor.registerTag(ElementTag.class, LocationTag.class, "worldguard_can_build", (attribute, player, loc) -> {
            WorldGuardPlugin worldGuard = (WorldGuardPlugin)WorldGuardBridge.instance.plugin;
            return new ElementTag(WorldGuard.getInstance().getPlatform().getRegionContainer().createQuery().testBuild(BukkitAdapter.adapt((Location)loc), worldGuard.wrapPlayer(player.getPlayerEntity()), new StateFlag[0]));
        }, new String[0]);
        PlayerTag.tagProcessor.registerTag(ObjectTag.class, MapTag.class, "worldguard_flag", (attribute, player, map) -> {
            ElementTag name = (ElementTag)map.getRequiredObjectAs("flag", ElementTag.class, attribute);
            Flag flag = Flags.fuzzyMatchFlag((FlagRegistry)WorldGuard.getInstance().getFlagRegistry(), (String)name.asString());
            if (flag == null) {
                Debug.echoError((String)("The tag PlayerTag.worldguard_flag[...] has an invalid flag: " + name.asString()));
                return null;
            }
            LocationTag loc = (LocationTag)map.getObjectAs("location", LocationTag.class, attribute.context);
            if (loc == null) {
                loc = player.getLocation();
            }
            WorldGuardPlugin worldGuard = (WorldGuardPlugin)WorldGuardBridge.instance.plugin;
            RegionQuery query = WorldGuard.getInstance().getPlatform().getRegionContainer().createQuery();
            if (flag instanceof StateFlag) {
                StateFlag stateFlag = (StateFlag)flag;
                return new ElementTag(query.testState(BukkitAdapter.adapt((Location)loc), worldGuard.wrapPlayer(player.getPlayerEntity()), new StateFlag[]{stateFlag}));
            }
            return CoreUtilities.objectToTagForm((Object)query.queryValue(BukkitAdapter.adapt((Location)loc), worldGuard.wrapPlayer(player.getPlayerEntity()), flag), (TagContext)attribute.context);
        }, new String[0]);
    }
}

