/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.depenizen.bukkit.bungee.packets.in;

import com.denizenscript.depenizen.bukkit.Depenizen;
import com.denizenscript.depenizen.bukkit.bungee.BungeeBridge;
import com.denizenscript.depenizen.bukkit.bungee.BungeePacketIn;
import com.denizenscript.depenizen.bukkit.bungee.packets.out.ProxyPingResultPacketOut;
import com.denizenscript.depenizen.bukkit.events.bungee.BungeeProxyServerListPingScriptEvent;
import io.netty.buffer.ByteBuf;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

public class ProxyPingPacketIn
extends BungeePacketIn {
    @Override
    public String getName() {
        return "ProxyPing";
    }

    @Override
    public void process(ByteBuf data) {
        if (data.readableBytes() < 32) {
            BungeeBridge.instance.handler.fail("Invalid ProxyPingPacket (bytes available: " + data.readableBytes() + ")");
            return;
        }
        long id = data.readLong();
        String address = this.readString(data, "address");
        int currentPlayers = data.readInt();
        int maxPlayers = data.readInt();
        String motd = this.readString(data, "motd");
        int protocol = data.readInt();
        String version = this.readString(data, "version");
        if (address == null || motd == null || version == null) {
            return;
        }
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)Depenizen.instance, () -> {
            BungeeProxyServerListPingScriptEvent.PingData ping = new BungeeProxyServerListPingScriptEvent.PingData();
            ping.address = address;
            ping.currentPlayers = currentPlayers;
            ping.maxPlayers = maxPlayers;
            ping.motd = motd;
            ping.protocol = protocol;
            ping.version = version;
            BungeeProxyServerListPingScriptEvent.instance.data = ping;
            BungeeProxyServerListPingScriptEvent.instance.fire();
            ProxyPingResultPacketOut packetOut = new ProxyPingResultPacketOut();
            packetOut.id = id;
            packetOut.maxPlayers = ping.maxPlayers;
            packetOut.version = ping.version;
            packetOut.motd = ping.motd;
            packetOut.playerSample = ping.playerSample;
            BungeeBridge.instance.sendPacket(packetOut);
        });
    }
}

