/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.depenizen.bukkit.objects.luckperms;

import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizencore.objects.Fetchable;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.tags.Attribute;
import com.denizenscript.denizencore.tags.ObjectTagProcessor;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.depenizen.bukkit.bridges.LuckPermsBridge;
import com.denizenscript.depenizen.bukkit.objects.luckperms.LuckPermsGroupTag;
import java.util.Collection;
import java.util.List;
import net.luckperms.api.model.group.Group;
import net.luckperms.api.model.user.User;
import net.luckperms.api.node.Node;
import net.luckperms.api.node.NodeType;
import net.luckperms.api.node.types.InheritanceNode;
import net.luckperms.api.query.QueryOptions;
import net.luckperms.api.track.Track;

public class LuckPermsTrackTag
implements ObjectTag {
    Track track;
    private String prefix = "LuckPermsTrack";
    public static ObjectTagProcessor<LuckPermsTrackTag> tagProcessor = new ObjectTagProcessor();

    @Fetchable(value="luckpermstrack")
    public static LuckPermsTrackTag valueOf(String string, TagContext context) {
        if (string.startsWith("luckpermstrack@")) {
            string = string.substring("luckpermstrack@".length());
        }
        try {
            Track track = LuckPermsBridge.luckPermsInstance.getTrackManager().getTrack(string);
            if (track == null) {
                return null;
            }
            return new LuckPermsTrackTag(track);
        }
        catch (Throwable e) {
            Debug.echoError((Throwable)e);
            return null;
        }
    }

    public static boolean matches(String arg) {
        if (arg.startsWith("luckpermstrack@")) {
            return true;
        }
        return LuckPermsBridge.luckPermsInstance.getTrackManager().isLoaded(arg);
    }

    public LuckPermsTrackTag(Track t) {
        this.track = t;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public LuckPermsTrackTag setPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    public int hashCode() {
        return this.track.hashCode();
    }

    public boolean equals(Object a) {
        if (a instanceof LuckPermsTrackTag) {
            return ((LuckPermsTrackTag)a).track.getName().equals(this.track.getName());
        }
        return false;
    }

    public boolean isUnique() {
        return true;
    }

    public String identify() {
        return "luckpermstrack@" + this.track.getName();
    }

    public String identifySimple() {
        return this.identify();
    }

    public String toString() {
        return this.identify();
    }

    public Track getTrack() {
        return this.track;
    }

    public ObjectTag getObjectAttribute(Attribute attribute) {
        return tagProcessor.getObjectAttribute((ObjectTag)this, attribute);
    }

    public static void register() {
        tagProcessor.registerStaticTag(ElementTag.class, "name", (attribute, object) -> new ElementTag(object.getTrack().getName(), true), new String[0]);
        tagProcessor.registerTag(ListTag.class, "groups", (attribute, object) -> {
            List trackGroups = object.getTrack().getGroups();
            if (!attribute.hasParam()) {
                return new ListTag((Collection)trackGroups, true);
            }
            PlayerTag player = (PlayerTag)attribute.paramAsType(PlayerTag.class);
            if (player == null) {
                attribute.echoError("Invalid player input for 'group' tag.");
                return null;
            }
            User user = LuckPermsBridge.luckPermsInstance.getUserManager().getUser(player.getUUID());
            if (user == null) {
                return null;
            }
            List<String> memberGroups = user.resolveInheritedNodes(QueryOptions.nonContextual()).stream().filter(arg_0 -> ((NodeType)NodeType.INHERITANCE).matches(arg_0)).map(arg_0 -> ((NodeType)NodeType.INHERITANCE).cast(arg_0)).filter(Node::getValue).map(InheritanceNode::getGroupName).filter(trackGroups::contains).toList();
            return new ListTag(memberGroups, true);
        }, new String[0]);
        tagProcessor.registerTag(ListTag.class, "loaded_groups", (attribute, object) -> {
            ListTag groups = new ListTag();
            List trackGroups = object.getTrack().getGroups();
            if (!attribute.hasParam()) {
                for (String groupName : trackGroups) {
                    Group group = LuckPermsBridge.luckPermsInstance.getGroupManager().getGroup(groupName);
                    if (group == null) continue;
                    groups.addObject((ObjectTag)new LuckPermsGroupTag(group));
                }
                return groups;
            }
            PlayerTag player = (PlayerTag)attribute.paramAsType(PlayerTag.class);
            if (player == null) {
                attribute.echoError("Invalid player input for 'group' tag.");
                return null;
            }
            User user = LuckPermsBridge.luckPermsInstance.getUserManager().getUser(player.getUUID());
            if (user == null) {
                return null;
            }
            List<String> memberGroups = user.resolveInheritedNodes(QueryOptions.nonContextual()).stream().filter(arg_0 -> ((NodeType)NodeType.INHERITANCE).matches(arg_0)).map(arg_0 -> ((NodeType)NodeType.INHERITANCE).cast(arg_0)).filter(Node::getValue).map(InheritanceNode::getGroupName).filter(trackGroups::contains).toList();
            for (String groupName : memberGroups) {
                Group group = LuckPermsBridge.luckPermsInstance.getGroupManager().getGroup(groupName);
                if (group == null) continue;
                groups.addObject((ObjectTag)new LuckPermsGroupTag(group));
            }
            return groups;
        }, new String[0]);
    }
}

