/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.depenizen.bukkit.commands.worldedit;

import com.denizenscript.denizen.Denizen;
import com.denizenscript.denizen.objects.CuboidTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.EmptyClipboardException;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.bukkit.BukkitPlayer;
import com.sk89q.worldedit.bukkit.BukkitWorld;
import com.sk89q.worldedit.extension.platform.Actor;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.extent.clipboard.BlockArrayClipboard;
import com.sk89q.worldedit.extent.clipboard.Clipboard;
import com.sk89q.worldedit.extent.clipboard.io.BuiltInClipboardFormat;
import com.sk89q.worldedit.extent.clipboard.io.ClipboardFormat;
import com.sk89q.worldedit.extent.clipboard.io.ClipboardFormats;
import com.sk89q.worldedit.extent.clipboard.io.ClipboardReader;
import com.sk89q.worldedit.extent.clipboard.io.ClipboardWriter;
import com.sk89q.worldedit.function.operation.ForwardExtentCopy;
import com.sk89q.worldedit.function.operation.Operation;
import com.sk89q.worldedit.function.operation.Operations;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.math.transform.AffineTransform;
import com.sk89q.worldedit.math.transform.Transform;
import com.sk89q.worldedit.regions.CuboidRegion;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.session.ClipboardHolder;
import com.sk89q.worldedit.session.SessionOwner;
import com.sk89q.worldedit.util.io.Closer;
import com.sk89q.worldedit.world.World;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.bukkit.entity.Player;

public class WorldEditCommand
extends AbstractCommand {
    public WorldEditCommand() {
        this.setName("worldedit");
        this.setSyntax("worldedit [create_schematic/copy_to_clipboard/paste] (file:<file path>) (cuboid:<cuboid>) (position:<location>) (rotate:<#>) (undoable) (noair)");
        this.setRequiredArguments(2, 7);
    }

    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (Argument arg : scriptEntry) {
            if (!scriptEntry.hasObject("position") && arg.matchesPrefix("position")) {
                scriptEntry.addObject("position", (Object)arg.asType(LocationTag.class));
                continue;
            }
            if (!scriptEntry.hasObject("file") && arg.matchesPrefix("file")) {
                scriptEntry.addObject("file", (Object)arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("cuboid") && arg.matchesPrefix("cuboid")) {
                scriptEntry.addObject("cuboid", (Object)arg.asType(CuboidTag.class));
                continue;
            }
            if (!scriptEntry.hasObject("noair") && arg.matches("noair")) {
                scriptEntry.addObject("noair", (Object)new ElementTag(true));
                continue;
            }
            if (!scriptEntry.hasObject("undoable") && arg.matches("undoable")) {
                scriptEntry.addObject("undoable", (Object)new ElementTag(true));
                continue;
            }
            if (!scriptEntry.hasObject("rotate") && arg.matchesPrefix("rotate")) {
                scriptEntry.addObject("rotate", (Object)arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("action") && arg.matchesEnum(Action.class)) {
                scriptEntry.addObject("action", (Object)arg.asElement());
                continue;
            }
            arg.reportUnhandled();
        }
        if (!scriptEntry.hasObject("action")) {
            throw new InvalidArgumentsException("Action not specified!");
        }
    }

    public CuboidRegion cuboidToWECuboid(CuboidTag cuboid) {
        LocationTag top = cuboid.getHigh(0);
        LocationTag bottom = cuboid.getLow(0);
        BlockVector3 topVector = BlockVector3.at((int)top.getBlockX(), (int)top.getBlockY(), (int)top.getBlockZ());
        BlockVector3 bottomVector = BlockVector3.at((int)bottom.getBlockX(), (int)bottom.getBlockY(), (int)bottom.getBlockZ());
        BukkitWorld w = new BukkitWorld(cuboid.getWorld().getWorld());
        return new CuboidRegion((World)w, bottomVector, topVector);
    }

    public void execute(ScriptEntry scriptEntry) {
        ElementTag action = (ElementTag)scriptEntry.getObjectTag("action");
        ElementTag file = (ElementTag)scriptEntry.getObjectTag("file");
        LocationTag position = (LocationTag)scriptEntry.getObjectTag("position");
        ElementTag noAir = (ElementTag)scriptEntry.getObjectTag("noair");
        CuboidTag cuboid = (CuboidTag)scriptEntry.getObjectTag("cuboid");
        ElementTag undoable = (ElementTag)scriptEntry.getObjectTag("undoable");
        ElementTag rotate = (ElementTag)scriptEntry.getObjectTag("rotate");
        if (scriptEntry.dbCallShouldDebug()) {
            Debug.report((Debuggable)scriptEntry, (String)this.getName(), (Object[])new Object[]{action, file, position, noAir, cuboid, undoable, rotate});
        }
        PlayerTag target = Utilities.getEntryPlayer((ScriptEntry)scriptEntry);
        if (action.asString().equalsIgnoreCase("paste")) {
            Clipboard clipboard;
            if (file == null) {
                Debug.echoError((String)"File path not specified");
                return;
            }
            if (position == null) {
                Debug.echoError((String)"Position not specified");
                return;
            }
            File fileToLoad = new File(Denizen.getInstance().getDataFolder(), "schematics/" + String.valueOf(file) + ".schem");
            if (!Utilities.canReadFile((File)fileToLoad)) {
                Debug.echoError((String)"Cannot read from that file path due to security settings in Denizen/config.yml.");
                return;
            }
            if (!fileToLoad.exists()) {
                Debug.echoError((String)"File not found");
                return;
            }
            ClipboardFormat format = ClipboardFormats.findByFile((File)fileToLoad);
            if (format == null) {
                Debug.echoError((String)"File not found");
                return;
            }
            try {
                ClipboardReader reader = format.getReader((InputStream)new FileInputStream(fileToLoad));
                clipboard = reader.read();
            }
            catch (IOException ex) {
                Debug.echoError((Throwable)ex);
                return;
            }
            if (clipboard == null) {
                Debug.echoError((String)"Clipboard became null");
                return;
            }
            ClipboardHolder holder = new ClipboardHolder(clipboard);
            if (rotate != null) {
                AffineTransform transform = new AffineTransform();
                transform = transform.rotateY((double)rotate.asInt());
                holder.setTransform(holder.getTransform().combine((Transform)transform));
            }
            BukkitWorld weWorld = new BukkitWorld(position.getWorld());
            if (undoable != null) {
                if (target == null) {
                    Debug.echoError((String)"Player not found in queue");
                    return;
                }
                BukkitPlayer wePlayer = BukkitAdapter.adapt((Player)target.getPlayerEntity());
                EditSession editSession = WorldEdit.getInstance().newEditSessionBuilder().world((World)weWorld).actor((Actor)wePlayer).build();
                Operation operation = holder.createPaste((Extent)editSession).to(BlockVector3.at((int)position.getBlockX(), (int)position.getBlockY(), (int)position.getBlockZ())).ignoreAirBlocks(noAir != null).build();
                try {
                    Operations.complete((Operation)operation);
                }
                catch (WorldEditException ex) {
                    Debug.echoError((String)"Exception in WorldEdit while loading a schematic to clipboard");
                    Debug.echoError((Throwable)ex);
                    return;
                }
                Operations.completeBlindly((Operation)editSession.commit());
                WorldEdit.getInstance().getSessionManager().get((SessionOwner)wePlayer).remember(editSession);
            } else {
                EditSession editSession = WorldEdit.getInstance().newEditSessionBuilder().world((World)weWorld).build();
                Operation operation = holder.createPaste((Extent)editSession).to(BlockVector3.at((int)position.getBlockX(), (int)position.getBlockY(), (int)position.getBlockZ())).ignoreAirBlocks(noAir != null).build();
                try {
                    Operations.complete((Operation)operation);
                }
                catch (WorldEditException ex) {
                    Debug.echoError((String)"Exception in WorldEdit while loading a schematic to clipboard");
                    Debug.echoError((Throwable)ex);
                    return;
                }
                Operations.completeBlindly((Operation)editSession.commit());
            }
        } else if (action.asString().equalsIgnoreCase("create_schematic")) {
            if (file == null) {
                Debug.echoError((String)"File not specified");
                return;
            }
            File fileToSave = new File(Denizen.getInstance().getDataFolder(), "schematics/" + String.valueOf(file) + ".schem");
            if (!Utilities.canWriteToFile((File)fileToSave)) {
                Debug.echoError((String)"Cannot write to that file path due to security settings in Denizen/config.yml.");
                return;
            }
            if (cuboid == null) {
                if (target == null) {
                    Debug.echoError((String)"Cuboid not specified");
                    return;
                }
                BukkitPlayer wePlayer = BukkitAdapter.adapt((Player)target.getPlayerEntity());
                try {
                    ClipboardHolder clipboard = WorldEdit.getInstance().getSessionManager().get((SessionOwner)wePlayer).getClipboard();
                    try (ClipboardWriter writer = BuiltInClipboardFormat.SPONGE_SCHEMATIC.getWriter((OutputStream)new FileOutputStream(fileToSave));){
                        writer.write(clipboard.getClipboard());
                    }
                    catch (IOException ex) {
                        Debug.echoError((Throwable)ex);
                    }
                }
                catch (EmptyClipboardException ex) {
                    Debug.echoError((String)"Cuboid not specified, and player does not have a clipboard");
                    return;
                }
                return;
            }
            CuboidRegion region = this.cuboidToWECuboid(cuboid);
            if (position == null) {
                Debug.echoError((String)"Position not specified");
                return;
            }
            BlockVector3 pos = BlockVector3.at((int)position.getBlockX(), (int)position.getBlockY(), (int)position.getBlockZ());
            BlockArrayClipboard clipboard = new BlockArrayClipboard((Region)region);
            clipboard.setOrigin(pos);
            EditSession editSession = WorldEdit.getInstance().getEditSessionFactory().getEditSession(region.getWorld(), -1);
            ForwardExtentCopy forwardExtentCopy = new ForwardExtentCopy((Extent)editSession, (Region)region, (Extent)clipboard, region.getMinimumPoint());
            forwardExtentCopy.setCopyingEntities(false);
            try {
                Operations.complete((Operation)forwardExtentCopy);
            }
            catch (WorldEditException ex) {
                Debug.echoError((String)"Exception in WorldEdit while loading a schematic to clipboard");
                Debug.echoError((Throwable)ex);
                return;
            }
            try (ClipboardWriter writer = BuiltInClipboardFormat.SPONGE_SCHEMATIC.getWriter((OutputStream)new FileOutputStream(fileToSave));){
                writer.write((Clipboard)clipboard);
            }
            catch (IOException ex) {
                Debug.echoError((Throwable)ex);
            }
        } else if (action.asString().equalsIgnoreCase("copy_to_clipboard")) {
            Clipboard clipboard;
            if (target == null) {
                Debug.echoError((String)"Player not found in queue");
                return;
            }
            if (file != null && cuboid != null) {
                Debug.echoError((String)"Both cuboid and file args were specified. Only one can be used.");
                return;
            }
            if (cuboid != null) {
                if (position == null) {
                    Debug.echoError((String)"Position not specified");
                    return;
                }
                CuboidRegion region = this.cuboidToWECuboid(cuboid);
                BukkitPlayer p = BukkitAdapter.adapt((Player)target.getPlayerEntity());
                BlockArrayClipboard clipboard2 = new BlockArrayClipboard((Region)region);
                BlockVector3 pos = BlockVector3.at((int)position.getBlockX(), (int)position.getBlockY(), (int)position.getBlockZ());
                clipboard2.setOrigin(pos);
                EditSession editSession = WorldEdit.getInstance().getEditSessionFactory().getEditSession(region.getWorld(), -1, (Actor)p);
                ForwardExtentCopy forwardExtentCopy = new ForwardExtentCopy((Extent)editSession, (Region)region, (Extent)clipboard2, region.getMinimumPoint());
                forwardExtentCopy.setCopyingEntities(false);
                try {
                    Operations.complete((Operation)forwardExtentCopy);
                }
                catch (WorldEditException ex) {
                    Debug.echoError((String)"Exception in WorldEdit while loading a schematic to clipboard");
                    Debug.echoError((Throwable)ex);
                    return;
                }
                ClipboardHolder holder = new ClipboardHolder((Clipboard)clipboard2);
                WorldEdit.getInstance().getSessionManager().get((SessionOwner)p).setClipboard(holder);
                return;
            }
            if (file == null) {
                Debug.echoError((String)"Cuboid or file must be specified.");
                return;
            }
            File fileToLoad = new File(Denizen.getInstance().getDataFolder(), "schematics/" + String.valueOf(file) + ".schem");
            if (!Utilities.canReadFile((File)fileToLoad)) {
                Debug.echoError((String)"Cannot read from that file path due to security settings in Denizen/config.yml.");
                return;
            }
            if (!fileToLoad.exists()) {
                Debug.echoError((String)"File not found");
                return;
            }
            ClipboardFormat format = ClipboardFormats.findByFile((File)fileToLoad);
            if (format == null) {
                Debug.echoError((String)"File not found");
                return;
            }
            Closer closer = Closer.create();
            try {
                FileInputStream fis = (FileInputStream)closer.register((Closeable)new FileInputStream(fileToLoad));
                BufferedInputStream bis = (BufferedInputStream)closer.register((Closeable)new BufferedInputStream(fis));
                ClipboardReader reader = (ClipboardReader)closer.register((Closeable)format.getReader((InputStream)bis));
                clipboard = reader.read();
            }
            catch (IOException ex) {
                Debug.echoError((Throwable)ex);
                return;
            }
            if (clipboard == null) {
                Debug.echoError((String)"Clipboard returned null");
                return;
            }
            ClipboardHolder holder = new ClipboardHolder(clipboard);
            BukkitPlayer wePlayer = BukkitAdapter.adapt((Player)target.getPlayerEntity());
            WorldEdit.getInstance().getSessionManager().get((SessionOwner)wePlayer).setClipboard(holder);
        }
    }

    private static enum Action {
        CREATE_SCHEMATIC,
        COPY_TO_CLIPBOARD,
        PASTE;

    }
}

