/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.depenizen.bukkit.objects.mobarena;

import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizencore.objects.Fetchable;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.tags.Attribute;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.depenizen.bukkit.bridges.MobArenaBridge;
import com.garbagemule.MobArena.MobArena;
import com.garbagemule.MobArena.framework.Arena;
import org.bukkit.entity.Player;

public class MobArenaArenaTag
implements ObjectTag {
    String prefix = "MobArena";
    Arena arena = null;

    public static MobArenaArenaTag valueOf(String name) {
        return MobArenaArenaTag.valueOf(name, null);
    }

    @Fetchable(value="mobarena")
    public static MobArenaArenaTag valueOf(String name, TagContext context) {
        if (name == null) {
            return null;
        }
        name = name.replace("mobarena@", "");
        Arena arena = ((MobArena)MobArenaBridge.instance.plugin).getArenaMaster().getArenaWithName(name);
        if (arena == null) {
            return null;
        }
        return new MobArenaArenaTag(arena);
    }

    public static boolean matches(String name) {
        return MobArenaArenaTag.valueOf(name) != null;
    }

    public MobArenaArenaTag(Arena arena) {
        if (arena != null) {
            this.arena = arena;
        } else {
            Debug.echoError((String)"Arena referenced is null");
        }
    }

    public Arena getArena() {
        return this.arena;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public ObjectTag setPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    public boolean isUnique() {
        return true;
    }

    public String identify() {
        return "mobarena@" + this.arena.configName();
    }

    public String identifySimple() {
        return this.identify();
    }

    public String toString() {
        return this.identify();
    }

    public ObjectTag getObjectAttribute(Attribute attribute) {
        if (attribute == null) {
            return null;
        }
        if (attribute.startsWith("name")) {
            return new ElementTag(this.arena.arenaName()).getObjectAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("config_name")) {
            return new ElementTag(this.arena.configName()).getObjectAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("is_running")) {
            return new ElementTag(this.arena.isRunning()).getObjectAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("wave_count")) {
            return new ElementTag(this.arena.getWaveManager().getFinalWave()).getObjectAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("current_wave") && this.arena.isRunning()) {
            return new ElementTag(this.arena.getWaveManager().getWaveNumber()).getObjectAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("wave_type") && this.arena.isRunning()) {
            return new ElementTag(this.arena.getWaveManager().getCurrent().getType().toString()).getObjectAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("is_enabled")) {
            return new ElementTag(this.arena.isEnabled()).getObjectAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("status")) {
            if (!this.arena.isEnabled()) {
                return new ElementTag("closed").getObjectAttribute(attribute.fulfill(1));
            }
            if (!this.arena.isRunning()) {
                return new ElementTag("open").getObjectAttribute(attribute.fulfill(1));
            }
            return new ElementTag("running").getObjectAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("players")) {
            if (attribute.getAttribute(2).startsWith("in_arena")) {
                ListTag players = new ListTag();
                for (Player p : this.arena.getPlayersInArena()) {
                    players.addObject((ObjectTag)new PlayerTag(p));
                }
                return players.getObjectAttribute(attribute.fulfill(2));
            }
            if (attribute.getAttribute(2).startsWith("in_lobby")) {
                ListTag players = new ListTag();
                for (Player p : this.arena.getPlayersInLobby()) {
                    players.addObject((ObjectTag)new PlayerTag(p));
                }
                return players.getObjectAttribute(attribute.fulfill(2));
            }
            ListTag players = new ListTag();
            for (Player p : this.arena.getAllPlayers()) {
                players.addObject((ObjectTag)new PlayerTag(p));
            }
            return players.getObjectAttribute(attribute.fulfill(1));
        }
        return new ElementTag(this.identify()).getObjectAttribute(attribute);
    }
}

