/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.depenizen.bukkit.objects.skillapi;

import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizencore.objects.Fetchable;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.tags.Attribute;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.sucy.skill.SkillAPI;
import com.sucy.skill.api.classes.RPGClass;

public class SkillAPIClassTag
implements ObjectTag {
    RPGClass rpgClass;
    private String prefix = "SkillAPIClass";

    @Fetchable(value="skillapiclass")
    public static SkillAPIClassTag valueOf(String string, TagContext context) {
        RPGClass rpgClass;
        if (string.startsWith("skillapiclass@")) {
            string = string.substring("skillapiclass@".length());
        }
        if ((rpgClass = SkillAPI.getClass((String)string)) != null) {
            return new SkillAPIClassTag(rpgClass);
        }
        return null;
    }

    public static boolean matches(String arg) {
        return SkillAPIClassTag.valueOf(arg, CoreUtilities.noDebugContext) != null;
    }

    public SkillAPIClassTag(RPGClass rpgClass) {
        this.rpgClass = rpgClass;
    }

    public RPGClass getRPGClass() {
        return this.rpgClass;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public ObjectTag setPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    public boolean isUnique() {
        return true;
    }

    public String identify() {
        return "skillapiclass@" + this.rpgClass.getName();
    }

    public String identifySimple() {
        return this.identify();
    }

    public String toString() {
        return this.identify();
    }

    public ObjectTag getObjectAttribute(Attribute attribute) {
        if (attribute.startsWith("name")) {
            return new ElementTag(this.rpgClass.getName()).getObjectAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("prefix_color")) {
            return new ElementTag(this.rpgClass.getPrefixColor().toString()).getObjectAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("class_prefix")) {
            return new ElementTag(this.rpgClass.getPrefix()).getObjectAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("needs_permission")) {
            return new ElementTag(this.rpgClass.isNeedsPermission()).getObjectAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("group_name")) {
            return new ElementTag(this.rpgClass.getGroup()).getObjectAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("group.name")) {
            Debug.echoError((String)"Deprecation notice - please change 'SkillAPIClassTag.group.name' to 'SkillAPIClassTag.group_name'");
            return new ElementTag(this.rpgClass.getGroup()).getObjectAttribute(attribute.fulfill(2));
        }
        if (attribute.startsWith("has_parent")) {
            return new ElementTag(this.rpgClass.hasParent()).getObjectAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("parent")) {
            return new SkillAPIClassTag(this.rpgClass.getParent()).getObjectAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("icon")) {
            return new ItemTag(this.rpgClass.getIcon()).getObjectAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("max_level")) {
            return new ElementTag(this.rpgClass.getMaxLevel()).getObjectAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("base_health")) {
            return new ElementTag(this.rpgClass.getBaseHealth()).getObjectAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("health_scale")) {
            return new ElementTag(this.rpgClass.getHealthScale()).getObjectAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("base_mana")) {
            return new ElementTag(this.rpgClass.getBaseMana()).getObjectAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("mana_scale")) {
            return new ElementTag(this.rpgClass.getManaScale()).getObjectAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("mana_name")) {
            return new ElementTag(this.rpgClass.getManaName()).getObjectAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("has_mana_regen")) {
            return new ElementTag(this.rpgClass.hasManaRegen()).getObjectAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("mana_regen")) {
            return new ElementTag(this.rpgClass.getManaRegen()).getObjectAttribute(attribute.fulfill(1));
        }
        return new ElementTag(this.identify()).getObjectAttribute(attribute);
    }
}

