/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.depenizen.bukkit.properties.worldedit;

import com.denizenscript.denizen.objects.CuboidTag;
import com.denizenscript.denizen.objects.EllipsoidTag;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.objects.PolygonTag;
import com.denizenscript.denizen.objects.WorldTag;
import com.denizenscript.denizencore.objects.Mechanism;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.objects.properties.Property;
import com.denizenscript.denizencore.objects.properties.PropertyParser;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.debugging.DebugInternals;
import com.denizenscript.depenizen.bukkit.bridges.WorldEditBridge;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.bukkit.WorldEditPlugin;
import com.sk89q.worldedit.command.tool.BrushTool;
import com.sk89q.worldedit.command.tool.Tool;
import com.sk89q.worldedit.command.tool.brush.Brush;
import com.sk89q.worldedit.extension.platform.Actor;
import com.sk89q.worldedit.function.pattern.BlockPattern;
import com.sk89q.worldedit.function.pattern.Pattern;
import com.sk89q.worldedit.math.BlockVector2;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.math.Vector3;
import com.sk89q.worldedit.regions.EllipsoidRegion;
import com.sk89q.worldedit.regions.Polygonal2DRegion;
import com.sk89q.worldedit.regions.RegionSelector;
import com.sk89q.worldedit.regions.selector.CuboidRegionSelector;
import com.sk89q.worldedit.regions.selector.EllipsoidRegionSelector;
import com.sk89q.worldedit.regions.selector.Polygonal2DRegionSelector;
import com.sk89q.worldedit.world.World;
import com.sk89q.worldedit.world.item.ItemType;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class WorldEditPlayerProperties
implements Property {
    public static final String[] handledMechs = new String[]{"we_selection"};
    Player player;

    public String getPropertyString() {
        return null;
    }

    public String getPropertyId() {
        return "WorldEditPlayer";
    }

    public static boolean describes(ObjectTag object) {
        return object instanceof PlayerTag && ((PlayerTag)object).isOnline();
    }

    public static WorldEditPlayerProperties getFrom(ObjectTag object) {
        if (!WorldEditPlayerProperties.describes(object)) {
            return null;
        }
        return new WorldEditPlayerProperties((PlayerTag)object);
    }

    public WorldEditPlayerProperties(PlayerTag player) {
        this.player = player.getPlayerEntity();
    }

    public static Material deLegacy(Material mat) {
        if (mat.isLegacy()) {
            return Bukkit.getUnsafe().fromLegacy(mat);
        }
        return mat;
    }

    public static void register() {
        PropertyParser.registerTag(WorldEditPlayerProperties.class, ListTag.class, (String)"we_brush_info", (attribute, object) -> {
            ItemStack itm;
            WorldEditPlugin worldEdit = (WorldEditPlugin)WorldEditBridge.instance.plugin;
            ItemType itemType = attribute.hasParam() ? BukkitAdapter.asItemType((Material)WorldEditPlayerProperties.deLegacy(((ItemTag)attribute.paramAsType(ItemTag.class)).getMaterial().getMaterial())) : BukkitAdapter.asItemType((Material)WorldEditPlayerProperties.deLegacy((itm = object.player.getEquipment().getItemInMainHand()) == null ? Material.AIR : itm.getType()));
            Tool tool = worldEdit.getSession(object.player).getTool(itemType);
            if (!(tool instanceof BrushTool)) {
                return null;
            }
            BrushTool brush = (BrushTool)tool;
            Brush btype = brush.getBrush();
            String brushType = CoreUtilities.toLowerCase((String)DebugInternals.getClassNameOpti((Class)btype.getClass()));
            String materialInfo = "unknown";
            Pattern materialPattern = brush.getMaterial();
            if (materialPattern instanceof BlockPattern) {
                materialInfo = ((BlockPattern)materialPattern).getBlock().getAsString();
            }
            ListTag info = new ListTag();
            info.add(brushType);
            info.add(String.valueOf(brush.getSize()));
            info.add(String.valueOf(brush.getRange()));
            info.add(materialInfo);
            return info;
        }, (String[])new String[0]);
        PropertyParser.registerTag(WorldEditPlayerProperties.class, ObjectTag.class, (String)"we_selection", (attribute, object) -> {
            WorldEditPlugin worldEdit = (WorldEditPlugin)WorldEditBridge.instance.plugin;
            RegionSelector selection = worldEdit.getSession(object.player).getRegionSelector(BukkitAdapter.adapt((org.bukkit.World)object.player.getWorld()));
            try {
                if (selection != null && selection.isDefined()) {
                    if (selection instanceof EllipsoidRegionSelector) {
                        EllipsoidRegion region = ((EllipsoidRegionSelector)selection).getRegion();
                        return new EllipsoidTag(new LocationTag(BukkitAdapter.adapt((org.bukkit.World)BukkitAdapter.adapt((World)region.getWorld()), (Vector3)region.getCenter())), new LocationTag(BukkitAdapter.adapt((org.bukkit.World)BukkitAdapter.adapt((World)region.getWorld()), (Vector3)region.getRadius())));
                    }
                    if (selection instanceof Polygonal2DRegionSelector) {
                        Polygonal2DRegion region = ((Polygonal2DRegionSelector)selection).getRegion();
                        PolygonTag poly = new PolygonTag(new WorldTag(region.getWorld().getName()));
                        for (BlockVector2 vec2 : region.getPoints()) {
                            poly.corners.add(new PolygonTag.Corner((double)vec2.getX(), (double)vec2.getZ()));
                        }
                        poly.yMin = region.getMinimumY();
                        poly.yMax = region.getMaximumY();
                        poly.recalculateBox();
                        return poly;
                    }
                    return new CuboidTag(BukkitAdapter.adapt((org.bukkit.World)object.player.getWorld(), (BlockVector3)selection.getIncompleteRegion().getMinimumPoint()), BukkitAdapter.adapt((org.bukkit.World)object.player.getWorld(), (BlockVector3)selection.getIncompleteRegion().getMaximumPoint()));
                }
            }
            catch (Throwable ex) {
                Debug.echoError((Throwable)ex);
            }
            return null;
        }, (String[])new String[]{"selected_region"});
    }

    public void adjust(Mechanism mechanism) {
        if (mechanism.matches("we_selection")) {
            CuboidRegionSelector selector;
            WorldEditPlugin worldEdit = (WorldEditPlugin)WorldEditBridge.instance.plugin;
            if (mechanism.getValue().asString().startsWith("cu@")) {
                input = (CuboidTag)mechanism.valueAsType(CuboidTag.class);
                selector = new CuboidRegionSelector(BukkitAdapter.adapt((org.bukkit.World)input.getWorld().getWorld()), BukkitAdapter.asBlockVector((Location)input.getLow(0)), BukkitAdapter.asBlockVector((Location)input.getHigh(0)));
            } else if (mechanism.getValue().asString().startsWith("ellipsoid@")) {
                input = (EllipsoidTag)mechanism.valueAsType(EllipsoidTag.class);
                selector = new EllipsoidRegionSelector(BukkitAdapter.adapt((org.bukkit.World)input.center.getWorld()), BukkitAdapter.asBlockVector((Location)input.center), BukkitAdapter.asVector((Location)input.size));
            } else if (mechanism.getValue().asString().startsWith("polygon@")) {
                input = (PolygonTag)mechanism.valueAsType(PolygonTag.class);
                selector = new Polygonal2DRegionSelector(BukkitAdapter.adapt((org.bukkit.World)input.world.getWorld()), input.corners.stream().map(c -> BlockVector2.at((double)c.x, (double)c.z)).collect(Collectors.toList()), (int)input.yMin, (int)input.yMax);
            } else {
                Debug.echoError((String)"Invalid we_selection input");
                return;
            }
            LocalSession session = worldEdit.getSession(this.player);
            session.setRegionSelector(BukkitAdapter.adapt((org.bukkit.World)this.player.getWorld()), (RegionSelector)selector);
            selector.explainRegionAdjust((Actor)BukkitAdapter.adapt((Player)this.player), session);
        }
    }
}

