/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.depenizen.bukkit.bungee;

import com.denizenscript.denizencore.DenizenCore;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.scripts.commands.core.AdjustCommand;
import com.denizenscript.denizencore.tags.Attribute;
import com.denizenscript.denizencore.tags.ReplaceableTagEvent;
import com.denizenscript.denizencore.tags.TagManager;
import com.denizenscript.denizencore.tags.TagRunnable;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.depenizen.bukkit.Depenizen;
import com.denizenscript.depenizen.bukkit.bungee.BungeeClientHandler;
import com.denizenscript.depenizen.bukkit.bungee.BungeePacketIn;
import com.denizenscript.depenizen.bukkit.bungee.BungeePacketOut;
import com.denizenscript.depenizen.bukkit.bungee.NettyExceptionHandler;
import com.denizenscript.depenizen.bukkit.bungee.packets.in.AddServerPacketIn;
import com.denizenscript.depenizen.bukkit.bungee.packets.in.KeepAlivePacketIn;
import com.denizenscript.depenizen.bukkit.bungee.packets.in.PlayerJoinPacketIn;
import com.denizenscript.depenizen.bukkit.bungee.packets.in.PlayerQuitPacketIn;
import com.denizenscript.depenizen.bukkit.bungee.packets.in.PlayerSwitchServerPacketIn;
import com.denizenscript.depenizen.bukkit.bungee.packets.in.ProxyCommandPacketIn;
import com.denizenscript.depenizen.bukkit.bungee.packets.in.ProxyPingPacketIn;
import com.denizenscript.depenizen.bukkit.bungee.packets.in.ReadTagPacketIn;
import com.denizenscript.depenizen.bukkit.bungee.packets.in.RemoveServerPacketIn;
import com.denizenscript.depenizen.bukkit.bungee.packets.in.RunCommandsPacketIn;
import com.denizenscript.depenizen.bukkit.bungee.packets.in.RunScriptPacketIn;
import com.denizenscript.depenizen.bukkit.bungee.packets.in.TagResponsePacketIn;
import com.denizenscript.depenizen.bukkit.bungee.packets.in.YourInfoPacketIn;
import com.denizenscript.depenizen.bukkit.bungee.packets.out.ControlsProxyCommandPacketOut;
import com.denizenscript.depenizen.bukkit.bungee.packets.out.ControlsProxyPingPacketOut;
import com.denizenscript.depenizen.bukkit.bungee.packets.out.KeepAlivePacketOut;
import com.denizenscript.depenizen.bukkit.commands.bungee.BungeeCommand;
import com.denizenscript.depenizen.bukkit.commands.bungee.BungeeExecuteCommand;
import com.denizenscript.depenizen.bukkit.commands.bungee.BungeeRunCommand;
import com.denizenscript.depenizen.bukkit.commands.bungee.BungeeTagCommand;
import com.denizenscript.depenizen.bukkit.events.bungee.BungeePlayerJoinsScriptEvent;
import com.denizenscript.depenizen.bukkit.events.bungee.BungeePlayerQuitsScriptEvent;
import com.denizenscript.depenizen.bukkit.events.bungee.BungeePlayerServerSwitchScriptEvent;
import com.denizenscript.depenizen.bukkit.events.bungee.BungeeProxyServerCommandScriptEvent;
import com.denizenscript.depenizen.bukkit.events.bungee.BungeeProxyServerListPingScriptEvent;
import com.denizenscript.depenizen.bukkit.events.bungee.BungeeServerConnectScriptEvent;
import com.denizenscript.depenizen.bukkit.events.bungee.BungeeServerDisconnectScriptEvent;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

public class BungeeBridge {
    public static BungeeBridge instance;
    public Channel channel;
    public NioEventLoopGroup workerGroup;
    public BungeeClientHandler handler;
    public String address;
    public int port;
    public String serverName = "<Unknown>";
    public List<String> knownServers = new ArrayList<String>();
    public HashMap<Integer, BungeePacketIn> packets = new HashMap();
    public boolean connected = false;
    public boolean controlsProxyPing = false;
    public boolean controlsProxyCommand = false;
    public int keepAliveTickRate = 10;
    public int ticksTilKeepalive = 10;
    public long lastPacketReceived = 0L;
    public boolean reconnectPending = false;
    public boolean shuttingDown = false;
    private boolean showedLastError = false;
    private boolean hasConnectionLoading = false;

    public void checkBroadcastProxyPing() {
        if (this.connected) {
            this.sendPacket(new ControlsProxyPingPacketOut(this.controlsProxyPing));
        }
    }

    public void checkBroadcastProxyCommand() {
        if (this.connected) {
            this.sendPacket(new ControlsProxyCommandPacketOut(this.controlsProxyCommand));
        }
    }

    public void registerPackets() {
        this.packets.put(1, new KeepAlivePacketIn());
        this.packets.put(50, new YourInfoPacketIn());
        this.packets.put(51, new AddServerPacketIn());
        this.packets.put(52, new RemoveServerPacketIn());
        this.packets.put(53, new PlayerJoinPacketIn());
        this.packets.put(54, new PlayerQuitPacketIn());
        this.packets.put(55, new PlayerSwitchServerPacketIn());
        this.packets.put(56, new ProxyPingPacketIn());
        this.packets.put(57, new RunScriptPacketIn());
        this.packets.put(58, new RunCommandsPacketIn());
        this.packets.put(59, new ReadTagPacketIn());
        this.packets.put(60, new TagResponsePacketIn());
        this.packets.put(61, new ProxyCommandPacketIn());
    }

    public static void runOnMainThread(Runnable run) {
        if (Bukkit.isPrimaryThread()) {
            run.run();
        } else if (Depenizen.instance.isEnabled()) {
            Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)Depenizen.instance, run);
        }
    }

    public void sendPacket(BungeePacketOut packet) {
        if (!this.connected && !packet.canBeFirstPacket) {
            BungeeBridge.runOnMainThread(() -> Debug.echoError((String)("BungeeBridge tried to send packet '" + packet.getClass().getName() + "' while not connected.")));
            return;
        }
        ByteBuf buf = this.channel.alloc().buffer();
        packet.writeTo(buf);
        ByteBuf header = this.channel.alloc().buffer();
        header.writeInt(buf.writerIndex());
        header.writeInt(packet.getPacketId());
        this.channel.writeAndFlush((Object)header);
        this.channel.writeAndFlush((Object)buf);
        if (this.connected) {
            this.ticksTilKeepalive = 0;
        }
    }

    public void init(String address, int port) {
        this.address = address;
        this.port = port;
        this.workerGroup = new NioEventLoopGroup();
        this.registerPackets();
        this.connect();
        this.successInit();
    }

    public void reconnect(boolean delay) {
        if (this.reconnectPending || this.shuttingDown) {
            return;
        }
        this.connected = false;
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)Depenizen.instance, () -> {
            this.reconnectPending = false;
            this.connect();
        }, delay ? 100L : 0L);
    }

    public void onShutdown() {
        this.shuttingDown = true;
        if (this.connected) {
            try {
                this.handler.channel.close().await();
                this.connected = false;
            }
            catch (Throwable ex) {
                Debug.echoError((Throwable)ex);
            }
        }
    }

    public void connect() {
        try {
            this.ticksTilKeepalive = 100;
            this.hasConnectionLoading = false;
            this.knownServers.clear();
            Bootstrap b = new Bootstrap();
            b.group((EventLoopGroup)this.workerGroup);
            b.channel(NioSocketChannel.class);
            b.option(ChannelOption.SO_KEEPALIVE, (Object)true);
            b.handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                public void initChannel(SocketChannel ch) {
                    BungeeBridge.this.hasConnectionLoading = true;
                    BungeeBridge.this.handler = new BungeeClientHandler();
                    BungeeBridge.this.handler.channel = ch;
                    ch.pipeline().addLast(new ChannelHandler[]{BungeeBridge.this.handler}).addLast(new ChannelHandler[]{new NettyExceptionHandler()});
                    BungeeBridge.this.channel = ch;
                }
            });
            b.connect(this.address, this.port).addListener(future -> Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)Depenizen.instance, () -> {
                if (!this.connected && !this.hasConnectionLoading) {
                    this.reconnect(true);
                }
            }, 10L));
            this.showedLastError = false;
        }
        catch (Throwable ex) {
            if (!this.showedLastError) {
                this.showedLastError = true;
                Debug.echoError((Throwable)ex);
            }
            this.reconnect(true);
        }
    }

    public void successInit() {
        instance = this;
        ScriptEvent.registerScriptEvent(BungeePlayerJoinsScriptEvent.class);
        ScriptEvent.registerScriptEvent(BungeePlayerQuitsScriptEvent.class);
        ScriptEvent.registerScriptEvent(BungeePlayerServerSwitchScriptEvent.class);
        ScriptEvent.registerScriptEvent(BungeeProxyServerCommandScriptEvent.class);
        ScriptEvent.registerScriptEvent(BungeeProxyServerListPingScriptEvent.class);
        ScriptEvent.registerScriptEvent(BungeeServerConnectScriptEvent.class);
        ScriptEvent.registerScriptEvent(BungeeServerDisconnectScriptEvent.class);
        DenizenCore.commandRegistry.registerCommand(BungeeRunCommand.class);
        DenizenCore.commandRegistry.registerCommand(BungeeExecuteCommand.class);
        DenizenCore.commandRegistry.registerCommand(BungeeCommand.class);
        DenizenCore.commandRegistry.registerCommand(BungeeTagCommand.class);
        TagManager.registerTagHandler((TagRunnable.RootForm)new TagRunnable.RootForm(){

            public void run(ReplaceableTagEvent event) {
                BungeeBridge.this.tagEvent(event);
            }
        }, (String[])new String[]{"bungee"});
        Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)Depenizen.instance, () -> {
            if (!this.connected) {
                return;
            }
            if (CoreUtilities.monotonicMillis() > this.lastPacketReceived + 20000L) {
                this.handler.fail("Connection time out.");
                return;
            }
            --this.ticksTilKeepalive;
            if (this.ticksTilKeepalive <= 0) {
                this.sendPacket(new KeepAlivePacketOut());
                this.ticksTilKeepalive = this.keepAliveTickRate;
            }
        }, 1L, 1L);
        AdjustCommand.specialAdjustables.put("bungee", mechanism -> {
            if (mechanism.matches("reconnect")) {
                if (BungeeBridge.instance.connected) {
                    BungeeBridge.instance.handler.fail("Reconnect requested");
                }
                instance.reconnect(false);
            }
        });
    }

    public void tagEvent(ReplaceableTagEvent event) {
        Attribute attribute = event.getAttributes().fulfill(1);
        if (attribute.startsWith("server")) {
            event.setReplacedObject(new ElementTag(this.serverName).getObjectAttribute(attribute.fulfill(1)));
        }
        if (attribute.startsWith("list_servers")) {
            event.setReplacedObject(new ListTag(this.knownServers).getObjectAttribute(attribute.fulfill(1)));
        }
        if (attribute.startsWith("connected")) {
            event.setReplacedObject(new ElementTag(this.connected).getObjectAttribute(attribute.fulfill(1)));
        }
    }
}

