/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.depenizen.bukkit.objects.plotsquared;

import com.denizenscript.denizen.objects.CuboidTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.objects.WorldTag;
import com.denizenscript.denizencore.objects.Fetchable;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.tags.Attribute;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.github.intellectualsites.plotsquared.plot.object.Location;
import com.github.intellectualsites.plotsquared.plot.object.Plot;
import com.github.intellectualsites.plotsquared.plot.object.RegionWrapper;
import com.github.intellectualsites.plotsquared.plot.util.MainUtil;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;

public class PlotSquaredPlotTag
implements ObjectTag {
    public Plot plot;
    private String prefix = "PlotSquaredPlot";

    @Fetchable(value="plotsquaredplot")
    public static PlotSquaredPlotTag valueOf(String string, TagContext context) {
        if (string.startsWith("plotsquaredplot@")) {
            string = string.substring("plotsquaredplot@".length());
        }
        try {
            List split = CoreUtilities.split((String)string, (char)',');
            if (split.size() < 3) {
                return null;
            }
            Plot p = MainUtil.getPlotFromString(null, (String)((String)split.get(2) + ";" + (String)split.get(0) + ";" + (String)split.get(1)), (boolean)false);
            if (p == null) {
                return null;
            }
            return new PlotSquaredPlotTag(p);
        }
        catch (Throwable e) {
            Debug.echoError((Throwable)e);
            return null;
        }
    }

    public static boolean matches(String arg) {
        return arg.startsWith("plotsquaredplot@");
    }

    public PlotSquaredPlotTag(Plot pl) {
        this.plot = pl;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public PlotSquaredPlotTag setPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    public int hashCode() {
        return this.plot.getId().hashCode();
    }

    public boolean equals(Object a) {
        if (a instanceof PlotSquaredPlotTag) {
            return ((PlotSquaredPlotTag)a).plot.getId().equals((Object)this.plot.getId());
        }
        return false;
    }

    public boolean isUnique() {
        return true;
    }

    public String identify() {
        return "plotsquaredplot@" + this.plot.getId().x + "," + this.plot.getId().y + "," + this.plot.getArea().worldname;
    }

    public String identifySimple() {
        return this.identify();
    }

    public String toString() {
        return this.identify();
    }

    public ObjectTag getObjectAttribute(Attribute attribute) {
        if (attribute.startsWith("x")) {
            return new ElementTag(this.plot.getId().x).getObjectAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("z")) {
            return new ElementTag(this.plot.getId().y).getObjectAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("home")) {
            Location loca = this.plot.getHome();
            return new LocationTag(new org.bukkit.Location(Bukkit.getWorld((String)this.plot.getArea().worldname), (double)loca.getX(), (double)loca.getY(), (double)loca.getZ())).getObjectAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("default_home")) {
            Location loca = this.plot.getDefaultHome();
            return new LocationTag(new org.bukkit.Location(Bukkit.getWorld((String)this.plot.getArea().worldname), (double)loca.getX(), (double)loca.getY(), (double)loca.getZ())).getObjectAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("world")) {
            return WorldTag.valueOf((String)this.plot.getArea().worldname, (TagContext)attribute.context).getObjectAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("owners")) {
            ListTag players = new ListTag();
            for (UUID uuid : this.plot.getOwners()) {
                players.addObject((ObjectTag)new PlayerTag(uuid));
            }
            return players.getObjectAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("trusted")) {
            ListTag players = new ListTag();
            for (UUID uuid : this.plot.getTrusted()) {
                players.addObject((ObjectTag)new PlayerTag(uuid));
            }
            return players.getObjectAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("denied")) {
            ListTag players = new ListTag();
            for (UUID uuid : this.plot.getDenied()) {
                players.addObject((ObjectTag)new PlayerTag(uuid));
            }
            return players.getObjectAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("members")) {
            ListTag players = new ListTag();
            for (UUID uuid : this.plot.getMembers()) {
                players.addObject((ObjectTag)new PlayerTag(uuid));
            }
            return players.getObjectAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("cuboid")) {
            WorldTag world = WorldTag.valueOf((String)this.plot.getArea().worldname, (TagContext)attribute.context);
            org.bukkit.Location l1 = new org.bukkit.Location(world.getWorld(), (double)this.plot.getBottomAbs().getX(), 0.0, (double)this.plot.getBottomAbs().getZ());
            org.bukkit.Location l2 = new org.bukkit.Location(world.getWorld(), (double)this.plot.getTopAbs().getX(), 255.0, (double)this.plot.getTopAbs().getZ());
            return new CuboidTag(l1, l2).getObjectAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("all_cuboids")) {
            ListTag cuboids = new ListTag();
            WorldTag world = WorldTag.valueOf((String)this.plot.getArea().worldname, (TagContext)attribute.context);
            for (RegionWrapper region : this.plot.getRegions()) {
                org.bukkit.Location l1 = new org.bukkit.Location(world.getWorld(), (double)region.minX, (double)region.minY, (double)region.minZ);
                org.bukkit.Location l2 = new org.bukkit.Location(world.getWorld(), (double)region.maxX, (double)region.maxY, (double)region.maxZ);
                cuboids.addObject((ObjectTag)new CuboidTag(l1, l2));
            }
            return cuboids.getObjectAttribute(attribute.fulfill(1));
        }
        return new ElementTag(this.identify()).getObjectAttribute(attribute);
    }
}

