/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.depenizen.bukkit.bungee.packets.in;

import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.tags.BukkitTagContext;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.denizencore.tags.TagManager;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.depenizen.bukkit.Depenizen;
import com.denizenscript.depenizen.bukkit.bungee.BungeeBridge;
import com.denizenscript.depenizen.bukkit.bungee.BungeePacketIn;
import com.denizenscript.depenizen.bukkit.bungee.packets.in.RunCommandsPacketIn;
import com.denizenscript.depenizen.bukkit.bungee.packets.out.RedirectPacketOut;
import com.denizenscript.depenizen.bukkit.bungee.packets.out.redirectable.TagResponsePacketOut;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.plugin.Plugin;

public class ReadTagPacketIn
extends BungeePacketIn {
    @Override
    public String getName() {
        return "ReadTag";
    }

    @Override
    public void process(ByteBuf data) {
        if (data.readableBytes() < 32) {
            BungeeBridge.instance.handler.fail("Invalid ReadTagPacket (bytes available: " + data.readableBytes() + ")");
            return;
        }
        String responseServer = this.readString(data, "serverName");
        String tag = this.readString(data, "tag");
        String defs = this.readString(data, "defs");
        if (tag == null || defs == null) {
            return;
        }
        long uuidMost = data.readLong();
        long uuidLeast = data.readLong();
        int responseId = data.readInt();
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)Depenizen.instance, () -> {
            PlayerTag linkedPlayer = null;
            if (uuidMost != 0L || uuidLeast != 0L) {
                UUID uuid = new UUID(uuidMost, uuidLeast);
                try {
                    OfflinePlayer player = Bukkit.getOfflinePlayer((UUID)uuid);
                    if (player != null) {
                        linkedPlayer = new PlayerTag(player);
                    }
                }
                catch (Exception player) {
                    // empty catch block
                }
            }
            BukkitTagContext context = new BukkitTagContext(linkedPlayer, null, null, false, null);
            List defSets = CoreUtilities.split((String)defs, (char)'\r');
            List defNames = CoreUtilities.split((String)((String)defSets.get(0)), (char)'\n');
            List defValues = CoreUtilities.split((String)((String)defSets.get(1)), (char)'\n');
            for (int i = 0; i < defNames.size(); ++i) {
                String name = RunCommandsPacketIn.unescape((String)defNames.get(i));
                if (name.length() <= 0) continue;
                String value = RunCommandsPacketIn.unescape((String)defValues.get(i));
                context.definitionProvider.addDefinition(name, value);
            }
            String result = TagManager.tag((String)tag, (TagContext)context);
            TagResponsePacketOut packet = new TagResponsePacketOut();
            packet.id = responseId;
            packet.result = result;
            RedirectPacketOut redirectPacket = new RedirectPacketOut(responseServer, packet);
            BungeeBridge.instance.sendPacket(redirectPacket);
        });
    }
}

