/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.depenizen.bukkit.bungee;

import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.depenizen.bukkit.Depenizen;
import com.denizenscript.depenizen.bukkit.bungee.BungeeBridge;
import com.denizenscript.depenizen.bukkit.bungee.BungeePacketIn;
import com.denizenscript.depenizen.bukkit.bungee.packets.out.ControlsProxyCommandPacketOut;
import com.denizenscript.depenizen.bukkit.bungee.packets.out.ControlsProxyPingPacketOut;
import com.denizenscript.depenizen.bukkit.bungee.packets.out.MyInfoPacketOut;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

public class BungeeClientHandler
extends ChannelInboundHandlerAdapter {
    public static final byte[] FAKE_HANDSHAKE = new byte[]{13, 0, 20, 7, 68, 0, 100, 101, 112, 101, 110, 80, 0, 1};
    public ByteBuf packetBuffer;
    public boolean hasClosed = false;
    public Channel channel;
    public int waitingLength;
    public int packetId;
    public Stage currentStage = Stage.AWAIT_HEADER;
    public BungeePacketIn lastPacket;

    public void fail(String reason) {
        if (this.hasClosed) {
            return;
        }
        this.hasClosed = true;
        this.channel.close();
        BungeeBridge.instance.connected = false;
        BungeeBridge.runOnMainThread(() -> Debug.echoError((String)("Depenizen-Bungee connection failed: " + reason + "... last valid packet: " + (this.lastPacket == null ? "none" : this.lastPacket.getName()))));
    }

    public void reallocateBuf(ChannelHandlerContext ctx) {
        ByteBuf newBuf = ctx.alloc().buffer(32);
        if (this.packetBuffer != null) {
            newBuf.writeBytes(this.packetBuffer);
            this.packetBuffer.release();
        }
        this.packetBuffer = newBuf;
    }

    public void handlerAdded(ChannelHandlerContext ctx) {
        if (this.packetBuffer != null) {
            this.packetBuffer.release();
        }
        this.packetBuffer = ctx.alloc().buffer(32);
    }

    public void handlerRemoved(ChannelHandlerContext ctx) {
        BungeeBridge.runOnMainThread(() -> Debug.log((String)"Depenizen-Bungee connection ended. If this is unexpected, check your Bungee proxy server logs."));
        this.packetBuffer.release();
        this.packetBuffer = null;
        BungeeBridge.instance.connected = false;
        BungeeBridge.instance.reconnect(true);
    }

    public void channelActive(ChannelHandlerContext ctx) {
        ByteBuf handshake = ctx.alloc().buffer(FAKE_HANDSHAKE.length);
        handshake.writeBytes(FAKE_HANDSHAKE);
        ctx.writeAndFlush((Object)handshake);
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)Depenizen.instance, () -> {
            Debug.log((String)"Depenizen now connected to Bungee server.");
            BungeeBridge.instance.lastPacketReceived = CoreUtilities.monotonicMillis();
            BungeeBridge.instance.sendPacket(new MyInfoPacketOut(Bukkit.getPort()));
            BungeeBridge.instance.sendPacket(new ControlsProxyPingPacketOut(BungeeBridge.instance.controlsProxyPing));
            BungeeBridge.instance.sendPacket(new ControlsProxyCommandPacketOut(BungeeBridge.instance.controlsProxyCommand));
        }, 30L);
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        ByteBuf m = (ByteBuf)msg;
        this.packetBuffer.writeBytes(m);
        m.release();
        while (true) {
            if (this.currentStage == Stage.AWAIT_HEADER) {
                if (this.packetBuffer.readableBytes() < 8) {
                    return;
                }
                this.waitingLength = this.packetBuffer.readInt();
                this.packetId = this.packetBuffer.readInt();
                this.currentStage = Stage.AWAIT_DATA;
                if (!BungeeBridge.instance.packets.containsKey(this.packetId)) {
                    this.fail("Invalid packet id: " + this.packetId);
                    return;
                }
                if (this.waitingLength >= 0 && this.waitingLength <= 0x40000000) continue;
                BungeeBridge.instance.handler.fail("Invalid/impossible packet header length value (bytes expected: " + this.waitingLength + ", bytes readable: " + this.packetBuffer.readableBytes() + ")");
                return;
            }
            if (this.currentStage != Stage.AWAIT_DATA) break;
            if (this.packetBuffer.readableBytes() < this.waitingLength) {
                return;
            }
            try {
                BungeeBridge.instance.lastPacketReceived = CoreUtilities.monotonicMillis();
                BungeePacketIn packet = BungeeBridge.instance.packets.get(this.packetId);
                packet.process(this.packetBuffer);
                this.currentStage = Stage.AWAIT_HEADER;
                this.reallocateBuf(ctx);
                this.lastPacket = packet;
            }
            catch (Throwable ex) {
                ex.printStackTrace();
                this.fail("Internal exception.");
                return;
            }
        }
    }

    public static enum Stage {
        AWAIT_HEADER,
        AWAIT_DATA;

    }
}

