/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.depenizen.bukkit.events.bungee;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.depenizen.bukkit.bungee.BungeeBridge;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;

public class BungeeProxyServerCommandScriptEvent
extends BukkitScriptEvent {
    public static BungeeProxyServerCommandScriptEvent instance;
    public String sender;
    public CommandData command;
    public UUID senderId;

    public BungeeProxyServerCommandScriptEvent() {
        instance = this;
        this.registerCouldMatcher("proxy server (<'command'>) command");
    }

    public String commandName() {
        return CoreUtilities.toLowerCase((String)this.command.command.substring(1, this.command.command.contains(" ") ? this.command.command.indexOf(32) : this.command.command.length()));
    }

    public boolean matches(ScriptEvent.ScriptPath path) {
        if (!path.eventArgLowerAt(2).equals("command") && !path.eventArgLowerAt(2).equals(this.commandName())) {
            return false;
        }
        return super.matches(path);
    }

    public void init() {
        BungeeBridge.instance.controlsProxyCommand = true;
        BungeeBridge.instance.checkBroadcastProxyCommand();
    }

    public void destroy() {
        BungeeBridge.instance.controlsProxyCommand = false;
        BungeeBridge.instance.checkBroadcastProxyCommand();
    }

    public ScriptEntryData getScriptEntryData() {
        OfflinePlayer player = null;
        if (this.senderId != null) {
            try {
                player = Bukkit.getOfflinePlayer((UUID)this.senderId);
                if (!player.isOnline() && !player.hasPlayedBefore()) {
                    player = null;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return new BukkitScriptEntryData(player == null ? null : new PlayerTag(player), null);
    }

    public void cancellationChanged() {
        this.command.cancelled = this.cancelled;
        super.cancellationChanged();
    }

    public boolean applyDetermination(ScriptEvent.ScriptPath path, ObjectTag determinationObj) {
        String determination;
        String determinationLow;
        if (determinationObj instanceof ElementTag && (determinationLow = CoreUtilities.toLowerCase((String)(determination = determinationObj.toString()))).startsWith("command:")) {
            this.command.command = determination.substring("command:".length());
            return true;
        }
        return super.applyDetermination(path, determinationObj);
    }

    public ObjectTag getContext(String name) {
        if (name.equals("sender")) {
            return new ElementTag(this.sender);
        }
        if (name.equals("sender_id") && this.senderId != null) {
            return new ElementTag(this.senderId.toString());
        }
        if (name.equals("command")) {
            return new ElementTag(this.command.command);
        }
        return super.getContext(name);
    }

    public static class CommandData {
        public String command;
        public boolean cancelled;
    }
}

