/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.depenizen.bukkit.events.bungee;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.denizencore.utilities.CoreConfiguration;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.depenizen.bukkit.bungee.BungeeBridge;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public class BungeeProxyServerListPingScriptEvent
extends BukkitScriptEvent {
    public static BungeeProxyServerListPingScriptEvent instance;
    public PingData data;

    public BungeeProxyServerListPingScriptEvent() {
        instance = this;
    }

    public boolean couldMatch(ScriptEvent.ScriptPath path) {
        return path.eventLower.startsWith("proxy server list ping");
    }

    public void init() {
        BungeeBridge.instance.controlsProxyPing = true;
        BungeeBridge.instance.checkBroadcastProxyPing();
    }

    public void destroy() {
        BungeeBridge.instance.controlsProxyPing = false;
        BungeeBridge.instance.checkBroadcastProxyPing();
    }

    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(null, null);
    }

    public boolean applyDetermination(ScriptEvent.ScriptPath path, ObjectTag determinationObj) {
        if (determinationObj instanceof ElementTag) {
            String determination = determinationObj.toString();
            String determinationLow = CoreUtilities.toLowerCase((String)determination);
            if (determinationLow.startsWith("max_players:")) {
                this.data.maxPlayers = Integer.parseInt(determination.substring("max_players:".length()));
                return true;
            }
            if (determinationLow.startsWith("version:")) {
                this.data.version = determination.substring("version:".length());
                return true;
            }
            if (determinationLow.startsWith("motd:")) {
                this.data.motd = determination.substring("motd:".length());
                return true;
            }
            if (determinationLow.startsWith("players:")) {
                List players = ListTag.valueOf((String)determination.substring("players:".length()), (TagContext)this.getTagContext(path)).filter(PlayerTag.class, (TagContext)this.getTagContext(path));
                this.data.playerSample = new ArrayList<PlayerInfo>(players.size());
                for (PlayerTag player : players) {
                    PlayerInfo info = new PlayerInfo();
                    info.id = player.getUUID();
                    info.name = player.getName();
                    this.data.playerSample.add(info);
                }
                return true;
            }
            if (determinationLow.startsWith("alternate_player_text:")) {
                if (!CoreConfiguration.allowRestrictedActions) {
                    Debug.echoError((String)"Cannot use 'alternate_player_text' in proxy list ping event: 'Allow restricted actions' is disabled in Denizen config.yml.");
                    return true;
                }
                ListTag text = ListTag.valueOf((String)determination.substring("alternate_player_text:".length()), (TagContext)this.getTagContext(path));
                this.data.playerSample = new ArrayList<PlayerInfo>(text.size());
                for (String line : text) {
                    PlayerInfo info = new PlayerInfo();
                    info.name = line;
                    info.id = new UUID(0L, 0L);
                    this.data.playerSample.add(info);
                }
                return true;
            }
        }
        return super.applyDetermination(path, determinationObj);
    }

    public ObjectTag getContext(String name) {
        return switch (name) {
            case "address" -> new ElementTag(this.data.address);
            case "num_players", "current_players" -> new ElementTag(this.data.currentPlayers);
            case "max_players" -> new ElementTag(this.data.maxPlayers);
            case "motd" -> new ElementTag(this.data.motd);
            case "protocol" -> new ElementTag(this.data.protocol);
            case "version" -> new ElementTag(this.data.version);
            default -> super.getContext(name);
        };
    }

    public static class PingData {
        public String address;
        public int currentPlayers;
        public int maxPlayers;
        public String motd;
        public int protocol;
        public String version;
        public List<PlayerInfo> playerSample;
    }

    public static class PlayerInfo {
        public UUID id;
        public String name;
    }
}

