/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.depenizen.bukkit.objects.areashop;

import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizencore.objects.Fetchable;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.tags.Attribute;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.depenizen.bukkit.objects.worldguard.WorldGuardRegionTag;
import me.wiefferink.areashop.AreaShop;
import me.wiefferink.areashop.regions.BuyRegion;
import me.wiefferink.areashop.regions.GeneralRegion;
import me.wiefferink.areashop.regions.RentRegion;

public class AreaShopTag
implements ObjectTag {
    GeneralRegion areaShop = null;
    String prefix = "AreaShop";

    @Fetchable(value="areashop")
    public static AreaShopTag valueOf(String string, TagContext context) {
        if (string == null) {
            return null;
        }
        string = string.replace("areashop@", "");
        GeneralRegion areaShop = AreaShop.getInstance().getFileManager().getRegion(string);
        if (areaShop == null) {
            return null;
        }
        return new AreaShopTag(areaShop);
    }

    public static boolean matches(String arg) {
        arg = arg.replace("areashop@", "");
        return AreaShop.getInstance().getFileManager().getRegion(arg) != null;
    }

    public AreaShopTag(GeneralRegion areaShop) {
        if (areaShop != null) {
            this.areaShop = areaShop;
        } else {
            Debug.echoError((String)"AreaShop referenced is null!");
        }
    }

    public String getPrefix() {
        return this.prefix;
    }

    public boolean isUnique() {
        return true;
    }

    public String identify() {
        return "areashop@" + this.areaShop.getName();
    }

    public String identifySimple() {
        return this.identify();
    }

    public ObjectTag setPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    public String toString() {
        return this.identify();
    }

    public GeneralRegion getAreaShop() {
        return this.areaShop;
    }

    public boolean equals(AreaShopTag areaShop) {
        return areaShop.getAreaShop().equals((Object)this.getAreaShop());
    }

    public ObjectTag getObjectAttribute(Attribute attribute) {
        if (attribute == null) {
            return null;
        }
        if (attribute.startsWith("is_bought")) {
            return new ElementTag(this.areaShop.isBuyRegion()).getObjectAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("is_rented")) {
            return new ElementTag(this.areaShop.isRentRegion()).getObjectAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("groups")) {
            return new ListTag(this.areaShop.getGroupNames()).getObjectAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("landlord")) {
            return new PlayerTag(this.areaShop.getLandlord()).getObjectAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("name")) {
            return new ElementTag(this.areaShop.getName()).getObjectAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("name")) {
            double price;
            if (this.areaShop instanceof BuyRegion) {
                price = ((BuyRegion)this.areaShop).getPrice();
            } else if (this.areaShop instanceof RentRegion) {
                price = ((RentRegion)this.areaShop).getPrice();
            } else {
                return null;
            }
            return new ElementTag(price).getObjectAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("owner")) {
            return new PlayerTag(this.areaShop.getOwner()).getObjectAttribute(attribute.fulfill(1));
        }
        if (attribute.startsWith("worldguard_region")) {
            return new WorldGuardRegionTag(this.areaShop.getRegion(), this.areaShop.getWorld()).getObjectAttribute(attribute.fulfill(1));
        }
        return new ElementTag(this.identify()).getObjectAttribute(attribute);
    }
}

