/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.depenizen.bukkit.objects.towny;

import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizencore.DenizenCore;
import com.denizenscript.denizencore.flags.AbstractFlagTracker;
import com.denizenscript.denizencore.flags.FlaggableObject;
import com.denizenscript.denizencore.flags.RedirectionFlagTracker;
import com.denizenscript.denizencore.objects.Fetchable;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.tags.Attribute;
import com.denizenscript.denizencore.tags.ObjectTagProcessor;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.depenizen.bukkit.objects.towny.TownTag;
import com.palmergames.bukkit.towny.TownyUniverse;
import com.palmergames.bukkit.towny.object.Nation;
import com.palmergames.bukkit.towny.object.Resident;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;

public class NationTag
implements ObjectTag,
FlaggableObject {
    public Nation nation = null;
    private String prefix = "Nation";
    public static ObjectTagProcessor<NationTag> tagProcessor = new ObjectTagProcessor();

    @Fetchable(value="nation")
    public static NationTag valueOf(String string, TagContext context) {
        Nation nation;
        if (string.startsWith("nation@")) {
            string = string.substring("nation@".length());
        }
        if (string.length() == 36 && string.indexOf(45) >= 0) {
            try {
                Nation nation2;
                UUID uuid = UUID.fromString(string);
                if (uuid != null && (nation2 = TownyUniverse.getInstance().getNation(uuid)) != null) {
                    return new NationTag(nation2);
                }
            }
            catch (IllegalArgumentException uuid) {
                // empty catch block
            }
        }
        if ((nation = TownyUniverse.getInstance().getNation(string)) == null) {
            return null;
        }
        return new NationTag(nation);
    }

    public static boolean matches(String arg) {
        if (arg.startsWith("nation@")) {
            return true;
        }
        return NationTag.valueOf(arg, CoreUtilities.noDebugContext) != null;
    }

    public NationTag(Nation nation) {
        if (nation != null) {
            this.nation = nation;
        } else {
            Debug.echoError((String)"Nation referenced is null!");
        }
    }

    public String getPrefix() {
        return this.prefix;
    }

    public NationTag setPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    public boolean isUnique() {
        return true;
    }

    public String identify() {
        return "nation@" + String.valueOf(this.nation.getUUID());
    }

    public String identifySimple() {
        return this.identify();
    }

    public String toString() {
        return this.identify();
    }

    public AbstractFlagTracker getFlagTracker() {
        if (DenizenCore.serverFlagMap.hasFlag("__depenizen_towny_nations." + this.nation.getName()) && !DenizenCore.serverFlagMap.hasFlag("__depenizen_towny_nations_uuid." + String.valueOf(this.nation.getUUID()))) {
            ObjectTag legacyValue = DenizenCore.serverFlagMap.getFlagValue("__depenizen_towny_nations." + this.nation.getName());
            DenizenCore.serverFlagMap.setFlag("__depenizen_towny_nations_uuid." + String.valueOf(this.nation.getUUID()), legacyValue, null);
            DenizenCore.serverFlagMap.setFlag("__depenizen_towny_nations." + this.nation.getName(), null, null);
        }
        return new RedirectionFlagTracker((AbstractFlagTracker)DenizenCore.serverFlagMap, "__depenizen_towny_nations_uuid." + String.valueOf(this.nation.getUUID()));
    }

    public void reapplyTracker(AbstractFlagTracker tracker) {
    }

    public static void register() {
        AbstractFlagTracker.registerFlagHandlers(tagProcessor);
        tagProcessor.registerTag(ListTag.class, "allies", (attribute, object) -> {
            ListTag list = new ListTag();
            for (Nation ally : object.nation.getAllies()) {
                list.addObject((ObjectTag)new NationTag(ally));
            }
            return list;
        }, new String[0]);
        tagProcessor.registerTag(ListTag.class, "assistants", (attribute, object) -> {
            ListTag list = new ListTag();
            for (Resident resident : object.nation.getAssistants()) {
                list.addObject((ObjectTag)new PlayerTag(resident.getUUID()));
            }
            return list;
        }, new String[0]);
        tagProcessor.registerTag(ElementTag.class, "balance", (attribute, object) -> new ElementTag(object.nation.getAccount().getHoldingBalance()), new String[0]);
        tagProcessor.registerTag(TownTag.class, "capital", (attribute, object) -> {
            if (object.nation.hasCapital()) {
                return new TownTag(object.nation.getCapital());
            }
            return null;
        }, new String[0]);
        tagProcessor.registerTag(ListTag.class, "enemies", (attribute, object) -> {
            ListTag list = new ListTag();
            for (Nation enemy : object.nation.getEnemies()) {
                list.addObject((ObjectTag)new NationTag(enemy));
            }
            return list;
        }, new String[0]);
        tagProcessor.registerTag(ListTag.class, ElementTag.class, "members_by_rank", (attribute, object, rankObj) -> {
            ListTag list = new ListTag();
            List rankList = object.nation.getResidents().stream().filter(assistant -> assistant.hasNationRank(rankObj.asString())).collect(Collectors.toList());
            for (Resident resident : rankList) {
                list.addObject((ObjectTag)new PlayerTag(resident.getUUID()));
            }
            return list;
        }, new String[0]);
        tagProcessor.registerTag(ElementTag.class, "is_neutral", (attribute, object) -> new ElementTag(object.nation.isNeutral()), new String[0]);
        tagProcessor.registerTag(PlayerTag.class, "king", (attribute, object) -> new PlayerTag(object.nation.getCapital().getMayor().getUUID()), new String[0]);
        tagProcessor.registerTag(ElementTag.class, "name", (attribute, object) -> new ElementTag(object.nation.getName()), new String[0]);
        tagProcessor.registerTag(ElementTag.class, "player_count", (attribute, object) -> new ElementTag(object.nation.getNumResidents()), new String[0]);
        tagProcessor.registerTag(ElementTag.class, NationTag.class, "relation", (attribute, object, nationObj) -> {
            try {
                if (object.nation.hasAlly(nationObj.nation)) {
                    return new ElementTag("allies");
                }
                if (object.nation.hasEnemy(nationObj.nation)) {
                    return new ElementTag("enemies");
                }
                return new ElementTag("neutral");
            }
            catch (Exception exception) {
                return null;
            }
        }, new String[0]);
        tagProcessor.registerTag(ListTag.class, "residents", (attribute, object) -> {
            ListTag list = new ListTag();
            for (Resident resident : object.nation.getResidents()) {
                list.addObject((ObjectTag)new PlayerTag(resident.getUUID()));
            }
            return list;
        }, new String[0]);
        tagProcessor.registerTag(ElementTag.class, "tag", (attribute, object) -> {
            if (object.nation.hasTag()) {
                return new ElementTag(object.nation.getTag());
            }
            return null;
        }, new String[0]);
        tagProcessor.registerTag(ElementTag.class, "taxes", (attribute, object) -> new ElementTag(object.nation.getTaxes()), new String[0]);
        tagProcessor.registerTag(ElementTag.class, "town_count", (attribute, object) -> new ElementTag(object.nation.getNumTowns()), new String[0]);
    }

    public ObjectTag getObjectAttribute(Attribute attribute) {
        return tagProcessor.getObjectAttribute((ObjectTag)this, attribute);
    }
}

