/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.depenizen.bukkit.commands.effectlib;

import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.DurationTag;
import com.denizenscript.denizencore.objects.core.MapTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.scripts.commands.Holdable;
import com.denizenscript.denizencore.scripts.commands.generator.ArgDefaultNull;
import com.denizenscript.denizencore.scripts.commands.generator.ArgName;
import com.denizenscript.denizencore.scripts.commands.generator.ArgPrefixed;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.debugging.SlowWarning;
import com.denizenscript.denizencore.utilities.debugging.Warning;
import com.denizenscript.denizencore.utilities.text.StringHolder;
import com.denizenscript.depenizen.bukkit.bridges.EffectLibBridge;
import de.slikey.effectlib.Effect;
import de.slikey.effectlib.util.DynamicLocation;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Location;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.MemoryConfiguration;

public class EffectLibCommand
extends AbstractCommand
implements Holdable {
    public static Warning durationArgument = new SlowWarning("effectlibCommandDuration", "The 'duration:<duration>' argument for the 'effectlib' command is deprecated in favor of the 'duration' key in the 'effect_data' map, refer to the meta docs for more information.");
    public static Warning oldTargetArguments = new SlowWarning("effectlibCommandOldTarget", "The 'target:<entity>'/'location:<location>' arguments for the 'effectlib' command are deprecated in favor of the 'origin:<entity>/<location>' argument.");
    public static HashMap<String, String> nameCasings = new HashMap();

    public EffectLibCommand() {
        this.setName("effectlib");
        this.setSyntax("effectlib [type:<effect>] (origin:<entity>/<location>) (target:<entity>/<location>) (for:<player>) (effect_data:<map>)");
        this.setRequiredArguments(1, 5);
        this.autoCompile();
    }

    public static void registerNameCasing(String s) {
        nameCasings.put(CoreUtilities.toLowerCase((String)s), s);
    }

    public static void autoExecute(ScriptEntry scriptEntry, @ArgPrefixed @ArgName(value="type") String effectInput, @ArgDefaultNull @ArgPrefixed @ArgName(value="origin") ObjectTag originInput, @ArgDefaultNull @ArgPrefixed @ArgName(value="target") ObjectTag targetInput, @ArgDefaultNull @ArgPrefixed @ArgName(value="for") PlayerTag forPlayer, @ArgDefaultNull @ArgPrefixed @ArgName(value="effect_data") MapTag effectData, @ArgDefaultNull @ArgPrefixed @ArgName(value="duration") DurationTag duration, @ArgDefaultNull @ArgPrefixed @ArgName(value="location") LocationTag oldLocation) {
        Effect effect;
        String fixed;
        if (originInput == null && oldLocation != null) {
            oldTargetArguments.warn(scriptEntry);
            originInput = oldLocation;
            targetInput = null;
        }
        if (originInput == null && targetInput != null && targetInput.shouldBeType(EntityTag.class)) {
            oldTargetArguments.warn(scriptEntry);
            originInput = targetInput;
            targetInput = null;
        }
        if (originInput == null && Utilities.entryHasPlayer((ScriptEntry)scriptEntry)) {
            originInput = Utilities.getEntryPlayer((ScriptEntry)scriptEntry);
        }
        if (originInput == null) {
            Debug.echoError((ScriptEntry)scriptEntry, (String)"Must specify an origin location or entity!");
            return;
        }
        if (Character.isLowerCase(((String)effectInput).charAt(0)) && (fixed = nameCasings.get(CoreUtilities.toLowerCase((String)(effectInput = Character.toUpperCase(((String)effectInput).charAt(0)) + ((String)effectInput).substring(1))))) != null) {
            effectInput = fixed;
        }
        if (effectData == null) {
            effect = EffectLibBridge.instance.effectManager.getEffectByClassName((String)effectInput);
            if (effect != null) {
                effect.setDynamicOrigin(EffectLibCommand.getEffectLibLocationFrom(originInput, scriptEntry.context));
                effect.setDynamicTarget(EffectLibCommand.getEffectLibLocationFrom(targetInput, scriptEntry.context));
                effect.setTargetPlayer(forPlayer != null ? forPlayer.getPlayerEntity() : null);
            }
        } else {
            MemoryConfiguration effectLibData = new MemoryConfiguration();
            for (Map.Entry entry : effectData.entrySet()) {
                effectLibData.set(((StringHolder)entry.getKey()).str, CoreUtilities.objectTagToJavaForm((ObjectTag)((ObjectTag)entry.getValue()), (boolean)false, (boolean)true));
            }
            effect = EffectLibBridge.instance.effectManager.getEffect((String)effectInput, (ConfigurationSection)effectLibData, EffectLibCommand.getEffectLibLocationFrom(originInput, scriptEntry.context), EffectLibCommand.getEffectLibLocationFrom(targetInput, scriptEntry.context), null, forPlayer != null ? forPlayer.getPlayerEntity() : null);
        }
        if (effect == null) {
            Debug.echoError((ScriptEntry)scriptEntry, (String)("Invalid effect specified: " + (String)effectInput));
            return;
        }
        effect.callback = () -> scriptEntry.setFinished(true);
        if (duration != null) {
            durationArgument.warn(scriptEntry);
            effect.iterations = duration.getTicksAsInt();
        }
        effect.start();
    }

    public static DynamicLocation getEffectLibLocationFrom(ObjectTag object, TagContext context) {
        if (object == null) {
            return null;
        }
        if (object.shouldBeType(LocationTag.class)) {
            return new DynamicLocation((Location)object.asType(LocationTag.class, context));
        }
        EntityTag entity = (EntityTag)object.asType(EntityTag.class, context);
        if (entity == null) {
            Debug.echoError((TagContext)context, (String)("Invalid input specified '" + String.valueOf(object) + "': must be a valid location or entity."));
            return null;
        }
        return new DynamicLocation(entity.getBukkitEntity());
    }

    static {
        EffectLibCommand.registerNameCasing("AnimatedBall");
        EffectLibCommand.registerNameCasing("BigBang");
        EffectLibCommand.registerNameCasing("ColoredImage");
        EffectLibCommand.registerNameCasing("DiscoBall");
        EffectLibCommand.registerNameCasing("SkyRocket");
    }
}

