/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.depenizen.bukkit.events.crackshot;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.shampaggon.crackshot.events.WeaponFireRateEvent;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;

public class CrackShotPlayerFiresAutomaticWeaponEvent
extends BukkitScriptEvent
implements Listener {
    public static CrackShotPlayerFiresAutomaticWeaponEvent instance;
    public WeaponFireRateEvent event;

    public boolean applyDetermination(ScriptEvent.ScriptPath path, ObjectTag determinationObj) {
        String determination = determinationObj.toString();
        String lower = CoreUtilities.toLowerCase((String)determination);
        if (lower.startsWith("fire_rate:")) {
            ElementTag newFireRate = new ElementTag(lower.substring("fire_rate:".length()));
            if (!newFireRate.isInt()) {
                Debug.echoError((String)"Determination for 'fire_rate' must be a valid integer.");
                return false;
            }
            this.event.setFireRate(newFireRate.asInt());
            return true;
        }
        return super.applyDetermination(path, determinationObj);
    }

    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData((Entity)this.event.getPlayer());
    }

    public boolean couldMatch(ScriptEvent.ScriptPath path) {
        return path.eventLower.startsWith("crackshot player fires automatic weapon");
    }

    public ObjectTag getContext(String name) {
        return switch (name) {
            case "weapon" -> new ElementTag(this.event.getWeaponTitle());
            case "fire_rate" -> new ElementTag(this.event.getFireRate());
            default -> super.getContext(name);
        };
    }

    @EventHandler
    public void onFiresAutomaticWeapon(WeaponFireRateEvent event) {
        this.event = event;
        this.fire((Event)event);
    }
}

