/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.depenizen.bukkit.commands.bossshop;

import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;
import com.denizenscript.depenizen.bukkit.bridges.BossShopBridge;
import org.black_ixx.bossshop.BossShop;
import org.black_ixx.bossshop.core.BSShop;

public class BossShopCommand
extends AbstractCommand {
    public BossShopCommand() {
        this.setName("bossshop");
        this.setSyntax("bossshop [<shop name>]");
        this.setRequiredArguments(1, 1);
    }

    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (Argument arg : scriptEntry) {
            if (!scriptEntry.hasObject("target") && arg.matchesPrefix("target")) {
                scriptEntry.addObject("target", (Object)arg.asType(PlayerTag.class));
                Debug.echoError((String)"Don't use 'target:' for 'bossshop' command. Just use 'player:'.");
                continue;
            }
            if (!scriptEntry.hasObject("shop")) {
                scriptEntry.addObject("shop", (Object)arg.asElement());
                continue;
            }
            arg.reportUnhandled();
        }
        if (!scriptEntry.hasObject("shop")) {
            throw new InvalidArgumentsException("Shop not specified!");
        }
        if (!scriptEntry.hasObject("target")) {
            if (Utilities.entryHasPlayer((ScriptEntry)scriptEntry)) {
                scriptEntry.addObject("target", (Object)Utilities.getEntryPlayer((ScriptEntry)scriptEntry));
            } else {
                throw new InvalidArgumentsException("This command does not have a player attached!");
            }
        }
    }

    public void execute(ScriptEntry scriptEntry) {
        PlayerTag target = (PlayerTag)scriptEntry.getObjectTag("target");
        ElementTag dshop = (ElementTag)scriptEntry.getObjectTag("shop");
        Debug.report((Debuggable)scriptEntry, (String)this.getName(), (Object[])new Object[]{target, dshop});
        if (target == null) {
            Debug.echoError((ScriptEntry)scriptEntry, (String)"Target not found!");
            return;
        }
        if (dshop == null) {
            Debug.echoError((ScriptEntry)scriptEntry, (String)"Shop not Specified!");
            return;
        }
        BossShop bs = (BossShop)BossShopBridge.instance.plugin;
        BSShop shop = bs.getAPI().getShop(dshop.asString());
        if (shop == null) {
            Debug.echoError((ScriptEntry)scriptEntry, (String)"Shop not found!");
            return;
        }
        bs.getAPI().openShop(target.getPlayerEntity(), shop);
    }
}

