/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.depenizen.bukkit.commands.jobs;

import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsRuntimeException;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.scripts.commands.generator.ArgDefaultNull;
import com.denizenscript.denizencore.scripts.commands.generator.ArgLinear;
import com.denizenscript.denizencore.scripts.commands.generator.ArgName;
import com.denizenscript.denizencore.utilities.Deprecations;
import com.denizenscript.depenizen.bukkit.objects.jobs.JobsJobTag;
import com.gamingmesh.jobs.Jobs;
import com.gamingmesh.jobs.PlayerManager;
import com.gamingmesh.jobs.container.Job;
import com.gamingmesh.jobs.container.JobsPlayer;

public class JobsCommand
extends AbstractCommand {
    public JobsCommand() {
        this.setName("jobs");
        this.setSyntax("jobs [promote/demote/join/quit] [<job>] (<#>)");
        this.setRequiredArguments(2, 3);
        this.autoCompile();
    }

    public void addCustomTabCompletions(AbstractCommand.TabCompletionsBuilder tab) {
        for (Job job : Jobs.getJobs()) {
            tab.add(job.getName());
        }
    }

    public static void autoExecute(ScriptEntry scriptEntry, @ArgName(value="action") Action action, @ArgLinear @ArgName(value="job") ObjectTag jobObject, @ArgLinear @ArgDefaultNull @ArgName(value="number") ObjectTag numberObject) {
        ElementTag numberElement;
        if (!Utilities.entryHasPlayer((ScriptEntry)scriptEntry)) {
            throw new InvalidArgumentsRuntimeException("Missing linked player.");
        }
        if (numberObject != null && jobObject.asElement().isInt()) {
            Deprecations.outOfOrderArgs.warn(scriptEntry);
            ObjectTag jobObjectSwitch = jobObject;
            jobObject = numberObject;
            numberObject = jobObjectSwitch;
        }
        ElementTag elementTag = numberElement = numberObject != null ? numberObject.asElement() : new ElementTag(0);
        if (!numberElement.isInt()) {
            throw new InvalidArgumentsRuntimeException("Invalid number '" + String.valueOf(numberElement) + "' specified: must be a valid non-decimal number.");
        }
        JobsJobTag job = (JobsJobTag)jobObject.asType(JobsJobTag.class, scriptEntry.context);
        if (job == null) {
            throw new InvalidArgumentsRuntimeException("Invalid JobsJobTag specified: " + String.valueOf(jobObject) + ".");
        }
        PlayerManager playerManager = Jobs.getPlayerManager();
        JobsPlayer player = playerManager.getJobsPlayer(Utilities.getEntryPlayer((ScriptEntry)scriptEntry).getUUID());
        switch (action.ordinal()) {
            case 0: {
                playerManager.promoteJob(player, job.getJob(), numberElement.asInt());
                break;
            }
            case 1: {
                playerManager.demoteJob(player, job.getJob(), numberElement.asInt());
                break;
            }
            case 2: {
                playerManager.joinJob(player, job.getJob());
                break;
            }
            case 3: {
                playerManager.leaveJob(player, job.getJob());
            }
        }
    }

    public static enum Action {
        PROMOTE,
        DEMOTE,
        JOIN,
        QUIT;

    }
}

