/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.depenizen.bukkit.commands.libsdisguises;

import com.denizenscript.denizen.objects.EntityTag;
import com.denizenscript.denizen.objects.ItemTag;
import com.denizenscript.denizen.utilities.Utilities;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;
import me.libraryaddict.disguise.DisguiseAPI;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.disguisetypes.DisguiseType;
import me.libraryaddict.disguise.disguisetypes.FlagWatcher;
import me.libraryaddict.disguise.disguisetypes.MiscDisguise;
import me.libraryaddict.disguise.disguisetypes.MobDisguise;
import me.libraryaddict.disguise.disguisetypes.PlayerDisguise;
import me.libraryaddict.disguise.disguisetypes.watchers.LivingWatcher;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class LibsDisguiseCommand
extends AbstractCommand {
    public LibsDisguiseCommand() {
        this.setName("libsdisguise");
        this.setSyntax("libsdisguise [remove/player/mob/misc] (type:<entity type>) (target:<entity>) (name:<text>) (display_name:<text>) (baby) (id:<item>) (self) (hide_name)");
        this.setRequiredArguments(1, 9);
        this.setPrefixesHandled(new String[]{"target", "name", "type", "id", "display_name"});
        this.setBooleansHandled(new String[]{"self", "baby", "hide_name"});
    }

    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (Argument arg : scriptEntry) {
            if (!scriptEntry.hasObject("action") && arg.matchesEnum(Action.class)) {
                scriptEntry.addObject("action", (Object)arg.asElement());
                continue;
            }
            arg.reportUnhandled();
        }
        if (!scriptEntry.hasObject("action")) {
            throw new InvalidArgumentsException("Action not specified! (remove/mob/player/misc)");
        }
    }

    public void execute(ScriptEntry scriptEntry) {
        EntityTag target = (EntityTag)scriptEntry.argForPrefix("target", EntityTag.class, true);
        ElementTag type = scriptEntry.argForPrefixAsElement("type", null);
        ElementTag name = scriptEntry.argForPrefixAsElement("name", null);
        ElementTag displayName = scriptEntry.argForPrefixAsElement("display_name", null);
        ElementTag actionElement = (ElementTag)scriptEntry.getObjectTag("action");
        ElementTag id = scriptEntry.argForPrefixAsElement("id", null);
        boolean baby = scriptEntry.argAsBoolean("baby");
        boolean self = scriptEntry.argAsBoolean("self");
        boolean hideName = scriptEntry.argAsBoolean("hide_name");
        if (scriptEntry.dbCallShouldDebug()) {
            Debug.report((Debuggable)scriptEntry, (String)this.getName(), (Object[])new Object[]{actionElement, target, type, name, displayName, id, LibsDisguiseCommand.db((String)"baby", (boolean)baby), LibsDisguiseCommand.db((String)"self", (boolean)self), LibsDisguiseCommand.db((String)"hide_name", (boolean)hideName)});
        }
        if (target == null) {
            if (Utilities.entryHasPlayer((ScriptEntry)scriptEntry)) {
                target = Utilities.getEntryPlayer((ScriptEntry)scriptEntry).getDenizenEntity();
            } else {
                Debug.echoError((ScriptEntry)scriptEntry, (String)"Target not found!");
                return;
            }
        }
        switch (((Action)((Object)actionElement.asEnum(Action.class))).ordinal()) {
            case 0: {
                DisguiseAPI.undisguiseToAll((Entity)target.getBukkitEntity());
                break;
            }
            case 1: {
                if (type == null) {
                    Debug.echoError((ScriptEntry)scriptEntry, (String)"Entity not specified!");
                    return;
                }
                MobDisguise mobDisguise = new MobDisguise((DisguiseType)type.asEnum(DisguiseType.class), !baby);
                LivingWatcher watcher = mobDisguise.getWatcher();
                if (displayName == null && name != null) {
                    displayName = name;
                }
                if (displayName != null) {
                    watcher.setCustomNameVisible(true);
                    watcher.setCustomName(displayName.asString());
                }
                if (target.isPlayer() && self) {
                    DisguiseAPI.disguiseIgnorePlayers((Entity)target.getBukkitEntity(), (Disguise)mobDisguise, (Player[])new Player[]{target.getPlayer()});
                    break;
                }
                DisguiseAPI.disguiseToAll((Entity)target.getBukkitEntity(), (Disguise)mobDisguise);
                break;
            }
            case 2: {
                if (name == null) {
                    Debug.echoError((ScriptEntry)scriptEntry, (String)"Name not specified!");
                    return;
                }
                PlayerDisguise playerDisguise = new PlayerDisguise(displayName != null ? displayName.asString() : name.asString(), name.asString());
                playerDisguise.setNameVisible(!hideName);
                if (target.isPlayer() && self) {
                    DisguiseAPI.disguiseIgnorePlayers((Entity)target.getBukkitEntity(), (Disguise)playerDisguise, (Player[])new Player[]{target.getPlayer()});
                    break;
                }
                DisguiseAPI.disguiseToAll((Entity)target.getBukkitEntity(), (Disguise)playerDisguise);
                break;
            }
            case 3: {
                MiscDisguise miscDisguise;
                if (type == null) {
                    Debug.echoError((ScriptEntry)scriptEntry, (String)"Entity not specified!");
                    return;
                }
                DisguiseType disType = (DisguiseType)type.asEnum(DisguiseType.class);
                if (disType == DisguiseType.FALLING_BLOCK || disType == DisguiseType.DROPPED_ITEM) {
                    if (id == null) {
                        Debug.echoError((ScriptEntry)scriptEntry, (String)"ID not specified!");
                        return;
                    }
                    miscDisguise = new MiscDisguise(disType, ItemTag.valueOf((String)id.asString(), (TagContext)scriptEntry.context).getItemStack());
                } else {
                    miscDisguise = new MiscDisguise(disType);
                }
                FlagWatcher watcher = miscDisguise.getWatcher();
                if (displayName == null && name != null) {
                    displayName = name;
                }
                if (displayName != null) {
                    watcher.setCustomNameVisible(true);
                    watcher.setCustomName(displayName.asString());
                }
                if (target.isPlayer() && self) {
                    DisguiseAPI.disguiseIgnorePlayers((Entity)target.getBukkitEntity(), (Disguise)miscDisguise, (Player[])new Player[]{target.getPlayer()});
                    break;
                }
                DisguiseAPI.disguiseToAll((Entity)target.getBukkitEntity(), (Disguise)miscDisguise);
                break;
            }
        }
    }

    private static enum Action {
        REMOVE,
        MOB,
        PLAYER,
        MISC;

    }
}

