/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.depenizen.bukkit.commands.worldguard;

import com.denizenscript.denizen.objects.CuboidTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.WorldTag;
import com.denizenscript.denizencore.exceptions.InvalidArgumentsException;
import com.denizenscript.denizencore.objects.Argument;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.scripts.ScriptEntry;
import com.denizenscript.denizencore.scripts.commands.AbstractCommand;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.denizencore.utilities.debugging.Debuggable;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldguard.WorldGuard;
import com.sk89q.worldguard.protection.managers.RegionManager;
import com.sk89q.worldguard.protection.regions.ProtectedCuboidRegion;
import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import org.bukkit.World;

public class RegionCommand
extends AbstractCommand {
    public RegionCommand() {
        this.setName("region");
        this.setSyntax("region [{add} <cuboid>/remove <world>] [id:<name>]");
        this.setRequiredArguments(2, 3);
    }

    public void parseArgs(ScriptEntry scriptEntry) throws InvalidArgumentsException {
        for (Argument arg : scriptEntry) {
            if (!scriptEntry.hasObject("region_id") && arg.matchesPrefix("id")) {
                scriptEntry.addObject("region_id", (Object)arg.asElement());
                continue;
            }
            if (!scriptEntry.hasObject("cuboid") && arg.matchesArgumentType(CuboidTag.class)) {
                scriptEntry.addObject("cuboid", (Object)arg.asType(CuboidTag.class));
                continue;
            }
            if (!scriptEntry.hasObject("world") && arg.matchesArgumentType(WorldTag.class)) {
                scriptEntry.addObject("world", (Object)arg.asType(WorldTag.class));
                continue;
            }
            if (!scriptEntry.hasObject("action") && arg.matchesEnum(Action.class)) {
                scriptEntry.addObject("action", (Object)arg.asElement());
                continue;
            }
            arg.reportUnhandled();
        }
        if (!scriptEntry.hasObject("region_id")) {
            throw new InvalidArgumentsException("Must specify a region id!");
        }
        if (!(scriptEntry.hasObject("cuboid") || scriptEntry.hasObject("action") && !scriptEntry.getElement("action").asString().equalsIgnoreCase("ADD"))) {
            throw new InvalidArgumentsException("Must specify a valid cuboid!");
        }
        if (!scriptEntry.hasObject("world") && scriptEntry.hasObject("action") && scriptEntry.getElement("action").asString().equalsIgnoreCase("REMOVE")) {
            throw new InvalidArgumentsException("Must specify a valid world!");
        }
        if (!scriptEntry.hasObject("action")) {
            scriptEntry.addObject("action", (Object)new ElementTag("ADD"));
        }
    }

    public void execute(ScriptEntry scriptEntry) {
        ElementTag region_id = scriptEntry.getElement("region_id");
        CuboidTag cuboid = (CuboidTag)scriptEntry.getObjectTag("cuboid");
        WorldTag w = (WorldTag)scriptEntry.getObjectTag("world");
        World world = w != null ? w.getWorld() : (cuboid != null ? cuboid.getWorld().getWorld() : null);
        ElementTag action = scriptEntry.getElement("action");
        if (world == null) {
            Debug.echoError((String)"No valid world found!");
            return;
        }
        Debug.report((Debuggable)scriptEntry, (String)this.getName(), (Object[])new Object[]{region_id, cuboid, RegionCommand.db((String)"world", (Object)world.getName()), action});
        RegionManager regionManager = WorldGuard.getInstance().getPlatform().getRegionContainer().get(BukkitAdapter.adapt((World)world));
        if (action.asString().equalsIgnoreCase("REMOVE")) {
            regionManager.removeRegion(region_id.asString());
            return;
        }
        LocationTag low = cuboid.getLow(0);
        LocationTag high = cuboid.getHigh(0);
        ProtectedCuboidRegion region = new ProtectedCuboidRegion(region_id.asString(), BlockVector3.at((double)low.getX(), (double)low.getY(), (double)low.getZ()), BlockVector3.at((double)high.getX(), (double)high.getY(), (double)high.getZ()));
        regionManager.addRegion((ProtectedRegion)region);
    }

    private static enum Action {
        ADD,
        REMOVE;

    }
}

