/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.depenizen.bukkit.events.magicspells;

import com.denizenscript.denizen.events.BukkitScriptEvent;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizen.utilities.implementation.BukkitScriptEntryData;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.scripts.ScriptEntryData;
import com.nisovin.magicspells.events.ManaChangeEvent;
import org.bukkit.OfflinePlayer;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;

public class ManaChangeScriptEvent
extends BukkitScriptEvent
implements Listener {
    public ManaChangeEvent event;
    public PlayerTag player;
    private int new_mana;
    private int old_mana;
    private int max_mana;
    private ElementTag reason;

    public boolean couldMatch(ScriptEvent.ScriptPath path) {
        return path.eventLower.startsWith("magicspells player mana change");
    }

    public boolean applyDetermination(ScriptEvent.ScriptPath path, ObjectTag determinationObj) {
        ElementTag mana;
        String determination = determinationObj.toString();
        if (determination.length() > 0 && (mana = new ElementTag(determination)).isInt()) {
            this.new_mana = mana.asInt();
            this.event.setNewAmount(this.new_mana);
            return true;
        }
        return super.applyDetermination(path, determinationObj);
    }

    public ScriptEntryData getScriptEntryData() {
        return new BukkitScriptEntryData(this.player, null);
    }

    public ObjectTag getContext(String name) {
        return switch (name) {
            case "new_mana" -> new ElementTag(this.new_mana);
            case "old_mana" -> new ElementTag(this.old_mana);
            case "max_mana" -> new ElementTag(this.max_mana);
            case "reason" -> this.reason;
            default -> super.getContext(name);
        };
    }

    @EventHandler
    public void onPlayerCastsSpell(ManaChangeEvent event) {
        this.player = PlayerTag.mirrorBukkitPlayer((OfflinePlayer)event.getPlayer());
        this.new_mana = event.getNewAmount();
        this.old_mana = event.getOldAmount();
        this.max_mana = event.getMaxMana();
        this.reason = new ElementTag((Enum)event.getReason());
        this.event = event;
        this.fire((Event)event);
    }
}

