/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.depenizen.bukkit.objects.residence;

import com.bekvon.bukkit.residence.Residence;
import com.bekvon.bukkit.residence.protection.ClaimedResidence;
import com.bekvon.bukkit.residence.protection.CuboidArea;
import com.denizenscript.denizen.objects.CuboidTag;
import com.denizenscript.denizen.objects.LocationTag;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.Fetchable;
import com.denizenscript.denizencore.objects.ObjectTag;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.objects.core.ListTag;
import com.denizenscript.denizencore.tags.Attribute;
import com.denizenscript.denizencore.tags.ObjectTagProcessor;
import com.denizenscript.denizencore.tags.TagContext;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import org.bukkit.Location;

public class ResidenceTag
implements ObjectTag {
    public static ObjectTagProcessor<ResidenceTag> tagProcessor = new ObjectTagProcessor();
    ClaimedResidence residence = null;
    String prefix = "Residence";

    @Fetchable(value="residence")
    public static ResidenceTag valueOf(String string, TagContext context) {
        if (string == null) {
            return null;
        }
        string = string.replace("residence@", "");
        ClaimedResidence residence = Residence.getInstance().getResidenceManagerAPI().getByName(string);
        if (residence == null) {
            return null;
        }
        return new ResidenceTag(residence);
    }

    public static boolean matches(String arg) {
        arg = arg.replace("residence@", "");
        return Residence.getInstance().getResidenceManagerAPI().getByName(arg) != null;
    }

    public ResidenceTag(ClaimedResidence residence) {
        if (residence != null) {
            this.residence = residence;
        } else {
            Debug.echoError((String)"Residence referenced is null!");
        }
    }

    public String getPrefix() {
        return this.prefix;
    }

    public boolean isUnique() {
        return true;
    }

    public String identify() {
        return "residence@" + this.residence.getName();
    }

    public String identifySimple() {
        return this.identify();
    }

    public ObjectTag setPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    public ClaimedResidence getResidence() {
        return this.residence;
    }

    public boolean equals(ResidenceTag residence) {
        return CoreUtilities.equalsIgnoreCase((String)residence.getResidence().getName(), (String)this.getResidence().getName());
    }

    public String toString() {
        return this.identify();
    }

    public ObjectTag getObjectAttribute(Attribute attribute) {
        return tagProcessor.getObjectAttribute((ObjectTag)this, attribute);
    }

    public static void register() {
        tagProcessor.registerTag(ElementTag.class, "name", (attribute, object) -> new ElementTag(object.getResidence().getName()), new String[0]);
        tagProcessor.registerTag(PlayerTag.class, "owner", (attribute, object) -> new PlayerTag(object.getResidence().getOwnerUUID()), new String[0]);
        tagProcessor.registerTag(ListTag.class, "subzones", (attribute, object) -> {
            ListTag list = new ListTag();
            for (ClaimedResidence subzone : object.getResidence().getSubzones()) {
                list.addObject((ObjectTag)new ResidenceTag(subzone));
            }
            return list;
        }, new String[0]);
        tagProcessor.registerTag(CuboidTag.class, "area", (attribute, object) -> {
            CuboidArea area = object.getResidence().getMainArea();
            return new CuboidTag(area.getLowLocation(), area.getHighLocation());
        }, new String[0]);
        tagProcessor.registerTag(ElementTag.class, LocationTag.class, "is_within", (attribute, object, loc) -> new ElementTag(object.getResidence().containsLoc((Location)loc)), new String[0]);
    }

    public boolean advancedMatches(String matcher) {
        String matcherLow = CoreUtilities.toLowerCase((String)matcher);
        if (matcherLow.equals("residence")) {
            return true;
        }
        return ScriptEvent.runGenericCheck((String)matcherLow, (String)this.getResidence().getName());
    }
}

