/*
 * Decompiled with CFR 0.152.
 */
package com.denizenscript.depenizen.bukkit.clientizen;

import com.denizenscript.denizen.Denizen;
import com.denizenscript.denizen.events.bukkit.ScriptReloadEvent;
import com.denizenscript.denizen.objects.PlayerTag;
import com.denizenscript.denizencore.DenizenCore;
import com.denizenscript.denizencore.events.ScriptEvent;
import com.denizenscript.denizencore.objects.core.ElementTag;
import com.denizenscript.denizencore.scripts.ScriptHelper;
import com.denizenscript.denizencore.utilities.CoreConfiguration;
import com.denizenscript.denizencore.utilities.CoreUtilities;
import com.denizenscript.denizencore.utilities.debugging.Debug;
import com.denizenscript.depenizen.bukkit.Depenizen;
import com.denizenscript.depenizen.bukkit.clientizen.ClientizenEventScriptEvent;
import com.denizenscript.depenizen.bukkit.clientizen.commands.ClientRunCommand;
import com.denizenscript.depenizen.bukkit.clientizen.network.NetworkManager;
import com.denizenscript.depenizen.bukkit.clientizen.network.packets.FireEventPacketIn;
import com.denizenscript.depenizen.bukkit.clientizen.network.packets.ReceiveConfirmationPacketIn;
import com.denizenscript.depenizen.bukkit.clientizen.network.packets.SetScriptsPacketOut;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;

public class ClientizenBridge
implements Listener {
    public static Map<String, String> clientizenScripts = new HashMap<String, String>();
    public static SetScriptsPacketOut scriptsPacket;
    public static Set<UUID> clientizenPlayers;
    public static File clientizenFolder;

    public static void init() {
        Bukkit.getPluginManager().registerEvents((Listener)new ClientizenBridge(), (Plugin)Depenizen.instance);
        clientizenFolder.mkdir();
        NetworkManager.init();
        NetworkManager.registerInPacket(new ReceiveConfirmationPacketIn());
        NetworkManager.registerInPacket(new FireEventPacketIn());
        ScriptEvent.registerScriptEvent(ClientizenEventScriptEvent.class);
        DenizenCore.commandRegistry.registerCommand(ClientRunCommand.class);
        PlayerTag.registerOnlineOnlyTag(ElementTag.class, (String)"has_clientizen", (attribute, object) -> new ElementTag(clientizenPlayers.contains(object.getUUID())), (String[])new String[0]);
        Debug.log((String)"Clientizen support enabled!");
    }

    public static void acceptNewPlayer(Player player) {
        clientizenPlayers.add(player.getUniqueId());
        NetworkManager.send(player, scriptsPacket);
    }

    public static void reloadClientScripts() {
        clientizenScripts.clear();
        for (File file : CoreUtilities.listDScriptFiles((File)clientizenFolder)) {
            String name = CoreUtilities.toLowerCase((String)file.getName());
            if (clientizenScripts.containsKey(name)) {
                Debug.echoError((String)("Multiple script files named '" + name + "' found in client-scripts folder!"));
                continue;
            }
            try (FileInputStream stream = new FileInputStream(file);){
                clientizenScripts.put(name, ScriptHelper.convertStreamToString((InputStream)stream));
                if (!CoreConfiguration.debugLoadingInfo) continue;
                Debug.log((String)("Loaded client script: " + name));
            }
            catch (Exception e) {
                Debug.echoError((String)("Failed to load client script file '" + name + "', see below stack trace:"));
                Debug.echoError((Throwable)e);
            }
        }
        scriptsPacket = new SetScriptsPacketOut(clientizenScripts);
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        clientizenPlayers.remove(event.getPlayer().getUniqueId());
    }

    @EventHandler
    public void onScriptsReload(ScriptReloadEvent event) {
        ClientizenBridge.reloadClientScripts();
        NetworkManager.broadcast(scriptsPacket);
    }

    static {
        clientizenPlayers = new HashSet<UUID>();
        clientizenFolder = new File(Denizen.instance.getDataFolder(), "client-scripts");
    }
}

