/*
 * Decompiled with CFR 0.152.
 */
package org.mcmonkey.sentinel;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Random;
import org.bukkit.Location;
import org.bukkit.util.Vector;

public class SentinelUtilities {
    public static Random random = new Random();
    public static final String encoding = "UTF-8";
    public static final int buff10k = 10240;

    public static double getArrowAngle(Location fireFrom, Location fireTo, double speed, double gravity) {
        double deltaY;
        double basic;
        double v2;
        double v4;
        Vector delta = fireTo.clone().subtract(fireFrom).toVector();
        double deltaXZ = Math.sqrt(delta.getX() * delta.getX() + delta.getZ() * delta.getZ());
        if (deltaXZ == 0.0) {
            deltaXZ = 0.1;
        }
        if ((v4 = (v2 = speed * speed) * v2) < (basic = gravity * (gravity * deltaXZ * deltaXZ + 2.0 * (deltaY = fireTo.getY() - fireFrom.getY()) * v2))) {
            return Double.NEGATIVE_INFINITY;
        }
        return Math.atan((v2 - Math.sqrt(v4 - basic)) / (gravity * deltaXZ));
    }

    public static double hangtime(double launchAngle, double vel, double deltaY, double gravity) {
        double b;
        double a = vel * Math.sin(launchAngle);
        double a2 = a * a + (b = -2.0 * gravity * deltaY);
        if (a2 < 0.0) {
            return 0.0;
        }
        return (a + Math.sqrt(a2)) / gravity;
    }

    public static String concatWithSpaces(String[] strs, int start) {
        StringBuilder temp = new StringBuilder();
        for (int i = start; i < strs.length; ++i) {
            temp.append(strs[i]).append(" ");
        }
        return temp.toString();
    }

    public static String streamToString(InputStream is) {
        try {
            char[] buffer = new char[10240];
            StringBuilder out = new StringBuilder();
            try (InputStreamReader in = new InputStreamReader(is, encoding);){
                int rsz;
                while ((rsz = ((Reader)in).read(buffer, 0, buffer.length)) >= 0) {
                    out.append(buffer, 0, rsz);
                }
            }
            return out.toString();
        }
        catch (Exception ex) {
            return null;
        }
    }
}

