/*
 * Decompiled with CFR 0.152.
 */
package org.mcmonkey.sentinel;

import java.lang.reflect.Method;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import java.util.regex.Pattern;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.ai.EntityTarget;
import net.citizensnpcs.api.ai.StuckAction;
import net.citizensnpcs.api.ai.TargetType;
import net.citizensnpcs.api.ai.TeleportStuckAction;
import net.citizensnpcs.api.ai.speech.SpeechContext;
import net.citizensnpcs.api.event.DespawnReason;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.persistence.Persist;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.trait.trait.Inventory;
import net.citizensnpcs.api.trait.trait.Owner;
import net.citizensnpcs.trait.waypoint.Waypoint;
import net.citizensnpcs.trait.waypoint.WaypointProvider;
import net.citizensnpcs.trait.waypoint.Waypoints;
import net.citizensnpcs.util.NMS;
import net.citizensnpcs.util.PlayerAnimation;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.ThrownPotion;
import org.bukkit.entity.TippedArrow;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionData;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.potion.PotionType;
import org.bukkit.projectiles.ProjectileSource;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;
import org.mcmonkey.sentinel.SentinelCurrentTarget;
import org.mcmonkey.sentinel.SentinelIntegration;
import org.mcmonkey.sentinel.SentinelPlugin;
import org.mcmonkey.sentinel.SentinelTarget;
import org.mcmonkey.sentinel.SentinelUtilities;
import org.mcmonkey.sentinel.events.SentinelAttackEvent;

public class SentinelTrait
extends Trait {
    public static final double healthMin = 0.01;
    public static final int attackRateMax = 2000;
    public static final int healRateMax = 2000;
    @Persist(value="stats_ticksSpawned")
    public long stats_ticksSpawned = 0L;
    @Persist(value="stats_timesSpawned")
    public long stats_timesSpawned = 0L;
    @Persist(value="stats_arrowsFired")
    public long stats_arrowsFired = 0L;
    @Persist(value="stats_potionsThrow")
    public long stats_potionsThrown = 0L;
    @Persist(value="stats_fireballsFired")
    public long stats_fireballsFired = 0L;
    @Persist(value="stats_snowballsThrown")
    public long stats_snowballsThrown = 0L;
    @Persist(value="stats_eggsThrown")
    public long stats_eggsThrown = 0L;
    @Persist(value="stats_skullsThrown")
    public long stats_skullsThrown = 0L;
    @Persist(value="stats_pearlsUsed")
    public long stats_pearlsUsed = 0L;
    @Persist(value="stats_punches")
    public long stats_punches = 0L;
    @Persist(value="stats_attackAttempts")
    public long stats_attackAttempts = 0L;
    @Persist(value="stats_damageTaken")
    public double stats_damageTaken = 0.0;
    @Persist(value="stats_damageGiven")
    public double stats_damageGiven = 0.0;
    @Persist(value="targets")
    public HashSet<String> targets = new HashSet();
    @Persist(value="ignores")
    public HashSet<String> ignores = new HashSet();
    @Persist(value="playerNameTargets")
    public List<String> playerNameTargets = new ArrayList<String>();
    @Persist(value="playerNameIgnores")
    public List<String> playerNameIgnores = new ArrayList<String>();
    @Persist(value="npcNameTargets")
    public List<String> npcNameTargets = new ArrayList<String>();
    @Persist(value="npcNameIgnores")
    public List<String> npcNameIgnores = new ArrayList<String>();
    @Persist(value="entityNameTargets")
    public List<String> entityNameTargets = new ArrayList<String>();
    @Persist(value="entityNameIgnores")
    public List<String> entityNameIgnores = new ArrayList<String>();
    @Persist(value="heldItemTargets")
    public List<String> heldItemTargets = new ArrayList<String>();
    @Persist(value="heldItemIgnores")
    public List<String> heldItemIgnores = new ArrayList<String>();
    @Persist(value="groupTargets")
    public List<String> groupTargets = new ArrayList<String>();
    @Persist(value="groupIgnores")
    public List<String> groupIgnores = new ArrayList<String>();
    @Persist(value="eventTargets")
    public List<String> eventTargets = new ArrayList<String>();
    @Persist(value="otherTargets")
    public List<String> otherTargets = new ArrayList<String>();
    @Persist(value="otherIgnores")
    public List<String> otherIgnores = new ArrayList<String>();
    @Persist(value="range")
    public double range = 20.0;
    @Persist(value="damage")
    public double damage = -1.0;
    @Persist(value="armor")
    public double armor = -1.0;
    @Persist(value="health")
    public double health = 20.0;
    @Persist(value="ranged_chase")
    public boolean rangedChase = false;
    @Persist(value="close_chase")
    public boolean closeChase = true;
    @Persist(value="invincible")
    public boolean invincible = false;
    @Persist(value="fightback")
    public boolean fightback = true;
    @Persist(value="attackRate")
    public int attackRate = 30;
    @Persist(value="attackRateRanged")
    public int attackRateRanged = 30;
    @Persist(value="healRate")
    public int healRate = 30;
    @Persist(value="guardingUpper")
    public long guardingUpper = 0L;
    @Persist(value="guardingLower")
    public long guardingLower = 0L;
    @Persist(value="needsAmmo")
    public boolean needsAmmo = false;
    @Persist(value="safeShot")
    public boolean safeShot = true;
    @Persist(value="respawnTime")
    public long respawnTime = 100L;
    @Persist(value="chaseRange")
    public double chaseRange = 100.0;
    @Persist(value="spawnPoint")
    public Location spawnPoint = null;
    @Persist(value="drops")
    public List<ItemStack> drops = new ArrayList<ItemStack>();
    @Persist(value="enemyDrops")
    public boolean enemyDrops = false;
    @Persist(value="enemyTargetTime")
    public long enemyTargetTime = 0L;
    @Persist(value="speed")
    public double speed = 1.0;
    @Persist(value="warning_text")
    public String warningText = "";
    @Persist(value="greeting_text")
    public String greetingText = "";
    @Persist(value="greet_range")
    public double greetRange = 10.0;
    @Persist(value="autoswitch")
    public boolean autoswitch = false;
    @Persist(value="squad")
    public String squad = null;
    @Persist(value="accuracy")
    public double accuracy = 0.0;
    @Persist(value="realistic")
    public boolean realistic = false;
    @Persist(value="reach")
    public double reach = 3.0;
    public LivingEntity chasing = null;
    private boolean canEnforce = false;
    private boolean sentinelProtected;
    Location bunny_goal = new Location(null, 0.0, 0.0, 0.0);
    public HashSet<SentinelCurrentTarget> currentTargets = new HashSet();
    private HashSet<UUID> greetedAlready = new HashSet();
    public int cTick = 0;
    public long timeSinceAttack = 0L;
    public long timeSinceHeal = 0L;
    int cleverTicks = 0;
    public boolean chased = false;
    public static Random random = new Random();
    public int ticksCountGuard = 0;
    private static final double MAX_DIST = 1.0E8;
    public BukkitRunnable respawnMe;
    public HashMap<UUID, Boolean> needsDropsClear = new HashMap();

    public SentinelTrait() {
        super("sentinel");
    }

    public UUID getGuarding() {
        if (this.guardingLower == 0L && this.guardingUpper == 0L) {
            return null;
        }
        return new UUID(this.guardingUpper, this.guardingLower);
    }

    public void setGuarding(UUID uuid) {
        if (uuid == null) {
            this.guardingUpper = 0L;
            this.guardingLower = 0L;
        } else {
            this.guardingUpper = uuid.getMostSignificantBits();
            this.guardingLower = uuid.getLeastSignificantBits();
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void whenAttacksAreHappening(EntityDamageByEntityEvent event) {
        ProjectileSource source;
        if (!this.npc.isSpawned()) {
            return;
        }
        if (event.isCancelled()) {
            return;
        }
        if (event.getEntity().getUniqueId().equals(this.getLivingEntity().getUniqueId())) {
            if (!event.isApplicable(EntityDamageEvent.DamageModifier.ARMOR)) {
                event.setDamage(EntityDamageEvent.DamageModifier.BASE, (1.0 - this.getArmor(this.getLivingEntity())) * event.getDamage(EntityDamageEvent.DamageModifier.BASE));
            } else {
                event.setDamage(EntityDamageEvent.DamageModifier.ARMOR, -this.getArmor(this.getLivingEntity()) * event.getDamage(EntityDamageEvent.DamageModifier.BASE));
            }
            return;
        }
        if (event.getDamager().getUniqueId().equals(this.getLivingEntity().getUniqueId())) {
            if (SentinelPlugin.instance.alternateDamage) {
                if (this.canEnforce) {
                    this.canEnforce = false;
                    this.whenAttacksHappened(event);
                    if (!event.isCancelled()) {
                        ((LivingEntity)event.getEntity()).damage(event.getFinalDamage());
                        if (event.getEntity() instanceof LivingEntity) {
                            this.knockback((LivingEntity)event.getEntity());
                        }
                    }
                    if (SentinelPlugin.debugMe) {
                        SentinelPlugin.instance.getLogger().info("Sentinel: enforce damage value to " + event.getFinalDamage());
                    }
                } else if (SentinelPlugin.debugMe) {
                    SentinelPlugin.instance.getLogger().info("Sentinel: refuse damage enforcement");
                }
                event.setDamage(0.0);
                event.setCancelled(true);
                return;
            }
            event.setDamage(EntityDamageEvent.DamageModifier.BASE, this.getDamage());
        }
        if (event.getDamager() instanceof Projectile && (source = ((Projectile)event.getDamager()).getShooter()) instanceof LivingEntity && ((LivingEntity)source).getUniqueId().equals(this.getLivingEntity().getUniqueId())) {
            if (SentinelPlugin.instance.alternateDamage) {
                if (this.canEnforce) {
                    this.canEnforce = false;
                    this.whenAttacksHappened(event);
                    if (!event.isCancelled()) {
                        ((LivingEntity)event.getEntity()).damage(this.getDamage());
                        if (event.getEntity() instanceof LivingEntity) {
                            this.knockback((LivingEntity)event.getEntity());
                        }
                    }
                    if (SentinelPlugin.debugMe) {
                        SentinelPlugin.instance.getLogger().info("Sentinel: enforce damage value to " + this.getDamage());
                    }
                } else if (SentinelPlugin.debugMe) {
                    SentinelPlugin.instance.getLogger().info("Sentinel: refuse damage enforcement");
                }
                event.setDamage(0.0);
                event.setCancelled(true);
                return;
            }
            double dam = this.getDamage();
            double modder = event.getDamage(EntityDamageEvent.DamageModifier.BASE);
            double rel = modder == 0.0 ? 1.0 : dam / modder;
            event.setDamage(EntityDamageEvent.DamageModifier.BASE, dam);
            for (EntityDamageEvent.DamageModifier mod : EntityDamageEvent.DamageModifier.values()) {
                if (mod == EntityDamageEvent.DamageModifier.BASE || !event.isApplicable(mod)) continue;
                event.setDamage(mod, event.getDamage(mod) * rel);
                if (!SentinelPlugin.debugMe) continue;
                SentinelPlugin.instance.getLogger().info("Sentinel: Set damage for " + mod + " to " + event.getDamage(mod));
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void whenAttacksHappened(EntityDamageByEntityEvent event) {
        ProjectileSource source;
        if (!this.npc.isSpawned()) {
            return;
        }
        if (event.isCancelled()) {
            return;
        }
        boolean isMe = event.getEntity().getUniqueId().equals(this.getLivingEntity().getUniqueId());
        if (this.sentinelProtected && isMe) {
            ProjectileSource source2;
            if (event.getDamager() instanceof LivingEntity && this.isIgnored((LivingEntity)event.getDamager())) {
                event.setCancelled(true);
                return;
            }
            if (event.getDamager() instanceof Projectile && (source2 = ((Projectile)event.getDamager()).getShooter()) instanceof LivingEntity && this.isIgnored((LivingEntity)source2)) {
                event.setCancelled(true);
                return;
            }
        }
        boolean isKilling = event.getEntity() instanceof LivingEntity && event.getFinalDamage() > ((LivingEntity)event.getEntity()).getHealth();
        boolean isFriend = this.getGuarding() != null && event.getEntity().getUniqueId().equals(this.getGuarding());
        boolean attackerIsMe = event.getDamager().getUniqueId().equals(this.getLivingEntity().getUniqueId());
        if (isMe || isFriend) {
            if (attackerIsMe) {
                event.setCancelled(true);
                return;
            }
            if (isMe) {
                this.stats_damageTaken += event.getFinalDamage();
            }
            if (this.fightback && event.getDamager() instanceof LivingEntity && !this.isIgnored((LivingEntity)event.getDamager())) {
                this.addTarget(event.getDamager().getUniqueId());
            } else if (event.getDamager() instanceof Projectile) {
                ProjectileSource source3 = ((Projectile)event.getDamager()).getShooter();
                if (this.fightback && source3 instanceof LivingEntity && !this.isIgnored((LivingEntity)source3)) {
                    if (((LivingEntity)source3).getUniqueId().equals(this.getLivingEntity().getUniqueId())) {
                        event.setCancelled(true);
                        return;
                    }
                    this.addTarget(((LivingEntity)source3).getUniqueId());
                }
            }
            if (isKilling && isMe && SentinelPlugin.instance.blockEvents) {
                this.generalDeathHandler(this.getLivingEntity());
                this.npc.despawn(DespawnReason.DEATH);
                event.setCancelled(true);
                return;
            }
            return;
        }
        if (attackerIsMe) {
            if (this.safeShot && !this.shouldTarget((LivingEntity)event.getEntity())) {
                event.setCancelled(true);
                return;
            }
            this.stats_damageGiven += event.getFinalDamage();
            if (!this.enemyDrops) {
                this.needsDropsClear.put(event.getEntity().getUniqueId(), true);
            }
            return;
        }
        Entity e = event.getDamager();
        if (!(e instanceof LivingEntity) && e instanceof Projectile && (source = ((Projectile)e).getShooter()) instanceof LivingEntity && (e = (LivingEntity)source).getUniqueId().equals(this.getLivingEntity().getUniqueId())) {
            if (this.safeShot && !this.shouldTarget((LivingEntity)event.getEntity())) {
                event.setCancelled(true);
                return;
            }
            this.stats_damageGiven += event.getFinalDamage();
            if (!this.enemyDrops) {
                this.needsDropsClear.put(event.getEntity().getUniqueId(), true);
            }
            return;
        }
        boolean isEventTarget = false;
        if (this.eventTargets.contains("pvp") && event.getEntity() instanceof Player && !CitizensAPI.getNPCRegistry().isNPC(event.getEntity())) {
            isEventTarget = true;
        } else if (this.eventTargets.contains("pve") && !(event.getEntity() instanceof Player) && event.getEntity() instanceof LivingEntity) {
            isEventTarget = true;
        } else if (this.eventTargets.contains("pvnpc") && event.getEntity() instanceof LivingEntity && CitizensAPI.getNPCRegistry().isNPC(event.getEntity())) {
            isEventTarget = true;
        } else if (this.eventTargets.contains("pvsentinel") && event.getEntity() instanceof LivingEntity && CitizensAPI.getNPCRegistry().isNPC(event.getEntity()) && CitizensAPI.getNPCRegistry().getNPC(event.getEntity()).hasTrait(SentinelTrait.class)) {
            isEventTarget = true;
        }
        if (isEventTarget && e != null && e instanceof LivingEntity && this.canSee((LivingEntity)e) && !this.isIgnored((LivingEntity)e)) {
            this.addTarget(e.getUniqueId());
        }
    }

    @EventHandler
    public void whenAnEnemyDies(EntityDeathEvent event) {
        SentinelCurrentTarget target = new SentinelCurrentTarget();
        target.targetID = event.getEntity().getUniqueId();
        this.currentTargets.remove(target);
    }

    public void onAttach() {
        FileConfiguration config = SentinelPlugin.instance.getConfig();
        this.attackRate = config.getInt("sentinel defaults.attack rate", 30);
        this.healRate = config.getInt("sentinel defaults.heal rate", 30);
        this.respawnTime = config.getInt("sentinel defaults.respawn time", 100);
        this.rangedChase = config.getBoolean("sentinel defaults.ranged chase target", false);
        this.closeChase = config.getBoolean("sentinel defaults.close chase target", true);
        this.armor = config.getDouble("sentinel defaults.armor", -1.0);
        this.damage = config.getDouble("sentinel defaults.damage", -1.0);
        this.health = config.getDouble("sentinel defaults.health", 20.0);
        if (this.npc.isSpawned()) {
            this.getLivingEntity().setMaxHealth(this.health);
            this.getLivingEntity().setHealth(this.health);
        }
        this.setInvincible(config.getBoolean("sentinel defaults.invincible", false));
        this.fightback = config.getBoolean("sentinel defaults.fightback", true);
        this.needsAmmo = config.getBoolean("sentinel defaults.needs ammo", false);
        this.safeShot = config.getBoolean("sentinel defaults.safe shot", true);
        this.enemyDrops = config.getBoolean("sentinel defaults.enemy drops", false);
        this.enemyTargetTime = config.getInt("sentinel defaults.enemy target time", 0);
        this.speed = config.getInt("sentinel defaults.speed", 1);
        if (this.speed <= 0.0) {
            this.speed = 1.0;
        }
        this.autoswitch = config.getBoolean("sentinel defaults.autoswitch", false);
        this.ignores.add(SentinelTarget.OWNER.name());
        this.sentinelProtected = config.getBoolean("random.protected", false);
        this.reach = config.getDouble("reach", 3.0);
    }

    public void useItem() {
        if (this.npc.isSpawned() && this.getLivingEntity() instanceof Player) {
            if (SentinelTarget.v1_9) {
                PlayerAnimation.START_USE_MAINHAND_ITEM.play((Player)this.getLivingEntity());
            }
            BukkitRunnable runner = new BukkitRunnable(){

                public void run() {
                    if (SentinelTrait.this.npc.isSpawned() && SentinelTrait.this.getLivingEntity() instanceof Player) {
                        PlayerAnimation.STOP_USE_ITEM.play((Player)SentinelTrait.this.getLivingEntity());
                    }
                }
            };
            runner.runTaskLater((Plugin)SentinelPlugin.instance, 10L);
        }
    }

    public void swingWeapon() {
        if (this.npc.isSpawned() && this.getLivingEntity() instanceof Player) {
            PlayerAnimation.ARM_SWING.play((Player)this.getLivingEntity());
        }
    }

    public double firingMinimumRange() {
        EntityType type = this.getLivingEntity().getType();
        if (type == EntityType.WITHER || type == EntityType.GHAST) {
            return 8.0;
        }
        return 2.0;
    }

    public AbstractMap.SimpleEntry<Location, Vector> getLaunchDetail(Location target, Vector lead) {
        double sbase;
        double speeda;
        this.faceLocation(target);
        double angt = Double.POSITIVE_INFINITY;
        Location start = this.getLivingEntity().getEyeLocation().clone().add(this.getLivingEntity().getEyeLocation().getDirection().multiply(this.firingMinimumRange()));
        for (speeda = sbase = SentinelPlugin.instance.minShootSpeed; speeda <= sbase + 15.0 && Double.isInfinite(angt = SentinelUtilities.getArrowAngle(start, target, speeda, 20.0)); speeda += 5.0) {
        }
        if (Double.isInfinite(angt)) {
            return null;
        }
        double hangT = SentinelUtilities.hangtime(angt, speeda, target.getY() - start.getY(), 20.0);
        Location to = target.clone().add(lead.clone().multiply(hangT));
        Vector relative = to.clone().subtract(start.toVector()).toVector();
        double deltaXZ = Math.sqrt(relative.getX() * relative.getX() + relative.getZ() * relative.getZ());
        if (deltaXZ == 0.0) {
            deltaXZ = 0.1;
        }
        for (speeda = sbase; speeda <= sbase + 15.0 && Double.isInfinite(angt = SentinelUtilities.getArrowAngle(start, to, speeda, 20.0)); speeda += 5.0) {
        }
        if (Double.isInfinite(angt)) {
            return null;
        }
        relative.setY(Math.tan(angt) * deltaXZ);
        relative = relative.normalize();
        Vector normrel = relative.clone();
        relative = relative.multiply((speeda += 1.188 * hangT * hangT) / 20.0);
        start.setDirection(normrel);
        return new AbstractMap.SimpleEntry<Location, Vector>(start, relative);
    }

    public double randomAcc() {
        return SentinelUtilities.random.nextDouble() * this.accuracy * 2.0 - this.accuracy;
    }

    public Vector fixForAcc(Vector input) {
        if (Double.isInfinite(input.getX()) || Double.isNaN(input.getX())) {
            return new Vector(0, 0, 0);
        }
        return new Vector(input.getX() + this.randomAcc(), input.getY() + this.randomAcc(), input.getZ() + this.randomAcc());
    }

    public void firePotion(ItemStack potion, Location target, Vector lead) {
        ++this.stats_potionsThrown;
        AbstractMap.SimpleEntry<Location, Vector> start = this.getLaunchDetail(target, lead);
        Entity entpotion = SentinelTarget.v1_9 ? start.getKey().getWorld().spawnEntity(start.getKey(), potion.getType() == Material.SPLASH_POTION ? EntityType.SPLASH_POTION : EntityType.LINGERING_POTION) : start.getKey().getWorld().spawnEntity(start.getKey(), EntityType.SPLASH_POTION);
        ((ThrownPotion)entpotion).setShooter((ProjectileSource)this.getLivingEntity());
        ((ThrownPotion)entpotion).setItem(potion);
        entpotion.setVelocity(this.fixForAcc(start.getValue()));
        this.swingWeapon();
    }

    public void fireArrow(ItemStack type, Location target, Vector lead) {
        Entity arrow;
        AbstractMap.SimpleEntry<Location, Vector> start = this.getLaunchDetail(target, lead);
        if (start == null || start.getKey() == null) {
            return;
        }
        ++this.stats_arrowsFired;
        if (SentinelTarget.v1_9) {
            PotionData data;
            arrow = start.getKey().getWorld().spawnEntity(start.getKey(), type.getType() == Material.SPECTRAL_ARROW ? EntityType.SPECTRAL_ARROW : (type.getType() == Material.TIPPED_ARROW ? EntityType.TIPPED_ARROW : EntityType.ARROW));
            ((Projectile)arrow).setShooter((ProjectileSource)this.getLivingEntity());
            if (arrow instanceof TippedArrow && (data = ((PotionMeta)type.getItemMeta()).getBasePotionData()).getType() != null && data.getType() != PotionType.UNCRAFTABLE) {
                ((TippedArrow)arrow).setBasePotionData(data);
                for (PotionEffect effect : ((PotionMeta)type.getItemMeta()).getCustomEffects()) {
                    ((TippedArrow)arrow).addCustomEffect(effect, true);
                }
            }
        } else {
            arrow = start.getKey().getWorld().spawnEntity(start.getKey(), EntityType.ARROW);
            ((Projectile)arrow).setShooter((ProjectileSource)this.getLivingEntity());
        }
        arrow.setVelocity(this.fixForAcc(start.getValue()));
        if (((Inventory)this.npc.getTrait(Inventory.class)).getContents()[0].containsEnchantment(Enchantment.ARROW_FIRE)) {
            arrow.setFireTicks(10000);
        }
        this.useItem();
    }

    public void fireSnowball(Location target) {
        this.swingWeapon();
        ++this.stats_snowballsThrown;
        this.faceLocation(target);
        Vector forward = this.getLivingEntity().getEyeLocation().getDirection();
        Location spawnAt = this.getLivingEntity().getEyeLocation().clone().add(forward.clone().multiply(this.firingMinimumRange()));
        Entity ent = spawnAt.getWorld().spawnEntity(spawnAt, EntityType.SNOWBALL);
        ((Projectile)ent).setShooter((ProjectileSource)this.getLivingEntity());
        ent.setVelocity(this.fixForAcc(target.clone().subtract(spawnAt).toVector().normalize().multiply(2.0)));
    }

    public void fireEgg(Location target) {
        this.swingWeapon();
        ++this.stats_eggsThrown;
        this.faceLocation(target);
        Vector forward = this.getLivingEntity().getEyeLocation().getDirection();
        Location spawnAt = this.getLivingEntity().getEyeLocation().clone().add(forward.clone().multiply(this.firingMinimumRange()));
        Entity ent = spawnAt.getWorld().spawnEntity(spawnAt, EntityType.EGG);
        ((Projectile)ent).setShooter((ProjectileSource)this.getLivingEntity());
        ent.setVelocity(this.fixForAcc(target.clone().subtract(spawnAt).toVector().normalize().multiply(2.0)));
    }

    public void firePearl(LivingEntity target) {
        this.swingWeapon();
        this.faceLocation(target.getEyeLocation());
        ++this.stats_pearlsUsed;
        target.setVelocity(target.getVelocity().add(new Vector(0.0, this.getDamage(), 0.0)));
    }

    public void faceLocation(Location l) {
        this.npc.faceLocation(l.clone().subtract(0.0, this.getLivingEntity().getEyeHeight(), 0.0));
    }

    public void fireFireball(Location target) {
        this.swingWeapon();
        ++this.stats_fireballsFired;
        this.faceLocation(target);
        Vector forward = this.getLivingEntity().getEyeLocation().getDirection();
        Location spawnAt = this.getLivingEntity().getEyeLocation().clone().add(forward.clone().multiply(this.firingMinimumRange()));
        Entity ent = spawnAt.getWorld().spawnEntity(spawnAt, EntityType.SMALL_FIREBALL);
        ((Projectile)ent).setShooter((ProjectileSource)this.getLivingEntity());
        ent.setVelocity(this.fixForAcc(target.clone().subtract(spawnAt).toVector().normalize().multiply(4)));
    }

    public void fireSkull(Location target) {
        this.swingWeapon();
        ++this.stats_skullsThrown;
        this.faceLocation(target);
        Vector forward = this.getLivingEntity().getEyeLocation().getDirection();
        Location spawnAt = this.getLivingEntity().getEyeLocation().clone().add(forward.clone().multiply(this.firingMinimumRange()));
        Entity ent = spawnAt.getWorld().spawnEntity(spawnAt, EntityType.WITHER_SKULL);
        ((Projectile)ent).setShooter((ProjectileSource)this.getLivingEntity());
        ent.setVelocity(this.fixForAcc(target.clone().subtract(spawnAt).toVector().normalize().multiply(4)));
    }

    public double getDamage() {
        if (this.damage >= 0.0) {
            return this.damage;
        }
        ItemStack weapon = SentinelTarget.v1_9 ? this.getLivingEntity().getEquipment().getItemInMainHand() : this.getLivingEntity().getEquipment().getItemInHand();
        if (weapon == null) {
            return 1.0;
        }
        double multiplier = 1.0;
        multiplier += weapon.getItemMeta() == null || !weapon.getItemMeta().hasEnchant(Enchantment.DAMAGE_ALL) ? 0.0 : (double)weapon.getItemMeta().getEnchantLevel(Enchantment.DAMAGE_ALL) * 0.2;
        Material weaponType = weapon.getType();
        if (SentinelTarget.BOW_MATERIALS.contains(weaponType)) {
            return 6.0 * (1.0 + (weapon.getItemMeta() == null || !weapon.getItemMeta().hasEnchant(Enchantment.ARROW_DAMAGE) ? 0.0 : (double)weapon.getItemMeta().getEnchantLevel(Enchantment.ARROW_DAMAGE) * 0.3));
        }
        Double damageMult = SentinelTarget.WEAPON_DAMAGE_MULTIPLIERS.get(weaponType);
        if (damageMult == null) {
            return multiplier;
        }
        return multiplier * damageMult;
    }

    public double getArmor(LivingEntity ent) {
        if (this.armor < 0.0) {
            ItemStack boots;
            Double bootsAdder;
            ItemStack leggings;
            Double leggingsAdder;
            ItemStack chestplate;
            Double chestplateAdder;
            Double helmetAdder;
            double baseArmor = 0.0;
            ItemStack helmet = ent.getEquipment().getHelmet();
            Double d = helmetAdder = helmet == null ? null : SentinelTarget.ARMOR_PROTECTION_MULTIPLIERS.get(helmet.getType());
            if (helmetAdder != null) {
                baseArmor += helmetAdder.doubleValue();
            }
            Double d2 = chestplateAdder = (chestplate = ent.getEquipment().getChestplate()) == null ? null : SentinelTarget.ARMOR_PROTECTION_MULTIPLIERS.get(chestplate.getType());
            if (chestplateAdder != null) {
                baseArmor += chestplateAdder.doubleValue();
            }
            Double d3 = leggingsAdder = (leggings = ent.getEquipment().getLeggings()) == null ? null : SentinelTarget.ARMOR_PROTECTION_MULTIPLIERS.get(leggings.getType());
            if (leggingsAdder != null) {
                baseArmor += leggingsAdder.doubleValue();
            }
            Double d4 = bootsAdder = (boots = ent.getEquipment().getBoots()) == null ? null : SentinelTarget.ARMOR_PROTECTION_MULTIPLIERS.get(boots.getType());
            if (bootsAdder != null) {
                baseArmor += bootsAdder.doubleValue();
            }
            return Math.min(baseArmor, 0.8);
        }
        return this.armor;
    }

    public void knockback(LivingEntity entity) {
        Vector relative = entity.getLocation().toVector().subtract(this.getLivingEntity().getLocation().toVector());
        relative = relative.normalize();
        relative.setY(0.75);
        relative.multiply(0.5);
        entity.setVelocity(entity.getVelocity().add(relative));
        if (SentinelPlugin.debugMe) {
            SentinelPlugin.instance.getLogger().info("Sentinel: applied knockback velocity adder of " + relative);
        }
    }

    public void punch(LivingEntity entity) {
        this.faceLocation(entity.getLocation());
        this.swingWeapon();
        ++this.stats_punches;
        if (SentinelPlugin.instance.workaroundDamage) {
            if (SentinelPlugin.debugMe) {
                SentinelPlugin.instance.getLogger().info("Sentinel: workaround damage value at " + this.getDamage() + " yields " + this.getDamage() * (1.0 - this.getArmor(entity)));
            }
            entity.damage(this.getDamage() * (1.0 - this.getArmor(entity)));
            this.knockback(entity);
            if (!this.enemyDrops) {
                this.needsDropsClear.put(entity.getUniqueId(), true);
            }
        } else {
            if (SentinelPlugin.debugMe) {
                SentinelPlugin.instance.getLogger().info("Sentinel: Punch/natural for " + this.getDamage());
            }
            entity.damage(this.getDamage(), (Entity)this.getLivingEntity());
        }
    }

    public Entity getTargetFor(EntityTarget targ) {
        if (SentinelTarget.v1_9) {
            return targ.getTarget();
        }
        try {
            Method meth = EntityTarget.class.getMethod("getTarget", new Class[0]);
            meth.setAccessible(true);
            return (LivingEntity)meth.invoke((Object)targ, new Object[0]);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public void chase(LivingEntity entity) {
        if (this.npc.getNavigator().getTargetType() == TargetType.LOCATION && this.npc.getNavigator().getTargetAsLocation() != null && (this.npc.getNavigator().getTargetAsLocation().getWorld().equals(entity.getWorld()) && this.npc.getNavigator().getTargetAsLocation().distanceSquared(entity.getLocation()) < 4.0 || this.npc.getNavigator().getTargetAsLocation().getWorld().equals(this.bunny_goal.getWorld()) && this.npc.getNavigator().getTargetAsLocation().distanceSquared(this.bunny_goal) < 4.0)) {
            return;
        }
        this.cleverTicks = 0;
        this.chasing = entity;
        this.chased = true;
        if (this.npc.getNavigator().getTargetType() == TargetType.ENTITY && this.getTargetFor(this.npc.getNavigator().getEntityTarget()).getUniqueId().equals(entity.getUniqueId())) {
            return;
        }
        this.npc.getNavigator().getDefaultParameters().stuckAction(null);
        this.npc.getNavigator().setTarget((Entity)entity, false);
        this.npc.getNavigator().getLocalParameters().speedModifier((float)this.speed);
    }

    public ItemStack getArrow() {
        ItemStack[] items;
        if (!this.npc.hasTrait(Inventory.class)) {
            return this.needsAmmo ? null : new ItemStack(Material.ARROW, 1);
        }
        Inventory inv = (Inventory)this.npc.getTrait(Inventory.class);
        for (ItemStack item : items = inv.getContents()) {
            if (item == null) continue;
            Material mat = item.getType();
            if (!(SentinelTarget.v1_9 ? mat == Material.ARROW || mat == Material.TIPPED_ARROW || mat == Material.SPECTRAL_ARROW : mat == Material.ARROW)) continue;
            return item.clone();
        }
        return this.needsAmmo ? null : new ItemStack(Material.ARROW, 1);
    }

    public void reduceDurability() {
        if (SentinelTarget.v1_9) {
            ItemStack item = this.getLivingEntity().getEquipment().getItemInMainHand();
            if (item != null && item.getType() != Material.AIR) {
                if (item.getDurability() >= item.getType().getMaxDurability() - 1) {
                    this.getLivingEntity().getEquipment().setItemInMainHand(null);
                } else {
                    item.setDurability((short)(item.getDurability() + 1));
                    this.getLivingEntity().getEquipment().setItemInMainHand(item);
                }
            }
        } else {
            ItemStack item = this.getLivingEntity().getEquipment().getItemInHand();
            if (item != null && item.getType() != Material.AIR) {
                if (item.getDurability() >= item.getType().getMaxDurability() - 1) {
                    this.getLivingEntity().getEquipment().setItemInHand(null);
                } else {
                    item.setDurability((short)(item.getDurability() + 1));
                    this.getLivingEntity().getEquipment().setItemInHand(item);
                }
            }
        }
    }

    public void takeArrow() {
        if (!this.npc.hasTrait(Inventory.class)) {
            return;
        }
        Inventory inv = (Inventory)this.npc.getTrait(Inventory.class);
        ItemStack[] items = inv.getContents();
        for (int i = 0; i < items.length; ++i) {
            Material mat;
            ItemStack item = items[i];
            if (item == null || (mat = item.getType()) != Material.ARROW && (!SentinelTarget.v1_9 || mat != Material.TIPPED_ARROW && mat != Material.SPECTRAL_ARROW)) continue;
            if (item.getAmount() > 1) {
                item.setAmount(item.getAmount() - 1);
                items[i] = item;
                inv.setContents(items);
                return;
            }
            items[i] = null;
            inv.setContents(items);
            return;
        }
    }

    public void takeSnowball() {
        if (!this.npc.hasTrait(Inventory.class)) {
            return;
        }
        Inventory inv = (Inventory)this.npc.getTrait(Inventory.class);
        ItemStack[] items = inv.getContents();
        for (int i = 0; i < items.length; ++i) {
            Material mat;
            ItemStack item = items[i];
            if (item == null || (mat = item.getType()) != SentinelTarget.MATERIAL_SNOW_BALL) continue;
            if (item.getAmount() > 1) {
                item.setAmount(item.getAmount() - 1);
                items[i] = item;
                inv.setContents(items);
                return;
            }
            items[i] = null;
            inv.setContents(items);
            return;
        }
    }

    public void takeOne() {
        if (SentinelTarget.v1_9) {
            ItemStack item = this.getLivingEntity().getEquipment().getItemInMainHand();
            if (item != null && item.getType() != Material.AIR) {
                if (item.getAmount() > 1) {
                    item.setAmount(item.getAmount() - 1);
                    this.getLivingEntity().getEquipment().setItemInMainHand(item);
                } else {
                    this.getLivingEntity().getEquipment().setItemInMainHand(null);
                }
            }
        } else {
            ItemStack item = this.getLivingEntity().getEquipment().getItemInHand();
            if (item != null && item.getType() != Material.AIR) {
                if (item.getAmount() > 1) {
                    item.setAmount(item.getAmount() - 1);
                    this.getLivingEntity().getEquipment().setItemInHand(item);
                } else {
                    this.getLivingEntity().getEquipment().setItemInHand(null);
                }
            }
        }
    }

    public boolean isWeapon(Material mat) {
        return SentinelTarget.WEAPON_DAMAGE_MULTIPLIERS.containsKey(mat) || SentinelTarget.POTION_MATERIALS.contains(mat) || SentinelTarget.BOW_MATERIALS.contains(mat) || SentinelTarget.SKULL_MATERIALS.contains(mat) || mat == SentinelTarget.MATERIAL_SNOW_BALL || mat == SentinelTarget.MATERIAL_BLAZE_ROD || mat == SentinelTarget.MATERIAL_NETHER_STAR;
    }

    public void grabNextItem() {
        if (!this.npc.hasTrait(Inventory.class)) {
            return;
        }
        Inventory inv = (Inventory)this.npc.getTrait(Inventory.class);
        ItemStack[] items = inv.getContents();
        ItemStack held = items[0];
        if (held != null && held.getType() != Material.AIR) {
            return;
        }
        for (int i = 0; i < items.length; ++i) {
            Material mat;
            ItemStack item = items[i];
            if (item == null || !this.isWeapon(mat = (item = item.clone()).getType())) continue;
            if (item.getAmount() > 1) {
                item.setAmount(item.getAmount() - 1);
                items[i] = item;
                items[0] = item.clone();
                items[0].setAmount(1);
                inv.setContents(items);
                item = item.clone();
                item.setAmount(1);
                return;
            }
            items[i] = new ItemStack(Material.AIR);
            items[0] = item.clone();
            inv.setContents(items);
            return;
        }
    }

    public void rechase() {
        if (this.chasing != null) {
            this.chase(this.chasing);
        }
    }

    public void swapToRanged() {
        if (!this.npc.hasTrait(Inventory.class)) {
            return;
        }
        int i = 0;
        Inventory inv = (Inventory)this.npc.getTrait(Inventory.class);
        ItemStack[] items = inv.getContents();
        ItemStack held = items[0] == null ? null : items[0].clone();
        boolean edit = false;
        while (!this.isRanged() && i < items.length - 1) {
            if (items[++i] == null || items[i].getType() == Material.AIR) continue;
            items[0] = items[i].clone();
            items[i] = new ItemStack(Material.AIR);
            inv.setContents(items);
            edit = true;
        }
        if (edit) {
            items[i] = held;
            inv.setContents(items);
        }
    }

    public void swapToMelee() {
        if (!this.npc.hasTrait(Inventory.class)) {
            return;
        }
        int i = 0;
        Inventory inv = (Inventory)this.npc.getTrait(Inventory.class);
        ItemStack[] items = inv.getContents();
        ItemStack held = items[0] == null ? null : items[0].clone();
        boolean edit = false;
        while (this.isRanged() && i < items.length - 1) {
            if (items[++i] == null || items[i].getType() == Material.AIR) continue;
            items[0] = items[i].clone();
            items[i] = new ItemStack(Material.AIR);
            inv.setContents(items);
            edit = true;
        }
        if (edit) {
            items[i] = held;
            inv.setContents(items);
        }
    }

    public void tryAttack(LivingEntity entity) {
        ItemStack item;
        if (!entity.getWorld().equals(this.getLivingEntity().getWorld())) {
            return;
        }
        if (!this.getLivingEntity().hasLineOfSight((Entity)entity)) {
            return;
        }
        ++this.stats_attackAttempts;
        double dist = this.getLivingEntity().getEyeLocation().distanceSquared(entity.getEyeLocation());
        if (SentinelPlugin.debugMe) {
            SentinelPlugin.instance.getLogger().info("Sentinel: tryAttack at range " + dist);
        }
        if (this.autoswitch && dist > this.reach * this.reach) {
            this.swapToRanged();
        } else if (this.autoswitch && dist < this.reach * this.reach) {
            this.swapToMelee();
        }
        SentinelAttackEvent sat = new SentinelAttackEvent(this.npc);
        Bukkit.getPluginManager().callEvent((Event)sat);
        if (sat.isCancelled()) {
            if (SentinelPlugin.debugMe) {
                SentinelPlugin.instance.getLogger().info("Sentinel: tryAttack refused, event cancellation");
            }
            return;
        }
        this.addTarget(entity.getUniqueId());
        for (SentinelIntegration si : SentinelPlugin.integrations) {
            if (!si.tryAttack(this, entity)) continue;
            return;
        }
        if (this.usesBow()) {
            if (this.canSee(entity)) {
                if (this.timeSinceAttack < (long)this.attackRateRanged) {
                    if (this.rangedChase) {
                        this.rechase();
                    }
                    return;
                }
                this.timeSinceAttack = 0L;
                item = this.getArrow();
                if (item != null) {
                    this.fireArrow(item, entity.getEyeLocation(), entity.getVelocity());
                    if (this.needsAmmo) {
                        this.reduceDurability();
                        this.takeArrow();
                        this.grabNextItem();
                    }
                }
            } else if (this.rangedChase) {
                this.chase(entity);
            }
        } else if (this.usesSnowball()) {
            if (this.canSee(entity)) {
                if (this.timeSinceAttack < (long)this.attackRateRanged) {
                    if (this.rangedChase) {
                        this.rechase();
                    }
                    return;
                }
                this.timeSinceAttack = 0L;
                item = this.getArrow();
                if (item != null) {
                    this.fireSnowball(entity.getEyeLocation());
                    if (this.needsAmmo) {
                        this.takeSnowball();
                        this.grabNextItem();
                    }
                }
            } else if (this.rangedChase) {
                this.chase(entity);
            }
        } else if (this.usesPotion()) {
            if (this.canSee(entity)) {
                if (this.timeSinceAttack < (long)this.attackRateRanged) {
                    if (this.rangedChase) {
                        this.rechase();
                    }
                    return;
                }
                this.timeSinceAttack = 0L;
                if (SentinelTarget.v1_9) {
                    this.firePotion(this.getLivingEntity().getEquipment().getItemInMainHand(), entity.getEyeLocation(), entity.getVelocity());
                } else {
                    this.firePotion(this.getLivingEntity().getEquipment().getItemInHand(), entity.getEyeLocation(), entity.getVelocity());
                }
                if (this.needsAmmo) {
                    this.takeOne();
                    this.grabNextItem();
                }
            } else if (this.rangedChase) {
                this.chase(entity);
            }
        } else if (this.usesEgg()) {
            if (this.canSee(entity)) {
                if (this.timeSinceAttack < (long)this.attackRateRanged) {
                    if (this.rangedChase) {
                        this.rechase();
                    }
                    return;
                }
                this.timeSinceAttack = 0L;
                this.fireEgg(entity.getEyeLocation());
                if (this.needsAmmo) {
                    this.takeOne();
                    this.grabNextItem();
                }
            } else if (this.rangedChase) {
                this.chase(entity);
            }
        } else if (this.usesPearl()) {
            if (this.canSee(entity)) {
                if (this.timeSinceAttack < (long)this.attackRateRanged) {
                    if (this.rangedChase) {
                        this.rechase();
                    }
                    return;
                }
                this.timeSinceAttack = 0L;
                this.firePearl(entity);
                if (this.needsAmmo) {
                    this.takeOne();
                    this.grabNextItem();
                }
            } else if (this.rangedChase) {
                this.chase(entity);
            }
        } else if (this.usesWitherSkull()) {
            if (this.canSee(entity)) {
                if (this.timeSinceAttack < (long)this.attackRateRanged) {
                    if (this.rangedChase) {
                        this.rechase();
                    }
                    return;
                }
                this.timeSinceAttack = 0L;
                this.fireSkull(entity.getEyeLocation());
                if (this.needsAmmo) {
                    this.takeOne();
                    this.grabNextItem();
                }
            } else if (this.rangedChase) {
                this.chase(entity);
            }
        } else if (this.usesFireball()) {
            if (this.canSee(entity)) {
                if (this.timeSinceAttack < (long)this.attackRateRanged) {
                    if (this.rangedChase) {
                        this.rechase();
                    }
                    return;
                }
                this.timeSinceAttack = 0L;
                this.fireFireball(entity.getEyeLocation());
                if (this.needsAmmo) {
                    this.takeOne();
                    this.grabNextItem();
                }
            } else if (this.rangedChase) {
                this.chase(entity);
            }
        } else if (this.usesLightning()) {
            if (this.canSee(entity)) {
                if (this.timeSinceAttack < (long)this.attackRateRanged) {
                    if (this.rangedChase) {
                        this.rechase();
                    }
                    return;
                }
                this.timeSinceAttack = 0L;
                this.swingWeapon();
                entity.getWorld().strikeLightningEffect(entity.getLocation());
                if (SentinelPlugin.debugMe) {
                    SentinelPlugin.instance.getLogger().info("Sentinel: Lightning hits for " + this.getDamage());
                }
                entity.damage(this.getDamage());
                if (this.needsAmmo) {
                    this.takeOne();
                    this.grabNextItem();
                }
            } else if (this.rangedChase) {
                this.chase(entity);
            }
        } else if (this.usesSpectral()) {
            if (this.canSee(entity)) {
                if (this.timeSinceAttack < (long)this.attackRateRanged) {
                    if (this.rangedChase) {
                        this.rechase();
                    }
                    return;
                }
                this.timeSinceAttack = 0L;
                if (!entity.isGlowing()) {
                    this.swingWeapon();
                    try {
                        Sound snd = SentinelPlugin.instance.spectralSound;
                        if (snd != null) {
                            entity.getWorld().playSound(entity.getLocation(), snd, 1.0f, 1.0f);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    entity.setGlowing(true);
                    if (this.needsAmmo) {
                        this.takeOne();
                        this.grabNextItem();
                    }
                }
            } else if (this.rangedChase) {
                this.chase(entity);
            }
        } else if (dist < this.reach * this.reach) {
            if (this.timeSinceAttack < (long)this.attackRate) {
                if (SentinelPlugin.debugMe) {
                    SentinelPlugin.instance.getLogger().info("Sentinel: tryAttack refused, timeSinceAttack");
                }
                if (this.closeChase) {
                    this.rechase();
                }
                return;
            }
            this.timeSinceAttack = 0L;
            if (SentinelPlugin.debugMe) {
                SentinelPlugin.instance.getLogger().info("Sentinel: tryAttack passed!");
            }
            this.punch(entity);
            if (this.needsAmmo && this.shouldTakeDura()) {
                this.reduceDurability();
                this.grabNextItem();
            }
        } else if (this.closeChase) {
            if (SentinelPlugin.debugMe) {
                SentinelPlugin.instance.getLogger().info("Sentinel: tryAttack refused, range");
            }
            this.chase(entity);
        }
    }

    public float getYaw(Vector vector) {
        double dx = vector.getX();
        double dz = vector.getZ();
        double yaw = 0.0;
        if (dx != 0.0) {
            yaw = dx < 0.0 ? 4.71238898038469 : 1.5707963267948966;
            yaw -= Math.atan(dz / dx);
        } else if (dz < 0.0) {
            yaw = Math.PI;
        }
        return (float)(-yaw * 180.0 / Math.PI);
    }

    public boolean canSee(LivingEntity entity) {
        if (!this.getLivingEntity().hasLineOfSight((Entity)entity)) {
            return false;
        }
        if (this.realistic) {
            float yaw;
            for (yaw = this.getLivingEntity().getEyeLocation().getYaw(); yaw < 0.0f; yaw += 360.0f) {
            }
            while (yaw >= 360.0f) {
                yaw -= 360.0f;
            }
            Vector rel = entity.getLocation().toVector().subtract(this.getLivingEntity().getLocation().toVector()).normalize();
            float yawHelp = this.getYaw(rel);
            if (!(Math.abs(yawHelp - yaw) < 90.0f || Math.abs(yawHelp + 360.0f - yaw) < 90.0f || Math.abs(yaw + 360.0f - yawHelp) < 90.0f)) {
                return false;
            }
        }
        return true;
    }

    public LivingEntity getLivingEntity() {
        return (LivingEntity)this.npc.getEntity();
    }

    public boolean isRanged() {
        return this.usesBow() || this.usesFireball() || this.usesSnowball() || this.usesLightning() || this.usesSpectral() || this.usesPotion();
    }

    public boolean usesBow() {
        if (!this.npc.hasTrait(Inventory.class)) {
            return false;
        }
        ItemStack it = ((Inventory)this.npc.getTrait(Inventory.class)).getContents()[0];
        return it != null && it.getType() == Material.BOW && this.getArrow() != null;
    }

    public boolean usesFireball() {
        if (!this.npc.hasTrait(Inventory.class)) {
            return false;
        }
        ItemStack it = ((Inventory)this.npc.getTrait(Inventory.class)).getContents()[0];
        return it != null && it.getType() == SentinelTarget.MATERIAL_BLAZE_ROD;
    }

    public boolean usesSnowball() {
        if (!this.npc.hasTrait(Inventory.class)) {
            return false;
        }
        ItemStack it = ((Inventory)this.npc.getTrait(Inventory.class)).getContents()[0];
        return it != null && it.getType() == SentinelTarget.MATERIAL_SNOW_BALL;
    }

    public boolean usesLightning() {
        if (!this.npc.hasTrait(Inventory.class)) {
            return false;
        }
        ItemStack it = ((Inventory)this.npc.getTrait(Inventory.class)).getContents()[0];
        return it != null && it.getType() == SentinelTarget.MATERIAL_NETHER_STAR;
    }

    public boolean usesEgg() {
        if (!this.npc.hasTrait(Inventory.class)) {
            return false;
        }
        ItemStack it = ((Inventory)this.npc.getTrait(Inventory.class)).getContents()[0];
        return it != null && it.getType() == Material.EGG;
    }

    public boolean usesPearl() {
        if (!this.npc.hasTrait(Inventory.class)) {
            return false;
        }
        ItemStack it = ((Inventory)this.npc.getTrait(Inventory.class)).getContents()[0];
        return it != null && it.getType() == Material.ENDER_PEARL;
    }

    public boolean usesWitherSkull() {
        if (!this.npc.hasTrait(Inventory.class)) {
            return false;
        }
        if (!SentinelPlugin.instance.canUseSkull) {
            return false;
        }
        ItemStack it = ((Inventory)this.npc.getTrait(Inventory.class)).getContents()[0];
        return it != null && SentinelTarget.SKULL_MATERIALS.contains(it.getType());
    }

    public boolean usesSpectral() {
        if (!this.npc.hasTrait(Inventory.class)) {
            return false;
        }
        if (!SentinelTarget.v1_10) {
            return false;
        }
        ItemStack it = ((Inventory)this.npc.getTrait(Inventory.class)).getContents()[0];
        return it != null && it.getType() == Material.SPECTRAL_ARROW;
    }

    public boolean usesPotion() {
        if (!this.npc.hasTrait(Inventory.class)) {
            return false;
        }
        ItemStack it = ((Inventory)this.npc.getTrait(Inventory.class)).getContents()[0];
        if (it == null) {
            return false;
        }
        if (!SentinelTarget.v1_9) {
            return it.getType() == Material.POTION;
        }
        return it.getType() == Material.SPLASH_POTION || it.getType() == Material.LINGERING_POTION;
    }

    public boolean shouldTakeDura() {
        Material type = SentinelTarget.v1_9 ? this.getLivingEntity().getEquipment().getItemInMainHand().getType() : this.getLivingEntity().getEquipment().getItemInHand().getType();
        return SentinelTarget.BOW_MATERIALS.contains(type) || SentinelTarget.SWORD_MATERIALS.contains(type) || SentinelTarget.PICKAXE_MATERIALS.contains(type) || SentinelTarget.AXE_MATERIALS.contains(type);
    }

    public boolean shouldTarget(LivingEntity entity) {
        if (entity.getUniqueId().equals(this.getLivingEntity().getUniqueId())) {
            return false;
        }
        return this.isTargeted(entity) && !this.isIgnored(entity);
    }

    public void addTarget(UUID id) {
        if (id.equals(this.getLivingEntity().getUniqueId())) {
            return;
        }
        if (!(this.getEntityForID(id) instanceof LivingEntity)) {
            return;
        }
        this.addTargetNoBounce(id);
        if (this.squad != null) {
            for (NPC npc : CitizensAPI.getNPCRegistry()) {
                if (!npc.hasTrait(SentinelTrait.class)) continue;
                SentinelTrait sentinel = (SentinelTrait)npc.getTrait(SentinelTrait.class);
                if (sentinel.squad == null || !sentinel.squad.equals(this.squad)) continue;
                sentinel.addTargetNoBounce(id);
            }
        }
    }

    public void addTargetNoBounce(UUID id) {
        SentinelCurrentTarget target = new SentinelCurrentTarget();
        target.targetID = id;
        target.ticksLeft = this.enemyTargetTime;
        this.currentTargets.remove(target);
        this.currentTargets.add(target);
    }

    public boolean isRegexTargeted(String name, List<String> regexes) {
        for (String str : regexes) {
            Pattern pattern = Pattern.compile(".*" + str + ".*", 2);
            if (!pattern.matcher(name).matches()) continue;
            return true;
        }
        return false;
    }

    public boolean isAir(ItemStack its) {
        return its == null || its.getType() == Material.AIR;
    }

    public boolean isInvisible(LivingEntity entity) {
        SentinelCurrentTarget sct = new SentinelCurrentTarget();
        sct.targetID = entity.getUniqueId();
        EntityEquipment eq = entity.getEquipment();
        return entity.hasPotionEffect(PotionEffectType.INVISIBILITY) && !this.currentTargets.contains(sct) && this.isAir(eq.getItemInHand()) && this.isAir(eq.getBoots()) && this.isAir(eq.getLeggings()) && this.isAir(eq.getChestplate()) && this.isAir(eq.getHelmet()) && SentinelPlugin.instance.ignoreInvisible;
    }

    public boolean isIgnored(LivingEntity entity) {
        if (this.isInvisible(entity)) {
            return true;
        }
        if (entity.getUniqueId().equals(this.getLivingEntity().getUniqueId())) {
            return true;
        }
        if (this.getGuarding() != null && entity.getUniqueId().equals(this.getGuarding())) {
            return true;
        }
        if (SentinelTarget.v1_9 ? entity.getEquipment() != null && entity.getEquipment().getItemInMainHand() != null && this.isRegexTargeted(entity.getEquipment().getItemInMainHand().getType().name(), this.heldItemIgnores) : entity.getEquipment() != null && entity.getEquipment().getItemInHand() != null && this.isRegexTargeted(entity.getEquipment().getItemInHand().getType().name(), this.heldItemIgnores)) {
            return true;
        }
        for (SentinelIntegration integration : SentinelPlugin.integrations) {
            for (String text : this.otherIgnores) {
                if (!integration.isTarget(entity, text)) continue;
                return true;
            }
        }
        if (entity.hasMetadata("NPC")) {
            return this.ignores.contains(SentinelTarget.NPCS.name()) || this.isRegexTargeted(CitizensAPI.getNPCRegistry().getNPC((Entity)entity).getName(), this.npcNameIgnores);
        }
        if (entity instanceof Player) {
            if (((Player)entity).getGameMode() == GameMode.CREATIVE || ((Player)entity).getGameMode() == GameMode.SPECTATOR) {
                return true;
            }
            if (this.isRegexTargeted(((Player)entity).getName(), this.playerNameIgnores)) {
                return true;
            }
            if (SentinelPlugin.instance.vaultPerms != null) {
                for (String group : this.groupIgnores) {
                    if (!SentinelPlugin.instance.vaultPerms.playerInGroup((Player)entity, group)) continue;
                    return true;
                }
            }
        } else if (this.isRegexTargeted(entity.getCustomName() == null ? entity.getType().name() : entity.getCustomName(), this.entityNameIgnores)) {
            return true;
        }
        if (this.ignores.contains(SentinelTarget.OWNER.name()) && entity.getUniqueId().equals(((Owner)this.npc.getTrait(Owner.class)).getOwnerId())) {
            return true;
        }
        HashSet<SentinelTarget> possible = SentinelPlugin.entityToTargets.get(entity.getType());
        for (SentinelTarget poss : possible) {
            if (!this.ignores.contains(poss.name())) continue;
            return true;
        }
        return false;
    }

    public boolean isTargeted(LivingEntity entity) {
        if (this.isInvisible(entity)) {
            return false;
        }
        SentinelCurrentTarget target = new SentinelCurrentTarget();
        target.targetID = entity.getUniqueId();
        if (entity.getUniqueId().equals(this.getLivingEntity().getUniqueId())) {
            return false;
        }
        if (this.getGuarding() != null && entity.getUniqueId().equals(this.getGuarding())) {
            return false;
        }
        if (this.currentTargets.contains(target)) {
            return true;
        }
        if (SentinelTarget.v1_9 ? entity.getEquipment() != null && entity.getEquipment().getItemInMainHand() != null && this.isRegexTargeted(entity.getEquipment().getItemInMainHand().getType().name(), this.heldItemTargets) : entity.getEquipment() != null && entity.getEquipment().getItemInHand() != null && this.isRegexTargeted(entity.getEquipment().getItemInHand().getType().name(), this.heldItemTargets)) {
            return true;
        }
        for (SentinelIntegration integration : SentinelPlugin.integrations) {
            for (String text : this.otherTargets) {
                if (!integration.isTarget(entity, text)) continue;
                return true;
            }
        }
        if (entity.hasMetadata("NPC")) {
            return this.targets.contains(SentinelTarget.NPCS.name()) || this.isRegexTargeted(CitizensAPI.getNPCRegistry().getNPC((Entity)entity).getName(), this.npcNameTargets);
        }
        if (entity instanceof Player) {
            if (this.isRegexTargeted(((Player)entity).getName(), this.playerNameTargets)) {
                return true;
            }
            if (SentinelPlugin.instance.vaultPerms != null) {
                for (String group : this.groupTargets) {
                    if (!SentinelPlugin.instance.vaultPerms.playerInGroup((Player)entity, group)) continue;
                    return true;
                }
            }
        } else if (this.isRegexTargeted(entity.getCustomName() == null ? entity.getType().name() : entity.getCustomName(), this.entityNameTargets)) {
            return true;
        }
        if (this.targets.contains(SentinelTarget.OWNER.name()) && entity.getUniqueId().equals(((Owner)this.npc.getTrait(Owner.class)).getOwnerId())) {
            return true;
        }
        HashSet<SentinelTarget> possible = SentinelPlugin.entityToTargets.get(entity.getType());
        for (SentinelTarget poss : possible) {
            if (!this.targets.contains(poss.name())) continue;
            return true;
        }
        return false;
    }

    public LivingEntity findBestTarget() {
        boolean ignoreGlow = this.usesSpectral();
        double rangesquared = this.range * this.range;
        double crsq = this.chaseRange * this.chaseRange;
        Location pos = this.getGuardZone();
        if (!this.getGuardZone().getWorld().equals(this.getLivingEntity().getWorld())) {
            this.npc.getNavigator().cancelNavigation();
            this.getLivingEntity().teleport(this.getGuardZone());
            return null;
        }
        if (!pos.getWorld().equals(this.getLivingEntity().getWorld())) {
            return null;
        }
        LivingEntity closest = null;
        boolean wasLos = false;
        for (LivingEntity ent : this.getLivingEntity().getWorld().getLivingEntities()) {
            if (ignoreGlow && ent.isGlowing() || ent.isDead()) continue;
            double dist = ent.getEyeLocation().distanceSquared(pos);
            SentinelCurrentTarget sct = new SentinelCurrentTarget();
            sct.targetID = ent.getUniqueId();
            if (!(dist < rangesquared && this.shouldTarget(ent) && this.canSee(ent)) && (!(dist < crsq) || !this.currentTargets.contains(sct))) continue;
            boolean hasLos = this.canSee(ent);
            if (wasLos && !hasLos) continue;
            rangesquared = dist;
            closest = ent;
            wasLos = hasLos;
        }
        return closest;
    }

    private Entity getEntityForID(UUID id) {
        if (!SentinelTarget.v1_12) {
            for (Entity e : this.getLivingEntity().getWorld().getEntities()) {
                if (!e.getUniqueId().equals(id)) continue;
                return e;
            }
            return null;
        }
        return Bukkit.getServer().getEntity(id);
    }

    private void updateTargets() {
        for (SentinelCurrentTarget uuid : new HashSet<SentinelCurrentTarget>(this.currentTargets)) {
            double d;
            Entity e = this.getEntityForID(uuid.targetID);
            if (e == null) {
                this.currentTargets.remove(uuid);
                continue;
            }
            if (e instanceof Player && (((Player)e).getGameMode() == GameMode.CREATIVE || ((Player)e).getGameMode() == GameMode.SPECTATOR)) {
                this.currentTargets.remove(uuid);
                continue;
            }
            if (e.isDead()) {
                this.currentTargets.remove(uuid);
                continue;
            }
            double d2 = d = e.getWorld().equals(this.getLivingEntity().getWorld()) ? e.getLocation().distanceSquared(this.getLivingEntity().getLocation()) : 1.0E8;
            if (d > this.range * this.range * 4.0 && d > this.chaseRange * this.chaseRange * 4.0) {
                this.currentTargets.remove(uuid);
                continue;
            }
            if (uuid.ticksLeft <= 0L) continue;
            uuid.ticksLeft -= (long)SentinelPlugin.instance.tickRate;
            if (uuid.ticksLeft > 0L) continue;
            this.currentTargets.remove(uuid);
        }
        if (this.chasing != null) {
            SentinelCurrentTarget cte = new SentinelCurrentTarget();
            cte.targetID = this.chasing.getUniqueId();
            if (!this.currentTargets.contains(cte)) {
                this.chasing = null;
                this.npc.getNavigator().cancelNavigation();
            }
        }
    }

    public void specialMarkVision() {
        if (SentinelPlugin.debugMe) {
            SentinelPlugin.instance.getLogger().info("Sentinel: Target! I see you, " + (this.chasing == null ? "(Unknown)" : this.chasing.getName()));
        }
        if (SentinelTarget.v1_11 && this.getLivingEntity().getType() == EntityType.SHULKER) {
            NMS.setPeekShulker((Entity)this.getLivingEntity(), (int)100);
        }
    }

    public void specialUnmarkVision() {
        if (SentinelPlugin.debugMe) {
            SentinelPlugin.instance.getLogger().info("Sentinel: Goodbye, visible target " + (this.chasing == null ? "(Unknown)" : this.chasing.getName()));
        }
        if (SentinelTarget.v1_11 && this.getLivingEntity().getType() == EntityType.SHULKER) {
            NMS.setPeekShulker((Entity)this.getLivingEntity(), (int)0);
        }
    }

    public static double randomDecimal(double min, double max) {
        return random.nextDouble() * (max - min) + min;
    }

    public static Location rayTrace(Location start, Location end) {
        double dSq = start.distanceSquared(end);
        if (dSq < 1.0) {
            if (end.getBlock().getType().isSolid()) {
                return start.clone();
            }
            return end.clone();
        }
        double dist = Math.sqrt(dSq);
        Vector move = end.toVector().subtract(start.toVector()).multiply(1.0 / dist);
        int iters = (int)Math.ceil(dist);
        Location cur = start.clone();
        Location next = cur.clone().add(move);
        for (int i = 0; i < iters; ++i) {
            if (next.getBlock().getType().isSolid()) {
                return cur;
            }
            cur = cur.add(move);
            next = next.add(move);
        }
        return cur;
    }

    public static Location pickNear(Location start, double range) {
        Location hit = SentinelTrait.rayTrace(start.clone().add(0.0, 1.5, 0.0), start.clone().add(SentinelTrait.randomDecimal(-range, range), 1.5, SentinelTrait.randomDecimal(range, range)));
        if (hit.subtract(0.0, 1.0, 0.0).getBlock().getType().isSolid()) {
            return hit;
        }
        return hit.subtract(0.0, 1.0, 0.0);
    }

    public void runUpdate() {
        Player player;
        Location near;
        Waypoints wp;
        this.canEnforce = true;
        this.timeSinceAttack += (long)SentinelPlugin.instance.tickRate;
        this.timeSinceHeal += (long)SentinelPlugin.instance.tickRate;
        if (this.getLivingEntity().getLocation().getY() <= 0.0) {
            if (SentinelPlugin.debugMe) {
                SentinelPlugin.instance.getLogger().info("Sentinel: Injuring self, I'm below the map!");
            }
            this.getLivingEntity().damage(1.0);
            if (!this.npc.isSpawned()) {
                if (this.getGuarding() != null && Bukkit.getPlayer((UUID)this.getGuarding()) != null && this.respawnTime > 0L && this.respawnMe == null) {
                    this.npc.spawn(Bukkit.getPlayer((UUID)this.getGuarding()).getLocation());
                }
                return;
            }
        }
        if (this.health != this.getLivingEntity().getMaxHealth()) {
            this.getLivingEntity().setMaxHealth(this.health);
        }
        if (this.healRate > 0 && this.timeSinceHeal > (long)this.healRate && this.getLivingEntity().getHealth() < this.health) {
            this.getLivingEntity().setHealth(Math.min(this.getLivingEntity().getHealth() + 1.0, this.health));
            this.timeSinceHeal = 0L;
        }
        if (this.getGuarding() != null && this.npc.hasTrait(Waypoints.class)) {
            wp = (Waypoints)this.npc.getTrait(Waypoints.class);
            wp.getCurrentProvider().setPaused(true);
        } else if (this.npc.hasTrait(Waypoints.class)) {
            wp = (Waypoints)this.npc.getTrait(Waypoints.class);
            wp.getCurrentProvider().setPaused(false);
        }
        double crsq = this.chaseRange * this.chaseRange;
        this.updateTargets();
        boolean goHome = this.chased;
        LivingEntity target = this.findBestTarget();
        if (target != null) {
            near = this.nearestPathPoint();
            if (SentinelPlugin.debugMe) {
                SentinelPlugin.instance.getLogger().info("Sentinel: target selected to be " + target.getName());
            }
            if (crsq <= 0.0 || near == null || near.distanceSquared(target.getLocation()) <= crsq) {
                if (SentinelPlugin.debugMe) {
                    SentinelPlugin.instance.getLogger().info("Sentinel: Attack target within range of safe zone: " + (near == null ? "Any" : Double.valueOf(near.distanceSquared(target.getLocation()))));
                }
                if (this.chasing == null) {
                    this.specialMarkVision();
                }
                this.chasing = target;
                this.cleverTicks = 0;
                this.tryAttack(target);
                goHome = false;
            } else {
                if (SentinelPlugin.debugMe) {
                    SentinelPlugin.instance.getLogger().info("Sentinel: Actually, that target is bad!");
                }
                this.specialUnmarkVision();
                target = null;
                this.chasing = null;
                this.cleverTicks = 0;
            }
        } else if (this.chasing != null && this.chasing.isValid()) {
            ++this.cleverTicks;
            if (this.cleverTicks >= SentinelPlugin.instance.cleverTicks) {
                this.specialUnmarkVision();
                this.chasing = null;
            } else {
                near = this.nearestPathPoint();
                if (crsq <= 0.0 || near == null || near.distanceSquared(this.chasing.getLocation()) <= crsq) {
                    this.tryAttack(this.chasing);
                    goHome = false;
                }
            }
        } else if (this.chasing == null) {
            this.specialUnmarkVision();
        }
        if (this.getGuarding() != null && (player = Bukkit.getPlayer((UUID)this.getGuarding())) != null) {
            double dist;
            Location myLoc = this.getLivingEntity().getLocation();
            Location theirLoc = player.getLocation();
            double d = dist = theirLoc.getWorld().equals(myLoc.getWorld()) ? myLoc.distanceSquared(theirLoc) : 1.0E8;
            if (dist > 3600.0) {
                this.npc.teleport(player.getLocation(), PlayerTeleportEvent.TeleportCause.PLUGIN);
            }
            if (dist > 49.0) {
                this.ticksCountGuard += SentinelPlugin.instance.tickRate;
                if (this.ticksCountGuard >= 30) {
                    this.ticksCountGuard = 0;
                    this.npc.getNavigator().getDefaultParameters().distanceMargin(2.0);
                    this.npc.getNavigator().getDefaultParameters().range(100.0f);
                    this.npc.getNavigator().getDefaultParameters().stuckAction((StuckAction)TeleportStuckAction.INSTANCE);
                    this.npc.getNavigator().setTarget(SentinelTrait.pickNear(player.getLocation(), 4.0));
                    this.npc.getNavigator().getLocalParameters().speedModifier((float)this.speed);
                    this.chased = true;
                }
            }
            goHome = false;
        }
        if (goHome && this.chaseRange > 0.0 && target == null) {
            near = this.nearestPathPoint();
            if (near != null && (this.chasing == null || near.distanceSquared(this.chasing.getLocation()) > crsq)) {
                if (SentinelPlugin.debugMe && near.distanceSquared(this.getLivingEntity().getLocation()) > 9.0) {
                    SentinelPlugin.instance.getLogger().info("Sentinel: screw you guys, I'm going home!");
                }
                this.npc.getNavigator().getDefaultParameters().stuckAction((StuckAction)TeleportStuckAction.INSTANCE);
                this.npc.getNavigator().setTarget(near);
                this.npc.getNavigator().getLocalParameters().speedModifier((float)this.speed);
                this.chased = false;
            } else {
                if (this.npc.getNavigator().getEntityTarget() != null) {
                    this.npc.getNavigator().cancelNavigation();
                }
                if (SentinelPlugin.debugMe && near != null && near.distanceSquared(this.getLivingEntity().getLocation()) > 9.0) {
                    SentinelPlugin.instance.getLogger().info("Sentinel: I'll just stand here and hope they come out...");
                }
            }
        } else if (this.chasing == null && this.npc.getNavigator().getEntityTarget() != null) {
            this.npc.getNavigator().cancelNavigation();
        }
    }

    public Location getGuardZone() {
        Location goal;
        Player player;
        if (this.getGuarding() != null && (player = Bukkit.getPlayer((UUID)this.getGuarding())) != null) {
            return player.getLocation();
        }
        if (this.chaseRange > 0.0 && (goal = this.nearestPathPoint()) != null) {
            return goal;
        }
        return this.getLivingEntity().getLocation();
    }

    public Location nearestPathPoint() {
        if (!SentinelTarget.v1_9) {
            return null;
        }
        if (!this.npc.hasTrait(Waypoints.class)) {
            return null;
        }
        if (this.getGuarding() != null) {
            return null;
        }
        Waypoints wp = (Waypoints)this.npc.getTrait(Waypoints.class);
        if (!(wp.getCurrentProvider() instanceof WaypointProvider.EnumerableWaypointProvider)) {
            return null;
        }
        Location baseloc = this.getLivingEntity().getLocation();
        Location nearest = null;
        double dist = 1.0E8;
        for (Waypoint wayp : ((WaypointProvider.EnumerableWaypointProvider)wp.getCurrentProvider()).waypoints()) {
            double d;
            Location l = wayp.getLocation();
            if (!l.getWorld().equals(baseloc.getWorld()) || !((d = baseloc.distanceSquared(l)) < dist)) continue;
            dist = d;
            nearest = l;
        }
        return nearest;
    }

    public void run() {
        if (!this.npc.isSpawned()) {
            return;
        }
        ++this.stats_ticksSpawned;
        ++this.cTick;
        if (this.cTick >= SentinelPlugin.instance.tickRate) {
            this.cTick = 0;
            this.runUpdate();
        }
    }

    public void onSpawn() {
        ++this.stats_timesSpawned;
        this.setHealth(this.health);
        this.setInvincible(this.invincible);
        if (this.respawnMe != null) {
            this.respawnMe.cancel();
            this.respawnMe = null;
        }
    }

    public void sayTo(Player player, String message) {
        SpeechContext sc = new SpeechContext(this.npc, message, (LivingEntity)player);
        this.npc.getDefaultSpeechController().speak(sc, "chat");
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerTeleports(final PlayerTeleportEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (this.getGuarding() == null) {
            return;
        }
        if (!event.getPlayer().getUniqueId().equals(this.getGuarding())) {
            return;
        }
        if (!this.npc.isSpawned()) {
            return;
        }
        if (event.getFrom().getWorld().equals(event.getTo().getWorld())) {
            this.npc.teleport(event.getTo(), PlayerTeleportEvent.TeleportCause.PLUGIN);
        } else {
            event.getFrom().getChunk().load();
            event.getTo().getChunk().load();
            Bukkit.getScheduler().runTaskLater((Plugin)SentinelPlugin.instance, new Runnable(){

                @Override
                public void run() {
                    if (!event.getPlayer().getWorld().equals(event.getTo().getWorld())) {
                        return;
                    }
                    event.getFrom().getChunk().load();
                    event.getTo().getChunk().load();
                    SentinelTrait.this.npc.spawn(event.getTo());
                }
            }, 1L);
        }
    }

    @EventHandler
    public void onPlayerMovesInRange(PlayerMoveEvent event) {
        if (!this.npc.isSpawned()) {
            return;
        }
        if (!event.getTo().getWorld().equals(this.getLivingEntity().getLocation().getWorld())) {
            return;
        }
        double dist = event.getTo().distanceSquared(this.getLivingEntity().getLocation());
        boolean known = this.greetedAlready.contains(event.getPlayer().getUniqueId());
        if (dist < this.greetRange && !known && this.canSee((LivingEntity)event.getPlayer())) {
            this.greetedAlready.add(event.getPlayer().getUniqueId());
            boolean enemy = this.shouldTarget((LivingEntity)event.getPlayer());
            if (enemy && this.warningText != null && this.warningText.length() > 0) {
                this.sayTo(event.getPlayer(), this.warningText);
            } else if (!enemy && this.greetingText != null && this.greetingText.length() > 0) {
                this.sayTo(event.getPlayer(), this.greetingText);
            }
        } else if (dist >= this.greetRange + 1.0 && known) {
            this.greetedAlready.remove(event.getPlayer().getUniqueId());
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void whenSomethingMightDie(EntityDamageByEntityEvent event) {
        this.needsDropsClear.remove(event.getEntity().getUniqueId());
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void whenWeDie(EntityDeathEvent event) {
        if (CitizensAPI.getNPCRegistry().isNPC((Entity)event.getEntity()) && CitizensAPI.getNPCRegistry().getNPC((Entity)event.getEntity()).getUniqueId().equals(this.npc.getUniqueId())) {
            event.getDrops().clear();
            if (event instanceof PlayerDeathEvent && !SentinelPlugin.instance.deathMessages) {
                ((PlayerDeathEvent)event).setDeathMessage("");
            }
            if (!SentinelPlugin.instance.workaroundDrops) {
                event.getDrops().addAll(this.drops);
            }
            event.setDroppedExp(0);
            this.generalDeathHandler(event.getEntity());
        }
    }

    public void generalDeathHandler(LivingEntity entity) {
        if (SentinelPlugin.instance.workaroundDrops) {
            for (ItemStack item : this.drops) {
                entity.getWorld().dropItemNaturally(entity.getLocation(), item.clone());
            }
        }
        this.onDeath();
    }

    @EventHandler(priority=EventPriority.LOW)
    public void whenSomethingDies(EntityDeathEvent event) {
        if (event.getEntity().getType() != EntityType.PLAYER && this.needsDropsClear.containsKey(event.getEntity().getUniqueId())) {
            event.getDrops().clear();
            event.setDroppedExp(0);
        }
    }

    public void onDeath() {
        this.greetedAlready.clear();
        this.currentTargets.clear();
        if (this.respawnTime < 0L) {
            BukkitRunnable removeMe = new BukkitRunnable(){

                public void run() {
                    SentinelTrait.this.npc.destroy();
                }
            };
            removeMe.runTaskLater((Plugin)SentinelPlugin.instance, 1L);
        } else if (this.respawnTime > 0L) {
            final long rsT = this.respawnTime;
            this.respawnMe = new BukkitRunnable(){
                long timer = 0L;

                public void run() {
                    if (CitizensAPI.getNPCRegistry().getById(SentinelTrait.this.npc.getId()) != null) {
                        if (SentinelTrait.this.npc.isSpawned()) {
                            this.cancel();
                            SentinelTrait.this.respawnMe = null;
                            return;
                        }
                        if (this.timer >= rsT) {
                            if (SentinelTrait.this.spawnPoint == null && SentinelTrait.this.npc.getStoredLocation() == null) {
                                SentinelPlugin.instance.getLogger().warning("NPC " + SentinelTrait.this.npc.getId() + " has a null spawn point and can't be spawned. Perhaps the world was deleted?");
                                this.cancel();
                                return;
                            }
                            SentinelTrait.this.npc.spawn(SentinelTrait.this.spawnPoint == null ? SentinelTrait.this.npc.getStoredLocation() : SentinelTrait.this.spawnPoint);
                            this.cancel();
                            SentinelTrait.this.respawnMe = null;
                            return;
                        }
                        this.timer += 10L;
                    } else {
                        SentinelTrait.this.respawnMe = null;
                        this.cancel();
                        return;
                    }
                }
            };
            this.respawnMe.runTaskTimer((Plugin)SentinelPlugin.instance, 10L, 10L);
        }
    }

    public void onDespawn() {
        this.currentTargets.clear();
    }

    public void setHealth(double heal) {
        this.health = heal;
        if (this.npc.isSpawned()) {
            this.getLivingEntity().setMaxHealth(this.health);
            this.getLivingEntity().setHealth(this.health);
        }
    }

    public void setInvincible(boolean inv) {
        this.invincible = inv;
        this.npc.setProtected(this.invincible);
    }
}

