/*
 * Decompiled with CFR 0.152.
 */
package org.mcmonkey.sentinel.external;

import java.util.UUID;
import net.aufdemrand.sentry.SentryInstance;
import net.aufdemrand.sentry.SentryTrait;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.npc.NPC;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.event.Listener;
import org.mcmonkey.sentinel.SentinelPlugin;
import org.mcmonkey.sentinel.SentinelTarget;
import org.mcmonkey.sentinel.SentinelTrait;

public class SentryImport
implements Listener {
    public static int PerformImport() {
        int convertedCount = 0;
        for (NPC npc : CitizensAPI.getNPCRegistry()) {
            SentinelTarget target;
            String[] sections;
            UUID playerId;
            OfflinePlayer op;
            SentryInstance sentry;
            if (!npc.hasTrait(SentryTrait.class) || (sentry = ((SentryTrait)npc.getTrait(SentryTrait.class)).getInstance()) == null) continue;
            ++convertedCount;
            if (!npc.hasTrait(SentinelTrait.class)) {
                npc.addTrait(SentinelTrait.class);
            }
            SentinelTrait sentinel = (SentinelTrait)npc.getTrait(SentinelTrait.class);
            sentinel.armor = Math.min((double)sentry.Armor.intValue() * 0.1, 1.0);
            sentinel.attackRate = (int)(sentry.AttackRateSeconds * 20.0);
            if (sentinel.attackRate < SentinelPlugin.instance.tickRate) {
                sentinel.attackRate = SentinelPlugin.instance.tickRate;
            } else if (sentinel.attackRate > 2000) {
                sentinel.attackRate = 2000;
            }
            sentinel.chaseRange = sentry.sentryRange.intValue();
            sentinel.closeChase = true;
            sentinel.rangedChase = false;
            sentinel.damage = sentry.Strength.intValue();
            sentinel.enemyDrops = sentry.KillsDropInventory;
            sentinel.fightback = sentry.Retaliate;
            double hpHealedPerPeriod = 1.0;
            if (sentry.HealRate < 0.5) {
                hpHealedPerPeriod = 0.5 / sentry.HealRate;
            }
            double secondsPerHpPoint = sentry.HealRate / hpHealedPerPeriod;
            sentinel.healRate = (int)(20.0 * secondsPerHpPoint);
            if (sentinel.healRate < SentinelPlugin.instance.tickRate) {
                sentinel.healRate = SentinelPlugin.instance.tickRate;
            } else if (sentinel.healRate > 2000) {
                sentinel.healRate = 2000;
            }
            double health = sentry.sentryHealth;
            if (health < 0.01) {
                health = 0.01;
            } else if (health > SentinelPlugin.instance.maxHealth) {
                health = SentinelPlugin.instance.maxHealth;
            }
            sentinel.setHealth(health);
            sentinel.setInvincible(sentry.Invincible);
            sentinel.needsAmmo = false;
            sentinel.range = sentry.sentryRange.intValue();
            sentinel.respawnTime = sentry.RespawnDelaySeconds * 20;
            sentinel.safeShot = false;
            sentinel.spawnPoint = sentry.Spawn;
            if (sentry.guardTarget != null && sentry.guardTarget.length() > 0 && (op = Bukkit.getOfflinePlayer((String)sentry.guardTarget)) != null && (playerId = op.getUniqueId()) != null) {
                sentinel.setGuarding(playerId);
            }
            sentinel.targets.clear();
            sentinel.eventTargets.clear();
            sentinel.playerNameTargets.clear();
            sentinel.npcNameTargets.clear();
            sentinel.groupTargets.clear();
            sentinel.ignores.clear();
            sentinel.playerNameIgnores.clear();
            sentinel.npcNameIgnores.clear();
            sentinel.groupIgnores.clear();
            for (String t : sentry.validTargets) {
                if (t.contains("ENTITY:ALL")) {
                    sentinel.targets.add(SentinelTarget.forName("MOBS").name());
                    sentinel.targets.add(SentinelTarget.PLAYERS.name());
                    sentinel.targets.add(SentinelTarget.NPCS.name());
                    continue;
                }
                if (t.contains("ENTITY:MONSTER")) {
                    sentinel.targets.add(SentinelTarget.forName("MONSTERS").name());
                    continue;
                }
                if (t.contains("ENTITY:PLAYER")) {
                    sentinel.targets.add(SentinelTarget.PLAYERS.name());
                    continue;
                }
                if (t.contains("ENTITY:NPC")) {
                    sentinel.targets.add(SentinelTarget.NPCS.name());
                    continue;
                }
                if (t.contains("EVENT:PVP")) {
                    sentinel.eventTargets.add("pvp");
                    continue;
                }
                if (t.contains("EVENT:PVE")) {
                    sentinel.eventTargets.add("pve");
                    continue;
                }
                if (t.contains("EVENT:PVNPC")) {
                    sentinel.eventTargets.add("pvnpc");
                    continue;
                }
                sections = t.split(":");
                if (sections.length != 2) continue;
                sections[0] = sections[0].trim();
                sections[1] = sections[1].trim();
                if (sections[0].equals("NPC")) {
                    sentinel.npcNameTargets.add(sections[1]);
                    continue;
                }
                if (sections[0].equals("GROUP")) {
                    sentinel.groupTargets.add(sections[1]);
                    continue;
                }
                if (sections[0].equals("PLAYER")) {
                    sentinel.playerNameTargets.add(sections[1]);
                    continue;
                }
                if (!sections[0].equals("ENTITY") || (target = SentinelTarget.forName(sections[1])) == null) continue;
                sentinel.targets.add(target.name());
            }
            for (String t : sentry.ignoreTargets) {
                if (t.contains("ENTITY:ALL")) {
                    sentinel.ignores.add(SentinelTarget.forName("MOBS").name());
                    sentinel.ignores.add(SentinelTarget.PLAYERS.name());
                    sentinel.ignores.add(SentinelTarget.NPCS.name());
                    continue;
                }
                if (t.contains("ENTITY:MONSTER")) {
                    sentinel.ignores.add(SentinelTarget.forName("MONSTERS").name());
                    continue;
                }
                if (t.contains("ENTITY:PLAYER")) {
                    sentinel.ignores.add(SentinelTarget.PLAYERS.name());
                    continue;
                }
                if (t.contains("ENTITY:NPC")) {
                    sentinel.ignores.add(SentinelTarget.NPCS.name());
                    continue;
                }
                if (t.contains("ENTITY:OWNER")) {
                    sentinel.ignores.add(SentinelTarget.OWNER.name());
                    continue;
                }
                sections = t.split(":");
                if (sections.length != 2) continue;
                sections[0] = sections[0].trim();
                sections[1] = sections[1].trim();
                if (sections[0].equals("NPC")) {
                    sentinel.npcNameIgnores.add(sections[1]);
                    continue;
                }
                if (sections[0].equals("GROUP")) {
                    sentinel.groupIgnores.add(sections[1]);
                    continue;
                }
                if (sections[0].equals("PLAYER")) {
                    sentinel.playerNameIgnores.add(sections[1]);
                    continue;
                }
                if (!sections[0].equals("ENTITY") || (target = SentinelTarget.forName(sections[1])) == null) continue;
                sentinel.ignores.add(target.name());
            }
            npc.removeTrait(SentryTrait.class);
        }
        return convertedCount;
    }
}

