/*
 * Decompiled with CFR 0.152.
 */
package org.mcmonkey.sentinel;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.EntityType;
import org.mcmonkey.sentinel.SentinelPlugin;

public class SentinelTarget {
    public static SentinelTarget NPCS;
    public static SentinelTarget OWNER;
    public static SentinelTarget PLAYERS;
    public static SentinelTarget PIGS;
    public static SentinelTarget OCELOTS;
    public static SentinelTarget COWS;
    public static SentinelTarget RABBITS;
    public static SentinelTarget SHEEP;
    public static SentinelTarget CHICKENS;
    public static SentinelTarget HORSES;
    public static SentinelTarget MUSHROOM_COW;
    public static SentinelTarget IRON_GOLEMS;
    public static SentinelTarget SQUIDS;
    public static SentinelTarget VILLAGER;
    public static SentinelTarget WOLF;
    public static SentinelTarget SNOWMEN;
    public static SentinelTarget WITCH;
    public static SentinelTarget GUARDIANS;
    public static SentinelTarget CREERERS;
    public static SentinelTarget SKELETONS;
    public static SentinelTarget ZOMBIES;
    public static SentinelTarget MAGMA_CUBES;
    public static SentinelTarget ZOMBIE_PIGMEN;
    public static SentinelTarget SILVERFISH;
    public static SentinelTarget BATS;
    public static SentinelTarget BLAZES;
    public static SentinelTarget GHASTS;
    public static SentinelTarget GIANTS;
    public static SentinelTarget SLIME;
    public static SentinelTarget SPIDER;
    public static SentinelTarget CAVE_SPIDERS;
    public static SentinelTarget ENDERMEN;
    public static SentinelTarget ENDERMITES;
    public static SentinelTarget WITHER;
    public static SentinelTarget ENDERDRAGON;
    public static final HashSet<Material> SWORD_MATERIALS;
    public static final HashSet<Material> PICKAXE_MATERIALS;
    public static final HashSet<Material> AXE_MATERIALS;
    public static final HashSet<Material> HELMET_MATERIALS;
    public static final HashSet<Material> CHESTPLATE_MATERIALS;
    public static final HashSet<Material> LEGGINGS_MATERIALS;
    public static final HashSet<Material> BOOTS_MATERIALS;
    public static final HashSet<Material> BOW_MATERIALS;
    public static final HashSet<Material> POTION_MATERIALS;
    public static final HashSet<Material> SKULL_MATERIALS;
    public static final Map<Material, Double> WEAPON_DAMAGE_MULTIPLIERS;
    public static final Map<Material, Double> ARMOR_PROTECTION_MULTIPLIERS;
    public static final Material MATERIAL_SNOW_BALL;
    public static final Material MATERIAL_NETHER_STAR;
    public static final Material MATERIAL_BLAZE_ROD;
    public static final boolean v1_8;
    public static final boolean v1_9;
    public static final boolean v1_10;
    public static final boolean v1_11;
    public static final boolean v1_12;
    public static final boolean v1_13;
    public String[] names;

    public static boolean isWeapon(Material mat) {
        return WEAPON_DAMAGE_MULTIPLIERS.containsKey(mat) || POTION_MATERIALS.contains(mat) || BOW_MATERIALS.contains(mat) || SKULL_MATERIALS.contains(mat) || mat == MATERIAL_SNOW_BALL || mat == MATERIAL_BLAZE_ROD || mat == MATERIAL_NETHER_STAR;
    }

    public static Material getMaterial(String name) {
        try {
            return Material.valueOf((String)name);
        }
        catch (IllegalArgumentException ex) {
            SentinelPlugin.instance.getLogger().warning("Sentinel loader failed to handle material name '" + name + "', that material will not function (REPORT THIS ERROR!)");
            return Material.valueOf((String)"STICK");
        }
    }

    public static void addAllMaterials(Set<Material> set, String ... matNames) {
        for (String mat : matNames) {
            set.add(SentinelTarget.getMaterial(mat));
        }
    }

    public static void allMaterialsTo(Map<Material, Double> map, Set<Material> set, Double val) {
        for (Material mat : set) {
            map.put(mat, val);
        }
    }

    public static HashSet<SentinelTarget> forEntityType(EntityType type) {
        return SentinelPlugin.entityToTargets.get(type);
    }

    public static SentinelTarget forName(String name) {
        return SentinelPlugin.targetOptions.get(name.toUpperCase());
    }

    public String name() {
        return this.names[0];
    }

    SentinelTarget(EntityType[] types, String ... names) {
        this.names = names;
        for (String string : names) {
            SentinelPlugin.targetOptions.put(string, this);
            SentinelPlugin.targetOptions.put(string + "S", this);
        }
        for (String string : types) {
            SentinelPlugin.entityToTargets.get(string).add(this);
        }
    }

    static {
        SentinelTarget LLAMAS;
        SentinelTarget sentinelTarget;
        SentinelTarget MOBS;
        SentinelTarget PASSIVE_MOB;
        NPCS = new SentinelTarget(new EntityType[0], "NPC");
        OWNER = new SentinelTarget(new EntityType[0], "OWNER");
        PLAYERS = new SentinelTarget(new EntityType[]{EntityType.PLAYER}, "PLAYER");
        PIGS = new SentinelTarget(new EntityType[]{EntityType.PIG}, "PIG");
        OCELOTS = new SentinelTarget(new EntityType[]{EntityType.OCELOT}, "OCELOT", "CAT");
        COWS = new SentinelTarget(new EntityType[]{EntityType.COW}, "COW");
        RABBITS = new SentinelTarget(new EntityType[]{EntityType.RABBIT}, "RABBIT", "BUNNY", "BUNNIE");
        SHEEP = new SentinelTarget(new EntityType[]{EntityType.SHEEP}, "SHEEP");
        CHICKENS = new SentinelTarget(new EntityType[]{EntityType.CHICKEN}, "CHICKEN", "DUCK");
        HORSES = new SentinelTarget(new EntityType[]{EntityType.HORSE}, "HORSE");
        MUSHROOM_COW = new SentinelTarget(new EntityType[]{EntityType.MUSHROOM_COW}, "MUSHROOM_COW", "MUSHROOMCOW", "MOOSHROOM");
        IRON_GOLEMS = new SentinelTarget(new EntityType[]{EntityType.IRON_GOLEM}, "IRON_GOLEM", "IRONGOLEM");
        SQUIDS = new SentinelTarget(new EntityType[]{EntityType.SQUID}, "SQUID");
        VILLAGER = new SentinelTarget(new EntityType[]{EntityType.VILLAGER}, "VILLAGER");
        WOLF = new SentinelTarget(new EntityType[]{EntityType.WOLF}, "WOLF");
        SNOWMEN = new SentinelTarget(new EntityType[]{EntityType.SNOWMAN}, "SNOWMAN", "SNOWMEN");
        WITCH = new SentinelTarget(new EntityType[]{EntityType.WITCH}, "WITCH");
        GUARDIANS = new SentinelTarget(new EntityType[]{EntityType.GUARDIAN}, "GUARDIAN");
        CREERERS = new SentinelTarget(new EntityType[]{EntityType.CREEPER}, "CREEPER");
        SKELETONS = new SentinelTarget(new EntityType[]{EntityType.SKELETON}, "SKELETON");
        ZOMBIES = new SentinelTarget(new EntityType[]{EntityType.ZOMBIE}, "ZOMBIE");
        MAGMA_CUBES = new SentinelTarget(new EntityType[]{EntityType.MAGMA_CUBE}, "MAGMA_CUBE", "MAGMACUBE");
        ZOMBIE_PIGMEN = new SentinelTarget(new EntityType[]{EntityType.PIG_ZOMBIE}, "PIG_ZOMBIE", "PIGZOMBIE", "ZOMBIEPIGMAN", "ZOMBIEPIGMEN", "ZOMBIE_PIGMAN", "ZOMBIE_PIGMEN", "ZOMBIE_PIGMAN");
        SILVERFISH = new SentinelTarget(new EntityType[]{EntityType.SILVERFISH}, "SILVERFISH", "SILVER_FISH", "SILVERFISHE", "SILVER_FISHE");
        BATS = new SentinelTarget(new EntityType[]{EntityType.BAT}, "BAT");
        BLAZES = new SentinelTarget(new EntityType[]{EntityType.BLAZE}, "BLAZE");
        GHASTS = new SentinelTarget(new EntityType[]{EntityType.GHAST}, "GHAST");
        GIANTS = new SentinelTarget(new EntityType[]{EntityType.GIANT}, "GIANT");
        SLIME = new SentinelTarget(new EntityType[]{EntityType.SLIME}, "SLIME");
        SPIDER = new SentinelTarget(new EntityType[]{EntityType.SPIDER}, "SPIDER");
        CAVE_SPIDERS = new SentinelTarget(new EntityType[]{EntityType.CAVE_SPIDER}, "CAVE_SPIDER", "CAVESPIDER");
        ENDERMEN = new SentinelTarget(new EntityType[]{EntityType.ENDERMAN}, "ENDERMAN", "ENDER_MAN", "ENDERMEN", "ENDER_MEN");
        ENDERMITES = new SentinelTarget(new EntityType[]{EntityType.ENDERMITE}, "ENDERMITE", "ENDER_MITE");
        WITHER = new SentinelTarget(new EntityType[]{EntityType.WITHER}, "WITHER");
        ENDERDRAGON = new SentinelTarget(new EntityType[]{EntityType.ENDER_DRAGON}, "ENDERDRAGON", "ENDER_DRAGON");
        SWORD_MATERIALS = new HashSet();
        PICKAXE_MATERIALS = new HashSet();
        AXE_MATERIALS = new HashSet();
        HELMET_MATERIALS = new HashSet();
        CHESTPLATE_MATERIALS = new HashSet();
        LEGGINGS_MATERIALS = new HashSet();
        BOOTS_MATERIALS = new HashSet();
        BOW_MATERIALS = new HashSet();
        POTION_MATERIALS = new HashSet();
        SKULL_MATERIALS = new HashSet();
        WEAPON_DAMAGE_MULTIPLIERS = new HashMap<Material, Double>();
        ARMOR_PROTECTION_MULTIPLIERS = new HashMap<Material, Double>();
        String vers = Bukkit.getBukkitVersion();
        v1_13 = vers.startsWith("1.13");
        v1_12 = vers.startsWith("1.12") || v1_13;
        v1_11 = vers.startsWith("1.11") || v1_12;
        v1_10 = vers.startsWith("1.10") || v1_11;
        v1_9 = vers.startsWith("1.9") || v1_10;
        boolean bl = v1_8 = vers.startsWith("1.8") || v1_9;
        if (v1_8 && !v1_9) {
            PASSIVE_MOB = new SentinelTarget(new EntityType[]{EntityType.PIG, EntityType.OCELOT, EntityType.COW, EntityType.RABBIT, EntityType.SHEEP, EntityType.CHICKEN, EntityType.MUSHROOM_COW, EntityType.HORSE, EntityType.IRON_GOLEM, EntityType.SQUID, EntityType.VILLAGER, EntityType.WOLF, EntityType.SNOWMAN}, "PASSIVE_MOB", "PASSIVEMOB", "GOODMOB", "GOOD_MOB", "FRIENDLYMOB", "FRIENDLY_MOB");
            MOBS = new SentinelTarget(new EntityType[]{EntityType.GUARDIAN, EntityType.CREEPER, EntityType.SKELETON, EntityType.ZOMBIE, EntityType.MAGMA_CUBE, EntityType.PIG_ZOMBIE, EntityType.SILVERFISH, EntityType.BAT, EntityType.BLAZE, EntityType.GHAST, EntityType.GIANT, EntityType.SLIME, EntityType.SPIDER, EntityType.CAVE_SPIDER, EntityType.ENDERMAN, EntityType.ENDERMITE, EntityType.WITHER, EntityType.ENDER_DRAGON, EntityType.WITCH, EntityType.PIG, EntityType.OCELOT, EntityType.COW, EntityType.RABBIT, EntityType.SHEEP, EntityType.CHICKEN, EntityType.MUSHROOM_COW, EntityType.HORSE, EntityType.IRON_GOLEM, EntityType.SQUID, EntityType.VILLAGER, EntityType.WOLF, EntityType.SNOWMAN}, "MOB");
            sentinelTarget = new SentinelTarget(new EntityType[]{EntityType.GUARDIAN, EntityType.CREEPER, EntityType.SKELETON, EntityType.ZOMBIE, EntityType.MAGMA_CUBE, EntityType.PIG_ZOMBIE, EntityType.SILVERFISH, EntityType.BAT, EntityType.BLAZE, EntityType.GHAST, EntityType.GIANT, EntityType.SLIME, EntityType.SPIDER, EntityType.CAVE_SPIDER, EntityType.ENDERMAN, EntityType.ENDERMITE, EntityType.WITHER, EntityType.ENDER_DRAGON, EntityType.WITCH}, "MONSTER");
        }
        if (v1_9) {
            PASSIVE_MOB = new SentinelTarget(new EntityType[]{EntityType.SHULKER}, "SHULKER");
        }
        if (v1_9 && !v1_10) {
            PASSIVE_MOB = new SentinelTarget(new EntityType[]{EntityType.PIG, EntityType.OCELOT, EntityType.COW, EntityType.RABBIT, EntityType.SHEEP, EntityType.CHICKEN, EntityType.MUSHROOM_COW, EntityType.HORSE, EntityType.IRON_GOLEM, EntityType.SQUID, EntityType.VILLAGER, EntityType.WOLF, EntityType.SNOWMAN}, "PASSIVE_MOB", "PASSIVEMOB", "GOODMOB", "GOOD_MOB", "FRIENDLYMOB", "FRIENDLY_MOB");
            MOBS = new SentinelTarget(new EntityType[]{EntityType.GUARDIAN, EntityType.SHULKER, EntityType.CREEPER, EntityType.SKELETON, EntityType.ZOMBIE, EntityType.MAGMA_CUBE, EntityType.PIG_ZOMBIE, EntityType.SILVERFISH, EntityType.BAT, EntityType.BLAZE, EntityType.GHAST, EntityType.GIANT, EntityType.SLIME, EntityType.SPIDER, EntityType.CAVE_SPIDER, EntityType.ENDERMAN, EntityType.ENDERMITE, EntityType.WITHER, EntityType.ENDER_DRAGON, EntityType.WITCH, EntityType.PIG, EntityType.OCELOT, EntityType.COW, EntityType.RABBIT, EntityType.SHEEP, EntityType.CHICKEN, EntityType.MUSHROOM_COW, EntityType.HORSE, EntityType.IRON_GOLEM, EntityType.SQUID, EntityType.VILLAGER, EntityType.WOLF, EntityType.SNOWMAN}, "MOB");
            sentinelTarget = new SentinelTarget(new EntityType[]{EntityType.GUARDIAN, EntityType.SHULKER, EntityType.CREEPER, EntityType.SKELETON, EntityType.ZOMBIE, EntityType.MAGMA_CUBE, EntityType.PIG_ZOMBIE, EntityType.SILVERFISH, EntityType.BAT, EntityType.BLAZE, EntityType.GHAST, EntityType.GIANT, EntityType.SLIME, EntityType.SPIDER, EntityType.CAVE_SPIDER, EntityType.ENDERMAN, EntityType.ENDERMITE, EntityType.WITHER, EntityType.ENDER_DRAGON, EntityType.WITCH}, "MONSTER");
        }
        if (v1_10) {
            PASSIVE_MOB = new SentinelTarget(new EntityType[]{EntityType.POLAR_BEAR}, "POLARBEAR", "POLAR_BEAR");
        }
        if (v1_10 && !v1_11) {
            PASSIVE_MOB = new SentinelTarget(new EntityType[]{EntityType.PIG, EntityType.OCELOT, EntityType.COW, EntityType.RABBIT, EntityType.SHEEP, EntityType.CHICKEN, EntityType.MUSHROOM_COW, EntityType.HORSE, EntityType.IRON_GOLEM, EntityType.SQUID, EntityType.VILLAGER, EntityType.WOLF, EntityType.SNOWMAN, EntityType.POLAR_BEAR}, "PASSIVE_MOB", "PASSIVEMOB", "GOODMOB", "GOOD_MOB", "FRIENDLYMOB", "FRIENDLY_MOB");
            MOBS = new SentinelTarget(new EntityType[]{EntityType.GUARDIAN, EntityType.SHULKER, EntityType.CREEPER, EntityType.SKELETON, EntityType.ZOMBIE, EntityType.MAGMA_CUBE, EntityType.PIG_ZOMBIE, EntityType.SILVERFISH, EntityType.BAT, EntityType.BLAZE, EntityType.GHAST, EntityType.GIANT, EntityType.SLIME, EntityType.SPIDER, EntityType.CAVE_SPIDER, EntityType.ENDERMAN, EntityType.ENDERMITE, EntityType.WITHER, EntityType.ENDER_DRAGON, EntityType.WITCH, EntityType.PIG, EntityType.OCELOT, EntityType.COW, EntityType.RABBIT, EntityType.SHEEP, EntityType.CHICKEN, EntityType.MUSHROOM_COW, EntityType.HORSE, EntityType.IRON_GOLEM, EntityType.SQUID, EntityType.VILLAGER, EntityType.WOLF, EntityType.SNOWMAN, EntityType.POLAR_BEAR}, "MOB");
            sentinelTarget = new SentinelTarget(new EntityType[]{EntityType.GUARDIAN, EntityType.SHULKER, EntityType.CREEPER, EntityType.SKELETON, EntityType.ZOMBIE, EntityType.MAGMA_CUBE, EntityType.PIG_ZOMBIE, EntityType.SILVERFISH, EntityType.BAT, EntityType.BLAZE, EntityType.GHAST, EntityType.GIANT, EntityType.SLIME, EntityType.SPIDER, EntityType.CAVE_SPIDER, EntityType.ENDERMAN, EntityType.ENDERMITE, EntityType.WITHER, EntityType.ENDER_DRAGON, EntityType.WITCH}, "MONSTER");
        }
        if (v1_11) {
            SentinelTarget VEXES = new SentinelTarget(new EntityType[]{EntityType.VEX}, "VEX", "VEXE");
            SentinelTarget DONKEYS = new SentinelTarget(new EntityType[]{EntityType.DONKEY}, "DONKEY");
            LLAMAS = new SentinelTarget(new EntityType[]{EntityType.LLAMA}, "LLAMA");
            SentinelTarget MULES = new SentinelTarget(new EntityType[]{EntityType.MULE}, "MULE");
            SentinelTarget HUSKS = new SentinelTarget(new EntityType[]{EntityType.HUSK}, "HUSK");
            SentinelTarget ELDER_GUARDIANS = new SentinelTarget(new EntityType[]{EntityType.ELDER_GUARDIAN}, "ELDER_GUARDIAN", "ELDERGUARDIAN");
            SentinelTarget EVOKERS = new SentinelTarget(new EntityType[]{EntityType.EVOKER}, "EVOKER");
            SentinelTarget SKELETON_HORSES = new SentinelTarget(new EntityType[]{EntityType.SKELETON_HORSE}, "SKELETON_HORSE", "SKELETONHORSE");
            SentinelTarget STRAYS = new SentinelTarget(new EntityType[]{EntityType.STRAY}, "STRAY");
            SentinelTarget ZOMBIE_VILLAGERS = new SentinelTarget(new EntityType[]{EntityType.ZOMBIE_VILLAGER}, "ZOMBIE_VILLAGER", "ZOMBIEVILLAGER");
            SentinelTarget ZOMBIE_HORSES = new SentinelTarget(new EntityType[]{EntityType.ZOMBIE_HORSE}, "ZOMBIE_HORSE", "ZOMBIEHORSE");
            SentinelTarget WITHER_SKELETONS = new SentinelTarget(new EntityType[]{EntityType.WITHER_SKELETON}, "WITHER_SKELETON", "WITHERSKELETON");
            SentinelTarget sentinelTarget2 = new SentinelTarget(new EntityType[]{EntityType.VINDICATOR}, "VINDICATOR");
        }
        if (v1_11 && !v1_12) {
            PASSIVE_MOB = new SentinelTarget(new EntityType[]{EntityType.PIG, EntityType.OCELOT, EntityType.COW, EntityType.RABBIT, EntityType.SHEEP, EntityType.CHICKEN, EntityType.MUSHROOM_COW, EntityType.HORSE, EntityType.IRON_GOLEM, EntityType.SQUID, EntityType.VILLAGER, EntityType.WOLF, EntityType.SNOWMAN, EntityType.POLAR_BEAR, EntityType.DONKEY, EntityType.LLAMA, EntityType.MULE, EntityType.ZOMBIE_HORSE, EntityType.SKELETON_HORSE}, "PASSIVE_MOB", "PASSIVEMOB", "GOODMOB", "GOOD_MOB", "FRIENDLYMOB", "FRIENDLY_MOB");
            MOBS = new SentinelTarget(new EntityType[]{EntityType.GUARDIAN, EntityType.SHULKER, EntityType.CREEPER, EntityType.SKELETON, EntityType.ZOMBIE, EntityType.MAGMA_CUBE, EntityType.PIG_ZOMBIE, EntityType.SILVERFISH, EntityType.BAT, EntityType.BLAZE, EntityType.GHAST, EntityType.GIANT, EntityType.SLIME, EntityType.SPIDER, EntityType.CAVE_SPIDER, EntityType.ENDERMAN, EntityType.ENDERMITE, EntityType.WITHER, EntityType.ENDER_DRAGON, EntityType.WITCH, EntityType.PIG, EntityType.OCELOT, EntityType.COW, EntityType.RABBIT, EntityType.SHEEP, EntityType.CHICKEN, EntityType.MUSHROOM_COW, EntityType.HORSE, EntityType.IRON_GOLEM, EntityType.SQUID, EntityType.VILLAGER, EntityType.WOLF, EntityType.SNOWMAN, EntityType.POLAR_BEAR, EntityType.DONKEY, EntityType.LLAMA, EntityType.MULE, EntityType.ZOMBIE_HORSE, EntityType.SKELETON_HORSE, EntityType.VEX, EntityType.HUSK, EntityType.ELDER_GUARDIAN, EntityType.EVOKER, EntityType.STRAY, EntityType.ZOMBIE_VILLAGER, EntityType.WITHER_SKELETON, EntityType.VINDICATOR}, "MOB");
            LLAMAS = new SentinelTarget(new EntityType[]{EntityType.GUARDIAN, EntityType.SHULKER, EntityType.CREEPER, EntityType.SKELETON, EntityType.ZOMBIE, EntityType.MAGMA_CUBE, EntityType.PIG_ZOMBIE, EntityType.SILVERFISH, EntityType.BAT, EntityType.BLAZE, EntityType.GHAST, EntityType.GIANT, EntityType.SLIME, EntityType.SPIDER, EntityType.CAVE_SPIDER, EntityType.ENDERMAN, EntityType.ENDERMITE, EntityType.WITHER, EntityType.ENDER_DRAGON, EntityType.WITCH, EntityType.VEX, EntityType.HUSK, EntityType.ELDER_GUARDIAN, EntityType.EVOKER, EntityType.STRAY, EntityType.ZOMBIE_VILLAGER, EntityType.WITHER_SKELETON, EntityType.VINDICATOR}, "MONSTER");
        }
        if (v1_12) {
            SentinelTarget PARROTS = new SentinelTarget(new EntityType[]{EntityType.PARROT}, "PARROT");
            MOBS = new SentinelTarget(new EntityType[]{EntityType.ILLUSIONER}, "ILLUSIONER");
        }
        if (v1_12 && !v1_13) {
            PASSIVE_MOB = new SentinelTarget(new EntityType[]{EntityType.PIG, EntityType.OCELOT, EntityType.COW, EntityType.RABBIT, EntityType.SHEEP, EntityType.CHICKEN, EntityType.MUSHROOM_COW, EntityType.HORSE, EntityType.IRON_GOLEM, EntityType.SQUID, EntityType.VILLAGER, EntityType.WOLF, EntityType.SNOWMAN, EntityType.POLAR_BEAR, EntityType.DONKEY, EntityType.LLAMA, EntityType.MULE, EntityType.ZOMBIE_HORSE, EntityType.SKELETON_HORSE, EntityType.PARROT}, "PASSIVE_MOB", "PASSIVEMOB", "GOODMOB", "GOOD_MOB", "FRIENDLYMOB", "FRIENDLY_MOB");
            MOBS = new SentinelTarget(new EntityType[]{EntityType.GUARDIAN, EntityType.SHULKER, EntityType.CREEPER, EntityType.SKELETON, EntityType.ZOMBIE, EntityType.MAGMA_CUBE, EntityType.PIG_ZOMBIE, EntityType.SILVERFISH, EntityType.BAT, EntityType.BLAZE, EntityType.GHAST, EntityType.GIANT, EntityType.SLIME, EntityType.SPIDER, EntityType.CAVE_SPIDER, EntityType.ENDERMAN, EntityType.ENDERMITE, EntityType.WITHER, EntityType.ENDER_DRAGON, EntityType.WITCH, EntityType.PIG, EntityType.OCELOT, EntityType.COW, EntityType.RABBIT, EntityType.SHEEP, EntityType.CHICKEN, EntityType.MUSHROOM_COW, EntityType.HORSE, EntityType.IRON_GOLEM, EntityType.SQUID, EntityType.VILLAGER, EntityType.WOLF, EntityType.SNOWMAN, EntityType.POLAR_BEAR, EntityType.DONKEY, EntityType.LLAMA, EntityType.MULE, EntityType.ZOMBIE_HORSE, EntityType.SKELETON_HORSE, EntityType.VEX, EntityType.HUSK, EntityType.ELDER_GUARDIAN, EntityType.EVOKER, EntityType.STRAY, EntityType.ZOMBIE_VILLAGER, EntityType.WITHER_SKELETON, EntityType.VINDICATOR, EntityType.PARROT, EntityType.ILLUSIONER}, "MOB");
            LLAMAS = new SentinelTarget(new EntityType[]{EntityType.GUARDIAN, EntityType.SHULKER, EntityType.CREEPER, EntityType.SKELETON, EntityType.ZOMBIE, EntityType.MAGMA_CUBE, EntityType.PIG_ZOMBIE, EntityType.SILVERFISH, EntityType.BAT, EntityType.BLAZE, EntityType.GHAST, EntityType.GIANT, EntityType.SLIME, EntityType.SPIDER, EntityType.CAVE_SPIDER, EntityType.ENDERMAN, EntityType.ENDERMITE, EntityType.WITHER, EntityType.ENDER_DRAGON, EntityType.WITCH, EntityType.VEX, EntityType.HUSK, EntityType.ELDER_GUARDIAN, EntityType.EVOKER, EntityType.STRAY, EntityType.ZOMBIE_VILLAGER, EntityType.WITHER_SKELETON, EntityType.VINDICATOR, EntityType.ILLUSIONER}, "MONSTER");
        }
        if (v1_13) {
            SentinelTarget DOLPHIN = new SentinelTarget(new EntityType[]{EntityType.DOLPHIN}, "DOLPHIN");
            SentinelTarget DROWNED = new SentinelTarget(new EntityType[]{EntityType.DROWNED}, "DROWNED");
            SentinelTarget COD = new SentinelTarget(new EntityType[]{EntityType.COD}, "COD");
            SentinelTarget SALMON = new SentinelTarget(new EntityType[]{EntityType.SALMON}, "SALMON");
            SentinelTarget PUFFERFISH = new SentinelTarget(new EntityType[]{EntityType.PUFFERFISH}, "PUFFERFISH");
            SentinelTarget TROPICAL_FISH = new SentinelTarget(new EntityType[]{EntityType.TROPICAL_FISH}, "TROPICAL_FISH", "TROPICALFISH");
            SentinelTarget PHANTOM = new SentinelTarget(new EntityType[]{EntityType.PHANTOM}, "PHANTOM");
            SentinelTarget sentinelTarget3 = new SentinelTarget(new EntityType[]{EntityType.TURTLE}, "TURTLE");
        }
        if (v1_13) {
            PASSIVE_MOB = new SentinelTarget(new EntityType[]{EntityType.PIG, EntityType.OCELOT, EntityType.COW, EntityType.RABBIT, EntityType.SHEEP, EntityType.CHICKEN, EntityType.MUSHROOM_COW, EntityType.HORSE, EntityType.IRON_GOLEM, EntityType.SQUID, EntityType.VILLAGER, EntityType.WOLF, EntityType.SNOWMAN, EntityType.POLAR_BEAR, EntityType.DONKEY, EntityType.LLAMA, EntityType.MULE, EntityType.ZOMBIE_HORSE, EntityType.SKELETON_HORSE, EntityType.PARROT, EntityType.DOLPHIN, EntityType.COD, EntityType.SALMON, EntityType.PUFFERFISH, EntityType.TROPICAL_FISH, EntityType.TURTLE}, "PASSIVE_MOB", "PASSIVEMOB", "GOODMOB", "GOOD_MOB", "FRIENDLYMOB", "FRIENDLY_MOB");
            MOBS = new SentinelTarget(new EntityType[]{EntityType.GUARDIAN, EntityType.SHULKER, EntityType.CREEPER, EntityType.SKELETON, EntityType.ZOMBIE, EntityType.MAGMA_CUBE, EntityType.PIG_ZOMBIE, EntityType.SILVERFISH, EntityType.BAT, EntityType.BLAZE, EntityType.GHAST, EntityType.GIANT, EntityType.SLIME, EntityType.SPIDER, EntityType.CAVE_SPIDER, EntityType.ENDERMAN, EntityType.ENDERMITE, EntityType.WITHER, EntityType.ENDER_DRAGON, EntityType.WITCH, EntityType.PIG, EntityType.OCELOT, EntityType.COW, EntityType.RABBIT, EntityType.SHEEP, EntityType.CHICKEN, EntityType.MUSHROOM_COW, EntityType.HORSE, EntityType.IRON_GOLEM, EntityType.SQUID, EntityType.VILLAGER, EntityType.WOLF, EntityType.SNOWMAN, EntityType.POLAR_BEAR, EntityType.DONKEY, EntityType.LLAMA, EntityType.MULE, EntityType.ZOMBIE_HORSE, EntityType.SKELETON_HORSE, EntityType.VEX, EntityType.HUSK, EntityType.ELDER_GUARDIAN, EntityType.EVOKER, EntityType.STRAY, EntityType.ZOMBIE_VILLAGER, EntityType.WITHER_SKELETON, EntityType.VINDICATOR, EntityType.PARROT, EntityType.ILLUSIONER, EntityType.DROWNED, EntityType.PHANTOM, EntityType.DOLPHIN, EntityType.COD, EntityType.SALMON, EntityType.PUFFERFISH, EntityType.TROPICAL_FISH, EntityType.TURTLE}, "MOB");
            sentinelTarget = new SentinelTarget(new EntityType[]{EntityType.GUARDIAN, EntityType.SHULKER, EntityType.CREEPER, EntityType.SKELETON, EntityType.ZOMBIE, EntityType.MAGMA_CUBE, EntityType.PIG_ZOMBIE, EntityType.SILVERFISH, EntityType.BAT, EntityType.BLAZE, EntityType.GHAST, EntityType.GIANT, EntityType.SLIME, EntityType.SPIDER, EntityType.CAVE_SPIDER, EntityType.ENDERMAN, EntityType.ENDERMITE, EntityType.WITHER, EntityType.ENDER_DRAGON, EntityType.WITCH, EntityType.VEX, EntityType.HUSK, EntityType.ELDER_GUARDIAN, EntityType.EVOKER, EntityType.STRAY, EntityType.ZOMBIE_VILLAGER, EntityType.WITHER_SKELETON, EntityType.VINDICATOR, EntityType.ILLUSIONER, EntityType.DROWNED, EntityType.PHANTOM}, "MONSTER");
        }
        if (v1_13) {
            SentinelTarget.addAllMaterials(SWORD_MATERIALS, "DIAMOND_SWORD", "IRON_SWORD", "STONE_SWORD", "GOLDEN_SWORD", "WOODEN_SWORD");
            WEAPON_DAMAGE_MULTIPLIERS.put(SentinelTarget.getMaterial("DIAMOND_SWORD"), 7.0);
            WEAPON_DAMAGE_MULTIPLIERS.put(SentinelTarget.getMaterial("IRON_SWORD"), 6.0);
            WEAPON_DAMAGE_MULTIPLIERS.put(SentinelTarget.getMaterial("STONE_SWORD"), 5.0);
            WEAPON_DAMAGE_MULTIPLIERS.put(SentinelTarget.getMaterial("GOLDEN_SWORD"), 4.0);
            WEAPON_DAMAGE_MULTIPLIERS.put(SentinelTarget.getMaterial("WOODEN_SWORD"), 4.0);
            SentinelTarget.addAllMaterials(PICKAXE_MATERIALS, "DIAMOND_PICKAXE", "IRON_PICKAXE", "STONE_PICKAXE", "GOLDEN_PICKAXE", "WOODEN_PICKAXE");
            SentinelTarget.allMaterialsTo(WEAPON_DAMAGE_MULTIPLIERS, PICKAXE_MATERIALS, 2.0);
            SentinelTarget.addAllMaterials(AXE_MATERIALS, "DIAMOND_AXE", "IRON_AXE", "STONE_AXE", "GOLDEN_AXE", "WOODEN_AXE");
            SentinelTarget.allMaterialsTo(WEAPON_DAMAGE_MULTIPLIERS, AXE_MATERIALS, 3.0);
            BOW_MATERIALS.add(SentinelTarget.getMaterial("BOW"));
            SentinelTarget.addAllMaterials(HELMET_MATERIALS, "DIAMOND_HELMET", "GOLDEN_HELMET", "IRON_HELMET", "LEATHER_HELMET", "CHAINMAIL_HELMET");
            ARMOR_PROTECTION_MULTIPLIERS.put(SentinelTarget.getMaterial("DIAMOND_HELMET"), 0.12);
            ARMOR_PROTECTION_MULTIPLIERS.put(SentinelTarget.getMaterial("GOLDEN_HELMET"), 0.08);
            ARMOR_PROTECTION_MULTIPLIERS.put(SentinelTarget.getMaterial("IRON_HELMET"), 0.08);
            ARMOR_PROTECTION_MULTIPLIERS.put(SentinelTarget.getMaterial("LEATHER_HELMET"), 0.04);
            ARMOR_PROTECTION_MULTIPLIERS.put(SentinelTarget.getMaterial("CHAINMAIL_HELMET"), 0.08);
            SentinelTarget.addAllMaterials(CHESTPLATE_MATERIALS, "DIAMOND_CHESTPLATE", "GOLDEN_CHESTPLATE", "IRON_CHESTPLATE", "LEATHER_CHESTPLATE", "CHAINMAIL_CHESTPLATE");
            ARMOR_PROTECTION_MULTIPLIERS.put(SentinelTarget.getMaterial("DIAMOND_CHESTPLATE"), 0.32);
            ARMOR_PROTECTION_MULTIPLIERS.put(SentinelTarget.getMaterial("GOLDEN_CHESTPLATE"), 0.2);
            ARMOR_PROTECTION_MULTIPLIERS.put(SentinelTarget.getMaterial("IRON_CHESTPLATE"), 0.24);
            ARMOR_PROTECTION_MULTIPLIERS.put(SentinelTarget.getMaterial("LEATHER_CHESTPLATE"), 0.12);
            ARMOR_PROTECTION_MULTIPLIERS.put(SentinelTarget.getMaterial("CHAINMAIL_CHESTPLATE"), 0.2);
            SentinelTarget.addAllMaterials(LEGGINGS_MATERIALS, "DIAMOND_LEGGINGS", "GOLDEN_LEGGINGS", "IRON_LEGGINGS", "LEATHER_LEGGINGS", "CHAINMAIL_LEGGINGS");
            ARMOR_PROTECTION_MULTIPLIERS.put(SentinelTarget.getMaterial("DIAMOND_LEGGINGS"), 0.24);
            ARMOR_PROTECTION_MULTIPLIERS.put(SentinelTarget.getMaterial("GOLDEN_LEGGINGS"), 0.12);
            ARMOR_PROTECTION_MULTIPLIERS.put(SentinelTarget.getMaterial("IRON_LEGGINGS"), 0.2);
            ARMOR_PROTECTION_MULTIPLIERS.put(SentinelTarget.getMaterial("LEATHER_LEGGINGS"), 0.08);
            ARMOR_PROTECTION_MULTIPLIERS.put(SentinelTarget.getMaterial("CHAINMAIL_LEGGINGS"), 0.16);
            SentinelTarget.addAllMaterials(BOOTS_MATERIALS, "DIAMOND_BOOTS", "GOLDEN_BOOTS", "IRON_BOOTS", "LEATHER_BOOTS", "CHAINMAIL_BOOTS");
            ARMOR_PROTECTION_MULTIPLIERS.put(SentinelTarget.getMaterial("DIAMOND_BOOTS"), 0.12);
            ARMOR_PROTECTION_MULTIPLIERS.put(SentinelTarget.getMaterial("GOLDEN_BOOTS"), 0.04);
            ARMOR_PROTECTION_MULTIPLIERS.put(SentinelTarget.getMaterial("IRON_BOOTS"), 0.08);
            ARMOR_PROTECTION_MULTIPLIERS.put(SentinelTarget.getMaterial("LEATHER_BOOTS"), 0.04);
            ARMOR_PROTECTION_MULTIPLIERS.put(SentinelTarget.getMaterial("CHAINMAIL_BOOTS"), 0.04);
            SentinelTarget.addAllMaterials(POTION_MATERIALS, "POTION", "LINGERING_POTION", "SPLASH_POTION");
            SentinelTarget.addAllMaterials(SKULL_MATERIALS, "WITHER_SKELETON_SKULL", "WITHER_SKELETON_WALL_SKULL");
            MATERIAL_SNOW_BALL = SentinelTarget.getMaterial("SNOWBALL");
            MATERIAL_NETHER_STAR = SentinelTarget.getMaterial("NETHER_STAR");
            MATERIAL_BLAZE_ROD = SentinelTarget.getMaterial("BLAZE_ROD");
        } else {
            SentinelTarget.addAllMaterials(SWORD_MATERIALS, "DIAMOND_SWORD", "IRON_SWORD", "STONE_SWORD", "GOLD_SWORD", "WOOD_SWORD");
            WEAPON_DAMAGE_MULTIPLIERS.put(SentinelTarget.getMaterial("DIAMOND_SWORD"), 7.0);
            WEAPON_DAMAGE_MULTIPLIERS.put(SentinelTarget.getMaterial("IRON_SWORD"), 6.0);
            WEAPON_DAMAGE_MULTIPLIERS.put(SentinelTarget.getMaterial("STONE_SWORD"), 5.0);
            WEAPON_DAMAGE_MULTIPLIERS.put(SentinelTarget.getMaterial("GOLD_SWORD"), 4.0);
            WEAPON_DAMAGE_MULTIPLIERS.put(SentinelTarget.getMaterial("WOOD_SWORD"), 4.0);
            SentinelTarget.addAllMaterials(PICKAXE_MATERIALS, "DIAMOND_PICKAXE", "IRON_PICKAXE", "STONE_PICKAXE", "GOLD_PICKAXE", "WOOD_PICKAXE");
            SentinelTarget.allMaterialsTo(WEAPON_DAMAGE_MULTIPLIERS, PICKAXE_MATERIALS, 2.0);
            SentinelTarget.addAllMaterials(AXE_MATERIALS, "DIAMOND_AXE", "IRON_AXE", "STONE_AXE", "GOLD_AXE", "WOOD_AXE");
            SentinelTarget.allMaterialsTo(WEAPON_DAMAGE_MULTIPLIERS, AXE_MATERIALS, 3.0);
            BOW_MATERIALS.add(SentinelTarget.getMaterial("BOW"));
            SentinelTarget.addAllMaterials(HELMET_MATERIALS, "DIAMOND_HELMET", "GOLD_HELMET", "IRON_HELMET", "LEATHER_HELMET", "CHAINMAIL_HELMET");
            ARMOR_PROTECTION_MULTIPLIERS.put(SentinelTarget.getMaterial("DIAMOND_HELMET"), 0.12);
            ARMOR_PROTECTION_MULTIPLIERS.put(SentinelTarget.getMaterial("GOLD_HELMET"), 0.08);
            ARMOR_PROTECTION_MULTIPLIERS.put(SentinelTarget.getMaterial("IRON_HELMET"), 0.08);
            ARMOR_PROTECTION_MULTIPLIERS.put(SentinelTarget.getMaterial("LEATHER_HELMET"), 0.04);
            ARMOR_PROTECTION_MULTIPLIERS.put(SentinelTarget.getMaterial("CHAINMAIL_HELMET"), 0.08);
            SentinelTarget.addAllMaterials(CHESTPLATE_MATERIALS, "DIAMOND_CHESTPLATE", "GOLD_CHESTPLATE", "IRON_CHESTPLATE", "LEATHER_CHESTPLATE", "CHAINMAIL_CHESTPLATE");
            ARMOR_PROTECTION_MULTIPLIERS.put(SentinelTarget.getMaterial("DIAMOND_CHESTPLATE"), 0.32);
            ARMOR_PROTECTION_MULTIPLIERS.put(SentinelTarget.getMaterial("GOLD_CHESTPLATE"), 0.2);
            ARMOR_PROTECTION_MULTIPLIERS.put(SentinelTarget.getMaterial("IRON_CHESTPLATE"), 0.24);
            ARMOR_PROTECTION_MULTIPLIERS.put(SentinelTarget.getMaterial("LEATHER_CHESTPLATE"), 0.12);
            ARMOR_PROTECTION_MULTIPLIERS.put(SentinelTarget.getMaterial("CHAINMAIL_CHESTPLATE"), 0.2);
            SentinelTarget.addAllMaterials(LEGGINGS_MATERIALS, "DIAMOND_LEGGINGS", "GOLD_LEGGINGS", "IRON_LEGGINGS", "LEATHER_LEGGINGS", "CHAINMAIL_LEGGINGS");
            ARMOR_PROTECTION_MULTIPLIERS.put(SentinelTarget.getMaterial("DIAMOND_LEGGINGS"), 0.24);
            ARMOR_PROTECTION_MULTIPLIERS.put(SentinelTarget.getMaterial("GOLD_LEGGINGS"), 0.12);
            ARMOR_PROTECTION_MULTIPLIERS.put(SentinelTarget.getMaterial("IRON_LEGGINGS"), 0.2);
            ARMOR_PROTECTION_MULTIPLIERS.put(SentinelTarget.getMaterial("LEATHER_LEGGINGS"), 0.08);
            ARMOR_PROTECTION_MULTIPLIERS.put(SentinelTarget.getMaterial("CHAINMAIL_LEGGINGS"), 0.16);
            SentinelTarget.addAllMaterials(BOOTS_MATERIALS, "DIAMOND_BOOTS", "GOLD_BOOTS", "IRON_BOOTS", "LEATHER_BOOTS", "CHAINMAIL_BOOTS");
            ARMOR_PROTECTION_MULTIPLIERS.put(SentinelTarget.getMaterial("DIAMOND_BOOTS"), 0.12);
            ARMOR_PROTECTION_MULTIPLIERS.put(SentinelTarget.getMaterial("GOLD_BOOTS"), 0.04);
            ARMOR_PROTECTION_MULTIPLIERS.put(SentinelTarget.getMaterial("IRON_BOOTS"), 0.08);
            ARMOR_PROTECTION_MULTIPLIERS.put(SentinelTarget.getMaterial("LEATHER_BOOTS"), 0.04);
            ARMOR_PROTECTION_MULTIPLIERS.put(SentinelTarget.getMaterial("CHAINMAIL_BOOTS"), 0.04);
            if (v1_9) {
                SentinelTarget.addAllMaterials(POTION_MATERIALS, "POTION", "LINGERING_POTION", "SPLASH_POTION");
            } else {
                SentinelTarget.addAllMaterials(POTION_MATERIALS, "POTION");
            }
            SentinelTarget.addAllMaterials(SKULL_MATERIALS, "SKULL", "SKULL_ITEM");
            MATERIAL_SNOW_BALL = SentinelTarget.getMaterial("SNOW_BALL");
            MATERIAL_NETHER_STAR = SentinelTarget.getMaterial("NETHER_STAR");
            MATERIAL_BLAZE_ROD = SentinelTarget.getMaterial("BLAZE_ROD");
        }
    }
}

