/*
 * Decompiled with CFR 0.152.
 */
package org.mcmonkey.sentinel;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Method;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import java.util.regex.Pattern;
import net.citizensnpcs.api.ai.EntityTarget;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.util.Vector;
import org.mcmonkey.sentinel.SentinelPlugin;
import org.mcmonkey.sentinel.SentinelTarget;

public class SentinelUtilities {
    public static Random random = new Random();
    public static HashMap<String, Pattern> regexes = new HashMap(128);
    public static final String ENCODING = "UTF-8";
    public static final int BUFFER_10_KB = 10240;

    public static Location rayTrace(Location start, Location end) {
        double dSq = start.distanceSquared(end);
        if (dSq < 1.0) {
            if (end.getBlock().getType().isSolid()) {
                return start.clone();
            }
            return end.clone();
        }
        double dist = Math.sqrt(dSq);
        Vector move = end.toVector().subtract(start.toVector()).multiply(1.0 / dist);
        int iters = (int)Math.ceil(dist);
        Location cur = start.clone();
        Location next = cur.clone().add(move);
        for (int i = 0; i < iters; ++i) {
            if (next.getBlock().getType().isSolid()) {
                return cur;
            }
            cur = cur.add(move);
            next = next.add(move);
        }
        return cur;
    }

    public static Location pickNear(Location start, double range) {
        Location hit = SentinelUtilities.rayTrace(start.clone().add(0.0, 1.5, 0.0), start.clone().add(SentinelUtilities.randomDecimal(-range, range), 1.5, SentinelUtilities.randomDecimal(range, range)));
        if (hit.subtract(0.0, 1.0, 0.0).getBlock().getType().isSolid()) {
            return hit;
        }
        return hit.subtract(0.0, 1.0, 0.0);
    }

    public static Pattern regexFor(String input) {
        Pattern result = regexes.get(input);
        if (result != null) {
            return result;
        }
        result = Pattern.compile(input, 2);
        regexes.put(input, result);
        return result;
    }

    public static boolean isRegexTargeted(String name, List<String> regexes) {
        for (String str : regexes) {
            Pattern pattern = SentinelUtilities.regexFor(".*" + str + ".*");
            if (!pattern.matcher(name).matches()) continue;
            return true;
        }
        return false;
    }

    public static float getYaw(Vector vector) {
        double dx = vector.getX();
        double dz = vector.getZ();
        double yaw = 0.0;
        if (dx != 0.0) {
            yaw = dx < 0.0 ? 4.71238898038469 : 1.5707963267948966;
            yaw -= Math.atan(dz / dx);
        } else if (dz < 0.0) {
            yaw = Math.PI;
        }
        return (float)(-yaw * 57.29577951308232);
    }

    public static double randomDecimal(double min, double max) {
        return random.nextDouble() * (max - min) + min;
    }

    public static boolean isAir(ItemStack its) {
        return its == null || its.getType() == Material.AIR;
    }

    public static Entity getEntityForID(UUID id) {
        if (!SentinelTarget.v1_12) {
            for (World world : Bukkit.getServer().getWorlds()) {
                for (Entity e : world.getEntities()) {
                    if (!e.getUniqueId().equals(id)) continue;
                    return e;
                }
            }
            return null;
        }
        return Bukkit.getServer().getEntity(id);
    }

    public static boolean isInvisible(LivingEntity entity) {
        EntityEquipment eq = entity.getEquipment();
        if (!SentinelPlugin.instance.ignoreInvisible || !entity.hasPotionEffect(PotionEffectType.INVISIBILITY)) {
            return false;
        }
        if (SentinelTarget.v1_9 ? !SentinelUtilities.isAir(eq.getItemInMainHand()) || !SentinelUtilities.isAir(eq.getItemInOffHand()) : !SentinelUtilities.isAir(eq.getItemInHand())) {
            return false;
        }
        return SentinelUtilities.isAir(eq.getBoots()) && SentinelUtilities.isAir(eq.getLeggings()) && SentinelUtilities.isAir(eq.getChestplate()) && SentinelUtilities.isAir(eq.getHelmet());
    }

    public static Entity getTargetFor(EntityTarget targ) {
        if (SentinelTarget.v1_9) {
            return targ.getTarget();
        }
        try {
            Method meth = EntityTarget.class.getMethod("getTarget", new Class[0]);
            meth.setAccessible(true);
            return (LivingEntity)meth.invoke((Object)targ, new Object[0]);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return targ.getTarget();
        }
    }

    public static AbstractMap.SimpleEntry<Location, Vector> getLaunchDetail(Location start, Location target, Vector lead) {
        double sbase;
        double speeda;
        double angt = Double.POSITIVE_INFINITY;
        for (speeda = sbase = SentinelPlugin.instance.minShootSpeed; speeda <= sbase + 15.0 && Double.isInfinite(angt = SentinelUtilities.getArrowAngle(start, target, speeda, 20.0)); speeda += 5.0) {
        }
        if (Double.isInfinite(angt)) {
            return null;
        }
        double hangT = SentinelUtilities.hangtime(angt, speeda, target.getY() - start.getY(), 20.0);
        Location to = target.clone().add(lead.clone().multiply(hangT));
        Vector relative = to.clone().subtract(start.toVector()).toVector();
        double deltaXZ = Math.sqrt(relative.getX() * relative.getX() + relative.getZ() * relative.getZ());
        if (deltaXZ == 0.0) {
            deltaXZ = 0.1;
        }
        for (speeda = sbase; speeda <= sbase + 15.0 && Double.isInfinite(angt = SentinelUtilities.getArrowAngle(start, to, speeda, 20.0)); speeda += 5.0) {
        }
        if (Double.isInfinite(angt)) {
            return null;
        }
        relative.setY(Math.tan(angt) * deltaXZ);
        relative = relative.normalize();
        Vector normrel = relative.clone();
        relative = relative.multiply((speeda += 1.188 * hangT * hangT) / 20.0);
        start.setDirection(normrel);
        return new AbstractMap.SimpleEntry<Location, Vector>(start, relative);
    }

    public static double getArrowAngle(Location fireFrom, Location fireTo, double speed, double gravity) {
        double deltaY;
        double basic;
        double v2;
        double v4;
        Vector delta = fireTo.clone().subtract(fireFrom).toVector();
        double deltaXZ = Math.sqrt(delta.getX() * delta.getX() + delta.getZ() * delta.getZ());
        if (deltaXZ == 0.0) {
            deltaXZ = 0.1;
        }
        if ((v4 = (v2 = speed * speed) * v2) < (basic = gravity * (gravity * deltaXZ * deltaXZ + 2.0 * (deltaY = fireTo.getY() - fireFrom.getY()) * v2))) {
            return Double.NEGATIVE_INFINITY;
        }
        return Math.atan((v2 - Math.sqrt(v4 - basic)) / (gravity * deltaXZ));
    }

    public static double hangtime(double launchAngle, double vel, double deltaY, double gravity) {
        double b;
        double a = vel * Math.sin(launchAngle);
        double a2 = a * a + (b = -2.0 * gravity * deltaY);
        if (a2 < 0.0) {
            return 0.0;
        }
        return (a + Math.sqrt(a2)) / gravity;
    }

    public static String concatWithSpaces(String[] strs, int start) {
        StringBuilder temp = new StringBuilder();
        for (int i = start; i < strs.length; ++i) {
            temp.append(strs[i]).append(" ");
        }
        return temp.toString();
    }

    public static String streamToString(InputStream is) {
        try {
            char[] buffer = new char[10240];
            StringBuilder out = new StringBuilder();
            try (InputStreamReader in = new InputStreamReader(is, ENCODING);){
                int rsz;
                while ((rsz = ((Reader)in).read(buffer, 0, buffer.length)) >= 0) {
                    out.append(buffer, 0, rsz);
                }
            }
            return out.toString();
        }
        catch (Exception ex) {
            return null;
        }
    }
}

