/*
 * Decompiled with CFR 0.152.
 */
package org.mcmonkey.sentinel.targeting;

import java.util.HashSet;
import java.util.UUID;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.trait.trait.Owner;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;
import org.mcmonkey.sentinel.SentinelCurrentTarget;
import org.mcmonkey.sentinel.SentinelHelperObject;
import org.mcmonkey.sentinel.SentinelPlugin;
import org.mcmonkey.sentinel.SentinelTrait;
import org.mcmonkey.sentinel.SentinelUtilities;
import org.mcmonkey.sentinel.targeting.SentinelTarget;

public class SentinelTargetingHelper
extends SentinelHelperObject {
    public HashSet<SentinelCurrentTarget> currentTargets = new HashSet();

    public boolean canSee(LivingEntity entity) {
        if (!this.getLivingEntity().hasLineOfSight((Entity)entity)) {
            return false;
        }
        if (this.sentinel.realistic) {
            float yaw;
            for (yaw = this.getLivingEntity().getEyeLocation().getYaw(); yaw < 0.0f; yaw += 360.0f) {
            }
            while (yaw >= 360.0f) {
                yaw -= 360.0f;
            }
            Vector rel = entity.getLocation().toVector().subtract(this.getLivingEntity().getLocation().toVector()).normalize();
            float yawHelp = SentinelUtilities.getYaw(rel);
            if (!(Math.abs(yawHelp - yaw) < 90.0f || Math.abs(yawHelp + 360.0f - yaw) < 90.0f || Math.abs(yaw + 360.0f - yawHelp) < 90.0f)) {
                return false;
            }
        }
        return true;
    }

    public boolean shouldTarget(LivingEntity entity) {
        if (entity.getUniqueId().equals(this.getLivingEntity().getUniqueId())) {
            return false;
        }
        return this.isTargeted(entity) && !this.isIgnored(entity);
    }

    public void addTarget(UUID id) {
        if (id.equals(this.getLivingEntity().getUniqueId())) {
            return;
        }
        if (!(SentinelUtilities.getEntityForID(id) instanceof LivingEntity)) {
            return;
        }
        this.addTargetNoBounce(id);
        if (this.sentinel.squad != null) {
            for (NPC npc : CitizensAPI.getNPCRegistry()) {
                if (!npc.hasTrait(SentinelTrait.class)) continue;
                SentinelTrait squadMade = (SentinelTrait)npc.getTrait(SentinelTrait.class);
                if (squadMade.squad == null || !squadMade.squad.equals(this.sentinel.squad)) continue;
                this.addTargetNoBounce(id);
            }
        }
    }

    public boolean removeTarget(UUID id) {
        SentinelCurrentTarget target = new SentinelCurrentTarget();
        target.targetID = id;
        boolean removed = this.currentTargets.remove(target);
        if (removed && this.sentinel.squad != null) {
            for (NPC npc : CitizensAPI.getNPCRegistry()) {
                if (!npc.hasTrait(SentinelTrait.class)) continue;
                SentinelTrait squadMade = (SentinelTrait)npc.getTrait(SentinelTrait.class);
                if (squadMade.squad == null || !squadMade.squad.equals(this.sentinel.squad)) continue;
                this.sentinel.targetingHelper.currentTargets.remove(target);
            }
        }
        return removed;
    }

    public void addTargetNoBounce(UUID id) {
        SentinelCurrentTarget target = new SentinelCurrentTarget();
        target.targetID = id;
        target.ticksLeft = this.sentinel.enemyTargetTime;
        this.currentTargets.remove(target);
        this.currentTargets.add(target);
    }

    public boolean isInvisible(LivingEntity entity) {
        SentinelCurrentTarget sct = new SentinelCurrentTarget();
        sct.targetID = entity.getUniqueId();
        return !this.currentTargets.contains(sct) && SentinelUtilities.isInvisible(entity);
    }

    public boolean isIgnored(LivingEntity entity) {
        if (this.isInvisible(entity)) {
            return true;
        }
        if (entity.getUniqueId().equals(this.getLivingEntity().getUniqueId())) {
            return true;
        }
        if (this.sentinel.getGuarding() != null && entity.getUniqueId().equals(this.sentinel.getGuarding())) {
            return true;
        }
        this.sentinel.allIgnores.checkRecalculateTargetsCache();
        if (this.sentinel.allIgnores.targetsProcessed.contains(SentinelTarget.OWNER) && entity.getUniqueId().equals(((Owner)this.getNPC().getTrait(Owner.class)).getOwnerId())) {
            return true;
        }
        return this.sentinel.allIgnores.isTarget(entity);
    }

    public boolean isTargeted(LivingEntity entity) {
        if (this.isInvisible(entity)) {
            return false;
        }
        if (entity.getUniqueId().equals(this.getLivingEntity().getUniqueId())) {
            return false;
        }
        if (this.sentinel.getGuarding() != null && entity.getUniqueId().equals(this.sentinel.getGuarding())) {
            return false;
        }
        SentinelCurrentTarget target = new SentinelCurrentTarget();
        target.targetID = entity.getUniqueId();
        if (this.currentTargets.contains(target)) {
            return true;
        }
        this.sentinel.allTargets.checkRecalculateTargetsCache();
        if (this.sentinel.allTargets.targetsProcessed.contains(SentinelTarget.OWNER) && entity.getUniqueId().equals(((Owner)this.getNPC().getTrait(Owner.class)).getOwnerId())) {
            return true;
        }
        return this.sentinel.allTargets.isTarget(entity);
    }

    public LivingEntity findBestTarget() {
        boolean ignoreGlow = this.itemHelper.usesSpectral();
        double rangesquared = this.sentinel.range * this.sentinel.range;
        double crsq = this.sentinel.chaseRange * this.sentinel.chaseRange;
        Location pos = this.sentinel.getGuardZone();
        if (!this.sentinel.getGuardZone().getWorld().equals(this.getLivingEntity().getWorld())) {
            this.getNPC().getNavigator().cancelNavigation();
            this.getLivingEntity().teleport(this.sentinel.getGuardZone());
            return null;
        }
        if (!pos.getWorld().equals(this.getLivingEntity().getWorld())) {
            return null;
        }
        LivingEntity closest = null;
        boolean wasLos = false;
        for (LivingEntity ent : this.getLivingEntity().getWorld().getLivingEntities()) {
            if (ignoreGlow && ent.isGlowing() || ent.isDead()) continue;
            double dist = ent.getEyeLocation().distanceSquared(pos);
            SentinelCurrentTarget sct = new SentinelCurrentTarget();
            sct.targetID = ent.getUniqueId();
            if (!(dist < rangesquared && this.shouldTarget(ent) && this.canSee(ent)) && (!(dist < crsq) || !this.currentTargets.contains(sct))) continue;
            boolean hasLos = this.canSee(ent);
            if (wasLos && !hasLos) continue;
            rangesquared = dist;
            closest = ent;
            wasLos = hasLos;
        }
        return closest;
    }

    public void updateTargets() {
        for (SentinelCurrentTarget uuid : new HashSet<SentinelCurrentTarget>(this.currentTargets)) {
            double d;
            Entity e = SentinelUtilities.getEntityForID(uuid.targetID);
            if (e == null) {
                this.currentTargets.remove(uuid);
                continue;
            }
            if (e instanceof Player && (((Player)e).getGameMode() == GameMode.CREATIVE || ((Player)e).getGameMode() == GameMode.SPECTATOR)) {
                this.currentTargets.remove(uuid);
                continue;
            }
            if (e.isDead()) {
                this.currentTargets.remove(uuid);
                continue;
            }
            double d2 = d = e.getWorld().equals(this.getLivingEntity().getWorld()) ? e.getLocation().distanceSquared(this.getLivingEntity().getLocation()) : 1.0E8;
            if (d > this.sentinel.range * this.sentinel.range * 4.0 && d > this.sentinel.chaseRange * this.sentinel.chaseRange * 4.0) {
                this.currentTargets.remove(uuid);
                continue;
            }
            if (uuid.ticksLeft <= 0L) continue;
            uuid.ticksLeft -= (long)SentinelPlugin.instance.tickRate;
            if (uuid.ticksLeft > 0L) continue;
            this.currentTargets.remove(uuid);
        }
        if (this.sentinel.chasing != null) {
            SentinelCurrentTarget cte = new SentinelCurrentTarget();
            cte.targetID = this.sentinel.chasing.getUniqueId();
            if (!this.currentTargets.contains(cte)) {
                this.sentinel.chasing = null;
                this.getNPC().getNavigator().cancelNavigation();
            }
        }
    }
}

