/*
 * Decompiled with CFR 0.152.
 */
package org.mcmonkey.sentinel;

import net.citizensnpcs.api.ai.TargetType;
import org.bukkit.Bukkit;
import org.bukkit.Sound;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.mcmonkey.sentinel.SentinelHelperObject;
import org.mcmonkey.sentinel.SentinelIntegration;
import org.mcmonkey.sentinel.SentinelPlugin;
import org.mcmonkey.sentinel.SentinelUtilities;
import org.mcmonkey.sentinel.events.SentinelAttackEvent;
import org.mcmonkey.sentinel.targeting.SentinelTarget;

public class SentinelAttackHelper
extends SentinelHelperObject {
    public void chase(LivingEntity entity) {
        if (this.getNPC().getNavigator().getTargetType() == TargetType.LOCATION && this.getNPC().getNavigator().getTargetAsLocation() != null && this.getNPC().getNavigator().getTargetAsLocation().getWorld().equals(entity.getWorld()) && this.getNPC().getNavigator().getTargetAsLocation().distanceSquared(entity.getLocation()) < 4.0) {
            return;
        }
        this.sentinel.cleverTicks = 0;
        this.sentinel.chasing = entity;
        this.sentinel.chased = true;
        if (this.getNPC().getNavigator().getTargetType() == TargetType.ENTITY && SentinelUtilities.getTargetFor(this.getNPC().getNavigator().getEntityTarget()).getUniqueId().equals(entity.getUniqueId())) {
            return;
        }
        this.getNPC().getNavigator().getDefaultParameters().stuckAction(null);
        if (SentinelPlugin.instance.workaroundEntityChasePathfinder) {
            this.getNPC().getNavigator().setTarget(entity.getLocation());
        } else {
            this.getNPC().getNavigator().setTarget((Entity)entity, false);
        }
        this.getNPC().getNavigator().getLocalParameters().speedModifier((float)this.sentinel.speed);
    }

    public void rechase() {
        if (this.sentinel.chasing != null) {
            this.chase(this.sentinel.chasing);
        }
    }

    public void tryAttack(LivingEntity entity) {
        ItemStack item;
        if (!entity.getWorld().equals(this.getLivingEntity().getWorld())) {
            return;
        }
        if (!this.getLivingEntity().hasLineOfSight((Entity)entity)) {
            return;
        }
        ++this.sentinel.stats_attackAttempts;
        double dist = this.getLivingEntity().getEyeLocation().distanceSquared(entity.getEyeLocation());
        if (SentinelPlugin.debugMe) {
            this.debug("tryAttack at range " + (int)(Math.sqrt(dist) * 0.1) * 10);
        }
        if (this.sentinel.autoswitch && dist > this.sentinel.reach * this.sentinel.reach) {
            this.itemHelper.swapToRanged();
        } else if (this.sentinel.autoswitch && dist < this.sentinel.reach * this.sentinel.reach) {
            this.itemHelper.swapToMelee();
        }
        this.sentinel.chasing = entity;
        SentinelAttackEvent sat = new SentinelAttackEvent(this.getNPC());
        Bukkit.getPluginManager().callEvent((Event)sat);
        if (sat.isCancelled()) {
            if (SentinelPlugin.debugMe) {
                this.debug("tryAttack refused, event cancellation");
            }
            return;
        }
        this.targetingHelper.addTarget(entity.getUniqueId());
        for (SentinelIntegration si : SentinelPlugin.integrations) {
            if (!si.tryAttack(this.sentinel, entity)) continue;
            return;
        }
        if (this.itemHelper.usesBow()) {
            if (this.targetingHelper.canSee(entity)) {
                if (this.sentinel.timeSinceAttack < (long)this.sentinel.attackRateRanged) {
                    if (this.sentinel.rangedChase) {
                        this.rechase();
                    }
                    return;
                }
                this.sentinel.timeSinceAttack = 0L;
                item = this.itemHelper.getArrow();
                if (item != null) {
                    this.weaponHelper.fireArrow(item, entity.getEyeLocation(), entity.getVelocity());
                    if (this.sentinel.needsAmmo) {
                        this.itemHelper.reduceDurability();
                        this.itemHelper.takeArrow();
                        this.itemHelper.grabNextItem();
                    }
                }
            } else if (this.sentinel.rangedChase) {
                this.chase(entity);
            }
        } else if (this.itemHelper.usesSnowball()) {
            if (this.targetingHelper.canSee(entity)) {
                if (this.sentinel.timeSinceAttack < (long)this.sentinel.attackRateRanged) {
                    if (this.sentinel.rangedChase) {
                        this.rechase();
                    }
                    return;
                }
                this.sentinel.timeSinceAttack = 0L;
                item = this.itemHelper.getArrow();
                if (item != null) {
                    this.weaponHelper.fireSnowball(entity.getEyeLocation());
                    if (this.sentinel.needsAmmo) {
                        this.itemHelper.takeSnowball();
                        this.itemHelper.grabNextItem();
                    }
                }
            } else if (this.sentinel.rangedChase) {
                this.chase(entity);
            }
        } else if (this.itemHelper.usesPotion()) {
            if (this.targetingHelper.canSee(entity)) {
                if (this.sentinel.timeSinceAttack < (long)this.sentinel.attackRateRanged) {
                    if (this.sentinel.rangedChase) {
                        this.rechase();
                    }
                    return;
                }
                this.sentinel.timeSinceAttack = 0L;
                if (SentinelTarget.v1_9) {
                    this.weaponHelper.firePotion(this.getLivingEntity().getEquipment().getItemInMainHand(), entity.getEyeLocation(), entity.getVelocity());
                } else {
                    this.weaponHelper.firePotion(this.getLivingEntity().getEquipment().getItemInHand(), entity.getEyeLocation(), entity.getVelocity());
                }
                if (this.sentinel.needsAmmo) {
                    this.itemHelper.takeOne();
                    this.itemHelper.grabNextItem();
                }
            } else if (this.sentinel.rangedChase) {
                this.chase(entity);
            }
        } else if (this.itemHelper.usesEgg()) {
            if (this.targetingHelper.canSee(entity)) {
                if (this.sentinel.timeSinceAttack < (long)this.sentinel.attackRateRanged) {
                    if (this.sentinel.rangedChase) {
                        this.rechase();
                    }
                    return;
                }
                this.sentinel.timeSinceAttack = 0L;
                this.weaponHelper.fireEgg(entity.getEyeLocation());
                if (this.sentinel.needsAmmo) {
                    this.itemHelper.takeOne();
                    this.itemHelper.grabNextItem();
                }
            } else if (this.sentinel.rangedChase) {
                this.chase(entity);
            }
        } else if (this.itemHelper.usesPearl()) {
            if (this.targetingHelper.canSee(entity)) {
                if (this.sentinel.timeSinceAttack < (long)this.sentinel.attackRateRanged) {
                    if (this.sentinel.rangedChase) {
                        this.rechase();
                    }
                    return;
                }
                this.sentinel.timeSinceAttack = 0L;
                this.weaponHelper.firePearl(entity);
                if (this.sentinel.needsAmmo) {
                    this.itemHelper.takeOne();
                    this.itemHelper.grabNextItem();
                }
            } else if (this.sentinel.rangedChase) {
                this.chase(entity);
            }
        } else if (this.itemHelper.usesWitherSkull()) {
            if (this.targetingHelper.canSee(entity)) {
                if (this.sentinel.timeSinceAttack < (long)this.sentinel.attackRateRanged) {
                    if (this.sentinel.rangedChase) {
                        this.rechase();
                    }
                    return;
                }
                this.sentinel.timeSinceAttack = 0L;
                this.weaponHelper.fireSkull(entity.getEyeLocation());
                if (this.sentinel.needsAmmo) {
                    this.itemHelper.takeOne();
                    this.itemHelper.grabNextItem();
                }
            } else if (this.sentinel.rangedChase) {
                this.chase(entity);
            }
        } else if (this.itemHelper.usesFireball()) {
            if (this.targetingHelper.canSee(entity)) {
                if (this.sentinel.timeSinceAttack < (long)this.sentinel.attackRateRanged) {
                    if (this.sentinel.rangedChase) {
                        this.rechase();
                    }
                    return;
                }
                this.sentinel.timeSinceAttack = 0L;
                this.weaponHelper.fireFireball(entity.getEyeLocation());
                if (this.sentinel.needsAmmo) {
                    this.itemHelper.takeOne();
                    this.itemHelper.grabNextItem();
                }
            } else if (this.sentinel.rangedChase) {
                this.chase(entity);
            }
        } else if (this.itemHelper.usesLightning()) {
            if (this.targetingHelper.canSee(entity)) {
                if (this.sentinel.timeSinceAttack < (long)this.sentinel.attackRateRanged) {
                    if (this.sentinel.rangedChase) {
                        this.rechase();
                    }
                    return;
                }
                this.sentinel.timeSinceAttack = 0L;
                this.sentinel.swingWeapon();
                entity.getWorld().strikeLightningEffect(entity.getLocation());
                if (SentinelPlugin.debugMe) {
                    this.debug("Lightning hits for " + this.sentinel.getDamage());
                }
                entity.damage(this.sentinel.getDamage());
                if (this.sentinel.needsAmmo) {
                    this.itemHelper.takeOne();
                    this.itemHelper.grabNextItem();
                }
            } else if (this.sentinel.rangedChase) {
                this.chase(entity);
            }
        } else if (this.itemHelper.usesSpectral()) {
            if (this.targetingHelper.canSee(entity)) {
                if (this.sentinel.timeSinceAttack < (long)this.sentinel.attackRateRanged) {
                    if (this.sentinel.rangedChase) {
                        this.rechase();
                    }
                    return;
                }
                this.sentinel.timeSinceAttack = 0L;
                if (!entity.isGlowing()) {
                    this.sentinel.swingWeapon();
                    try {
                        Sound snd = SentinelPlugin.instance.spectralSound;
                        if (snd != null) {
                            entity.getWorld().playSound(entity.getLocation(), snd, 1.0f, 1.0f);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    entity.setGlowing(true);
                    if (this.sentinel.needsAmmo) {
                        this.itemHelper.takeOne();
                        this.itemHelper.grabNextItem();
                    }
                }
            } else if (this.sentinel.rangedChase) {
                this.chase(entity);
            }
        } else if (dist < this.sentinel.reach * this.sentinel.reach) {
            if (this.sentinel.timeSinceAttack < (long)this.sentinel.attackRate) {
                if (SentinelPlugin.debugMe) {
                    this.debug("tryAttack refused, timeSinceAttack");
                }
                if (this.sentinel.closeChase) {
                    this.rechase();
                }
                return;
            }
            this.sentinel.timeSinceAttack = 0L;
            if (SentinelPlugin.debugMe) {
                this.debug("tryAttack passed!");
            }
            this.weaponHelper.punch(entity);
            if (this.sentinel.needsAmmo && this.itemHelper.shouldTakeDura()) {
                this.itemHelper.reduceDurability();
                this.itemHelper.grabNextItem();
            }
        } else if (this.sentinel.closeChase) {
            if (SentinelPlugin.debugMe) {
                this.debug("tryAttack refused, range");
            }
            this.chase(entity);
        }
    }
}

