/*
 * Decompiled with CFR 0.152.
 */
package org.mcmonkey.sentinel.targeting;

import java.util.ArrayList;
import java.util.HashSet;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.persistence.Persist;
import net.citizensnpcs.api.trait.trait.Owner;
import net.citizensnpcs.api.util.DataKey;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.mcmonkey.sentinel.SentinelIntegration;
import org.mcmonkey.sentinel.SentinelPlugin;
import org.mcmonkey.sentinel.SentinelTrait;
import org.mcmonkey.sentinel.SentinelUtilities;
import org.mcmonkey.sentinel.targeting.SentinelTarget;

public class SentinelTargetList {
    public HashSet<SentinelTarget> targetsProcessed = new HashSet();
    @Persist(value="targets")
    public HashSet<String> targets = new HashSet();
    @Persist(value="byPlayerName")
    public ArrayList<String> byPlayerName = new ArrayList();
    @Persist(value="byNpcName")
    public ArrayList<String> byNpcName = new ArrayList();
    @Persist(value="byEntityName")
    public ArrayList<String> byEntityName = new ArrayList();
    @Persist(value="byHeldItem")
    public ArrayList<String> byHeldItem = new ArrayList();
    @Persist(value="byGroup")
    public ArrayList<String> byGroup = new ArrayList();
    @Persist(value="byEvent")
    public ArrayList<String> byEvent = new ArrayList();
    @Persist(value="byOther")
    public ArrayList<String> byOther = new ArrayList();

    public boolean isTarget(LivingEntity entity, SentinelTrait sentinel) {
        this.checkRecalculateTargetsCache();
        if (this.targetsProcessed.contains(SentinelTarget.OWNER) && entity.getUniqueId().equals(((Owner)sentinel.getNPC().getTrait(Owner.class)).getOwnerId())) {
            return true;
        }
        return this.isTarget(entity);
    }

    public boolean isTarget(LivingEntity entity) {
        this.checkRecalculateTargetsCache();
        if (SentinelTarget.v1_9 ? entity.getEquipment() != null && entity.getEquipment().getItemInMainHand() != null && SentinelUtilities.isRegexTargeted(entity.getEquipment().getItemInMainHand().getType().name(), this.byHeldItem) : entity.getEquipment() != null && entity.getEquipment().getItemInHand() != null && SentinelUtilities.isRegexTargeted(entity.getEquipment().getItemInHand().getType().name(), this.byHeldItem)) {
            return true;
        }
        for (SentinelIntegration integration : SentinelPlugin.integrations) {
            for (String text : this.byOther) {
                if (!integration.isTarget(entity, text)) continue;
                return true;
            }
        }
        if (entity.hasMetadata("NPC")) {
            return this.targetsProcessed.contains(SentinelTarget.NPCS) || SentinelUtilities.isRegexTargeted(CitizensAPI.getNPCRegistry().getNPC((Entity)entity).getName(), this.byNpcName);
        }
        if (entity instanceof Player) {
            if (SentinelUtilities.isRegexTargeted(((Player)entity).getName(), this.byPlayerName)) {
                return true;
            }
            if (SentinelPlugin.instance.vaultPerms != null) {
                for (String group : this.byGroup) {
                    if (!SentinelPlugin.instance.vaultPerms.playerInGroup((Player)entity, group)) continue;
                    return true;
                }
            }
        } else if (SentinelUtilities.isRegexTargeted(entity.getCustomName() == null ? entity.getType().name() : entity.getCustomName(), this.byEntityName)) {
            return true;
        }
        HashSet<SentinelTarget> possible = SentinelPlugin.entityToTargets.get(entity.getType());
        for (SentinelTarget poss : possible) {
            if (!this.targetsProcessed.contains(poss)) continue;
            return true;
        }
        return false;
    }

    public void fillListFromKey(ArrayList<String> list, DataKey key) {
        for (DataKey listEntry : key.getSubKeys()) {
            list.add(listEntry.getRaw("").toString());
        }
    }

    public void updateOld(DataKey key, String name) {
        if (name.equals("playerName")) {
            this.fillListFromKey(this.byPlayerName, key);
        } else if (name.equals("npcName")) {
            this.fillListFromKey(this.byNpcName, key);
        } else if (name.equals("entityName")) {
            this.fillListFromKey(this.byEntityName, key);
        } else if (name.equals("heldItem")) {
            this.fillListFromKey(this.byHeldItem, key);
        } else if (name.equals("group")) {
            this.fillListFromKey(this.byGroup, key);
        } else if (name.equals("event")) {
            this.fillListFromKey(this.byEvent, key);
        } else if (name.equals("other")) {
            this.fillListFromKey(this.byOther, key);
        }
    }

    public boolean isEventTarget(EntityDamageByEntityEvent event) {
        if (this.byEvent.contains("pvp") && event.getEntity() instanceof Player && !CitizensAPI.getNPCRegistry().isNPC(event.getEntity())) {
            return true;
        }
        if (this.byEvent.contains("pve") && !(event.getEntity() instanceof Player) && event.getEntity() instanceof LivingEntity) {
            return true;
        }
        if (this.byEvent.contains("pvnpc") && event.getEntity() instanceof LivingEntity && CitizensAPI.getNPCRegistry().isNPC(event.getEntity())) {
            return true;
        }
        return this.byEvent.contains("pvsentinel") && event.getEntity() instanceof LivingEntity && CitizensAPI.getNPCRegistry().isNPC(event.getEntity()) && CitizensAPI.getNPCRegistry().getNPC(event.getEntity()).hasTrait(SentinelTrait.class);
    }

    public void checkRecalculateTargetsCache() {
        if (this.targets.size() != this.targetsProcessed.size()) {
            this.recalculateTargetsCache();
        }
    }

    public void recalculateTargetsCache() {
        this.targetsProcessed.clear();
        for (String string : this.targets) {
            this.targetsProcessed.add(SentinelTarget.forName(string));
        }
        this.targets.clear();
        for (SentinelTarget sentinelTarget : this.targetsProcessed) {
            this.targets.add(sentinelTarget.name());
        }
    }
}

