/*
 * Decompiled with CFR 0.152.
 */
package org.mcmonkey.sentinel;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.UUID;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.ai.StuckAction;
import net.citizensnpcs.api.ai.TeleportStuckAction;
import net.citizensnpcs.api.ai.speech.SpeechContext;
import net.citizensnpcs.api.event.DespawnReason;
import net.citizensnpcs.api.persistence.Persist;
import net.citizensnpcs.api.persistence.PersistenceLoader;
import net.citizensnpcs.api.persistence.Persister;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.trait.trait.Spawned;
import net.citizensnpcs.api.util.DataKey;
import net.citizensnpcs.trait.CurrentLocation;
import net.citizensnpcs.trait.waypoint.WanderWaypointProvider;
import net.citizensnpcs.trait.waypoint.Waypoint;
import net.citizensnpcs.trait.waypoint.WaypointProvider;
import net.citizensnpcs.trait.waypoint.Waypoints;
import net.citizensnpcs.util.NMS;
import net.citizensnpcs.util.PlayerAnimation;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.projectiles.ProjectileSource;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;
import org.mcmonkey.sentinel.SentinelAttackHelper;
import org.mcmonkey.sentinel.SentinelCurrentTarget;
import org.mcmonkey.sentinel.SentinelItemHelper;
import org.mcmonkey.sentinel.SentinelPlugin;
import org.mcmonkey.sentinel.SentinelUtilities;
import org.mcmonkey.sentinel.SentinelWeaponHelper;
import org.mcmonkey.sentinel.targeting.SentinelTarget;
import org.mcmonkey.sentinel.targeting.SentinelTargetList;
import org.mcmonkey.sentinel.targeting.SentinelTargetingHelper;

public class SentinelTrait
extends Trait {
    public static final double healthMin = 0.01;
    public static final int attackRateMax = 2000;
    public static final int healRateMax = 2000;
    public SentinelTargetingHelper targetingHelper;
    public SentinelItemHelper itemHelper;
    public SentinelWeaponHelper weaponHelper;
    public SentinelAttackHelper attackHelper;
    @Persist(value="stats_ticksSpawned")
    public long stats_ticksSpawned = 0L;
    @Persist(value="stats_timesSpawned")
    public long stats_timesSpawned = 0L;
    @Persist(value="stats_arrowsFired")
    public long stats_arrowsFired = 0L;
    @Persist(value="stats_potionsThrow")
    public long stats_potionsThrown = 0L;
    @Persist(value="stats_fireballsFired")
    public long stats_fireballsFired = 0L;
    @Persist(value="stats_snowballsThrown")
    public long stats_snowballsThrown = 0L;
    @Persist(value="stats_eggsThrown")
    public long stats_eggsThrown = 0L;
    @Persist(value="stats_skullsThrown")
    public long stats_skullsThrown = 0L;
    @Persist(value="stats_pearlsUsed")
    public long stats_pearlsUsed = 0L;
    @Persist(value="stats_punches")
    public long stats_punches = 0L;
    @Persist(value="stats_attackAttempts")
    public long stats_attackAttempts = 0L;
    @Persist(value="stats_damageTaken")
    public double stats_damageTaken = 0.0;
    @Persist(value="stats_damageGiven")
    public double stats_damageGiven = 0.0;
    @Persist(value="allTargets")
    public SentinelTargetList allTargets = new SentinelTargetList();
    @Persist(value="allIgnores")
    public SentinelTargetList allIgnores = new SentinelTargetList();
    @Persist(value="allAvoids")
    public SentinelTargetList allAvoids = new SentinelTargetList();
    @Persist
    public double avoidRange = 10.0;
    @Persist(value="range")
    public double range = 20.0;
    @Persist(value="damage")
    public double damage = -1.0;
    @Persist(value="armor")
    public double armor = -1.0;
    @Persist(value="health")
    public double health = 20.0;
    @Persist(value="ranged_chase")
    public boolean rangedChase = false;
    @Persist(value="close_chase")
    public boolean closeChase = true;
    @Persist(value="invincible")
    public boolean invincible = false;
    @Persist(value="fightback")
    public boolean fightback = true;
    @Persist(value="runaway")
    public boolean runaway = false;
    @Persist(value="attackRate")
    public int attackRate = 30;
    @Persist(value="attackRateRanged")
    public int attackRateRanged = 30;
    @Persist(value="healRate")
    public int healRate = 30;
    @Persist(value="guardingUpper")
    public long guardingUpper = 0L;
    @Persist(value="guardingLower")
    public long guardingLower = 0L;
    @Persist(value="needsAmmo")
    public boolean needsAmmo = false;
    @Persist(value="safeShot")
    public boolean safeShot = true;
    @Persist(value="respawnTime")
    public long respawnTime = 100L;
    @Persist(value="chaseRange")
    public double chaseRange = 100.0;
    @Persist(value="spawnPoint")
    public Location spawnPoint = null;
    @Persist(value="drops")
    public ArrayList<ItemStack> drops = new ArrayList();
    @Persist(value="enemyDrops")
    public boolean enemyDrops = false;
    @Persist(value="enemyTargetTime")
    public long enemyTargetTime = 0L;
    @Persist(value="speed")
    public double speed = 1.0;
    @Persist(value="warning_text")
    public String warningText = "";
    @Persist(value="greeting_text")
    public String greetingText = "";
    @Persist(value="greet_range")
    public double greetRange = 10.0;
    @Persist(value="autoswitch")
    public boolean autoswitch = false;
    @Persist(value="squad")
    public String squad = null;
    @Persist(value="accuracy")
    public double accuracy = 0.0;
    @Persist(value="realistic")
    public boolean realistic = false;
    @Persist(value="reach")
    public double reach = 3.0;
    @Persist(value="guard_distance_minimum")
    public double guardDistanceMinimum = 7.0;
    @Persist(value="guard_selection_range")
    public double guardSelectionRange = 4.0;
    public LivingEntity chasing = null;
    private boolean canEnforce = false;
    private SentinelCurrentTarget tempTarget = new SentinelCurrentTarget();
    private HashSet<UUID> greetedAlready = new HashSet();
    public long timeSinceAttack = 0L;
    public long timeSinceHeal = 0L;
    int cleverTicks = 0;
    public boolean chased = false;
    private boolean visionMarked;
    public int ticksCountGuard = 0;
    public boolean needsToUnpause = false;
    public Location pathingTo = null;
    public boolean needsSafeReturn = true;
    private static final double MAX_DIST = 1.0E8;
    private Boolean waypointHelperAvailable = null;
    public int cTick = 0;
    public BukkitRunnable respawnMe;
    public HashMap<UUID, Boolean> needsDropsClear = new HashMap();

    public SentinelTrait() {
        super("sentinel");
        this.targetingHelper = new SentinelTargetingHelper();
        this.itemHelper = new SentinelItemHelper();
        this.weaponHelper = new SentinelWeaponHelper();
        this.attackHelper = new SentinelAttackHelper();
        this.targetingHelper.setTraitObject(this);
        this.itemHelper.setTraitObject(this);
        this.weaponHelper.setTraitObject(this);
        this.attackHelper.setTraitObject(this);
    }

    public void load(final DataKey key) {
        new BukkitRunnable(){

            public void run() {
                SentinelTrait.this.updateOld(key);
            }
        }.runTaskLater((Plugin)SentinelPlugin.instance, 1L);
    }

    public void save(DataKey key) {
        for (DataKey subkey : key.getSubKeys()) {
            if (!subkey.name().equals("targets") && !subkey.name().equals("ignores") && !subkey.name().endsWith("Targets") && !subkey.name().endsWith("Ignores")) continue;
            key.removeKey(subkey.name());
        }
    }

    public void updateOld(DataKey key) {
        for (DataKey subkey : key.getSubKeys()) {
            if (subkey.name().equals("targets")) {
                for (DataKey listEntry : subkey.getSubKeys()) {
                    this.allTargets.targets.add(listEntry.getRaw("").toString());
                }
                this.allTargets.recalculateTargetsCache();
            } else if (subkey.name().equals("ignores")) {
                for (DataKey listEntry : subkey.getSubKeys()) {
                    this.allIgnores.targets.add(listEntry.getRaw("").toString());
                }
                this.allIgnores.recalculateTargetsCache();
            }
            if (subkey.name().endsWith("Targets")) {
                this.allTargets.updateOld(subkey, subkey.name().substring(0, subkey.name().length() - "Targets".length()));
                continue;
            }
            if (!subkey.name().endsWith("Ignores")) continue;
            this.allIgnores.updateOld(subkey, subkey.name().substring(0, subkey.name().length() - "Ignores".length()));
        }
    }

    public UUID getGuarding() {
        if (this.guardingLower == 0L && this.guardingUpper == 0L) {
            return null;
        }
        return new UUID(this.guardingUpper, this.guardingLower);
    }

    public void setGuarding(UUID uuid) {
        if (uuid == null) {
            this.guardingUpper = 0L;
            this.guardingLower = 0L;
        } else {
            this.guardingUpper = uuid.getMostSignificantBits();
            this.guardingLower = uuid.getLeastSignificantBits();
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void whenAttacksAreHappening(EntityDamageByEntityEvent event) {
        ProjectileSource source;
        if (!this.npc.isSpawned()) {
            return;
        }
        if (event.isCancelled()) {
            return;
        }
        if (event.getEntity().getUniqueId().equals(this.getLivingEntity().getUniqueId())) {
            if (!event.isApplicable(EntityDamageEvent.DamageModifier.ARMOR)) {
                event.setDamage(EntityDamageEvent.DamageModifier.BASE, (1.0 - this.getArmor(this.getLivingEntity())) * event.getDamage(EntityDamageEvent.DamageModifier.BASE));
            } else {
                event.setDamage(EntityDamageEvent.DamageModifier.ARMOR, -this.getArmor(this.getLivingEntity()) * event.getDamage(EntityDamageEvent.DamageModifier.BASE));
            }
            return;
        }
        if (event.getDamager().getUniqueId().equals(this.getLivingEntity().getUniqueId())) {
            if (SentinelPlugin.instance.alternateDamage) {
                if (this.canEnforce) {
                    this.canEnforce = false;
                    this.whenAttacksHappened(event);
                    if (!event.isCancelled()) {
                        ((LivingEntity)event.getEntity()).damage(event.getFinalDamage());
                        if (event.getEntity() instanceof LivingEntity) {
                            this.weaponHelper.knockback((LivingEntity)event.getEntity());
                        }
                    }
                    if (SentinelPlugin.debugMe) {
                        this.debug("enforce damage value to " + event.getFinalDamage());
                    }
                } else if (SentinelPlugin.debugMe) {
                    this.debug("refuse damage enforcement");
                }
                event.setDamage(0.0);
                event.setCancelled(true);
                return;
            }
            event.setDamage(EntityDamageEvent.DamageModifier.BASE, this.getDamage());
        }
        if (event.getDamager() instanceof Projectile && (source = ((Projectile)event.getDamager()).getShooter()) instanceof LivingEntity && ((LivingEntity)source).getUniqueId().equals(this.getLivingEntity().getUniqueId())) {
            if (SentinelPlugin.instance.alternateDamage) {
                if (this.canEnforce) {
                    this.canEnforce = false;
                    this.whenAttacksHappened(event);
                    if (!event.isCancelled()) {
                        ((LivingEntity)event.getEntity()).damage(this.getDamage());
                        if (event.getEntity() instanceof LivingEntity) {
                            this.weaponHelper.knockback((LivingEntity)event.getEntity());
                        }
                    }
                    if (SentinelPlugin.debugMe) {
                        this.debug("enforce damage value to " + this.getDamage());
                    }
                } else if (SentinelPlugin.debugMe) {
                    this.debug("refuse damage enforcement");
                }
                event.setDamage(0.0);
                event.setCancelled(true);
                return;
            }
            double dam = this.getDamage();
            double modder = event.getDamage(EntityDamageEvent.DamageModifier.BASE);
            double rel = modder == 0.0 ? 1.0 : dam / modder;
            event.setDamage(EntityDamageEvent.DamageModifier.BASE, dam);
            for (EntityDamageEvent.DamageModifier mod : EntityDamageEvent.DamageModifier.values()) {
                if (mod == EntityDamageEvent.DamageModifier.BASE || !event.isApplicable(mod)) continue;
                event.setDamage(mod, event.getDamage(mod) * rel);
                if (!SentinelPlugin.debugMe) continue;
                this.debug("Set damage for " + mod + " to " + event.getDamage(mod));
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void whenAttacksHappened(EntityDamageByEntityEvent event) {
        ProjectileSource source;
        if (!this.npc.isSpawned()) {
            return;
        }
        if (event.isCancelled()) {
            return;
        }
        Entity damager = event.getDamager();
        LivingEntity projectileSource = null;
        if (event.getDamager() instanceof Projectile && (source = ((Projectile)event.getDamager()).getShooter()) instanceof LivingEntity) {
            projectileSource = (LivingEntity)source;
            damager = projectileSource;
        }
        boolean isMe = event.getEntity().getUniqueId().equals(this.getLivingEntity().getUniqueId());
        if (SentinelPlugin.instance.protectFromIgnores && isMe) {
            if (event.getDamager() instanceof LivingEntity && this.targetingHelper.isIgnored((LivingEntity)event.getDamager())) {
                event.setCancelled(true);
                return;
            }
            if (projectileSource != null && this.targetingHelper.isIgnored(projectileSource)) {
                event.setCancelled(true);
                return;
            }
        }
        boolean isKilling = event.getEntity() instanceof LivingEntity && event.getFinalDamage() >= ((LivingEntity)event.getEntity()).getHealth();
        boolean isFriend = this.getGuarding() != null && event.getEntity().getUniqueId().equals(this.getGuarding());
        boolean attackerIsMe = event.getDamager().getUniqueId().equals(this.getLivingEntity().getUniqueId());
        if (projectileSource != null && projectileSource.getUniqueId().equals(this.getLivingEntity().getUniqueId())) {
            attackerIsMe = true;
        }
        if (isMe || isFriend) {
            if (attackerIsMe) {
                if (SentinelPlugin.debugMe) {
                    this.debug("Ignoring damage I did to " + (isMe ? "myself." : "my friend."));
                }
                event.setCancelled(true);
                return;
            }
            if (this.getGuarding() != null && damager.getUniqueId().equals(this.getGuarding())) {
                if (isMe && SentinelPlugin.instance.noGuardDamage) {
                    if (SentinelPlugin.debugMe) {
                        this.debug("Ignoring damage from the player we're guarding.");
                    }
                    event.setCancelled(true);
                }
                return;
            }
            if (isMe) {
                this.stats_damageTaken += event.getFinalDamage();
                if (this.runaway) {
                    if (SentinelPlugin.debugMe) {
                        this.debug("Ow! They hit me! Run!");
                    }
                    this.targetingHelper.addAvoid(event.getDamager().getUniqueId());
                }
            }
            if (this.fightback && damager instanceof LivingEntity && !this.targetingHelper.isIgnored((LivingEntity)damager)) {
                if (SentinelPlugin.debugMe) {
                    this.debug("Fighting back against attacker: " + event.getDamager().getUniqueId() + "! They hurt " + (isMe ? "me!" : "my friend!"));
                }
                this.targetingHelper.addTarget(event.getDamager().getUniqueId());
            }
            if (SentinelPlugin.debugMe && isMe) {
                this.debug("Took damage of " + event.getFinalDamage() + " with currently remaining health " + this.getLivingEntity().getHealth() + (isKilling ? ". This will kill me." : "."));
            }
            if (isKilling && isMe && SentinelPlugin.instance.blockEvents) {
                if (SentinelPlugin.debugMe) {
                    this.debug("Died! Applying death workaround (due to config setting)");
                }
                this.generalDeathHandler(this.getLivingEntity());
                this.npc.despawn(DespawnReason.PLUGIN);
                event.setCancelled(true);
                return;
            }
            return;
        }
        if (attackerIsMe) {
            if (this.safeShot && !this.targetingHelper.shouldTarget((LivingEntity)event.getEntity())) {
                event.setCancelled(true);
                return;
            }
            this.stats_damageGiven += event.getFinalDamage();
            if (!this.enemyDrops) {
                this.needsDropsClear.put(event.getEntity().getUniqueId(), true);
            }
            return;
        }
        if (this.allTargets.isEventTarget(event) && damager instanceof LivingEntity && this.targetingHelper.canSee((LivingEntity)damager) && !this.targetingHelper.isIgnored((LivingEntity)damager)) {
            this.targetingHelper.addTarget(damager.getUniqueId());
        }
        if (this.allAvoids.isEventTarget(event) && damager instanceof LivingEntity && this.targetingHelper.canSee((LivingEntity)damager) && !this.targetingHelper.isIgnored((LivingEntity)damager)) {
            this.targetingHelper.addTarget(damager.getUniqueId());
        }
    }

    @EventHandler
    public void whenAnEnemyDies(EntityDeathEvent event) {
        this.tempTarget.targetID = event.getEntity().getUniqueId();
        this.targetingHelper.currentTargets.remove(this.tempTarget);
        this.targetingHelper.currentAvoids.remove(this.tempTarget);
    }

    public void onAttach() {
        FileConfiguration config = SentinelPlugin.instance.getConfig();
        this.attackRate = config.getInt("sentinel defaults.attack rate", 30);
        this.healRate = config.getInt("sentinel defaults.heal rate", 30);
        this.respawnTime = config.getInt("sentinel defaults.respawn time", 100);
        this.rangedChase = config.getBoolean("sentinel defaults.ranged chase target", false);
        this.closeChase = config.getBoolean("sentinel defaults.close chase target", true);
        this.armor = config.getDouble("sentinel defaults.armor", -1.0);
        this.damage = config.getDouble("sentinel defaults.damage", -1.0);
        this.health = config.getDouble("sentinel defaults.health", 20.0);
        if (this.npc.isSpawned()) {
            this.getLivingEntity().setMaxHealth(this.health);
            this.getLivingEntity().setHealth(this.health);
        }
        this.setInvincible(config.getBoolean("sentinel defaults.invincible", false));
        this.fightback = config.getBoolean("sentinel defaults.fightback", true);
        this.needsAmmo = config.getBoolean("sentinel defaults.needs ammo", false);
        this.safeShot = config.getBoolean("sentinel defaults.safe shot", true);
        this.enemyDrops = config.getBoolean("sentinel defaults.enemy drops", false);
        this.enemyTargetTime = config.getInt("sentinel defaults.enemy target time", 0);
        this.speed = config.getInt("sentinel defaults.speed", 1);
        if (this.speed <= 0.0) {
            this.speed = 1.0;
        }
        this.autoswitch = config.getBoolean("sentinel defaults.autoswitch", false);
        this.allIgnores.targets.add(SentinelTarget.OWNER.name());
        this.allIgnores.recalculateTargetsCache();
        this.reach = config.getDouble("sentinel defaults.reach", 3.0);
        this.avoidRange = config.getDouble("sentinel defaults.avoid range", 10.0);
        this.runaway = config.getBoolean("sentinel defaults.runaway", false);
        this.guardDistanceMinimum = SentinelPlugin.instance.guardDistanceMinimum;
        this.guardSelectionRange = SentinelPlugin.instance.guardDistanceSelectionRange;
    }

    public void useItem() {
        if (this.npc.isSpawned() && this.getLivingEntity() instanceof Player && SentinelTarget.v1_9) {
            PlayerAnimation.START_USE_MAINHAND_ITEM.play((Player)this.getLivingEntity());
            BukkitRunnable runner = new BukkitRunnable(){

                public void run() {
                    if (SentinelTrait.this.npc.isSpawned() && SentinelTrait.this.getLivingEntity() instanceof Player) {
                        PlayerAnimation.STOP_USE_ITEM.play((Player)SentinelTrait.this.getLivingEntity());
                    }
                }
            };
            runner.runTaskLater((Plugin)SentinelPlugin.instance, 10L);
        }
    }

    public void swingWeapon() {
        if (this.npc.isSpawned() && this.getLivingEntity() instanceof Player) {
            PlayerAnimation.ARM_SWING.play((Player)this.getLivingEntity());
        }
    }

    public double firingMinimumRange() {
        EntityType type = this.getLivingEntity().getType();
        if (type == EntityType.WITHER || type == EntityType.GHAST) {
            return 8.0;
        }
        return 2.0;
    }

    public AbstractMap.SimpleEntry<Location, Vector> getLaunchDetail(Location target, Vector lead) {
        this.faceLocation(target);
        Location start = this.getLivingEntity().getEyeLocation().clone().add(this.getLivingEntity().getEyeLocation().getDirection().multiply(this.firingMinimumRange()));
        return SentinelUtilities.getLaunchDetail(start, target, lead);
    }

    public double randomAcc() {
        return SentinelUtilities.random.nextDouble() * this.accuracy * 2.0 - this.accuracy;
    }

    public Vector fixForAcc(Vector input) {
        if (Double.isInfinite(input.getX()) || Double.isNaN(input.getX())) {
            return new Vector(0, 0, 0);
        }
        return new Vector(input.getX() + this.randomAcc(), input.getY() + this.randomAcc(), input.getZ() + this.randomAcc());
    }

    public void faceLocation(Location l) {
        this.npc.faceLocation(l.clone().subtract(0.0, this.getLivingEntity().getEyeHeight(), 0.0));
    }

    public double getDamage() {
        if (this.damage >= 0.0) {
            return this.damage;
        }
        ItemStack weapon = this.itemHelper.getHeldItem();
        if (weapon == null) {
            return 1.0;
        }
        double multiplier = 1.0;
        multiplier += weapon.getItemMeta() == null || !weapon.getItemMeta().hasEnchant(Enchantment.DAMAGE_ALL) ? 0.0 : (double)weapon.getItemMeta().getEnchantLevel(Enchantment.DAMAGE_ALL) * 0.2;
        Material weaponType = weapon.getType();
        if (SentinelTarget.BOW_MATERIALS.contains(weaponType)) {
            return 6.0 * (1.0 + (weapon.getItemMeta() == null || !weapon.getItemMeta().hasEnchant(Enchantment.ARROW_DAMAGE) ? 0.0 : (double)weapon.getItemMeta().getEnchantLevel(Enchantment.ARROW_DAMAGE) * 0.3));
        }
        Double damageMult = SentinelTarget.WEAPON_DAMAGE_MULTIPLIERS.get(weaponType);
        if (damageMult == null) {
            return multiplier;
        }
        return multiplier * damageMult;
    }

    public double getArmor(LivingEntity ent) {
        if (this.armor < 0.0) {
            ItemStack boots;
            Double bootsAdder;
            ItemStack leggings;
            Double leggingsAdder;
            ItemStack chestplate;
            Double chestplateAdder;
            Double helmetAdder;
            double baseArmor = 0.0;
            ItemStack helmet = ent.getEquipment().getHelmet();
            Double d = helmetAdder = helmet == null ? null : SentinelTarget.ARMOR_PROTECTION_MULTIPLIERS.get(helmet.getType());
            if (helmetAdder != null) {
                baseArmor += helmetAdder.doubleValue();
            }
            Double d2 = chestplateAdder = (chestplate = ent.getEquipment().getChestplate()) == null ? null : SentinelTarget.ARMOR_PROTECTION_MULTIPLIERS.get(chestplate.getType());
            if (chestplateAdder != null) {
                baseArmor += chestplateAdder.doubleValue();
            }
            Double d3 = leggingsAdder = (leggings = ent.getEquipment().getLeggings()) == null ? null : SentinelTarget.ARMOR_PROTECTION_MULTIPLIERS.get(leggings.getType());
            if (leggingsAdder != null) {
                baseArmor += leggingsAdder.doubleValue();
            }
            Double d4 = bootsAdder = (boots = ent.getEquipment().getBoots()) == null ? null : SentinelTarget.ARMOR_PROTECTION_MULTIPLIERS.get(boots.getType());
            if (bootsAdder != null) {
                baseArmor += bootsAdder.doubleValue();
            }
            return Math.min(baseArmor, 0.8);
        }
        return this.armor;
    }

    public LivingEntity getLivingEntity() {
        return (LivingEntity)this.npc.getEntity();
    }

    public void specialMarkVision() {
        if (SentinelPlugin.debugMe && !this.visionMarked) {
            this.debug("Target! I see you, " + (this.chasing == null ? "(Unknown)" : this.chasing.getName()));
        }
        if (SentinelTarget.v1_11 && this.getLivingEntity().getType() == EntityType.SHULKER) {
            NMS.setPeekShulker((Entity)this.getLivingEntity(), (int)100);
        }
        this.visionMarked = true;
    }

    public void specialUnmarkVision() {
        if (SentinelPlugin.debugMe && this.visionMarked) {
            this.debug("Goodbye, visible target " + (this.chasing == null ? "(Unknown)" : this.chasing.getName()));
        }
        if (SentinelTarget.v1_11 && this.getLivingEntity().getType() == EntityType.SHULKER) {
            NMS.setPeekShulker((Entity)this.getLivingEntity(), (int)0);
        }
        this.visionMarked = false;
    }

    public void pathTo(Location target) {
        this.pauseWaypoints();
        this.pathingTo = target;
        this.npc.getNavigator().getDefaultParameters().distanceMargin(1.5);
        this.getNPC().getNavigator().setTarget(target);
        this.chasing = null;
        this.needsSafeReturn = true;
    }

    public void pauseWaypoints() {
        Waypoints wp = (Waypoints)this.npc.getTrait(Waypoints.class);
        if (!wp.getCurrentProvider().isPaused()) {
            wp.getCurrentProvider().setPaused(true);
        }
        this.needsToUnpause = true;
        this.needsSafeReturn = true;
    }

    public void runUpdate() {
        Player player;
        Location near;
        this.canEnforce = true;
        this.timeSinceAttack += (long)SentinelPlugin.instance.tickRate;
        this.timeSinceHeal += (long)SentinelPlugin.instance.tickRate;
        if (this.getLivingEntity().getLocation().getY() <= 0.0) {
            if (SentinelPlugin.debugMe) {
                this.debug("Injuring self, I'm below the map!");
            }
            this.getLivingEntity().damage(1.0);
            if (!this.npc.isSpawned()) {
                if (this.getGuarding() != null && Bukkit.getPlayer((UUID)this.getGuarding()) != null && this.respawnTime > 0L && this.respawnMe == null) {
                    this.npc.spawn(Bukkit.getPlayer((UUID)this.getGuarding()).getLocation());
                }
                return;
            }
        }
        if (this.health != this.getLivingEntity().getMaxHealth()) {
            this.getLivingEntity().setMaxHealth(this.health);
        }
        if (this.healRate > 0 && this.timeSinceHeal > (long)this.healRate && this.getLivingEntity().getHealth() < this.health) {
            this.getLivingEntity().setHealth(Math.min(this.getLivingEntity().getHealth() + 1.0, this.health));
            this.timeSinceHeal = 0L;
        }
        if (!this.npc.getNavigator().isNavigating()) {
            this.pathingTo = null;
        }
        if ((this.getGuarding() != null || this.chasing != null || this.pathingTo != null) && this.npc.hasTrait(Waypoints.class)) {
            this.pauseWaypoints();
        } else if (this.needsToUnpause && this.npc.hasTrait(Waypoints.class)) {
            Waypoints wp = (Waypoints)this.npc.getTrait(Waypoints.class);
            wp.getCurrentProvider().setPaused(false);
            this.needsToUnpause = false;
        }
        this.targetingHelper.updateTargets();
        this.targetingHelper.updateAvoids();
        double crsq = this.chaseRange * this.chaseRange;
        boolean goHome = this.chased;
        LivingEntity target = this.targetingHelper.findBestTarget();
        if (target != null) {
            near = this.nearestPathPoint();
            if (SentinelPlugin.debugMe) {
                this.debug("target selected to be " + target.getName());
            }
            if (crsq <= 0.0 || near == null || near.distanceSquared(target.getLocation()) <= crsq) {
                if (SentinelPlugin.debugMe) {
                    this.debug("Attack target within range of safe zone: " + (near == null ? "Any" : Double.valueOf(near.distanceSquared(target.getLocation()))));
                }
                if (this.chasing == null) {
                    this.specialMarkVision();
                }
                this.chasing = target;
                this.needsSafeReturn = true;
                this.cleverTicks = 0;
                this.attackHelper.tryAttack(target);
                goHome = false;
            } else {
                if (SentinelPlugin.debugMe) {
                    this.debug("Actually, that target is bad!");
                }
                this.specialUnmarkVision();
                target = null;
                this.chasing = null;
                this.cleverTicks = 0;
            }
        } else if (this.chasing != null && this.chasing.isValid()) {
            this.needsSafeReturn = true;
            if (SentinelPlugin.instance.workaroundEntityChasePathfinder) {
                this.attackHelper.rechase();
            }
            ++this.cleverTicks;
            if (this.cleverTicks >= SentinelPlugin.instance.cleverTicks) {
                this.specialUnmarkVision();
                this.chasing = null;
            } else {
                near = this.nearestPathPoint();
                if (crsq <= 0.0 || near == null || near.distanceSquared(this.chasing.getLocation()) <= crsq) {
                    this.attackHelper.tryAttack(this.chasing);
                    goHome = false;
                }
            }
        } else if (this.chasing == null) {
            this.specialUnmarkVision();
        }
        if (this.getGuarding() != null && (player = Bukkit.getPlayer((UUID)this.getGuarding())) != null) {
            double dist;
            Location myLoc = this.getLivingEntity().getLocation();
            Location theirLoc = player.getLocation();
            double d = dist = theirLoc.getWorld().equals(myLoc.getWorld()) ? myLoc.distanceSquared(theirLoc) : 1.0E8;
            if (dist > 3600.0) {
                this.npc.teleport(player.getLocation(), PlayerTeleportEvent.TeleportCause.PLUGIN);
            }
            if (dist > this.guardDistanceMinimum * this.guardDistanceMinimum) {
                this.ticksCountGuard += SentinelPlugin.instance.tickRate;
                if (this.ticksCountGuard >= 30) {
                    this.ticksCountGuard = 0;
                    this.npc.getNavigator().getDefaultParameters().distanceMargin((double)SentinelPlugin.instance.guardDistanceMargin);
                    this.npc.getNavigator().getDefaultParameters().range(100.0f);
                    this.npc.getNavigator().getDefaultParameters().stuckAction((StuckAction)TeleportStuckAction.INSTANCE);
                    this.npc.getNavigator().setTarget(SentinelUtilities.pickNear(player.getLocation(), this.guardSelectionRange));
                    this.npc.getNavigator().getLocalParameters().speedModifier((float)this.speed);
                    this.chased = true;
                }
            }
            this.needsSafeReturn = true;
            goHome = false;
        }
        this.targetingHelper.processAvoidance();
        if (this.pathingTo != null) {
            goHome = false;
            this.needsSafeReturn = true;
        }
        if (goHome && this.chaseRange > 0.0 && target == null && this.needsSafeReturn) {
            near = this.nearestPathPoint();
            if (near != null && (this.chasing == null || near.distanceSquared(this.chasing.getLocation()) > crsq)) {
                if (SentinelPlugin.debugMe && near.distanceSquared(this.getLivingEntity().getLocation()) > 9.0) {
                    this.debug("screw you guys, I'm going home!");
                }
                this.npc.getNavigator().getDefaultParameters().stuckAction((StuckAction)TeleportStuckAction.INSTANCE);
                this.npc.getNavigator().setTarget(near);
                this.npc.getNavigator().getLocalParameters().speedModifier((float)this.speed);
                this.needsSafeReturn = false;
                this.chased = false;
            } else {
                if (this.pathingTo == null && this.npc.getNavigator().isNavigating()) {
                    this.npc.getNavigator().cancelNavigation();
                    this.needsSafeReturn = false;
                }
                if (SentinelPlugin.debugMe && near != null && near.distanceSquared(this.getLivingEntity().getLocation()) > 9.0) {
                    this.debug("I'll just stand here and hope they come out...");
                }
            }
        } else if (this.chasing == null && this.pathingTo == null && this.npc.getNavigator().isNavigating() && this.needsSafeReturn) {
            this.npc.getNavigator().cancelNavigation();
            this.needsSafeReturn = false;
        }
    }

    public Location getGuardZone() {
        Location goal;
        Player player;
        if (this.getGuarding() != null && (player = Bukkit.getPlayer((UUID)this.getGuarding())) != null) {
            return player.getLocation();
        }
        if (this.chaseRange > 0.0 && (goal = this.nearestPathPoint()) != null) {
            return goal;
        }
        return this.getLivingEntity().getLocation();
    }

    public Location nearestPathPoint() {
        if (!SentinelTarget.v1_9) {
            if (this.waypointHelperAvailable == null) {
                try {
                    Class.forName("net.citizensnpcs.trait.waypoint.WaypointProvider.EnumerableWaypointProvider");
                    this.waypointHelperAvailable = true;
                }
                catch (ClassNotFoundException ex) {
                    this.waypointHelperAvailable = false;
                    SentinelPlugin.instance.getLogger().warning("Citizens installation is **very outdated** and does not contain newer useful APIs. Please update your installation of the Citizens plugin!");
                }
            }
            if (!this.waypointHelperAvailable.booleanValue()) {
                return null;
            }
        }
        if (!this.npc.hasTrait(Waypoints.class)) {
            return null;
        }
        if (this.getGuarding() != null) {
            return null;
        }
        Location baseloc = this.getLivingEntity().getLocation();
        Location nearest = null;
        double dist = 1.0E8;
        Waypoints wp = (Waypoints)this.npc.getTrait(Waypoints.class);
        if (wp.getCurrentProvider() instanceof WaypointProvider.EnumerableWaypointProvider) {
            for (Waypoint wayp : ((WaypointProvider.EnumerableWaypointProvider)wp.getCurrentProvider()).waypoints()) {
                double d;
                Location l = wayp.getLocation();
                if (!l.getWorld().equals(baseloc.getWorld()) || !((d = baseloc.distanceSquared(l)) < dist)) continue;
                dist = d;
                nearest = l;
            }
        } else if (wp.getCurrentProvider() instanceof WanderWaypointProvider) {
            for (Location loc : ((WanderWaypointProvider)wp.getCurrentProvider()).getRegionCentres()) {
                double d;
                if (!loc.getWorld().equals(baseloc.getWorld()) || !((d = baseloc.distanceSquared(loc)) < dist)) continue;
                dist = d;
                nearest = loc;
            }
        } else {
            return null;
        }
        return nearest;
    }

    public void run() {
        if (!this.npc.isSpawned()) {
            return;
        }
        ++this.stats_ticksSpawned;
        ++this.cTick;
        if (this.cTick >= SentinelPlugin.instance.tickRate) {
            this.cTick = 0;
            this.runUpdate();
        }
    }

    public void onSpawn() {
        ++this.stats_timesSpawned;
        this.setHealth(this.health);
        this.setInvincible(this.invincible);
        if (this.respawnMe != null) {
            this.respawnMe.cancel();
            this.respawnMe = null;
        }
    }

    public void sayTo(Player player, String message) {
        SpeechContext sc = new SpeechContext(this.npc, message, (LivingEntity)player);
        this.npc.getDefaultSpeechController().speak(sc, "chat");
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerTeleports(final PlayerTeleportEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (this.getGuarding() == null) {
            return;
        }
        if (!event.getPlayer().getUniqueId().equals(this.getGuarding())) {
            return;
        }
        if (!this.npc.isSpawned()) {
            return;
        }
        if (event.getFrom().getWorld().equals(event.getTo().getWorld())) {
            this.npc.teleport(event.getTo(), PlayerTeleportEvent.TeleportCause.PLUGIN);
        } else {
            event.getFrom().getChunk().load();
            event.getTo().getChunk().load();
            Bukkit.getScheduler().runTaskLater((Plugin)SentinelPlugin.instance, new Runnable(){

                @Override
                public void run() {
                    if (!event.getPlayer().getWorld().equals(event.getTo().getWorld())) {
                        return;
                    }
                    event.getFrom().getChunk().load();
                    event.getTo().getChunk().load();
                    SentinelTrait.this.npc.spawn(event.getTo());
                }
            }, 1L);
        }
    }

    @EventHandler
    public void onPlayerMovesInRange(PlayerMoveEvent event) {
        if (!this.npc.isSpawned()) {
            return;
        }
        if (!event.getTo().getWorld().equals(this.getLivingEntity().getLocation().getWorld())) {
            return;
        }
        if (event.getTo().toVector().equals((Object)event.getFrom().toVector())) {
            return;
        }
        double dist = event.getTo().distanceSquared(this.getLivingEntity().getLocation());
        boolean known = this.greetedAlready.contains(event.getPlayer().getUniqueId());
        if (dist < this.greetRange * this.greetRange && !known && this.targetingHelper.canSee((LivingEntity)event.getPlayer())) {
            this.greetedAlready.add(event.getPlayer().getUniqueId());
            boolean enemy = this.targetingHelper.shouldTarget((LivingEntity)event.getPlayer());
            if (enemy && this.warningText != null && this.warningText.length() > 0) {
                this.sayTo(event.getPlayer(), this.warningText);
            } else if (!enemy && this.greetingText != null && this.greetingText.length() > 0) {
                this.sayTo(event.getPlayer(), this.greetingText);
            }
        } else if (dist >= this.greetRange * this.greetRange + 1.0 && known) {
            this.greetedAlready.remove(event.getPlayer().getUniqueId());
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void whenSomethingMightDie(EntityDamageByEntityEvent event) {
        this.needsDropsClear.remove(event.getEntity().getUniqueId());
    }

    public void debug(String message) {
        if (SentinelPlugin.debugMe) {
            SentinelPlugin.instance.getLogger().info("Sentinel Debug: " + this.npc.getId() + "/" + this.npc.getName() + ": " + message);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void whenWeDie(EntityDeathEvent event) {
        if (CitizensAPI.getNPCRegistry().isNPC((Entity)event.getEntity()) && CitizensAPI.getNPCRegistry().getNPC((Entity)event.getEntity()).getUniqueId().equals(this.npc.getUniqueId())) {
            if (SentinelPlugin.debugMe) {
                this.debug("Died! Death event received.");
            }
            event.getDrops().clear();
            if (event instanceof PlayerDeathEvent && !SentinelPlugin.instance.deathMessages) {
                ((PlayerDeathEvent)event).setDeathMessage("");
            }
            if (!SentinelPlugin.instance.workaroundDrops) {
                event.getDrops().addAll(this.drops);
            }
            event.setDroppedExp(0);
            this.generalDeathHandler(event.getEntity());
        }
    }

    public void generalDeathHandler(LivingEntity entity) {
        if (this.spawnPoint != null) {
            ((CurrentLocation)this.npc.getTrait(CurrentLocation.class)).setLocation(this.spawnPoint.clone());
        }
        if (SentinelPlugin.instance.workaroundDrops) {
            for (ItemStack item : this.drops) {
                entity.getWorld().dropItemNaturally(entity.getLocation(), item.clone());
            }
        }
        this.onDeath();
    }

    @EventHandler(priority=EventPriority.LOW)
    public void whenSomethingDies(EntityDeathEvent event) {
        if (event.getEntity().getType() != EntityType.PLAYER && this.needsDropsClear.containsKey(event.getEntity().getUniqueId())) {
            event.getDrops().clear();
            event.setDroppedExp(0);
        }
        this.targetingHelper.removeTarget(event.getEntity().getUniqueId());
    }

    public void onDeath() {
        this.greetedAlready.clear();
        this.targetingHelper.currentTargets.clear();
        this.targetingHelper.currentAvoids.clear();
        if (this.respawnTime < 0L) {
            BukkitRunnable removeMe = new BukkitRunnable(){

                public void run() {
                    SentinelTrait.this.npc.destroy();
                }
            };
            removeMe.runTaskLater((Plugin)SentinelPlugin.instance, 1L);
        } else if (this.respawnTime > 0L) {
            final long rsT = this.respawnTime;
            this.respawnMe = new BukkitRunnable(){
                long timer = 0L;

                public void run() {
                    if (CitizensAPI.getNPCRegistry().getById(SentinelTrait.this.npc.getId()) != null) {
                        if (SentinelTrait.this.npc.isSpawned()) {
                            this.cancel();
                            SentinelTrait.this.respawnMe = null;
                            return;
                        }
                        if (this.timer >= rsT) {
                            if (SentinelTrait.this.spawnPoint == null && SentinelTrait.this.npc.getStoredLocation() == null) {
                                SentinelPlugin.instance.getLogger().warning("NPC " + SentinelTrait.this.npc.getId() + " has a null spawn point and can't be spawned. Perhaps the world was deleted?");
                                this.cancel();
                                return;
                            }
                            SentinelTrait.this.npc.spawn(SentinelTrait.this.spawnPoint == null ? SentinelTrait.this.npc.getStoredLocation() : SentinelTrait.this.spawnPoint);
                            this.cancel();
                            SentinelTrait.this.respawnMe = null;
                            return;
                        }
                        this.timer += 10L;
                    } else {
                        SentinelTrait.this.respawnMe = null;
                        this.cancel();
                        return;
                    }
                }
            };
            this.respawnMe.runTaskTimer((Plugin)SentinelPlugin.instance, 10L, 10L);
        } else {
            ((Spawned)this.npc.getTrait(Spawned.class)).setSpawned(false);
        }
    }

    public void onDespawn() {
        this.targetingHelper.currentTargets.clear();
        this.targetingHelper.currentAvoids.clear();
    }

    public void setHealth(double heal) {
        this.health = heal;
        if (this.npc.isSpawned()) {
            this.getLivingEntity().setMaxHealth(this.health);
            this.getLivingEntity().setHealth(this.health);
        }
    }

    public void setInvincible(boolean inv) {
        this.invincible = inv;
        this.npc.setProtected(this.invincible);
    }

    static {
        PersistenceLoader.registerPersistDelegate(SentinelTargetList.class, SentinelTargetListPersister.class);
    }

    public static class SentinelTargetListPersister
    implements Persister<SentinelTargetList> {
        public SentinelTargetList create(DataKey dataKey) {
            return (SentinelTargetList)PersistenceLoader.load((Object)new SentinelTargetList(), (DataKey)dataKey);
        }

        public void save(SentinelTargetList o, DataKey dataKey) {
            PersistenceLoader.save((Object)o, (DataKey)dataKey);
        }
    }
}

