/*
 * Decompiled with CFR 0.152.
 */
package org.mcmonkey.sentinel.targeting;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import org.bukkit.ChatColor;
import org.mcmonkey.sentinel.targeting.SentinelTarget;
import org.mcmonkey.sentinel.targeting.SentinelTargetList;

public class SentinelTargetLabel {
    public String prefix;
    public String value;
    public boolean isRegex;
    public static HashSet<String> regexPrefixes = new HashSet<String>(Arrays.asList("player", "npc", "entityname", "helditem"));
    public static long ignoreMe = 0L;
    private static SentinelTargetList helperList = new SentinelTargetList();

    public boolean isValidRegex() {
        try {
            if (this.isRegex && "Sentinel".matches(this.value)) {
                ++ignoreMe;
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean isValidTarget() {
        if (this.prefix != null) {
            return true;
        }
        return SentinelTarget.forName(this.value) != null;
    }

    public Collection<String> getTargetsList(SentinelTargetList listSet) {
        if (this.prefix == null) {
            return listSet.targets;
        }
        if (this.prefix.equals("player")) {
            return listSet.byPlayerName;
        }
        if (this.prefix.equals("npc")) {
            return listSet.byNpcName;
        }
        if (this.prefix.equals("entityname")) {
            return listSet.byEntityName;
        }
        if (this.prefix.equals("helditem")) {
            return listSet.byHeldItem;
        }
        if (this.prefix.equals("group")) {
            return listSet.byGroup;
        }
        if (this.prefix.equals("event")) {
            return listSet.byEvent;
        }
        return listSet.byOther;
    }

    public String addable() {
        if (this.getTargetsList(helperList) == SentinelTargetLabel.helperList.byOther) {
            return this.prefix + ":" + this.value;
        }
        return this.value;
    }

    public boolean addToList(SentinelTargetList listSet) {
        String addable;
        Collection<String> list = this.getTargetsList(listSet);
        if (list.contains(addable = this.addable())) {
            return false;
        }
        this.getTargetsList(listSet).add(this.addable());
        if (list == listSet.targets) {
            listSet.recalculateTargetsCache();
        }
        return true;
    }

    public boolean removeFromList(SentinelTargetList listSet) {
        String addable;
        Collection<String> list = this.getTargetsList(listSet);
        if (!list.contains(addable = this.addable())) {
            return false;
        }
        this.getTargetsList(listSet).remove(this.addable());
        if (list == listSet.targets) {
            listSet.recalculateTargetsCache();
        }
        return true;
    }

    public SentinelTargetLabel(String label) {
        int index = label.indexOf(58);
        if (index >= 0) {
            this.prefix = label.substring(0, index).toLowerCase();
            this.value = label.substring(index + 1);
            this.isRegex = regexPrefixes.contains(this.prefix);
            this.value = ChatColor.translateAlternateColorCodes((char)'&', (String)this.value);
        } else {
            this.value = label.toUpperCase();
        }
    }
}

