/*
 * Decompiled with CFR 0.152.
 */
package org.mcmonkey.sentinel.targeting;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.UUID;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.astar.AStarGoal;
import net.citizensnpcs.api.astar.AStarMachine;
import net.citizensnpcs.api.astar.AStarNode;
import net.citizensnpcs.api.astar.pathfinder.BlockExaminer;
import net.citizensnpcs.api.astar.pathfinder.BlockSource;
import net.citizensnpcs.api.astar.pathfinder.ChunkBlockSource;
import net.citizensnpcs.api.astar.pathfinder.MinecraftBlockExaminer;
import net.citizensnpcs.api.astar.pathfinder.Path;
import net.citizensnpcs.api.astar.pathfinder.VectorGoal;
import net.citizensnpcs.api.astar.pathfinder.VectorNode;
import net.citizensnpcs.api.npc.NPC;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.util.Vector;
import org.mcmonkey.sentinel.SentinelCurrentTarget;
import org.mcmonkey.sentinel.SentinelHelperObject;
import org.mcmonkey.sentinel.SentinelPlugin;
import org.mcmonkey.sentinel.SentinelTrait;
import org.mcmonkey.sentinel.SentinelUtilities;
import org.mcmonkey.sentinel.events.SentinelNoMoreTargetsEvent;

public class SentinelTargetingHelper
extends SentinelHelperObject {
    public HashSet<SentinelCurrentTarget> currentTargets = new HashSet();
    public HashSet<SentinelCurrentTarget> currentAvoids = new HashSet();
    private SentinelCurrentTarget tempTarget = new SentinelCurrentTarget();
    private ArrayList<LivingEntity> avoidanceList = new ArrayList();
    private double[] threatDists = new double[36];
    private static Vector[] directionReferenceVectors = new Vector[36];
    private static AStarMachine ASTAR;
    private static BlockExaminer examiner;

    public boolean canSee(LivingEntity entity) {
        if (!this.getLivingEntity().getWorld().equals(entity.getWorld())) {
            return false;
        }
        if (this.getLivingEntity().getEyeLocation().distanceSquared(entity.getEyeLocation()) > this.sentinel.range * this.sentinel.range) {
            return false;
        }
        if (!this.getLivingEntity().hasLineOfSight((Entity)entity)) {
            return false;
        }
        if (this.sentinel.realistic) {
            float yaw;
            for (yaw = this.getLivingEntity().getEyeLocation().getYaw(); yaw < 0.0f; yaw += 360.0f) {
            }
            while (yaw >= 360.0f) {
                yaw -= 360.0f;
            }
            Vector rel = entity.getLocation().toVector().subtract(this.getLivingEntity().getLocation().toVector()).normalize();
            float yawHelp = SentinelUtilities.getYaw(rel);
            if (!(Math.abs(yawHelp - yaw) < 90.0f || Math.abs(yawHelp + 360.0f - yaw) < 90.0f || Math.abs(yaw + 360.0f - yawHelp) < 90.0f)) {
                return false;
            }
        }
        return true;
    }

    public boolean shouldTarget(LivingEntity entity) {
        if (entity.getUniqueId().equals(this.getLivingEntity().getUniqueId())) {
            return false;
        }
        return this.isTargeted(entity) && !this.isIgnored(entity);
    }

    public void addAvoid(UUID id) {
        if (id.equals(this.getLivingEntity().getUniqueId())) {
            return;
        }
        if (!(SentinelUtilities.getEntityForID(id) instanceof LivingEntity)) {
            return;
        }
        SentinelCurrentTarget target = new SentinelCurrentTarget();
        target.targetID = id;
        target.ticksLeft = SentinelPlugin.instance.runAwayTime;
        this.currentAvoids.remove(target);
        this.currentAvoids.add(target);
        if (this.sentinel.squad != null) {
            for (NPC npc : CitizensAPI.getNPCRegistry()) {
                if (!npc.hasTrait(SentinelTrait.class)) continue;
                SentinelTrait squadMade = (SentinelTrait)npc.getTrait(SentinelTrait.class);
                if (squadMade.squad == null || !squadMade.squad.equals(this.sentinel.squad)) continue;
                this.addTargetNoBounce(id);
            }
        }
    }

    public void addTarget(UUID id) {
        if (id.equals(this.getLivingEntity().getUniqueId())) {
            return;
        }
        if (!(SentinelUtilities.getEntityForID(id) instanceof LivingEntity)) {
            return;
        }
        SentinelCurrentTarget target = new SentinelCurrentTarget();
        target.targetID = id;
        target.ticksLeft = this.sentinel.enemyTargetTime;
        this.currentTargets.remove(target);
        this.currentTargets.add(target);
    }

    public boolean removeTarget(UUID id) {
        SentinelCurrentTarget target = new SentinelCurrentTarget();
        target.targetID = id;
        boolean removed = this.removeTargetNoBounce(target);
        if (removed && this.sentinel.squad != null) {
            for (NPC npc : CitizensAPI.getNPCRegistry()) {
                if (!npc.hasTrait(SentinelTrait.class)) continue;
                SentinelTrait squadMade = (SentinelTrait)npc.getTrait(SentinelTrait.class);
                if (squadMade.squad == null || !squadMade.squad.equals(this.sentinel.squad)) continue;
                this.sentinel.targetingHelper.removeTargetNoBounce(target);
            }
        }
        return removed;
    }

    public boolean removeTargetNoBounce(SentinelCurrentTarget target) {
        if (this.currentTargets.isEmpty()) {
            return false;
        }
        if (this.currentTargets.remove(target)) {
            if (this.currentTargets.isEmpty()) {
                Bukkit.getPluginManager().callEvent((Event)new SentinelNoMoreTargetsEvent(this.getNPC()));
            }
            return true;
        }
        return false;
    }

    public void addTargetNoBounce(UUID id) {
        SentinelCurrentTarget target = new SentinelCurrentTarget();
        target.targetID = id;
        target.ticksLeft = this.sentinel.enemyTargetTime;
        this.currentTargets.remove(target);
        this.currentTargets.add(target);
    }

    public boolean isInvisible(LivingEntity entity) {
        SentinelCurrentTarget sct = new SentinelCurrentTarget();
        sct.targetID = entity.getUniqueId();
        return !this.currentTargets.contains(sct) && SentinelUtilities.isInvisible(entity);
    }

    public boolean isIgnored(LivingEntity entity) {
        if (this.isInvisible(entity)) {
            return true;
        }
        if (entity.getUniqueId().equals(this.getLivingEntity().getUniqueId())) {
            return true;
        }
        if (this.sentinel.getGuarding() != null && entity.getUniqueId().equals(this.sentinel.getGuarding())) {
            return true;
        }
        return this.sentinel.allIgnores.isTarget(entity, this.sentinel);
    }

    public boolean isTargeted(LivingEntity entity) {
        if (this.isInvisible(entity)) {
            return false;
        }
        if (entity.getUniqueId().equals(this.getLivingEntity().getUniqueId())) {
            return false;
        }
        if (this.sentinel.getGuarding() != null && entity.getUniqueId().equals(this.sentinel.getGuarding())) {
            return false;
        }
        if (SentinelTargetingHelper.isUntargetable((Entity)entity)) {
            return false;
        }
        this.tempTarget.targetID = entity.getUniqueId();
        if (this.currentTargets.contains(this.tempTarget)) {
            return true;
        }
        return this.sentinel.allTargets.isTarget(entity, this.sentinel);
    }

    public boolean isAvoided(LivingEntity entity) {
        if (this.isInvisible(entity)) {
            return false;
        }
        if (entity.getUniqueId().equals(this.getLivingEntity().getUniqueId())) {
            return false;
        }
        if (this.sentinel.getGuarding() != null && entity.getUniqueId().equals(this.sentinel.getGuarding())) {
            return false;
        }
        this.tempTarget.targetID = entity.getUniqueId();
        if (this.currentAvoids.contains(this.tempTarget)) {
            return true;
        }
        return this.sentinel.allAvoids.isTarget(entity, this.sentinel);
    }

    public void processAvoidance() {
        this.avoidanceList.clear();
        double range = this.sentinel.avoidRange + 10.0;
        for (Entity entity : this.getLivingEntity().getWorld().getNearbyEntities(this.getLivingEntity().getLocation(), range, 16.0, range)) {
            if (!(entity instanceof LivingEntity)) continue;
            this.tempTarget.targetID = entity.getUniqueId();
            if (!this.canSee((LivingEntity)entity) && !this.targetingHelper.currentAvoids.contains(this.tempTarget) || !this.targetingHelper.currentAvoids.contains(this.tempTarget) && !this.sentinel.allAvoids.isTarget((LivingEntity)entity, this.sentinel)) continue;
            this.avoidanceList.add((LivingEntity)entity);
            this.targetingHelper.addAvoid(entity.getUniqueId());
        }
        if (this.avoidanceList.isEmpty()) {
            return;
        }
        Location runTo = this.findBestRunSpot();
        if (runTo != null) {
            this.sentinel.pathTo(runTo);
            if (SentinelPlugin.debugMe) {
                this.sentinel.debug("Running from threats, movement vector: " + runTo.clone().subtract(this.getLivingEntity().getLocation()).toVector().toBlockVector().toString());
            }
        } else if (SentinelPlugin.debugMe) {
            this.sentinel.debug("I have nowhere to run!");
        }
    }

    public Location findBestRunSpot() {
        Location pos = this.sentinel.getGuardZone();
        if (!pos.getWorld().equals(this.getLivingEntity().getWorld())) {
            this.getNPC().getNavigator().cancelNavigation();
            this.getLivingEntity().teleport(this.sentinel.getGuardZone());
            return null;
        }
        LivingEntity closestThreat = null;
        double threatRangeSquared = 1000000.0;
        for (LivingEntity entity : this.avoidanceList) {
            double dist = entity.getLocation().distanceSquared(pos);
            if (!(dist < threatRangeSquared)) continue;
            closestThreat = entity;
            threatRangeSquared = dist;
        }
        if (closestThreat == null) {
            return null;
        }
        if (threatRangeSquared >= this.sentinel.avoidRange * this.sentinel.avoidRange) {
            if (SentinelPlugin.debugMe) {
                this.sentinel.debug("Threats are getting close... holding my post.");
            }
            return pos;
        }
        return this.runDirection(pos);
    }

    public static Location findSpotForRunDirection(Location start, double distance, Vector direction) {
        VectorNode startNode;
        VectorGoal goal = new VectorGoal(start.clone().add(direction.clone().multiply(distance)), 4.0f);
        Path resultPath = (Path)ASTAR.runFully((AStarGoal)goal, (AStarNode)(startNode = new VectorNode(goal, start, (BlockSource)new ChunkBlockSource(start, (float)distance + 10.0f), new BlockExaminer[]{examiner})), (int)(distance * 50.0));
        if (resultPath == null || resultPath.isComplete()) {
            return null;
        }
        Vector current = resultPath.getCurrentVector();
        while (!resultPath.isComplete()) {
            current = resultPath.getCurrentVector();
            resultPath.update(null);
        }
        return current.toLocation(start.getWorld());
    }

    public Location runDirection(Location center) {
        int i;
        for (int i2 = 0; i2 < 36; ++i2) {
            this.threatDists[i2] = 1000000.0;
        }
        double range = this.sentinel.avoidRange;
        Vector centerVec = center.toVector();
        for (LivingEntity entity : this.avoidanceList) {
            Vector relative = entity.getLocation().toVector().subtract(centerVec);
            for (i = 0; i < 36; ++i) {
                double dist = relative.distanceSquared(directionReferenceVectors[i].clone().multiply(range));
                if (!(dist < this.threatDists[i])) continue;
                this.threatDists[i] = dist;
            }
        }
        double longestDistance = 0.0;
        Location runTo = null;
        for (i = 0; i < 36; ++i) {
            Location newRunTo;
            if (!(this.threatDists[i] > longestDistance) || (newRunTo = SentinelTargetingHelper.findSpotForRunDirection(center, range, directionReferenceVectors[i].clone())) == null) continue;
            runTo = newRunTo;
            longestDistance = this.threatDists[i];
        }
        if (SentinelPlugin.debugMe) {
            SentinelPlugin.instance.getLogger().info("(TEMP) Run to get threat distance: " + longestDistance + " to " + runTo + " from " + center.toVector());
        }
        return runTo;
    }

    public LivingEntity findBestTarget() {
        boolean ignoreGlow = this.itemHelper.usesSpectral();
        double rangesquared = this.sentinel.range * this.sentinel.range;
        double crsq = this.sentinel.chaseRange * this.sentinel.chaseRange;
        Location pos = this.sentinel.getGuardZone();
        if (!pos.getWorld().equals(this.getLivingEntity().getWorld())) {
            this.getNPC().getNavigator().cancelNavigation();
            this.getLivingEntity().teleport(this.sentinel.getGuardZone());
            return null;
        }
        LivingEntity closest = null;
        boolean wasLos = false;
        double range = rangesquared;
        for (Entity loopEnt : this.getLivingEntity().getWorld().getNearbyEntities(pos, range, range, range)) {
            if (!(loopEnt instanceof LivingEntity)) continue;
            LivingEntity ent = (LivingEntity)loopEnt;
            if (ignoreGlow && ent.isGlowing() || ent.isDead()) continue;
            double dist = ent.getEyeLocation().distanceSquared(pos);
            this.tempTarget.targetID = ent.getUniqueId();
            if (!(dist < rangesquared && this.shouldTarget(ent) && this.canSee(ent)) && (!(dist < crsq) || !this.currentTargets.contains(this.tempTarget))) continue;
            boolean hasLos = this.canSee(ent);
            if (wasLos && !hasLos) continue;
            rangesquared = dist;
            closest = ent;
            wasLos = hasLos;
        }
        return closest;
    }

    public LivingEntity findQuickMeleeTarget() {
        double range = this.sentinel.reach * 0.75;
        Location pos = this.getLivingEntity().getEyeLocation();
        for (Entity loopEnt : this.getLivingEntity().getWorld().getNearbyEntities(pos, range, range, range)) {
            if (!(loopEnt instanceof LivingEntity) || !this.shouldTarget((LivingEntity)loopEnt) || !this.canSee((LivingEntity)loopEnt)) continue;
            return (LivingEntity)loopEnt;
        }
        return null;
    }

    public void updateAvoids() {
        for (SentinelCurrentTarget uuid : new HashSet<SentinelCurrentTarget>(this.currentAvoids)) {
            Entity e = SentinelUtilities.getEntityForID(uuid.targetID);
            if (e == null) {
                this.currentAvoids.remove(uuid);
                continue;
            }
            if (e.isDead()) {
                this.currentAvoids.remove(uuid);
                continue;
            }
            if (uuid.ticksLeft <= 0L) continue;
            uuid.ticksLeft -= (long)SentinelPlugin.instance.tickRate;
            if (uuid.ticksLeft > 0L) continue;
            this.currentAvoids.remove(uuid);
        }
    }

    public static boolean isUntargetable(Entity e) {
        return e == null || e instanceof Player && (((Player)e).getGameMode() == GameMode.CREATIVE || ((Player)e).getGameMode() == GameMode.SPECTATOR) || e.isDead();
    }

    public void updateTargets() {
        for (SentinelCurrentTarget uuid : new HashSet<SentinelCurrentTarget>(this.currentTargets)) {
            double d;
            Entity e = SentinelUtilities.getEntityForID(uuid.targetID);
            if (SentinelTargetingHelper.isUntargetable(e)) {
                this.currentTargets.remove(uuid);
                continue;
            }
            double d2 = d = e.getWorld().equals(this.getLivingEntity().getWorld()) ? e.getLocation().distanceSquared(this.getLivingEntity().getLocation()) : 1.0E8;
            if (d > this.sentinel.range * this.sentinel.range * 4.0 && d > this.sentinel.chaseRange * this.sentinel.chaseRange * 4.0) {
                this.currentTargets.remove(uuid);
                continue;
            }
            if (uuid.ticksLeft <= 0L) continue;
            uuid.ticksLeft -= (long)SentinelPlugin.instance.tickRate;
            if (uuid.ticksLeft > 0L) continue;
            this.currentTargets.remove(uuid);
        }
        if (this.sentinel.chasing != null) {
            SentinelCurrentTarget cte = new SentinelCurrentTarget();
            cte.targetID = this.sentinel.chasing.getUniqueId();
            if (!this.currentTargets.contains(cte)) {
                this.sentinel.chasing = null;
                this.getNPC().getNavigator().cancelNavigation();
            }
        }
    }

    static {
        for (int i = 0; i < 36; ++i) {
            double yaw = i * 10;
            SentinelTargetingHelper.directionReferenceVectors[i] = new Vector(Math.sin(-yaw * (Math.PI / 180)), 0.0, Math.cos(yaw * (Math.PI / 180)));
        }
        ASTAR = AStarMachine.createWithDefaultStorage();
        examiner = new MinecraftBlockExaminer();
    }
}

