/*
 * Decompiled with CFR 0.152.
 */
package org.mcmonkey.sentinel;

import java.util.UUID;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.npc.NPC;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Projectile;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.projectiles.ProjectileSource;
import org.mcmonkey.sentinel.SentinelPlugin;
import org.mcmonkey.sentinel.SentinelTrait;

public class SentinelEventHandler
implements Listener {
    @EventHandler
    public void onAsyncPlayerChat(final AsyncPlayerChatEvent event) {
        if (event.isCancelled()) {
            return;
        }
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)SentinelPlugin.instance, new Runnable(){

            @Override
            public void run() {
                if (!event.getPlayer().isOnline()) {
                    return;
                }
                for (SentinelTrait sentinel : SentinelPlugin.instance.currentSentinelNPCs) {
                    if (!sentinel.validateOnList()) continue;
                    if (sentinel.allTargets.isEventTarget(sentinel, event)) {
                        sentinel.targetingHelper.addTarget(event.getPlayer().getUniqueId());
                    }
                    if (!sentinel.allAvoids.isEventTarget(sentinel, event)) continue;
                    sentinel.targetingHelper.addAvoid(event.getPlayer().getUniqueId());
                }
            }
        });
    }

    public SentinelTrait tryGetSentinel(Entity entity) {
        NPC npc;
        if (CitizensAPI.getNPCRegistry().isNPC(entity) && (npc = CitizensAPI.getNPCRegistry().getNPC(entity)).hasTrait(SentinelTrait.class)) {
            return (SentinelTrait)npc.getTrait(SentinelTrait.class);
        }
        return null;
    }

    @EventHandler(priority=EventPriority.LOW)
    public void whenAttacksAreHappening(EntityDamageByEntityEvent event) {
        SentinelTrait shooter;
        ProjectileSource source;
        SentinelTrait attacker;
        if (event.isCancelled()) {
            return;
        }
        UUID victimUuid = event.getEntity().getUniqueId();
        for (SentinelTrait sentinel : SentinelPlugin.instance.currentSentinelNPCs) {
            if (!sentinel.validateOnList()) continue;
            sentinel.whenSomethingMightDie(victimUuid);
        }
        SentinelTrait victim = this.tryGetSentinel(event.getEntity());
        if (victim != null) {
            victim.whenAttacksAreHappeningToMe(event);
        }
        if ((attacker = this.tryGetSentinel(event.getDamager())) != null) {
            attacker.whenAttacksAreHappeningFromMe(event);
        }
        if (event.getDamager() instanceof Projectile && (source = ((Projectile)event.getDamager()).getShooter()) instanceof Entity && (shooter = this.tryGetSentinel((Entity)source)) != null) {
            shooter.whenAttacksAreHappeningFromMyArrow(event);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void whenAttacksHappened(EntityDamageByEntityEvent event) {
        SentinelTrait shooter;
        ProjectileSource source;
        SentinelTrait attacker;
        if (event.isCancelled()) {
            return;
        }
        SentinelTrait victim = this.tryGetSentinel(event.getEntity());
        if (victim != null) {
            victim.whenAttacksHappened(event);
        }
        if ((attacker = this.tryGetSentinel(event.getDamager())) != null) {
            attacker.whenAttacksHappened(event);
        }
        if (event.getDamager() instanceof Projectile && (source = ((Projectile)event.getDamager()).getShooter()) instanceof Entity && (shooter = this.tryGetSentinel((Entity)source)) != null) {
            shooter.whenAttacksHappened(event);
        }
        for (SentinelTrait sentinel : SentinelPlugin.instance.currentSentinelNPCs) {
            UUID guarding;
            if (!sentinel.validateOnList() || (guarding = sentinel.getGuarding()) == null || !event.getEntity().getUniqueId().equals(guarding)) continue;
            sentinel.whenAttacksHappened(event);
        }
    }

    @EventHandler
    public void whenAnEnemyDies(EntityDeathEvent event) {
        UUID dead = event.getEntity().getUniqueId();
        for (SentinelTrait sentinel : SentinelPlugin.instance.currentSentinelNPCs) {
            if (!sentinel.validateOnList()) continue;
            sentinel.whenAnEnemyDies(dead);
            sentinel.whenSomethingDies(event);
            if (!sentinel.getLivingEntity().getUniqueId().equals(dead)) continue;
            sentinel.whenWeDie(event);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerTeleports(PlayerTeleportEvent event) {
        if (event.isCancelled()) {
            return;
        }
        UUID uuid = event.getPlayer().getUniqueId();
        for (SentinelTrait sentinel : SentinelPlugin.instance.currentSentinelNPCs) {
            if (!sentinel.validateOnList() || sentinel.getGuarding() == null || !sentinel.getGuarding().equals(uuid)) continue;
            sentinel.onPlayerTeleports(event);
        }
    }

    @EventHandler
    public void onPlayerMovesInRange(PlayerMoveEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (event.getTo().toVector().equals((Object)event.getFrom().toVector())) {
            return;
        }
        for (SentinelTrait sentinel : SentinelPlugin.instance.currentSentinelNPCs) {
            if (!sentinel.validateOnList()) continue;
            sentinel.onPlayerMovesInRange(event);
        }
    }
}

