/*
 * Decompiled with CFR 0.152.
 */
package org.mcmonkey.sentinel.targeting;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.persistence.Persist;
import net.citizensnpcs.api.trait.trait.Owner;
import net.citizensnpcs.api.util.DataKey;
import org.bukkit.ChatColor;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.mcmonkey.sentinel.SentinelIntegration;
import org.mcmonkey.sentinel.SentinelPlugin;
import org.mcmonkey.sentinel.SentinelTrait;
import org.mcmonkey.sentinel.SentinelUtilities;
import org.mcmonkey.sentinel.commands.SentinelCommand;
import org.mcmonkey.sentinel.targeting.SentinelTarget;

public class SentinelTargetList {
    public HashSet<SentinelTarget> targetsProcessed = new HashSet();
    public HashMap<String, ArrayList<CachedOtherTarget>> otherTargetCache = new HashMap();
    private int otherTargetSize = 0;
    public ArrayList<LivingEntity> tempTargeted = new ArrayList();
    @Persist(value="targets")
    public ArrayList<String> targets = new ArrayList();
    @Persist(value="byPlayerName")
    public ArrayList<String> byPlayerName = new ArrayList();
    @Persist(value="byNpcName")
    public ArrayList<String> byNpcName = new ArrayList();
    @Persist(value="byEntityName")
    public ArrayList<String> byEntityName = new ArrayList();
    @Persist(value="byHeldItem")
    public ArrayList<String> byHeldItem = new ArrayList();
    @Persist(value="byGroup")
    public ArrayList<String> byGroup = new ArrayList();
    @Persist(value="byEvent")
    public ArrayList<String> byEvent = new ArrayList();
    @Persist(value="byOther")
    public ArrayList<String> byOther = new ArrayList();
    @Persist(value="byAllInOne")
    public ArrayList<SentinelTargetList> byAllInOne = new ArrayList();
    @Persist(value="byMultiple")
    public ArrayList<SentinelTargetList> byMultiple = new ArrayList();

    public SentinelTargetList duplicate() {
        SentinelTargetList result = new SentinelTargetList();
        result.targets.addAll(this.targets);
        result.byPlayerName.addAll(this.byPlayerName);
        result.byNpcName.addAll(this.byNpcName);
        result.byEntityName.addAll(this.byEntityName);
        result.byHeldItem.addAll(this.byHeldItem);
        result.byGroup.addAll(this.byGroup);
        result.byEvent.addAll(this.byEvent);
        result.byOther.addAll(this.byOther);
        result.byMultiple.addAll(this.byMultiple);
        result.byAllInOne.addAll(this.byAllInOne);
        return result;
    }

    public boolean isTarget(LivingEntity entity, SentinelTrait sentinel) {
        this.checkRecalculateTargetsCache();
        if (this.targetsProcessed.contains(SentinelTarget.OWNER) && entity.getUniqueId().equals(((Owner)sentinel.getNPC().getTrait(Owner.class)).getOwnerId())) {
            return true;
        }
        return this.isTarget(entity);
    }

    public boolean isTarget(LivingEntity entity) {
        this.checkRecalculateTargetsCache();
        return this.isTargetNoCache(entity);
    }

    public boolean isTargetNoCache(LivingEntity entity) {
        if (entity.getEquipment() != null && SentinelUtilities.getHeldItem(entity) != null && SentinelUtilities.isRegexTargeted(SentinelUtilities.getHeldItem(entity).getType().name(), this.byHeldItem)) {
            return true;
        }
        for (ArrayList<CachedOtherTarget> targets : this.otherTargetCache.values()) {
            for (CachedOtherTarget target : targets) {
                if (!target.integration.isTarget(entity, target.prefix, target.value)) continue;
                return true;
            }
        }
        for (SentinelTargetList allInOne : this.byAllInOne) {
            SentinelTargetList subList = allInOne.duplicate();
            subList.recalculateCacheNoClear();
            if (SentinelPlugin.debugMe) {
                SentinelPlugin.instance.getLogger().info("All-In-One Debug: " + subList.totalTargetsCount() + " at start: " + subList.toMultiTargetString());
            }
            while (subList.ifIsTargetDeleteTarget(entity)) {
            }
            if (subList.totalTargetsCount() == 0) {
                return true;
            }
            if (!SentinelPlugin.debugMe) continue;
            SentinelPlugin.instance.getLogger().info("All-In-One Debug: " + subList.totalTargetsCount() + " left: " + subList.toMultiTargetString());
        }
        if (entity.hasMetadata("NPC")) {
            return this.targetsProcessed.contains(SentinelTarget.NPCS) || SentinelUtilities.isRegexTargeted(CitizensAPI.getNPCRegistry().getNPC((Entity)entity).getName(), this.byNpcName);
        }
        if (entity instanceof Player) {
            if (SentinelUtilities.isRegexTargeted(((Player)entity).getName(), this.byPlayerName)) {
                return true;
            }
            if (SentinelPlugin.instance.vaultPerms != null) {
                for (String group : this.byGroup) {
                    if (!SentinelPlugin.instance.vaultPerms.playerInGroup((Player)entity, group)) continue;
                    return true;
                }
            }
        } else if (SentinelUtilities.isRegexTargeted(entity.getCustomName() == null ? entity.getType().name() : entity.getCustomName(), this.byEntityName)) {
            return true;
        }
        HashSet<SentinelTarget> possible = SentinelPlugin.entityToTargets.get(entity.getType());
        for (SentinelTarget poss : possible) {
            if (!this.targetsProcessed.contains(poss)) continue;
            return true;
        }
        return false;
    }

    public boolean ifIsTargetDeleteTarget(LivingEntity entity) {
        Object match;
        if (entity.getEquipment() != null && SentinelUtilities.getHeldItem(entity) != null && (match = SentinelUtilities.getRegexTarget(SentinelUtilities.getHeldItem(entity).getType().name(), this.byHeldItem)) != null) {
            this.byHeldItem.remove(match);
            return true;
        }
        for (Map.Entry<String, ArrayList<CachedOtherTarget>> targets : this.otherTargetCache.entrySet()) {
            for (CachedOtherTarget target : targets.getValue()) {
                if (!target.integration.isTarget(entity, target.prefix, target.value)) continue;
                this.byOther.remove(target.prefix + ":" + target.value);
                this.recalculateCacheNoClear();
                return true;
            }
        }
        for (SentinelTargetList allInOne : this.byAllInOne) {
            SentinelTargetList subList = allInOne.duplicate();
            subList.recalculateCacheNoClear();
            while (subList.ifIsTargetDeleteTarget(entity)) {
            }
            if (subList.totalTargetsCount() != 0) continue;
            this.byAllInOne.remove(allInOne);
            return true;
        }
        if (entity.hasMetadata("NPC")) {
            if (this.targetsProcessed.contains(SentinelTarget.NPCS)) {
                for (String target : this.targets) {
                    if (SentinelTarget.forName(target) != SentinelTarget.NPCS) continue;
                    this.targets.remove(target);
                    this.recalculateCacheNoClear();
                    return true;
                }
                this.targetsProcessed.remove(SentinelTarget.NPCS);
                return true;
            }
            match = SentinelUtilities.getRegexTarget(CitizensAPI.getNPCRegistry().getNPC((Entity)entity).getName(), this.byNpcName);
            if (match != null) {
                this.byNpcName.remove(match);
                return true;
            }
            return false;
        }
        if (entity instanceof Player) {
            match = SentinelUtilities.getRegexTarget(((Player)entity).getName(), this.byPlayerName);
            if (match != null) {
                this.byPlayerName.remove(match);
                return true;
            }
            if (SentinelPlugin.instance.vaultPerms != null) {
                for (String group : this.byGroup) {
                    if (!SentinelPlugin.instance.vaultPerms.playerInGroup((Player)entity, group)) continue;
                    this.byGroup.remove(group);
                    return true;
                }
            }
        } else {
            match = SentinelUtilities.getRegexTarget(entity.getCustomName() == null ? entity.getType().name() : entity.getCustomName(), this.byEntityName);
            if (match != null) {
                this.byEntityName.remove(match);
                return true;
            }
        }
        HashSet<SentinelTarget> possible = SentinelPlugin.entityToTargets.get(entity.getType());
        for (SentinelTarget poss : possible) {
            if (!this.targetsProcessed.contains(poss)) continue;
            for (String target : this.targets) {
                if (SentinelTarget.forName(target) != poss) continue;
                this.targets.remove(target);
                this.recalculateCacheNoClear();
                return true;
            }
            this.targetsProcessed.remove(poss);
            return true;
        }
        return false;
    }

    public void fillListFromKey(ArrayList<String> list, DataKey key) {
        for (DataKey listEntry : key.getSubKeys()) {
            list.add(listEntry.getRaw("").toString());
        }
    }

    public void updateOld(DataKey key, String name) {
        if (name.equals("playerName")) {
            this.fillListFromKey(this.byPlayerName, key);
        } else if (name.equals("npcName")) {
            this.fillListFromKey(this.byNpcName, key);
        } else if (name.equals("entityName")) {
            this.fillListFromKey(this.byEntityName, key);
        } else if (name.equals("heldItem")) {
            this.fillListFromKey(this.byHeldItem, key);
        } else if (name.equals("group")) {
            this.fillListFromKey(this.byGroup, key);
        } else if (name.equals("event")) {
            this.fillListFromKey(this.byEvent, key);
        } else if (name.equals("other")) {
            this.fillListFromKey(this.byOther, key);
        }
    }

    public boolean isEventTarget(SentinelTrait sentinel, AsyncPlayerChatEvent event) {
        if (!sentinel.targetingHelper.canSee((LivingEntity)event.getPlayer())) {
            return false;
        }
        for (String str : this.byEvent) {
            if (!str.startsWith("message,")) continue;
            String messageCheck = str.substring("message,".length());
            if (!event.getMessage().toLowerCase().contains(messageCheck.toLowerCase())) continue;
            return true;
        }
        return false;
    }

    public boolean isEventTarget(EntityDamageByEntityEvent event) {
        if (this.byEvent.contains("pvp") && event.getEntity() instanceof Player && !CitizensAPI.getNPCRegistry().isNPC(event.getEntity())) {
            return true;
        }
        if (this.byEvent.contains("pve") && !(event.getEntity() instanceof Player) && event.getEntity() instanceof LivingEntity) {
            return true;
        }
        if (this.byEvent.contains("pvnpc") && event.getEntity() instanceof LivingEntity && CitizensAPI.getNPCRegistry().isNPC(event.getEntity())) {
            return true;
        }
        return this.byEvent.contains("pvsentinel") && event.getEntity() instanceof LivingEntity && CitizensAPI.getNPCRegistry().isNPC(event.getEntity()) && CitizensAPI.getNPCRegistry().getNPC(event.getEntity()).hasTrait(SentinelTrait.class);
    }

    public void checkRecalculateTargetsCache() {
        if (this.targets.size() != this.targetsProcessed.size() || this.byOther.size() != this.otherTargetSize) {
            this.recalculateTargetsCache();
        }
    }

    public void recalculateCacheNoClear() {
        this.targetsProcessed.clear();
        for (String target : this.targets) {
            this.targetsProcessed.add(SentinelTarget.forName(target));
        }
        this.otherTargetCache.clear();
        for (String otherTarget : this.byOther) {
            int colon = otherTarget.indexOf(58);
            String before = otherTarget.substring(0, colon);
            String after = otherTarget.substring(colon + 1);
            SentinelIntegration integration = SentinelPlugin.integrationPrefixMap.get(before);
            if (integration == null) continue;
            ArrayList<CachedOtherTarget> subList = this.otherTargetCache.get(before);
            if (subList == null) {
                subList = new ArrayList();
                this.otherTargetCache.put(before, subList);
            }
            CachedOtherTarget targ = new CachedOtherTarget();
            targ.integration = integration;
            targ.prefix = before;
            targ.value = after;
            subList.add(targ);
        }
        this.otherTargetSize = this.byOther.size();
    }

    public void recalculateTargetsCache() {
        this.recalculateCacheNoClear();
        this.targets.clear();
        for (SentinelTarget target : this.targetsProcessed) {
            this.targets.add(target.name());
        }
    }

    public int totalTargetsCount() {
        return this.targets.size() + this.byPlayerName.size() + this.byNpcName.size() + this.byEntityName.size() + this.byHeldItem.size() + this.byGroup.size() + this.byEvent.size() + this.byOther.size() + this.byAllInOne.size();
    }

    private static void addList(StringBuilder builder, ArrayList<String> strs, String prefix) {
        if (!strs.isEmpty()) {
            for (String str : strs) {
                if (prefix != null) {
                    builder.append(prefix).append(":");
                }
                builder.append(str).append(SentinelCommand.colorBasic).append(" ").append('\u0001').append(" ").append(ChatColor.AQUA);
            }
        }
    }

    public String toComboString() {
        StringBuilder sb = new StringBuilder();
        SentinelTargetList.addList(sb, this.targets, null);
        SentinelTargetList.addList(sb, this.byPlayerName, "player");
        SentinelTargetList.addList(sb, this.byNpcName, "npc");
        SentinelTargetList.addList(sb, this.byEntityName, "entityname");
        SentinelTargetList.addList(sb, this.byHeldItem, "helditem");
        SentinelTargetList.addList(sb, this.byGroup, "group");
        SentinelTargetList.addList(sb, this.byEvent, "event");
        SentinelTargetList.addList(sb, this.byOther, null);
        if (!this.byAllInOne.isEmpty()) {
            for (SentinelTargetList list : this.byAllInOne) {
                sb.append("allinone:").append(list.toAllInOneString()).append(SentinelCommand.colorBasic).append(" ").append('\u0001').append(" ").append(ChatColor.AQUA);
            }
        }
        if (sb.length() == 0) {
            return "";
        }
        return sb.substring(0, sb.length() - (SentinelCommand.colorBasic + " . " + ChatColor.AQUA.toString()).length());
    }

    public String toMultiTargetString() {
        return this.toComboString().replace('\u0001', ',');
    }

    public String toAllInOneString() {
        return this.toComboString().replace('\u0001', '|');
    }

    public static class CachedOtherTarget {
        public SentinelIntegration integration;
        public String prefix;
        public String value;
    }
}

