/*
 * Decompiled with CFR 0.152.
 */
package com.freneticllc.freneticutilities.freneticdatasyntax;

import java.util.ArrayList;
import java.util.Set;
import java.util.regex.Pattern;

public class FDSUtility {
    public static final char DEFAULT_SECTION_PATH_SPLIT = '.';
    public static char defaultSectionPathSplit = (char)46;
    public static final Pattern LONG_PATTERN = Pattern.compile("\\d+");
    public static final Pattern DOUBLE_PATTERN = Pattern.compile("\\d+(\\.\\d+)?");

    public static String cleanFileData(String contents) {
        contents = contents.contains("\r\n") ? contents.replace("\r", "") : contents.replace('\r', '\n');
        return contents.replace("\t", "    ");
    }

    public static String escape(String str) {
        if ((str = str.replace("\\", "\\\\").replace("\t", "\\t").replace("\n", "\\n").replace("\r", "\\r")).endsWith(" ")) {
            str = str + "\\x";
        }
        if (str.startsWith(" ")) {
            str = "\\x" + str;
        }
        return str;
    }

    public static String escapeKey(String str) {
        return FDSUtility.escape(str).replace(".", "\\d").replace(":", "\\c").replace("=", "\\e");
    }

    public static String unEscape(String str) {
        str = str.replace("\\t", "\t").replace("\\n", "\n").replace("\\r", "\r").replace("\\x", "").replace("\\\\", "\\");
        return str;
    }

    public static String unEscapeKey(String str) {
        return FDSUtility.unEscape(str.replace("\\d", ".").replace("\\c", ":").replace("\\e", "="));
    }

    public static Object interpretType(String input) {
        if (DOUBLE_PATTERN.matcher(input).matches()) {
            try {
                if (LONG_PATTERN.matcher(input).matches()) {
                    Long asLong = Long.parseLong(input);
                    if (asLong.toString().equals(input)) {
                        return asLong;
                    }
                } else {
                    Double asDouble = Double.parseDouble(input);
                    if (asDouble.toString().equals(input)) {
                        return asDouble;
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {}
        } else {
            if (input.equals("true")) {
                return true;
            }
            if (input.equals("false")) {
                return false;
            }
        }
        return input;
    }

    public static String[] split(String str, char c) {
        ArrayList<String> strings = new ArrayList<String>();
        int start = 0;
        for (int i = 0; i < str.length(); ++i) {
            if (str.charAt(i) != c) continue;
            strings.add(str.substring(start, i));
            start = i + 1;
        }
        strings.add(str.substring(start));
        return strings.toArray(new String[0]);
    }

    public static String[] split(String str, char c, int max) {
        ArrayList<String> strings = new ArrayList<String>();
        int start = 0;
        for (int i = 0; i < str.length(); ++i) {
            if (str.charAt(i) != c) continue;
            strings.add(str.substring(start, i));
            start = i + 1;
            if (strings.size() + 1 == max) break;
        }
        strings.add(str.substring(start));
        return strings.toArray(new String[0]);
    }

    public static String toLowerCase(String input) {
        char[] data = input.toCharArray();
        for (int i = 0; i < data.length; ++i) {
            if (data[i] < 'A' || data[i] > 'Z') continue;
            int n = i;
            data[n] = (char)(data[n] - -32);
        }
        return new String(data);
    }

    public static String trimStart(String str) {
        for (int start = 0; start < str.length(); ++start) {
            char c = str.charAt(start);
            if (c == ' ') continue;
            return str.substring(start);
        }
        return "";
    }

    public static String trimEnd(String str) {
        for (int end = str.length() - 1; end >= 0; --end) {
            char c = str.charAt(end);
            if (c == ' ') continue;
            return str.substring(0, end + 1);
        }
        return "";
    }

    public static String join(String separator, Set objects) {
        StringBuilder builder = new StringBuilder((separator.length() + 4) * objects.size());
        int count = 0;
        for (Object val : objects) {
            builder.append(val);
            if (++count == objects.size()) continue;
            builder.append(separator);
        }
        return builder.toString();
    }
}

