/*
 * Decompiled with CFR 0.152.
 */
package org.mcmonkey.sentinel;

import net.citizensnpcs.api.trait.trait.Inventory;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.mcmonkey.sentinel.SentinelHelperObject;
import org.mcmonkey.sentinel.SentinelPlugin;
import org.mcmonkey.sentinel.SentinelUtilities;
import org.mcmonkey.sentinel.targeting.SentinelTarget;

public class SentinelItemHelper
extends SentinelHelperObject {
    public ItemStack getArrow() {
        ItemStack[] items;
        if (!this.getNPC().hasTrait(Inventory.class)) {
            return this.sentinel.needsAmmo ? null : new ItemStack(Material.ARROW, 1);
        }
        Inventory inv = (Inventory)this.getNPC().getTrait(Inventory.class);
        for (ItemStack item : items = inv.getContents()) {
            if (item == null) continue;
            Material mat = item.getType();
            if (!(SentinelTarget.v1_9 ? mat == Material.ARROW || mat == Material.TIPPED_ARROW || mat == Material.SPECTRAL_ARROW : mat == Material.ARROW)) continue;
            return item.clone();
        }
        return this.sentinel.needsAmmo ? null : new ItemStack(Material.ARROW, 1);
    }

    public void reduceDurability() {
        ItemStack item = this.getHeldItem();
        if (item != null && item.getType() != Material.AIR) {
            ItemStack toSet;
            if (item.getDurability() >= item.getType().getMaxDurability() - 1) {
                toSet = null;
            } else {
                item.setDurability((short)(item.getDurability() + 1));
                toSet = item;
            }
            if (SentinelTarget.v1_9) {
                this.getLivingEntity().getEquipment().setItemInMainHand(toSet);
            } else {
                this.getLivingEntity().getEquipment().setItemInHand(toSet);
            }
        }
    }

    public void takeArrow() {
        if (!this.getNPC().hasTrait(Inventory.class)) {
            return;
        }
        Inventory inv = (Inventory)this.getNPC().getTrait(Inventory.class);
        ItemStack[] items = inv.getContents();
        for (int i = 0; i < items.length; ++i) {
            Material mat;
            ItemStack item = items[i];
            if (item == null || (mat = item.getType()) != Material.ARROW && (!SentinelTarget.v1_9 || mat != Material.TIPPED_ARROW && mat != Material.SPECTRAL_ARROW)) continue;
            if (item.getAmount() > 1) {
                item.setAmount(item.getAmount() - 1);
                items[i] = item;
                inv.setContents(items);
                return;
            }
            items[i] = null;
            inv.setContents(items);
            return;
        }
    }

    public void takeOne() {
        ItemStack item = this.getHeldItem();
        if (item != null && item.getType() != Material.AIR) {
            ItemStack toSet;
            if (item.getAmount() > 1) {
                item.setAmount(item.getAmount() - 1);
                toSet = item;
            } else {
                toSet = null;
            }
            if (SentinelTarget.v1_9) {
                this.getLivingEntity().getEquipment().setItemInMainHand(toSet);
            } else {
                this.getLivingEntity().getEquipment().setItemInHand(toSet);
            }
        }
    }

    public void grabNextItem() {
        if (!this.getNPC().hasTrait(Inventory.class)) {
            return;
        }
        Inventory inv = (Inventory)this.getNPC().getTrait(Inventory.class);
        ItemStack[] items = inv.getContents();
        ItemStack held = items[0];
        if (held != null && held.getType() != Material.AIR) {
            return;
        }
        for (int i = 0; i < items.length; ++i) {
            Material mat;
            ItemStack item = items[i];
            if (item == null || !SentinelTarget.isWeapon(mat = (item = item.clone()).getType())) continue;
            if (item.getAmount() > 1) {
                item.setAmount(item.getAmount() - 1);
                items[i] = item;
                items[0] = item.clone();
                items[0].setAmount(1);
                inv.setContents(items);
                item = item.clone();
                item.setAmount(1);
                return;
            }
            items[i] = new ItemStack(Material.AIR);
            items[0] = item.clone();
            inv.setContents(items);
            return;
        }
    }

    public void swapToRanged() {
        if (!this.getNPC().hasTrait(Inventory.class)) {
            return;
        }
        int i = 0;
        Inventory inv = (Inventory)this.getNPC().getTrait(Inventory.class);
        ItemStack[] items = inv.getContents();
        ItemStack held = items[0] == null ? null : items[0].clone();
        boolean edit = false;
        while (!this.isRanged() && i < items.length - 1) {
            if (items[++i] == null || items[i].getType() == Material.AIR) continue;
            items[0] = items[i].clone();
            items[i] = new ItemStack(Material.AIR);
            inv.setContents(items);
            edit = true;
        }
        if (edit) {
            items[i] = held;
            inv.setContents(items);
        }
    }

    public void swapToMelee() {
        if (!this.getNPC().hasTrait(Inventory.class)) {
            return;
        }
        int i = 0;
        Inventory inv = (Inventory)this.getNPC().getTrait(Inventory.class);
        ItemStack[] items = inv.getContents();
        ItemStack held = items[0] == null ? null : items[0].clone();
        boolean edit = false;
        while (this.isRanged() && i < items.length - 1) {
            if (items[++i] == null || items[i].getType() == Material.AIR) continue;
            items[0] = items[i].clone();
            items[i] = new ItemStack(Material.AIR);
            inv.setContents(items);
            edit = true;
        }
        if (edit) {
            items[i] = held;
            inv.setContents(items);
        }
    }

    public boolean isRanged() {
        return this.usesBow() || this.usesFireball() || this.usesSnowball() || this.usesLightning() || this.usesSpectral() || this.usesPotion();
    }

    public ItemStack getHeldItem() {
        if (!this.getNPC().hasTrait(Inventory.class)) {
            if (!this.getNPC().isSpawned()) {
                return null;
            }
            return SentinelUtilities.getHeldItem(this.getLivingEntity());
        }
        return ((Inventory)this.getNPC().getTrait(Inventory.class)).getContents()[0];
    }

    public boolean usesBow() {
        ItemStack it = this.getHeldItem();
        if (it == null) {
            return false;
        }
        if (SentinelTarget.v1_14 && it.getType() == Material.CROSSBOW && this.getArrow() != null) {
            return true;
        }
        return it.getType() == Material.BOW && this.getArrow() != null;
    }

    public boolean usesFireball() {
        ItemStack it = this.getHeldItem();
        return it != null && it.getType() == SentinelTarget.MATERIAL_BLAZE_ROD;
    }

    public boolean usesSnowball() {
        ItemStack it = this.getHeldItem();
        return it != null && it.getType() == SentinelTarget.MATERIAL_SNOW_BALL;
    }

    public boolean usesLightning() {
        ItemStack it = this.getHeldItem();
        return it != null && it.getType() == SentinelTarget.MATERIAL_NETHER_STAR;
    }

    public boolean usesEgg() {
        ItemStack it = this.getHeldItem();
        return it != null && it.getType() == Material.EGG;
    }

    public boolean usesPearl() {
        ItemStack it = this.getHeldItem();
        return it != null && it.getType() == Material.ENDER_PEARL;
    }

    public boolean usesWitherSkull() {
        if (!SentinelPlugin.instance.canUseSkull) {
            return false;
        }
        ItemStack it = this.getHeldItem();
        return it != null && SentinelTarget.SKULL_MATERIALS.contains(it.getType());
    }

    public boolean usesTrident() {
        if (!SentinelTarget.v1_13) {
            return false;
        }
        ItemStack it = this.getHeldItem();
        return it != null && it.getType() == Material.TRIDENT;
    }

    public boolean usesSpectral() {
        if (!SentinelTarget.v1_10) {
            return false;
        }
        ItemStack it = this.getHeldItem();
        return it != null && it.getType() == Material.SPECTRAL_ARROW;
    }

    public boolean usesPotion() {
        ItemStack it = this.getHeldItem();
        return it != null && SentinelTarget.POTION_MATERIALS.contains(it.getType());
    }

    public boolean shouldTakeDura() {
        ItemStack it = this.getHeldItem();
        if (it == null) {
            return false;
        }
        Material type = it.getType();
        return SentinelTarget.BOW_MATERIALS.contains(type) || SentinelTarget.SWORD_MATERIALS.contains(type) || SentinelTarget.PICKAXE_MATERIALS.contains(type) || SentinelTarget.AXE_MATERIALS.contains(type);
    }
}

