/*
 * Decompiled with CFR 0.152.
 */
package org.mcmonkey.sentinel;

import java.util.ArrayList;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Projectile;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.projectiles.ProjectileSource;
import org.mcmonkey.sentinel.SentinelPlugin;
import org.mcmonkey.sentinel.SentinelTrait;
import org.mcmonkey.sentinel.SentinelUtilities;

public class SentinelEventHandler
implements Listener {
    public ArrayList<SentinelTrait> cleanCurrentList() {
        ArrayList<SentinelTrait> npcs = SentinelPlugin.instance.currentSentinelNPCs;
        for (int i = 0; i < npcs.size(); ++i) {
            if (npcs.get(i).validateOnList()) continue;
            --i;
        }
        return npcs;
    }

    @EventHandler
    public void onAsyncPlayerChat(final AsyncPlayerChatEvent event) {
        if (event.isCancelled()) {
            return;
        }
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)SentinelPlugin.instance, new Runnable(){

            @Override
            public void run() {
                if (!event.getPlayer().isOnline()) {
                    return;
                }
                for (SentinelTrait sentinel : SentinelEventHandler.this.cleanCurrentList()) {
                    if (sentinel.allTargets.isEventTarget(sentinel, event)) {
                        sentinel.targetingHelper.addTarget(event.getPlayer().getUniqueId());
                    }
                    if (!sentinel.allAvoids.isEventTarget(sentinel, event)) continue;
                    sentinel.targetingHelper.addAvoid(event.getPlayer().getUniqueId());
                }
            }
        });
    }

    @EventHandler(priority=EventPriority.LOW)
    public void whenAttacksAreHappening(EntityDamageByEntityEvent event) {
        SentinelTrait shooter;
        ProjectileSource source;
        SentinelTrait attacker;
        if (event.isCancelled()) {
            return;
        }
        UUID victimUuid = event.getEntity().getUniqueId();
        for (SentinelTrait sentinel : this.cleanCurrentList()) {
            sentinel.whenSomethingMightDie(victimUuid);
        }
        SentinelTrait victim = SentinelUtilities.tryGetSentinel(event.getEntity());
        if (victim != null) {
            victim.whenAttacksAreHappeningToMe(event);
        }
        if ((attacker = SentinelUtilities.tryGetSentinel(event.getDamager())) != null) {
            attacker.whenAttacksAreHappeningFromMe(event);
        }
        if (event.getDamager() instanceof Projectile && (source = ((Projectile)event.getDamager()).getShooter()) instanceof Entity && (shooter = SentinelUtilities.tryGetSentinel((Entity)source)) != null) {
            shooter.whenAttacksAreHappeningFromMyArrow(event);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void whenEntitiesAreHurt(EntityDamageEvent event) {
        if (event.isCancelled()) {
            return;
        }
        SentinelTrait victim = SentinelUtilities.tryGetSentinel(event.getEntity());
        if (victim != null) {
            victim.whenImHurt(event);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void whenAttacksHappened(EntityDamageByEntityEvent event) {
        SentinelTrait shooter;
        ProjectileSource source;
        SentinelTrait attacker;
        if (event.isCancelled()) {
            return;
        }
        SentinelTrait victim = SentinelUtilities.tryGetSentinel(event.getEntity());
        if (victim != null) {
            victim.whenAttacksHappened(event);
        }
        if ((attacker = SentinelUtilities.tryGetSentinel(event.getDamager())) != null) {
            attacker.whenAttacksHappened(event);
        }
        if (event.getDamager() instanceof Projectile && (source = ((Projectile)event.getDamager()).getShooter()) instanceof Entity && (shooter = SentinelUtilities.tryGetSentinel((Entity)source)) != null) {
            shooter.whenAttacksHappened(event);
        }
        for (SentinelTrait sentinel : this.cleanCurrentList()) {
            UUID guarding = sentinel.getGuarding();
            if (guarding == null || !event.getEntity().getUniqueId().equals(guarding)) continue;
            sentinel.whenAttacksHappened(event);
        }
        if (event.getDamager() instanceof LivingEntity) {
            LivingEntity damager = (LivingEntity)event.getDamager();
            for (SentinelTrait sentinel : this.cleanCurrentList()) {
                if (sentinel.allTargets.isEventTarget(event) && sentinel.targetingHelper.canSee(damager) && !sentinel.targetingHelper.isIgnored(damager)) {
                    sentinel.targetingHelper.addTarget(damager.getUniqueId());
                }
                if (!sentinel.allAvoids.isEventTarget(event) || !sentinel.targetingHelper.canSee(damager) || sentinel.targetingHelper.isIgnored(damager)) continue;
                sentinel.targetingHelper.addTarget(damager.getUniqueId());
            }
        }
    }

    @EventHandler
    public void whenAnEnemyDies(EntityDeathEvent event) {
        UUID dead = event.getEntity().getUniqueId();
        for (SentinelTrait sentinel : this.cleanCurrentList()) {
            sentinel.whenAnEnemyDies(dead);
            sentinel.whenSomethingDies(event);
        }
    }

    @EventHandler
    public void whenWeDie(EntityDeathEvent event) {
        SentinelTrait sentinel = SentinelUtilities.tryGetSentinel((Entity)event.getEntity());
        if (sentinel != null) {
            sentinel.whenWeDie(event);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerTeleports(PlayerTeleportEvent event) {
        if (event.isCancelled()) {
            return;
        }
        UUID uuid = event.getPlayer().getUniqueId();
        for (SentinelTrait sentinel : this.cleanCurrentList()) {
            if (sentinel.getGuarding() == null || !sentinel.getGuarding().equals(uuid)) continue;
            sentinel.onPlayerTeleports(event);
        }
    }

    @EventHandler
    public void onPlayerMovesInRange(PlayerMoveEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (event.getTo().toVector().equals((Object)event.getFrom().toVector())) {
            return;
        }
        for (SentinelTrait sentinel : this.cleanCurrentList()) {
            sentinel.onPlayerMovesInRange(event);
        }
    }
}

