/*
 * Decompiled with CFR 0.152.
 */
package org.mcmonkey.sentinel.commands;

import java.util.Locale;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.command.Command;
import net.citizensnpcs.api.command.CommandContext;
import net.citizensnpcs.api.command.Requirements;
import net.citizensnpcs.api.npc.NPC;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.mcmonkey.sentinel.SentinelTrait;
import org.mcmonkey.sentinel.SentinelUtilities;
import org.mcmonkey.sentinel.commands.SentinelCommand;

public class SentinelIntelligenceCommands {
    @Command(aliases={"sentinel"}, usage="squad SQUAD", desc="Sets the NPC's squad name (give blank name for none).", modifiers={"squad"}, permission="sentinel.squad", min=1, max=9999)
    @Requirements(livingEntity=true, ownership=true, traits={SentinelTrait.class})
    public void squad(CommandContext args, CommandSender sender, SentinelTrait sentinel) {
        sentinel.squad = SentinelUtilities.concatWithSpaces(args.getSlice(1), 1).toLowerCase(Locale.ENGLISH);
        if (sentinel.squad.equals("null") || sentinel.squad.length() == 0) {
            sentinel.squad = null;
        }
        sender.sendMessage(SentinelCommand.prefixGood + "Set!");
    }

    @Command(aliases={"sentinel"}, usage="guard [PLAYERNAME]/npc:[ID]", desc="Makes the NPC guard a specific player or NPC - don't specify a player to stop guarding.", modifiers={"guard"}, permission="sentinel.guard", min=1, max=2)
    @Requirements(livingEntity=true, ownership=true, traits={SentinelTrait.class})
    public void guard(CommandContext args, CommandSender sender, SentinelTrait sentinel) {
        if (args.argsLength() > 1) {
            String inputArg = args.getString(1);
            if (inputArg.toLowerCase().startsWith("npc:")) {
                try {
                    int id = Integer.parseInt(inputArg.substring("npc:".length()));
                    NPC npc = CitizensAPI.getNPCRegistry().getById(id);
                    if (npc == null) {
                        sender.sendMessage(SentinelCommand.prefixBad + "NPC ID input invalid (that number isn't any NPC's ID)!");
                        return;
                    }
                    sentinel.setGuarding(id);
                    sender.sendMessage(SentinelCommand.prefixGood + "NPC now guarding the specified NPC!");
                    return;
                }
                catch (NumberFormatException ex) {
                    sender.sendMessage(SentinelCommand.prefixBad + "NPC ID input invalid (need a number)!");
                    return;
                }
            }
            Player pl = Bukkit.getPlayer((String)inputArg);
            sentinel.setGuarding(pl == null ? null : pl.getUniqueId());
        } else {
            sentinel.setGuarding(null);
        }
        if (sentinel.getGuarding() == null) {
            sender.sendMessage(SentinelCommand.prefixGood + "NPC now guarding its area!");
        } else {
            sender.sendMessage(SentinelCommand.prefixGood + "NPC now guarding that player!");
        }
    }

    @Command(aliases={"sentinel"}, usage="needammo ['true'/'false']", desc="Toggles whether the NPC will need ammo.", modifiers={"needammo"}, permission="sentinel.needammo", min=1, max=2)
    @Requirements(livingEntity=true, ownership=true, traits={SentinelTrait.class})
    public void needAmmo(CommandContext args, CommandSender sender, SentinelTrait sentinel) {
        boolean mode;
        boolean bl = mode = !sentinel.needsAmmo;
        if (args.argsLength() > 1 && "true".equalsIgnoreCase(args.getString(1))) {
            mode = true;
        }
        if (args.argsLength() > 1 && "false".equalsIgnoreCase(args.getString(1))) {
            mode = false;
        }
        sentinel.needsAmmo = mode;
        if (sentinel.needsAmmo) {
            sender.sendMessage(SentinelCommand.prefixGood + "NPC now needs ammo!");
        } else {
            sender.sendMessage(SentinelCommand.prefixGood + "NPC no longer needs ammo!");
        }
    }

    @Command(aliases={"sentinel"}, usage="autoswitch ['true'/'false']", desc="Toggles whether the NPC automatically switches items.", modifiers={"autoswitch"}, permission="sentinel.autoswitch", min=1, max=2)
    @Requirements(livingEntity=true, ownership=true, traits={SentinelTrait.class})
    public void autoswitch(CommandContext args, CommandSender sender, SentinelTrait sentinel) {
        boolean mode;
        boolean bl = mode = !sentinel.autoswitch;
        if (args.argsLength() > 1 && "true".equalsIgnoreCase(args.getString(1))) {
            mode = true;
        }
        if (args.argsLength() > 1 && "false".equalsIgnoreCase(args.getString(1))) {
            mode = false;
        }
        sentinel.autoswitch = mode;
        if (sentinel.autoswitch) {
            sender.sendMessage(SentinelCommand.prefixGood + "NPC now automatically switches items!");
        } else {
            sender.sendMessage(SentinelCommand.prefixGood + "NPC no longer automatically switches items!");
        }
    }

    @Command(aliases={"sentinel"}, usage="realistic ['true'/'false']", desc="Toggles whether the NPC should use 'realistic' targeting logic (don't attack things you can't see.)", modifiers={"realistic"}, permission="sentinel.realistic", min=1, max=2)
    @Requirements(livingEntity=true, ownership=true, traits={SentinelTrait.class})
    public void realistic(CommandContext args, CommandSender sender, SentinelTrait sentinel) {
        boolean mode;
        boolean bl = mode = !sentinel.realistic;
        if (args.argsLength() > 1 && "true".equalsIgnoreCase(args.getString(1))) {
            mode = true;
        }
        if (args.argsLength() > 1 && "false".equalsIgnoreCase(args.getString(1))) {
            mode = false;
        }
        sentinel.realistic = mode;
        if (sentinel.realistic) {
            sender.sendMessage(SentinelCommand.prefixGood + "NPC now targets realistically!");
        } else {
            sender.sendMessage(SentinelCommand.prefixGood + "NPC no longer targets realistically!");
        }
    }

    @Command(aliases={"sentinel"}, usage="guarddistance MINIMUM_DISTANCE [SELECTION_RANGE]", desc="Sets the NPC's minimum guard distance (how far you must go before the NPC moves to keep up) and selection range (how close it will try to get to you).", modifiers={"guarddistance"}, permission="sentinel.guarddistance", min=2, max=3)
    @Requirements(livingEntity=true, ownership=true, traits={SentinelTrait.class})
    public void guardDistance(CommandContext args, CommandSender sender, SentinelTrait sentinel) {
        try {
            double dist = Double.parseDouble(args.getString(1));
            double selDist = dist * 0.5;
            if (args.argsLength() > 1 && ((selDist = Double.parseDouble(args.getString(2))) < 1.0 || selDist > 25.0)) {
                throw new NumberFormatException("Selection_Range number out of range (must be >= 1 and <= 25).");
            }
            if (!(dist >= 1.0) || !(dist <= 100.0)) {
                throw new NumberFormatException("Minimum_Distance number out of range (must be >= 1 and <= 100).");
            }
            sentinel.guardDistanceMinimum = dist;
            sentinel.guardSelectionRange = selDist;
            sender.sendMessage(SentinelCommand.prefixGood + "guard distance set!");
        }
        catch (NumberFormatException ex) {
            sender.sendMessage(SentinelCommand.prefixBad + "Invalid distance number: " + ex.getMessage());
        }
    }
}

