/*
 * Decompiled with CFR 0.152.
 */
package org.mcmonkey.sentinel.targeting;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import org.bukkit.ChatColor;
import org.mcmonkey.sentinel.SentinelPlugin;
import org.mcmonkey.sentinel.targeting.SentinelTarget;
import org.mcmonkey.sentinel.targeting.SentinelTargetList;

public class SentinelTargetLabel {
    public String prefix;
    public String value;
    public boolean isRegex;
    public static HashSet<String> regexPrefixes = new HashSet<String>(Arrays.asList("player", "npc", "entityname", "helditem"));
    public static HashSet<String> corePrefixes = new HashSet<String>(Arrays.asList("player", "npc", "entityname", "helditem", "group", "event", "multi", "allinone"));
    public static long ignoreMe = 0L;
    private static SentinelTargetList helperList = new SentinelTargetList();

    public boolean isValidRegex() {
        try {
            if (this.isRegex && "Sentinel".matches(this.value)) {
                ++ignoreMe;
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean isValidTarget() {
        if (this.prefix != null) {
            if (this.prefix.equals("event")) {
                return SentinelPlugin.validEventTargets.contains(this.value);
            }
            return true;
        }
        return SentinelTarget.forName(this.value) != null;
    }

    public boolean isValidPrefix() {
        if (this.prefix == null) {
            return true;
        }
        if (corePrefixes.contains(this.prefix)) {
            return true;
        }
        return SentinelPlugin.integrationPrefixMap.containsKey(this.prefix);
    }

    public Collection<String> getTargetsList(SentinelTargetList listSet) {
        if (this.prefix == null) {
            return listSet.targets;
        }
        if (this.prefix.equals("player")) {
            return listSet.byPlayerName;
        }
        if (this.prefix.equals("npc")) {
            return listSet.byNpcName;
        }
        if (this.prefix.equals("entityname")) {
            return listSet.byEntityName;
        }
        if (this.prefix.equals("helditem")) {
            return listSet.byHeldItem;
        }
        if (this.prefix.equals("group")) {
            return listSet.byGroup;
        }
        if (this.prefix.equals("event")) {
            return listSet.byEvent;
        }
        if (this.prefix.equals("multi")) {
            return null;
        }
        if (this.prefix.equals("allinone")) {
            return null;
        }
        return listSet.byOther;
    }

    public String addable() {
        if (this.getTargetsList(helperList) == SentinelTargetLabel.helperList.byOther) {
            return this.prefix + ":" + this.value;
        }
        return this.value;
    }

    public boolean isValidMulti() {
        if (this.prefix == null) {
            return true;
        }
        if (this.prefix.equals("multi")) {
            return this.getMulti(",").totalTargetsCount() > 0;
        }
        if (this.prefix.equals("allinone")) {
            return this.getMulti("|").totalTargetsCount() > 0;
        }
        return true;
    }

    public SentinelTargetList getMulti(String splitter) {
        SentinelTargetList newList = new SentinelTargetList();
        for (String str : this.value.split(splitter)) {
            SentinelTargetLabel label = new SentinelTargetLabel(str);
            label.addToList(newList, false);
        }
        newList.recalculateCacheNoClear();
        return newList;
    }

    public boolean addToList(SentinelTargetList listSet) {
        return this.addToList(listSet, true);
    }

    public boolean addToList(SentinelTargetList listSet, boolean doRecache) {
        if (this.prefix != null && this.prefix.equals("multi")) {
            listSet.byMultiple.add(this.getMulti(","));
            return true;
        }
        if (this.prefix != null && this.prefix.equals("allinone")) {
            listSet.byAllInOne.add(this.getMulti("\\|"));
            return true;
        }
        Collection<String> list = this.getTargetsList(listSet);
        String addable = this.addable();
        if (doRecache && list.contains(addable)) {
            return false;
        }
        this.getTargetsList(listSet).add(this.addable());
        if (doRecache && (list == listSet.targets || list == listSet.byOther)) {
            listSet.recalculateTargetsCache();
        }
        return true;
    }

    public boolean removeFromList(SentinelTargetList listSet) {
        String addable;
        if (this.prefix != null && this.prefix.equals("multi")) {
            try {
                int integerValue = Integer.parseInt(this.value);
                if (integerValue >= 0 && integerValue < listSet.byMultiple.size()) {
                    listSet.byMultiple.remove(integerValue);
                    return true;
                }
                return false;
            }
            catch (NumberFormatException ex) {
                return false;
            }
        }
        if (this.prefix != null && this.prefix.equals("allinone")) {
            try {
                int integerValue = Integer.parseInt(this.value);
                if (integerValue >= 0 && integerValue < listSet.byAllInOne.size()) {
                    listSet.byAllInOne.remove(integerValue);
                    return true;
                }
                return false;
            }
            catch (NumberFormatException ex) {
                return false;
            }
        }
        Collection<String> list = this.getTargetsList(listSet);
        if (!list.contains(addable = this.addable())) {
            return false;
        }
        list.remove(this.addable());
        if (list == listSet.targets || list == listSet.byOther) {
            listSet.recalculateTargetsCache();
        }
        return true;
    }

    public SentinelTargetLabel(String label) {
        int index = label.indexOf(58);
        if (index >= 0) {
            this.prefix = label.substring(0, index).toLowerCase();
            this.value = label.substring(index + 1);
            this.isRegex = regexPrefixes.contains(this.prefix);
            this.value = ChatColor.translateAlternateColorCodes((char)'&', (String)this.value);
        } else {
            this.value = label.toUpperCase();
            SentinelTarget targetVersion = SentinelTarget.forName(this.value);
            if (targetVersion != null) {
                this.value = targetVersion.name();
            }
        }
    }
}

