/*
 * Decompiled with CFR 0.152.
 */
package org.mcmonkey.sentinel.targeting;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.trait.trait.Owner;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.mcmonkey.sentinel.SentinelPlugin;
import org.mcmonkey.sentinel.SentinelTrait;

public class SentinelTarget {
    public static SentinelTarget NPCS = new SentinelTarget(new EntityType[0], "NPC");
    public static SentinelTarget OWNER = new SentinelTarget(new EntityType[0], "OWNER");
    public static SentinelTarget PLAYERS = new SentinelTarget(new EntityType[]{EntityType.PLAYER}, "PLAYER");
    public static SentinelTarget PIGS = new SentinelTarget(new EntityType[]{EntityType.PIG}, "PIG");
    public static SentinelTarget OCELOTS = new SentinelTarget(new EntityType[]{EntityType.OCELOT}, "OCELOT", "CAT");
    public static SentinelTarget COWS = new SentinelTarget(new EntityType[]{EntityType.COW}, "COW");
    public static SentinelTarget RABBITS = new SentinelTarget(new EntityType[]{EntityType.RABBIT}, "RABBIT", "BUNNY", "BUNNIE");
    public static SentinelTarget SHEEP = new SentinelTarget(new EntityType[]{EntityType.SHEEP}, "SHEEP");
    public static SentinelTarget CHICKENS = new SentinelTarget(new EntityType[]{EntityType.CHICKEN}, "CHICKEN", "DUCK");
    public static SentinelTarget HORSES = new SentinelTarget(new EntityType[]{EntityType.HORSE}, "HORSE");
    public static SentinelTarget MUSHROOM_COW = new SentinelTarget(new EntityType[]{EntityType.MUSHROOM_COW}, "MUSHROOM_COW", "MUSHROOMCOW", "MOOSHROOM");
    public static SentinelTarget IRON_GOLEMS = new SentinelTarget(new EntityType[]{EntityType.IRON_GOLEM}, "IRON_GOLEM", "IRONGOLEM");
    public static SentinelTarget SQUIDS = new SentinelTarget(new EntityType[]{EntityType.SQUID}, "SQUID");
    public static SentinelTarget VILLAGER = new SentinelTarget(new EntityType[]{EntityType.VILLAGER}, "VILLAGER");
    public static SentinelTarget WOLF = new SentinelTarget(new EntityType[]{EntityType.WOLF}, "WOLF");
    public static SentinelTarget SNOWMEN = new SentinelTarget(new EntityType[]{EntityType.SNOWMAN}, "SNOWMAN", "SNOWMEN");
    public static SentinelTarget WITCH = new SentinelTarget(new EntityType[]{EntityType.WITCH}, "WITCH");
    public static SentinelTarget GUARDIANS = new SentinelTarget(new EntityType[]{EntityType.GUARDIAN}, "GUARDIAN");
    public static SentinelTarget CREERERS = new SentinelTarget(new EntityType[]{EntityType.CREEPER}, "CREEPER");
    public static SentinelTarget SKELETONS = new SentinelTarget(new EntityType[]{EntityType.SKELETON}, "SKELETON");
    public static SentinelTarget ZOMBIES = new SentinelTarget(new EntityType[]{EntityType.ZOMBIE}, "ZOMBIE");
    public static SentinelTarget MAGMA_CUBES = new SentinelTarget(new EntityType[]{EntityType.MAGMA_CUBE}, "MAGMA_CUBE", "MAGMACUBE");
    public static SentinelTarget ZOMBIE_PIGMEN = new SentinelTarget(new EntityType[]{EntityType.PIG_ZOMBIE}, "PIG_ZOMBIE", "PIGZOMBIE", "ZOMBIEPIGMAN", "ZOMBIEPIGMEN", "ZOMBIE_PIGMAN", "ZOMBIE_PIGMEN", "ZOMBIE_PIGMAN");
    public static SentinelTarget SILVERFISH = new SentinelTarget(new EntityType[]{EntityType.SILVERFISH}, "SILVERFISH", "SILVER_FISH", "SILVERFISHE", "SILVER_FISHE");
    public static SentinelTarget BATS = new SentinelTarget(new EntityType[]{EntityType.BAT}, "BAT");
    public static SentinelTarget BLAZES = new SentinelTarget(new EntityType[]{EntityType.BLAZE}, "BLAZE");
    public static SentinelTarget GHASTS = new SentinelTarget(new EntityType[]{EntityType.GHAST}, "GHAST");
    public static SentinelTarget GIANTS = new SentinelTarget(new EntityType[]{EntityType.GIANT}, "GIANT");
    public static SentinelTarget SLIME = new SentinelTarget(new EntityType[]{EntityType.SLIME}, "SLIME");
    public static SentinelTarget SPIDER = new SentinelTarget(new EntityType[]{EntityType.SPIDER}, "SPIDER");
    public static SentinelTarget CAVE_SPIDERS = new SentinelTarget(new EntityType[]{EntityType.CAVE_SPIDER}, "CAVE_SPIDER", "CAVESPIDER");
    public static SentinelTarget ENDERMEN = new SentinelTarget(new EntityType[]{EntityType.ENDERMAN}, "ENDERMAN", "ENDER_MAN", "ENDERMEN", "ENDER_MEN");
    public static SentinelTarget ENDERMITES = new SentinelTarget(new EntityType[]{EntityType.ENDERMITE}, "ENDERMITE", "ENDER_MITE");
    public static SentinelTarget WITHER = new SentinelTarget(new EntityType[]{EntityType.WITHER}, "WITHER");
    public static SentinelTarget ENDERDRAGON = new SentinelTarget(new EntityType[]{EntityType.ENDER_DRAGON}, "ENDERDRAGON", "ENDER_DRAGON");
    public static SentinelTarget SHULKERS;
    public static SentinelTarget POLAR_BEARS;
    public static SentinelTarget VEXES;
    public static SentinelTarget DONKEYS;
    public static SentinelTarget LLAMAS;
    public static SentinelTarget MULES;
    public static SentinelTarget HUSKS;
    public static SentinelTarget ELDER_GUARDIANS;
    public static SentinelTarget EVOKERS;
    public static SentinelTarget SKELETON_HORSES;
    public static SentinelTarget STRAYS;
    public static SentinelTarget ZOMBIE_VILLAGERS;
    public static SentinelTarget ZOMBIE_HORSES;
    public static SentinelTarget WITHER_SKELETONS;
    public static SentinelTarget VINDICATORS;
    public static SentinelTarget PARROTS;
    public static SentinelTarget ILLUSIONERS;
    public static SentinelTarget DOLPHIN;
    public static SentinelTarget DROWNED;
    public static SentinelTarget COD;
    public static SentinelTarget SALMON;
    public static SentinelTarget PUFFERFISH;
    public static SentinelTarget TROPICAL_FISH;
    public static SentinelTarget PHANTOM;
    public static SentinelTarget TURTLE;
    public static SentinelTarget FISH;
    public static SentinelTarget RAVAGERS;
    public static SentinelTarget PILLAGERS;
    public static SentinelTarget CATS;
    public static SentinelTarget PANDAS;
    public static SentinelTarget TRADER_LLAMAS;
    public static SentinelTarget WANDERING_TRADERS;
    public static SentinelTarget FOXES;
    public static SentinelTarget PASSIVE_MOBS;
    public static SentinelTarget MONSTERS;
    public static SentinelTarget MOBS;
    public static final HashSet<Material> SWORD_MATERIALS;
    public static final HashSet<Material> PICKAXE_MATERIALS;
    public static final HashSet<Material> AXE_MATERIALS;
    public static final HashSet<Material> HELMET_MATERIALS;
    public static final HashSet<Material> CHESTPLATE_MATERIALS;
    public static final HashSet<Material> LEGGINGS_MATERIALS;
    public static final HashSet<Material> BOOTS_MATERIALS;
    public static final HashSet<Material> BOW_MATERIALS;
    public static final HashSet<Material> POTION_MATERIALS;
    public static final HashSet<Material> SKULL_MATERIALS;
    public static final Map<Material, Double> WEAPON_DAMAGE_MULTIPLIERS;
    public static final Map<Material, Double> ARMOR_PROTECTION_MULTIPLIERS;
    public static final Material MATERIAL_SNOW_BALL;
    public static final Material MATERIAL_NETHER_STAR;
    public static final Material MATERIAL_BLAZE_ROD;
    public static final boolean v1_8;
    public static final boolean v1_9;
    public static final boolean v1_10;
    public static final boolean v1_11;
    public static final boolean v1_12;
    public static final boolean v1_13;
    public static final boolean v1_14;
    public String[] names;
    public HashSet<EntityType> types;

    public static boolean isWeapon(Material mat) {
        return WEAPON_DAMAGE_MULTIPLIERS.containsKey(mat) || POTION_MATERIALS.contains(mat) || BOW_MATERIALS.contains(mat) || SKULL_MATERIALS.contains(mat) || mat == MATERIAL_SNOW_BALL || mat == MATERIAL_BLAZE_ROD || mat == MATERIAL_NETHER_STAR;
    }

    public static EntityType[] combine(EntityType[] a, EntityType ... b) {
        int i;
        EntityType[] types = new EntityType[a.length + b.length];
        for (i = 0; i < a.length; ++i) {
            types[i] = a[i];
        }
        for (i = 0; i < b.length; ++i) {
            types[i + a.length] = b[i];
        }
        return types;
    }

    static String[] passiveNames() {
        return new String[]{"PASSIVE_MOB", "PASSIVEMOB", "GOODMOB", "GOOD_MOB", "FRIENDLYMOB", "FRIENDLY_MOB"};
    }

    static EntityType[] v1_8_passive() {
        return new EntityType[]{EntityType.PIG, EntityType.OCELOT, EntityType.COW, EntityType.RABBIT, EntityType.SHEEP, EntityType.CHICKEN, EntityType.MUSHROOM_COW, EntityType.HORSE, EntityType.IRON_GOLEM, EntityType.SQUID, EntityType.VILLAGER, EntityType.WOLF, EntityType.SNOWMAN};
    }

    static EntityType[] v1_10_passive() {
        return SentinelTarget.combine(SentinelTarget.v1_8_passive(), EntityType.POLAR_BEAR);
    }

    static EntityType[] v1_11_passive() {
        return SentinelTarget.combine(SentinelTarget.v1_10_passive(), EntityType.DONKEY, EntityType.LLAMA, EntityType.MULE, EntityType.ZOMBIE_HORSE, EntityType.SKELETON_HORSE);
    }

    static EntityType[] v1_12_passive() {
        return SentinelTarget.combine(SentinelTarget.v1_11_passive(), EntityType.PARROT);
    }

    static EntityType[] v1_13_passive() {
        return SentinelTarget.combine(SentinelTarget.v1_12_passive(), EntityType.DOLPHIN, EntityType.COD, EntityType.SALMON, EntityType.PUFFERFISH, EntityType.TROPICAL_FISH, EntityType.TURTLE);
    }

    static EntityType[] v1_14_passive() {
        return SentinelTarget.combine(SentinelTarget.v1_13_passive(), EntityType.CAT, EntityType.PANDA, EntityType.TRADER_LLAMA, EntityType.WANDERING_TRADER, EntityType.FOX);
    }

    static EntityType[] v1_8_monsters() {
        return new EntityType[]{EntityType.GUARDIAN, EntityType.CREEPER, EntityType.SKELETON, EntityType.ZOMBIE, EntityType.MAGMA_CUBE, EntityType.PIG_ZOMBIE, EntityType.SILVERFISH, EntityType.BAT, EntityType.BLAZE, EntityType.GHAST, EntityType.GIANT, EntityType.SLIME, EntityType.SPIDER, EntityType.CAVE_SPIDER, EntityType.ENDERMAN, EntityType.ENDERMITE, EntityType.WITHER, EntityType.ENDER_DRAGON, EntityType.WITCH};
    }

    static EntityType[] v1_9_monsters() {
        return SentinelTarget.combine(SentinelTarget.v1_8_monsters(), EntityType.SHULKER);
    }

    static EntityType[] v1_11_monsters() {
        return SentinelTarget.combine(SentinelTarget.v1_9_monsters(), EntityType.VEX, EntityType.HUSK, EntityType.ELDER_GUARDIAN, EntityType.EVOKER, EntityType.STRAY, EntityType.ZOMBIE_VILLAGER, EntityType.WITHER_SKELETON, EntityType.VINDICATOR);
    }

    static EntityType[] v1_12_monsters() {
        return SentinelTarget.combine(SentinelTarget.v1_11_monsters(), EntityType.ILLUSIONER);
    }

    static EntityType[] v1_13_monsters() {
        return SentinelTarget.combine(SentinelTarget.v1_12_monsters(), EntityType.DROWNED, EntityType.PHANTOM);
    }

    static EntityType[] v1_14_monsters() {
        return SentinelTarget.combine(SentinelTarget.v1_13_monsters(), EntityType.RAVAGER, EntityType.PILLAGER);
    }

    public static Material getMaterial(String name) {
        try {
            return Material.valueOf((String)name);
        }
        catch (IllegalArgumentException ex) {
            SentinelPlugin.instance.getLogger().warning("Sentinel loader failed to handle material name '" + name + "', that material will not function (REPORT THIS ERROR!)");
            return Material.valueOf((String)"STICK");
        }
    }

    public static void addAllMaterials(Set<Material> set, String ... matNames) {
        for (String mat : matNames) {
            set.add(SentinelTarget.getMaterial(mat));
        }
    }

    public static void allMaterialsTo(Map<Material, Double> map, Set<Material> set, Double val) {
        for (Material mat : set) {
            map.put(mat, val);
        }
    }

    public static HashSet<SentinelTarget> forEntityType(EntityType type) {
        return SentinelPlugin.entityToTargets.get(type);
    }

    public static SentinelTarget forName(String name) {
        return SentinelPlugin.targetOptions.get(name.toUpperCase());
    }

    public String name() {
        return this.names[0];
    }

    SentinelTarget(EntityType[] types, String ... names) {
        this.names = names;
        this.types = new HashSet<EntityType>(Arrays.asList(types));
        for (String string : names) {
            SentinelPlugin.targetOptions.put(string, this);
            SentinelPlugin.targetOptions.put(string + "S", this);
        }
        for (String string : types) {
            SentinelPlugin.entityToTargets.get(string).add(this);
        }
    }

    public boolean isTarget(LivingEntity entity) {
        return this.isTarget(entity, null);
    }

    public boolean isTarget(LivingEntity entity, SentinelTrait sentinel) {
        if (this.types.contains(entity.getType())) {
            return true;
        }
        if (this == NPCS && CitizensAPI.getNPCRegistry().isNPC((Entity)entity)) {
            return true;
        }
        return this == OWNER && sentinel != null && entity.getUniqueId().equals(((Owner)sentinel.getNPC().getTrait(Owner.class)).getOwnerId());
    }

    static {
        SWORD_MATERIALS = new HashSet();
        PICKAXE_MATERIALS = new HashSet();
        AXE_MATERIALS = new HashSet();
        HELMET_MATERIALS = new HashSet();
        CHESTPLATE_MATERIALS = new HashSet();
        LEGGINGS_MATERIALS = new HashSet();
        BOOTS_MATERIALS = new HashSet();
        BOW_MATERIALS = new HashSet();
        POTION_MATERIALS = new HashSet();
        SKULL_MATERIALS = new HashSet();
        WEAPON_DAMAGE_MULTIPLIERS = new HashMap<Material, Double>();
        ARMOR_PROTECTION_MULTIPLIERS = new HashMap<Material, Double>();
        String vers = Bukkit.getBukkitVersion();
        boolean future = vers.startsWith("1.15") || vers.startsWith("1.16");
        v1_14 = vers.startsWith("1.14") || future;
        v1_13 = vers.startsWith("1.13") || v1_14;
        v1_12 = vers.startsWith("1.12") || v1_13;
        v1_11 = vers.startsWith("1.11") || v1_12;
        v1_10 = vers.startsWith("1.10") || v1_11;
        v1_9 = vers.startsWith("1.9") || v1_10;
        boolean bl = v1_8 = vers.startsWith("1.8") || v1_9;
        if (v1_8 && !v1_9) {
            PASSIVE_MOBS = new SentinelTarget(SentinelTarget.v1_8_passive(), SentinelTarget.passiveNames());
            MOBS = new SentinelTarget(SentinelTarget.combine(SentinelTarget.v1_8_passive(), SentinelTarget.v1_8_monsters()), "MOB");
            MONSTERS = new SentinelTarget(SentinelTarget.v1_8_monsters(), "MONSTER");
        }
        if (v1_9) {
            SHULKERS = new SentinelTarget(new EntityType[]{EntityType.SHULKER}, "SHULKER");
        }
        if (v1_9 && !v1_10) {
            PASSIVE_MOBS = new SentinelTarget(SentinelTarget.v1_8_passive(), SentinelTarget.passiveNames());
            MOBS = new SentinelTarget(SentinelTarget.combine(SentinelTarget.v1_8_passive(), SentinelTarget.v1_9_monsters()), "MOB");
            MONSTERS = new SentinelTarget(SentinelTarget.v1_9_monsters(), "MONSTER");
        }
        if (v1_10) {
            POLAR_BEARS = new SentinelTarget(new EntityType[]{EntityType.POLAR_BEAR}, "POLARBEAR", "POLAR_BEAR");
        }
        if (v1_10 && !v1_11) {
            PASSIVE_MOBS = new SentinelTarget(SentinelTarget.v1_10_passive(), SentinelTarget.passiveNames());
            MOBS = new SentinelTarget(SentinelTarget.combine(SentinelTarget.v1_10_passive(), SentinelTarget.v1_9_monsters()), "MOB");
            MONSTERS = new SentinelTarget(SentinelTarget.v1_9_monsters(), "MONSTER");
        }
        if (v1_11) {
            VEXES = new SentinelTarget(new EntityType[]{EntityType.VEX}, "VEX", "VEXE");
            DONKEYS = new SentinelTarget(new EntityType[]{EntityType.DONKEY}, "DONKEY");
            LLAMAS = new SentinelTarget(new EntityType[]{EntityType.LLAMA}, "LLAMA");
            MULES = new SentinelTarget(new EntityType[]{EntityType.MULE}, "MULE");
            HUSKS = new SentinelTarget(new EntityType[]{EntityType.HUSK}, "HUSK");
            ELDER_GUARDIANS = new SentinelTarget(new EntityType[]{EntityType.ELDER_GUARDIAN}, "ELDER_GUARDIAN", "ELDERGUARDIAN");
            EVOKERS = new SentinelTarget(new EntityType[]{EntityType.EVOKER}, "EVOKER");
            SKELETON_HORSES = new SentinelTarget(new EntityType[]{EntityType.SKELETON_HORSE}, "SKELETON_HORSE", "SKELETONHORSE");
            STRAYS = new SentinelTarget(new EntityType[]{EntityType.STRAY}, "STRAY");
            ZOMBIE_VILLAGERS = new SentinelTarget(new EntityType[]{EntityType.ZOMBIE_VILLAGER}, "ZOMBIE_VILLAGER", "ZOMBIEVILLAGER");
            ZOMBIE_HORSES = new SentinelTarget(new EntityType[]{EntityType.ZOMBIE_HORSE}, "ZOMBIE_HORSE", "ZOMBIEHORSE");
            WITHER_SKELETONS = new SentinelTarget(new EntityType[]{EntityType.WITHER_SKELETON}, "WITHER_SKELETON", "WITHERSKELETON");
            VINDICATORS = new SentinelTarget(new EntityType[]{EntityType.VINDICATOR}, "VINDICATOR");
        }
        if (v1_11 && !v1_12) {
            PASSIVE_MOBS = new SentinelTarget(SentinelTarget.v1_11_passive(), SentinelTarget.passiveNames());
            MOBS = new SentinelTarget(SentinelTarget.combine(SentinelTarget.v1_11_passive(), SentinelTarget.v1_11_monsters()), "MOB");
            MONSTERS = new SentinelTarget(SentinelTarget.v1_11_monsters(), "MONSTER");
        }
        if (v1_12) {
            PARROTS = new SentinelTarget(new EntityType[]{EntityType.PARROT}, "PARROT");
            ILLUSIONERS = new SentinelTarget(new EntityType[]{EntityType.ILLUSIONER}, "ILLUSIONER");
        }
        if (v1_12 && !v1_13) {
            PASSIVE_MOBS = new SentinelTarget(SentinelTarget.v1_12_passive(), SentinelTarget.passiveNames());
            MOBS = new SentinelTarget(SentinelTarget.combine(SentinelTarget.v1_12_passive(), SentinelTarget.v1_12_monsters()), "MOB");
            MONSTERS = new SentinelTarget(SentinelTarget.v1_12_monsters(), "MONSTER");
        }
        if (v1_13) {
            DOLPHIN = new SentinelTarget(new EntityType[]{EntityType.DOLPHIN}, "DOLPHIN");
            DROWNED = new SentinelTarget(new EntityType[]{EntityType.DROWNED}, "DROWNED");
            COD = new SentinelTarget(new EntityType[]{EntityType.COD}, "COD");
            SALMON = new SentinelTarget(new EntityType[]{EntityType.SALMON}, "SALMON");
            PUFFERFISH = new SentinelTarget(new EntityType[]{EntityType.PUFFERFISH}, "PUFFERFISH", "PUFFERFISHE");
            TROPICAL_FISH = new SentinelTarget(new EntityType[]{EntityType.TROPICAL_FISH}, "TROPICAL_FISH", "TROPICALFISH", "TROPICAL_FISHE", "TROPICALFISHE");
            TROPICAL_FISH = new SentinelTarget(new EntityType[]{EntityType.TROPICAL_FISH, EntityType.PUFFERFISH, EntityType.SALMON, EntityType.COD}, "FISH", "FISHE");
            PHANTOM = new SentinelTarget(new EntityType[]{EntityType.PHANTOM}, "PHANTOM");
            TURTLE = new SentinelTarget(new EntityType[]{EntityType.TURTLE}, "TURTLE");
        }
        if (v1_13 && !v1_14) {
            PASSIVE_MOBS = new SentinelTarget(SentinelTarget.v1_13_passive(), SentinelTarget.passiveNames());
            MOBS = new SentinelTarget(SentinelTarget.combine(SentinelTarget.v1_13_passive(), SentinelTarget.v1_13_monsters()), "MOB");
            MONSTERS = new SentinelTarget(SentinelTarget.v1_13_monsters(), "MONSTER");
        }
        if (v1_14) {
            RAVAGERS = new SentinelTarget(new EntityType[]{EntityType.RAVAGER}, "RAVAGER");
            PILLAGERS = new SentinelTarget(new EntityType[]{EntityType.PILLAGER}, "PILLAGER");
            CATS = new SentinelTarget(new EntityType[]{EntityType.CAT}, "CAT");
            PANDAS = new SentinelTarget(new EntityType[]{EntityType.PANDA}, "PANDA");
            TRADER_LLAMAS = new SentinelTarget(new EntityType[]{EntityType.TRADER_LLAMA}, "TRADER_LLAMA", "TRADERLLAMA");
            WANDERING_TRADERS = new SentinelTarget(new EntityType[]{EntityType.WANDERING_TRADER}, "WANDERING_TRADER", "WANDERINGTRADER", "TRADER");
            FOXES = new SentinelTarget(new EntityType[]{EntityType.FOX}, "FOX", "FOXE");
        }
        if (v1_14) {
            PASSIVE_MOBS = new SentinelTarget(SentinelTarget.v1_13_passive(), SentinelTarget.passiveNames());
            MOBS = new SentinelTarget(SentinelTarget.combine(SentinelTarget.v1_13_passive(), SentinelTarget.v1_14_monsters()), "MOB");
            MONSTERS = new SentinelTarget(SentinelTarget.v1_14_monsters(), "MONSTER");
        }
        if (v1_13) {
            SentinelTarget.addAllMaterials(SWORD_MATERIALS, "DIAMOND_SWORD", "IRON_SWORD", "STONE_SWORD", "GOLDEN_SWORD", "WOODEN_SWORD");
            WEAPON_DAMAGE_MULTIPLIERS.put(SentinelTarget.getMaterial("DIAMOND_SWORD"), 7.0);
            WEAPON_DAMAGE_MULTIPLIERS.put(SentinelTarget.getMaterial("IRON_SWORD"), 6.0);
            WEAPON_DAMAGE_MULTIPLIERS.put(SentinelTarget.getMaterial("STONE_SWORD"), 5.0);
            WEAPON_DAMAGE_MULTIPLIERS.put(SentinelTarget.getMaterial("GOLDEN_SWORD"), 4.0);
            WEAPON_DAMAGE_MULTIPLIERS.put(SentinelTarget.getMaterial("WOODEN_SWORD"), 4.0);
            WEAPON_DAMAGE_MULTIPLIERS.put(SentinelTarget.getMaterial("TRIDENT"), 8.0);
            SentinelTarget.addAllMaterials(PICKAXE_MATERIALS, "DIAMOND_PICKAXE", "IRON_PICKAXE", "STONE_PICKAXE", "GOLDEN_PICKAXE", "WOODEN_PICKAXE");
            SentinelTarget.allMaterialsTo(WEAPON_DAMAGE_MULTIPLIERS, PICKAXE_MATERIALS, 2.0);
            SentinelTarget.addAllMaterials(AXE_MATERIALS, "DIAMOND_AXE", "IRON_AXE", "STONE_AXE", "GOLDEN_AXE", "WOODEN_AXE");
            SentinelTarget.allMaterialsTo(WEAPON_DAMAGE_MULTIPLIERS, AXE_MATERIALS, 3.0);
            BOW_MATERIALS.add(SentinelTarget.getMaterial("BOW"));
            SentinelTarget.addAllMaterials(HELMET_MATERIALS, "DIAMOND_HELMET", "GOLDEN_HELMET", "IRON_HELMET", "LEATHER_HELMET", "CHAINMAIL_HELMET");
            ARMOR_PROTECTION_MULTIPLIERS.put(SentinelTarget.getMaterial("DIAMOND_HELMET"), 0.12);
            ARMOR_PROTECTION_MULTIPLIERS.put(SentinelTarget.getMaterial("GOLDEN_HELMET"), 0.08);
            ARMOR_PROTECTION_MULTIPLIERS.put(SentinelTarget.getMaterial("IRON_HELMET"), 0.08);
            ARMOR_PROTECTION_MULTIPLIERS.put(SentinelTarget.getMaterial("LEATHER_HELMET"), 0.04);
            ARMOR_PROTECTION_MULTIPLIERS.put(SentinelTarget.getMaterial("CHAINMAIL_HELMET"), 0.08);
            ARMOR_PROTECTION_MULTIPLIERS.put(SentinelTarget.getMaterial("TURTLE_HELMET"), 0.08);
            SentinelTarget.addAllMaterials(CHESTPLATE_MATERIALS, "DIAMOND_CHESTPLATE", "GOLDEN_CHESTPLATE", "IRON_CHESTPLATE", "LEATHER_CHESTPLATE", "CHAINMAIL_CHESTPLATE");
            ARMOR_PROTECTION_MULTIPLIERS.put(SentinelTarget.getMaterial("DIAMOND_CHESTPLATE"), 0.32);
            ARMOR_PROTECTION_MULTIPLIERS.put(SentinelTarget.getMaterial("GOLDEN_CHESTPLATE"), 0.2);
            ARMOR_PROTECTION_MULTIPLIERS.put(SentinelTarget.getMaterial("IRON_CHESTPLATE"), 0.24);
            ARMOR_PROTECTION_MULTIPLIERS.put(SentinelTarget.getMaterial("LEATHER_CHESTPLATE"), 0.12);
            ARMOR_PROTECTION_MULTIPLIERS.put(SentinelTarget.getMaterial("CHAINMAIL_CHESTPLATE"), 0.2);
            SentinelTarget.addAllMaterials(LEGGINGS_MATERIALS, "DIAMOND_LEGGINGS", "GOLDEN_LEGGINGS", "IRON_LEGGINGS", "LEATHER_LEGGINGS", "CHAINMAIL_LEGGINGS");
            ARMOR_PROTECTION_MULTIPLIERS.put(SentinelTarget.getMaterial("DIAMOND_LEGGINGS"), 0.24);
            ARMOR_PROTECTION_MULTIPLIERS.put(SentinelTarget.getMaterial("GOLDEN_LEGGINGS"), 0.12);
            ARMOR_PROTECTION_MULTIPLIERS.put(SentinelTarget.getMaterial("IRON_LEGGINGS"), 0.2);
            ARMOR_PROTECTION_MULTIPLIERS.put(SentinelTarget.getMaterial("LEATHER_LEGGINGS"), 0.08);
            ARMOR_PROTECTION_MULTIPLIERS.put(SentinelTarget.getMaterial("CHAINMAIL_LEGGINGS"), 0.16);
            SentinelTarget.addAllMaterials(BOOTS_MATERIALS, "DIAMOND_BOOTS", "GOLDEN_BOOTS", "IRON_BOOTS", "LEATHER_BOOTS", "CHAINMAIL_BOOTS");
            ARMOR_PROTECTION_MULTIPLIERS.put(SentinelTarget.getMaterial("DIAMOND_BOOTS"), 0.12);
            ARMOR_PROTECTION_MULTIPLIERS.put(SentinelTarget.getMaterial("GOLDEN_BOOTS"), 0.04);
            ARMOR_PROTECTION_MULTIPLIERS.put(SentinelTarget.getMaterial("IRON_BOOTS"), 0.08);
            ARMOR_PROTECTION_MULTIPLIERS.put(SentinelTarget.getMaterial("LEATHER_BOOTS"), 0.04);
            ARMOR_PROTECTION_MULTIPLIERS.put(SentinelTarget.getMaterial("CHAINMAIL_BOOTS"), 0.04);
            SentinelTarget.addAllMaterials(POTION_MATERIALS, "POTION", "LINGERING_POTION", "SPLASH_POTION");
            SentinelTarget.addAllMaterials(SKULL_MATERIALS, "WITHER_SKELETON_SKULL", "WITHER_SKELETON_WALL_SKULL");
            MATERIAL_SNOW_BALL = SentinelTarget.getMaterial("SNOWBALL");
            MATERIAL_NETHER_STAR = SentinelTarget.getMaterial("NETHER_STAR");
            MATERIAL_BLAZE_ROD = SentinelTarget.getMaterial("BLAZE_ROD");
        } else {
            SentinelTarget.addAllMaterials(SWORD_MATERIALS, "DIAMOND_SWORD", "IRON_SWORD", "STONE_SWORD", "GOLD_SWORD", "WOOD_SWORD");
            WEAPON_DAMAGE_MULTIPLIERS.put(SentinelTarget.getMaterial("DIAMOND_SWORD"), 7.0);
            WEAPON_DAMAGE_MULTIPLIERS.put(SentinelTarget.getMaterial("IRON_SWORD"), 6.0);
            WEAPON_DAMAGE_MULTIPLIERS.put(SentinelTarget.getMaterial("STONE_SWORD"), 5.0);
            WEAPON_DAMAGE_MULTIPLIERS.put(SentinelTarget.getMaterial("GOLD_SWORD"), 4.0);
            WEAPON_DAMAGE_MULTIPLIERS.put(SentinelTarget.getMaterial("WOOD_SWORD"), 4.0);
            SentinelTarget.addAllMaterials(PICKAXE_MATERIALS, "DIAMOND_PICKAXE", "IRON_PICKAXE", "STONE_PICKAXE", "GOLD_PICKAXE", "WOOD_PICKAXE");
            SentinelTarget.allMaterialsTo(WEAPON_DAMAGE_MULTIPLIERS, PICKAXE_MATERIALS, 2.0);
            SentinelTarget.addAllMaterials(AXE_MATERIALS, "DIAMOND_AXE", "IRON_AXE", "STONE_AXE", "GOLD_AXE", "WOOD_AXE");
            SentinelTarget.allMaterialsTo(WEAPON_DAMAGE_MULTIPLIERS, AXE_MATERIALS, 3.0);
            BOW_MATERIALS.add(SentinelTarget.getMaterial("BOW"));
            SentinelTarget.addAllMaterials(HELMET_MATERIALS, "DIAMOND_HELMET", "GOLD_HELMET", "IRON_HELMET", "LEATHER_HELMET", "CHAINMAIL_HELMET");
            ARMOR_PROTECTION_MULTIPLIERS.put(SentinelTarget.getMaterial("DIAMOND_HELMET"), 0.12);
            ARMOR_PROTECTION_MULTIPLIERS.put(SentinelTarget.getMaterial("GOLD_HELMET"), 0.08);
            ARMOR_PROTECTION_MULTIPLIERS.put(SentinelTarget.getMaterial("IRON_HELMET"), 0.08);
            ARMOR_PROTECTION_MULTIPLIERS.put(SentinelTarget.getMaterial("LEATHER_HELMET"), 0.04);
            ARMOR_PROTECTION_MULTIPLIERS.put(SentinelTarget.getMaterial("CHAINMAIL_HELMET"), 0.08);
            SentinelTarget.addAllMaterials(CHESTPLATE_MATERIALS, "DIAMOND_CHESTPLATE", "GOLD_CHESTPLATE", "IRON_CHESTPLATE", "LEATHER_CHESTPLATE", "CHAINMAIL_CHESTPLATE");
            ARMOR_PROTECTION_MULTIPLIERS.put(SentinelTarget.getMaterial("DIAMOND_CHESTPLATE"), 0.32);
            ARMOR_PROTECTION_MULTIPLIERS.put(SentinelTarget.getMaterial("GOLD_CHESTPLATE"), 0.2);
            ARMOR_PROTECTION_MULTIPLIERS.put(SentinelTarget.getMaterial("IRON_CHESTPLATE"), 0.24);
            ARMOR_PROTECTION_MULTIPLIERS.put(SentinelTarget.getMaterial("LEATHER_CHESTPLATE"), 0.12);
            ARMOR_PROTECTION_MULTIPLIERS.put(SentinelTarget.getMaterial("CHAINMAIL_CHESTPLATE"), 0.2);
            SentinelTarget.addAllMaterials(LEGGINGS_MATERIALS, "DIAMOND_LEGGINGS", "GOLD_LEGGINGS", "IRON_LEGGINGS", "LEATHER_LEGGINGS", "CHAINMAIL_LEGGINGS");
            ARMOR_PROTECTION_MULTIPLIERS.put(SentinelTarget.getMaterial("DIAMOND_LEGGINGS"), 0.24);
            ARMOR_PROTECTION_MULTIPLIERS.put(SentinelTarget.getMaterial("GOLD_LEGGINGS"), 0.12);
            ARMOR_PROTECTION_MULTIPLIERS.put(SentinelTarget.getMaterial("IRON_LEGGINGS"), 0.2);
            ARMOR_PROTECTION_MULTIPLIERS.put(SentinelTarget.getMaterial("LEATHER_LEGGINGS"), 0.08);
            ARMOR_PROTECTION_MULTIPLIERS.put(SentinelTarget.getMaterial("CHAINMAIL_LEGGINGS"), 0.16);
            SentinelTarget.addAllMaterials(BOOTS_MATERIALS, "DIAMOND_BOOTS", "GOLD_BOOTS", "IRON_BOOTS", "LEATHER_BOOTS", "CHAINMAIL_BOOTS");
            ARMOR_PROTECTION_MULTIPLIERS.put(SentinelTarget.getMaterial("DIAMOND_BOOTS"), 0.12);
            ARMOR_PROTECTION_MULTIPLIERS.put(SentinelTarget.getMaterial("GOLD_BOOTS"), 0.04);
            ARMOR_PROTECTION_MULTIPLIERS.put(SentinelTarget.getMaterial("IRON_BOOTS"), 0.08);
            ARMOR_PROTECTION_MULTIPLIERS.put(SentinelTarget.getMaterial("LEATHER_BOOTS"), 0.04);
            ARMOR_PROTECTION_MULTIPLIERS.put(SentinelTarget.getMaterial("CHAINMAIL_BOOTS"), 0.04);
            if (v1_9) {
                SentinelTarget.addAllMaterials(POTION_MATERIALS, "POTION", "LINGERING_POTION", "SPLASH_POTION");
            } else {
                SentinelTarget.addAllMaterials(POTION_MATERIALS, "POTION");
            }
            SentinelTarget.addAllMaterials(SKULL_MATERIALS, "SKULL", "SKULL_ITEM");
            MATERIAL_SNOW_BALL = SentinelTarget.getMaterial("SNOW_BALL");
            MATERIAL_NETHER_STAR = SentinelTarget.getMaterial("NETHER_STAR");
            MATERIAL_BLAZE_ROD = SentinelTarget.getMaterial("BLAZE_ROD");
        }
    }
}

